/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.entity;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.egov.collection.entity.CollectionDishonorChequeDetails;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.EgwStatus;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.model.instrument.InstrumentHeader;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGCL_DISHONORCHEQUE")
@SequenceGenerator(name="SEQ_EGCL_DISHONORCHEQUE", sequenceName="SEQ_EGCL_DISHONORCHEQUE", allocationSize=1)
public class CollectionDishonorCheque
extends StateAware {
    private static final long serialVersionUID = -6134188498111765210L;
    public static final String SEQ_EGCL_DISHONORCHEQUE = "SEQ_EGCL_DISHONORCHEQUE";
    @Id
    @GeneratedValue(generator="SEQ_EGCL_DISHONORCHEQUE", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne
    @JoinColumn(name="instrumentheader")
    private InstrumentHeader instrumentHeader;
    @ManyToOne
    @JoinColumn(name="collectionheader")
    private ReceiptHeader collectionHeader;
    @ManyToOne
    @JoinColumn(name="status")
    private EgwStatus status;
    @Column(name="bankcharges")
    private BigDecimal bankChargesAmt;
    @ManyToOne
    @JoinColumn(name="bankchargeschartofaccounts")
    private CChartOfAccounts bankcChargesChartofaccounts;
    private Date transactionDate;
    @Length(max=20)
    private String bankReferenceNumber;
    private String instrumentDishonorReason;
    private String bankreason;
    @ManyToOne
    @JoinColumn(name="reversalvoucher")
    private CVoucherHeader reversalVoucherHeader;
    @ManyToOne
    @JoinColumn(name="bankchargesvoucher")
    private CVoucherHeader bankchargesVoucherHeader;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="dishonorcheque", targetEntity=CollectionDishonorChequeDetails.class)
    private Set<CollectionDishonorChequeDetails> details = new HashSet<CollectionDishonorChequeDetails>(0);

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getStateDetails() {
        String instInfo = "Instrument Number :" + this.getInstrumentHeader().getInstrumentNumber() + " Amount : " + this.getInstrumentHeader().getInstrumentAmount();
        return instInfo;
    }

    public Date getTransactionDate() {
        return this.transactionDate;
    }

    public void setTransactionDate(Date transactionDate) {
        this.transactionDate = transactionDate;
    }

    public String getBankReferenceNumber() {
        return this.bankReferenceNumber;
    }

    public void setBankReferenceNumber(String bankReferenceNumber) {
        this.bankReferenceNumber = bankReferenceNumber;
    }

    public InstrumentHeader getInstrumentHeader() {
        return this.instrumentHeader;
    }

    public void setInstrumentHeader(InstrumentHeader instrumentHeader) {
        this.instrumentHeader = instrumentHeader;
    }

    public ReceiptHeader getCollectionHeader() {
        return this.collectionHeader;
    }

    public void setCollectionHeader(ReceiptHeader collectionHeader) {
        this.collectionHeader = collectionHeader;
    }

    public EgwStatus getStatus() {
        return this.status;
    }

    public void setStatus(EgwStatus status) {
        this.status = status;
    }

    public BigDecimal getBankChargesAmt() {
        return this.bankChargesAmt;
    }

    public void setBankChargesAmt(BigDecimal bankChargesAmt) {
        this.bankChargesAmt = bankChargesAmt;
    }

    public CChartOfAccounts getBankcChargesChartofaccounts() {
        return this.bankcChargesChartofaccounts;
    }

    public void setBankcChargesChartofaccounts(CChartOfAccounts bankcChargesChartofaccounts) {
        this.bankcChargesChartofaccounts = bankcChargesChartofaccounts;
    }

    public CVoucherHeader getReversalVoucherHeader() {
        return this.reversalVoucherHeader;
    }

    public void setReversalVoucherHeader(CVoucherHeader reversalVoucherHeader) {
        this.reversalVoucherHeader = reversalVoucherHeader;
    }

    public CVoucherHeader getBankchargesVoucherHeader() {
        return this.bankchargesVoucherHeader;
    }

    public void setBankchargesVoucherHeader(CVoucherHeader bankchargesVoucherHeader) {
        this.bankchargesVoucherHeader = bankchargesVoucherHeader;
    }

    public Set<CollectionDishonorChequeDetails> getDetails() {
        return this.details;
    }

    public void setDetails(Set<CollectionDishonorChequeDetails> details) {
        this.details = details;
    }

    public Set<CollectionDishonorChequeDetails> addDishonorChqDetails(CollectionDishonorChequeDetails chqDet) {
        this.details.add(chqDet);
        return this.details;
    }

    public String getInstrumentDishonorReason() {
        return this.instrumentDishonorReason;
    }

    public String getBankreason() {
        return this.bankreason;
    }

    public void setInstrumentDishonorReason(String instrumentDishonorReason) {
        this.instrumentDishonorReason = instrumentDishonorReason;
    }

    public void setBankreason(String bankreason) {
        this.bankreason = bankreason;
    }

    public String myLinkId() {
        return this.getId().toString();
    }
}

