/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.config;

import java.util.HashMap;
import javax.sql.DataSource;
import org.egov.collection.scheduler.AxisReconciliationJob;
import org.egov.collection.scheduler.RemittanceInstrumentJob;
import org.egov.infra.config.scheduling.QuartzSchedulerConfiguration;
import org.egov.infra.config.scheduling.SchedulerConfigCondition;
import org.quartz.Trigger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

@Configuration
@Conditional(value={SchedulerConfigCondition.class})
public class CollectionSchedulerConfiguration
extends QuartzSchedulerConfiguration {
    private static final String INSTRUMENT_TYPE_CHEQUE = "cheque";
    private static final String INSTRUMENT_TYPE_CASH = "cash";
    private static final String INSTRUMENT_TYPE_DD = "dd";

    @Bean(destroyMethod="destroy")
    public SchedulerFactoryBean collectionScheduler(DataSource dataSource) {
        SchedulerFactoryBean collectionScheduler = this.createScheduler(dataSource);
        collectionScheduler.setSchedulerName("collection-scheduler");
        collectionScheduler.setAutoStartup(true);
        collectionScheduler.setOverwriteExistingJobs(true);
        collectionScheduler.setTriggers(new Trigger[]{this.axisReconciliationCronTrigger().getObject(), this.remittanceCashInstrumentCronTrigger0().getObject(), this.remittanceCashInstrumentCronTrigger1().getObject(), this.remittanceDDInstrumentCronTrigger0().getObject(), this.remittanceDDInstrumentCronTrigger1().getObject(), this.remittanceChequeInstrumentCronTrigger0().getObject(), this.remittanceChequeInstrumentCronTrigger1().getObject()});
        return collectionScheduler;
    }

    @Bean
    public JobDetailFactoryBean axisReconciliationJobDetail() {
        JobDetailFactoryBean axisReconciliationJobDetail = new JobDetailFactoryBean();
        axisReconciliationJobDetail.setGroup("COLLECTION_JOB_GROUP");
        axisReconciliationJobDetail.setName("COLLECTION_AXIS_RECON_JOB");
        axisReconciliationJobDetail.setDurability(true);
        axisReconciliationJobDetail.setJobClass(AxisReconciliationJob.class);
        axisReconciliationJobDetail.setRequestsRecovery(true);
        HashMap<String, String> jobDetailMap = new HashMap<String, String>();
        jobDetailMap.put("jobBeanName", "axisReconciliationJob");
        jobDetailMap.put("userName", "egovernments");
        jobDetailMap.put("cityDataRequired", "true");
        jobDetailMap.put("moduleName", "collection");
        axisReconciliationJobDetail.setJobDataAsMap(jobDetailMap);
        return axisReconciliationJobDetail;
    }

    @Bean
    public CronTriggerFactoryBean axisReconciliationCronTrigger() {
        CronTriggerFactoryBean axisReconciliationCron = new CronTriggerFactoryBean();
        axisReconciliationCron.setJobDetail(this.axisReconciliationJobDetail().getObject());
        axisReconciliationCron.setGroup("COLLECTION_TRIGGER_GROUP");
        axisReconciliationCron.setName("COLLECTION_AXIS_RECON_TRIGGER");
        axisReconciliationCron.setCronExpression("0 */30 * * * ?");
        axisReconciliationCron.setMisfireInstruction(2);
        return axisReconciliationCron;
    }

    @Bean(value={"axisReconciliationJob"})
    public AxisReconciliationJob axisReconciliationJob() {
        return new AxisReconciliationJob();
    }

    @Bean
    public JobDetailFactoryBean remittanceCashInstrumentJobDetail0() {
        return this.createJobDetailFactory(INSTRUMENT_TYPE_CASH, 0);
    }

    @Bean
    public JobDetailFactoryBean remittanceCashInstrumentJobDetail1() {
        return this.createJobDetailFactory(INSTRUMENT_TYPE_CASH, 1);
    }

    @Bean
    public JobDetailFactoryBean remittanceDDInstrumentJobDetail0() {
        return this.createJobDetailFactory(INSTRUMENT_TYPE_DD, 0);
    }

    @Bean
    public JobDetailFactoryBean remittanceDDInstrumentJobDetail1() {
        return this.createJobDetailFactory(INSTRUMENT_TYPE_DD, 1);
    }

    @Bean
    public JobDetailFactoryBean remittanceChequeInstrumentJobDetail0() {
        return this.createJobDetailFactory(INSTRUMENT_TYPE_CHEQUE, 0);
    }

    @Bean
    public JobDetailFactoryBean remittanceChequeInstrumentJobDetail1() {
        return this.createJobDetailFactory(INSTRUMENT_TYPE_CHEQUE, 1);
    }

    @Bean
    public CronTriggerFactoryBean remittanceCashInstrumentCronTrigger0() {
        return this.createCronTrigger(this.remittanceCashInstrumentJobDetail0(), INSTRUMENT_TYPE_CASH, 0);
    }

    @Bean
    public CronTriggerFactoryBean remittanceCashInstrumentCronTrigger1() {
        return this.createCronTrigger(this.remittanceCashInstrumentJobDetail1(), INSTRUMENT_TYPE_CASH, 1);
    }

    @Bean
    public CronTriggerFactoryBean remittanceDDInstrumentCronTrigger0() {
        return this.createCronTrigger(this.remittanceDDInstrumentJobDetail0(), INSTRUMENT_TYPE_DD, 0);
    }

    @Bean
    public CronTriggerFactoryBean remittanceDDInstrumentCronTrigger1() {
        return this.createCronTrigger(this.remittanceDDInstrumentJobDetail1(), INSTRUMENT_TYPE_DD, 1);
    }

    @Bean
    public CronTriggerFactoryBean remittanceChequeInstrumentCronTrigger0() {
        return this.createCronTrigger(this.remittanceChequeInstrumentJobDetail0(), INSTRUMENT_TYPE_CHEQUE, 0);
    }

    @Bean
    public CronTriggerFactoryBean remittanceChequeInstrumentCronTrigger1() {
        return this.createCronTrigger(this.remittanceChequeInstrumentJobDetail1(), INSTRUMENT_TYPE_CHEQUE, 1);
    }

    @Bean(value={"remittanceddInstrumentJob0"})
    public RemittanceInstrumentJob remittanceddInstrumentJob0() {
        RemittanceInstrumentJob remittanceInstrumentJob = new RemittanceInstrumentJob();
        remittanceInstrumentJob.setModulo(0);
        remittanceInstrumentJob.setInstrumentType(INSTRUMENT_TYPE_DD);
        return remittanceInstrumentJob;
    }

    @Bean(value={"remittanceddInstrumentJob1"})
    public RemittanceInstrumentJob remittanceddInstrumentJob1() {
        RemittanceInstrumentJob remittanceInstrumentJob = new RemittanceInstrumentJob();
        remittanceInstrumentJob.setModulo(1);
        remittanceInstrumentJob.setInstrumentType(INSTRUMENT_TYPE_DD);
        return remittanceInstrumentJob;
    }

    @Bean(value={"remittancechequeInstrumentJob0"})
    public RemittanceInstrumentJob remittancechequeInstrumentJob0() {
        RemittanceInstrumentJob remittanceInstrumentJob = new RemittanceInstrumentJob();
        remittanceInstrumentJob.setModulo(0);
        remittanceInstrumentJob.setInstrumentType(INSTRUMENT_TYPE_CHEQUE);
        return remittanceInstrumentJob;
    }

    @Bean(value={"remittancechequeInstrumentJob1"})
    public RemittanceInstrumentJob remittancechequeInstrumentJob1() {
        RemittanceInstrumentJob remittanceInstrumentJob = new RemittanceInstrumentJob();
        remittanceInstrumentJob.setModulo(1);
        remittanceInstrumentJob.setInstrumentType(INSTRUMENT_TYPE_CHEQUE);
        return remittanceInstrumentJob;
    }

    @Bean(value={"remittancecashInstrumentJob0"})
    public RemittanceInstrumentJob remittancecashInstrumentJob0() {
        RemittanceInstrumentJob remittanceInstrumentJob = new RemittanceInstrumentJob();
        remittanceInstrumentJob.setModulo(0);
        remittanceInstrumentJob.setInstrumentType(INSTRUMENT_TYPE_CASH);
        return remittanceInstrumentJob;
    }

    @Bean(value={"remittancecashInstrumentJob1"})
    public RemittanceInstrumentJob remittancecashInstrumentJob1() {
        RemittanceInstrumentJob remittanceInstrumentJob = new RemittanceInstrumentJob();
        remittanceInstrumentJob.setModulo(1);
        remittanceInstrumentJob.setInstrumentType(INSTRUMENT_TYPE_CASH);
        return remittanceInstrumentJob;
    }

    private JobDetailFactoryBean createJobDetailFactory(String instrumentType, int modulo) {
        JobDetailFactoryBean remittanceInstrumentJobDetail = new JobDetailFactoryBean();
        remittanceInstrumentJobDetail.setGroup("COLLECTION_JOB_GROUP");
        remittanceInstrumentJobDetail.setName(String.format("COLLECTION_REMIT_INSTRMNT_%s%d_JOB", instrumentType, modulo));
        remittanceInstrumentJobDetail.setDurability(true);
        remittanceInstrumentJobDetail.setJobClass(RemittanceInstrumentJob.class);
        remittanceInstrumentJobDetail.setRequestsRecovery(true);
        HashMap<String, String> jobDetailMap = new HashMap<String, String>();
        jobDetailMap.put("jobBeanName", String.format("remittance%sInstrumentJob%d", instrumentType, modulo));
        jobDetailMap.put("userName", "egovernments");
        jobDetailMap.put("cityDataRequired", "true");
        jobDetailMap.put("moduleName", "collection");
        remittanceInstrumentJobDetail.setJobDataAsMap(jobDetailMap);
        return remittanceInstrumentJobDetail;
    }

    private CronTriggerFactoryBean createCronTrigger(JobDetailFactoryBean jobDetail, String instrumentType, int modulo) {
        CronTriggerFactoryBean remittanceCron = new CronTriggerFactoryBean();
        remittanceCron.setJobDetail(jobDetail.getObject());
        remittanceCron.setGroup("COLLECTION_TRIGGER_GROUP");
        remittanceCron.setName(String.format("COLLECTION_REMIT_INSTRMNT_%s%d_TRIGGER", instrumentType, modulo));
        remittanceCron.setCronExpression("0 */5 * * * ?");
        remittanceCron.setMisfireInstruction(2);
        return remittanceCron;
    }
}

