/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.autonumber.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.egov.collection.autonumber.ReceiptNumberGenerator;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.commons.CFinancialYear;
import org.egov.infra.persistence.utils.SequenceNumberGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReceiptNumberGeneratorImpl
implements ReceiptNumberGenerator {
    @Autowired
    private CollectionsUtil collectionsUtil;
    @Autowired
    private SequenceNumberGenerator sequenceNumberGenerator;

    @Override
    public String generateReceiptNumber(ReceiptHeader receiptHeader) {
        CFinancialYear financialYear = this.collectionsUtil.getFinancialYearforDate(new Date());
        SimpleDateFormat sdf = new SimpleDateFormat("MM");
        String formattedDate = sdf.format(receiptHeader.getReceiptdate());
        String strObj = "SQ_RECEIPTHEADER_" + financialYear.getFinYearRange().replace("-", "_");
        String result = formattedDate + '/' + financialYear.getFinYearRange() + '/' + this.sequenceNumberGenerator.getNextSequence(strObj);
        return result;
    }
}

