/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.service.elasticsearch;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.egov.collection.bean.dashboard.CollectionDashBoardRequest;
import org.egov.collection.bean.dashboard.CollectionDashBoardTrend;
import org.egov.collection.bean.dashboard.CollectionDocumentDetails;
import org.egov.collection.bean.dashboard.CollectionTableData;
import org.egov.collection.bean.dashboard.TaxPayerDashBoardDetails;
import org.egov.collection.bean.dashboard.TaxPayerDashBoardResponseDetails;
import org.egov.collection.constants.CollectionConstants;
import org.egov.collection.entity.es.CollectionDocument;
import org.egov.commons.CFinancialYear;
import org.egov.infra.utils.DateUtils;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.elasticsearch.search.aggregations.metrics.valuecount.ValueCount;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;

@Service
public class CollectionDocumentElasticSearchService {
    private static final String DATE_AGG = "date_agg";
    private static final String BY_CITY = "by_city";
    private static final String MILLISECS = " (millisecs) ";
    private static final String REVENUE_WARD = "revenueWard";
    private static final String CITY_NAME = "cityName";
    private static final String CITY_CODE = "cityCode";
    private static final String CITY_GRADE = "cityGrade";
    private static final String DISTRICT_NAME = "districtName";
    private static final String REGION_NAME = "regionName";
    private static final String BILLING_SERVICE = "billingService";
    private static final String TOTAL_AMOUNT = "totalAmount";
    private static final String COLLECTIONTOTAL = "collectiontotal";
    private static final String CANCELLED = "Cancelled";
    private static final String STATUS = "status";
    private static final String RECEIPT_DATE = "receiptDate";
    private static final String TOTAL_COLLECTION = "total_collection";
    private static final String BY_AGGREGATION_FIELD = "by_aggregationField";
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionDocumentElasticSearchService.class);
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;

    public Set<String> getServices() {
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"receipts"}).addAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)"services_count").field(BILLING_SERVICE)).build();
        Aggregations collCountAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
        ValueCount aggr = (ValueCount)collCountAggr.get("services_count");
        searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"receipts"}).withFields(new String[]{BILLING_SERVICE}).withPageable((Pageable)new PageRequest(0, (int)(aggr.getValue() == 0L ? 1L : aggr.getValue()))).build();
        List list = this.elasticsearchTemplate.queryForList((SearchQuery)searchQueryColl, CollectionDocument.class);
        TreeSet<String> services = new TreeSet<String>();
        for (CollectionDocument colDoc : list) {
            services.add(colDoc.getBillingService());
        }
        return services;
    }

    public BigDecimal getConsolidatedCollForYears(Date fromDate, Date toDate, List<String> serviceDetails) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.rangeQuery((String)RECEIPT_DATE).gte(CollectionConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(CollectionConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false)).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)STATUS, (Object)CANCELLED));
        if (!serviceDetails.isEmpty()) {
            boolQuery = boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)BILLING_SERVICE, serviceDetails));
        }
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"receipts"}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)COLLECTIONTOTAL).field(TOTAL_AMOUNT)).build();
        Aggregations collAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
        Sum aggr = (Sum)collAggr.get(COLLECTIONTOTAL);
        return BigDecimal.valueOf(aggr.getValue()).setScale(0, 4);
    }

    public Map<String, BigDecimal> getFinYearsCollByService(List<String> serviceDetails, CFinancialYear currFinYear) {
        HashMap<String, BigDecimal> consolidatedCollValues = new HashMap<String, BigDecimal>();
        consolidatedCollValues.put("cytdColln", this.getConsolidatedCollForYears(currFinYear.getStartingDate(), org.apache.commons.lang3.time.DateUtils.addDays((Date)new Date(), (int)1), serviceDetails));
        consolidatedCollValues.put("lytdColln", this.getConsolidatedCollForYears(org.apache.commons.lang3.time.DateUtils.addYears((Date)currFinYear.getStartingDate(), (int)-1), org.apache.commons.lang3.time.DateUtils.addDays((Date)org.apache.commons.lang3.time.DateUtils.addYears((Date)new Date(), (int)-1), (int)1), serviceDetails));
        return consolidatedCollValues;
    }

    private BoolQueryBuilder prepareWhereClause(CollectionDashBoardRequest collectionDashBoardRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)TOTAL_AMOUNT).from(0).to(null));
        if (StringUtils.isNotBlank((CharSequence)collectionDashBoardRequest.getRegionName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)REGION_NAME, (Object)collectionDashBoardRequest.getRegionName()));
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDashBoardRequest.getDistrictName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)DISTRICT_NAME, (Object)collectionDashBoardRequest.getDistrictName()));
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDashBoardRequest.getUlbGrade())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CITY_GRADE, (Object)collectionDashBoardRequest.getUlbGrade()));
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDashBoardRequest.getUlbCode())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CITY_CODE, (Object)collectionDashBoardRequest.getUlbCode()));
        }
        return boolQuery;
    }

    public CollectionDocumentDetails getCompleteCollectionIndexDetails(CollectionDashBoardRequest collectionDashBoardRequest, List<String> serviceDetail, CFinancialYear financialYear) {
        Date toDate;
        Date fromDate;
        Long startTime = System.currentTimeMillis();
        CollectionDocumentDetails collectionDocumentDetails = new CollectionDocumentDetails();
        if (StringUtils.isNotBlank((CharSequence)collectionDashBoardRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDashBoardRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDashBoardRequest.getToDate(), (String)"yyyy-MM-dd");
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)DateUtils.getDate((String)collectionDashBoardRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = new Date();
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)new Date(), (int)1);
        }
        BigDecimal todayColl = this.getCollectionBetweenDates(collectionDashBoardRequest, fromDate, toDate, null, serviceDetail, false);
        collectionDocumentDetails.setTodayColl(todayColl);
        todayColl = this.getCollectionBetweenDates(collectionDashBoardRequest, org.apache.commons.lang3.time.DateUtils.addYears((Date)fromDate, (int)-1), org.apache.commons.lang3.time.DateUtils.addYears((Date)toDate, (int)-1), null, serviceDetail, false);
        collectionDocumentDetails.setLyTodayColl(todayColl);
        if (StringUtils.isNotBlank((CharSequence)collectionDashBoardRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDashBoardRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDashBoardRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)DateUtils.getDate((String)collectionDashBoardRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = DateUtils.startOfDay((Date)financialYear.getStartingDate());
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)new Date(), (int)1);
        }
        BigDecimal tillDateColl = this.getCollectionBetweenDates(collectionDashBoardRequest, fromDate, toDate, null, serviceDetail, false);
        collectionDocumentDetails.setCytdColl(tillDateColl);
        tillDateColl = this.getCollectionBetweenDates(collectionDashBoardRequest, org.apache.commons.lang3.time.DateUtils.addYears((Date)fromDate, (int)-1), org.apache.commons.lang3.time.DateUtils.addYears((Date)toDate, (int)-1), null, serviceDetail, false);
        collectionDocumentDetails.setLytdColl(tillDateColl);
        BigDecimal variance = collectionDocumentDetails.getLytdColl().compareTo(BigDecimal.ZERO) == 0 ? CollectionConstants.BIGDECIMAL_100 : collectionDocumentDetails.getCytdColl().subtract(collectionDocumentDetails.getLytdColl()).multiply(CollectionConstants.BIGDECIMAL_100).divide(collectionDocumentDetails.getLytdColl(), 1, 4);
        collectionDocumentDetails.setLyVar(variance);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken by getCompleteCollectionIndexDetails() is : " + timeTaken + MILLISECS);
        }
        return collectionDocumentDetails;
    }

    public BigDecimal getCollectionBetweenDates(CollectionDashBoardRequest collectionDashBoardRequest, Date fromDate, Date toDate, String cityName, List<String> serviceDetails, boolean isWard) {
        Long startTime = System.currentTimeMillis();
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDashBoardRequest);
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)RECEIPT_DATE).gte(CollectionConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(CollectionConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false)).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)STATUS, (Object)CANCELLED));
        if (StringUtils.isNotBlank((CharSequence)cityName)) {
            boolQuery = !isWard ? boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CITY_NAME, (Object)cityName)) : boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)REVENUE_WARD, (Object)cityName));
        }
        if (!serviceDetails.isEmpty()) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)BILLING_SERVICE, serviceDetails));
        }
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"receipts"}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)COLLECTIONTOTAL).field(TOTAL_AMOUNT)).build();
        Aggregations collAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
        Sum aggr = (Sum)collAggr.get(COLLECTIONTOTAL);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken by getCollectionBetweenDates() is : " + timeTaken + MILLISECS);
        }
        return BigDecimal.valueOf(aggr.getValue()).setScale(0, 4);
    }

    public List<CollectionTableData> getResponseTableData(CollectionDashBoardRequest collectionDashBoardRequest, List<String> serviceDetail, CFinancialYear financialYear) {
        Date toDate;
        Date fromDate;
        ArrayList<CollectionTableData> collIndDataList = new ArrayList<CollectionTableData>();
        String aggregationField = REGION_NAME;
        Map detailsForAggregationField = Collections.emptyMap();
        if (StringUtils.isNotBlank((CharSequence)collectionDashBoardRequest.getType())) {
            if (collectionDashBoardRequest.getType().equalsIgnoreCase("region")) {
                aggregationField = REGION_NAME;
            } else if (collectionDashBoardRequest.getType().equalsIgnoreCase("district")) {
                aggregationField = DISTRICT_NAME;
            } else if (collectionDashBoardRequest.getType().equalsIgnoreCase("ulb")) {
                aggregationField = CITY_NAME;
            } else if (collectionDashBoardRequest.getType().equalsIgnoreCase("grade")) {
                aggregationField = CITY_GRADE;
            } else if (collectionDashBoardRequest.getType().equalsIgnoreCase("ward")) {
                aggregationField = REVENUE_WARD;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDashBoardRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDashBoardRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDashBoardRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)DateUtils.getDate((String)collectionDashBoardRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = DateUtils.startOfDay((Date)financialYear.getStartingDate());
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)new Date(), (int)1);
        }
        Long startTime = System.currentTimeMillis();
        Map<String, BigDecimal> totalCollMap = this.getCollectionAndDemandValues(collectionDashBoardRequest, fromDate, toDate, TOTAL_AMOUNT, aggregationField, serviceDetail);
        if (StringUtils.isNotBlank((CharSequence)collectionDashBoardRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDashBoardRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDashBoardRequest.getToDate(), (String)"yyyy-MM-dd");
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)DateUtils.getDate((String)collectionDashBoardRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = new Date();
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)new Date(), (int)1);
        }
        Map<String, BigDecimal> todaysCollMap = this.getCollectionAndDemandValues(collectionDashBoardRequest, fromDate, toDate, TOTAL_AMOUNT, aggregationField, serviceDetail);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken by getCollectionAndDemandValues() is : " + timeTaken + MILLISECS);
        }
        startTime = System.currentTimeMillis();
        for (Map.Entry<String, BigDecimal> entry : totalCollMap.entrySet()) {
            CollectionTableData collTableData = new CollectionTableData();
            String name = entry.getKey();
            if (DISTRICT_NAME.equalsIgnoreCase(aggregationField) || CITY_NAME.equalsIgnoreCase(aggregationField) || REGION_NAME.equalsIgnoreCase(aggregationField) || REVENUE_WARD.equalsIgnoreCase(aggregationField)) {
                detailsForAggregationField = this.getDetailsForAggregationType(collectionDashBoardRequest, name, aggregationField);
            }
            if (aggregationField.equals(REGION_NAME)) {
                collTableData.setRegionName(name);
            } else if (aggregationField.equals(DISTRICT_NAME)) {
                collTableData.setRegionName(collectionDashBoardRequest.getRegionName());
                collTableData.setDistrictName(name);
            } else if (aggregationField.equals(CITY_NAME)) {
                collTableData.setUlbName(name);
                collTableData.setDistrictName(collectionDashBoardRequest.getDistrictName());
                collTableData.setUlbGrade(collectionDashBoardRequest.getUlbGrade());
            } else if (aggregationField.equals(CITY_GRADE)) {
                collTableData.setUlbGrade(name);
            } else if (aggregationField.equals(REVENUE_WARD)) {
                collTableData.setWardName(name);
                collTableData.setRegionName(detailsForAggregationField.get(REGION_NAME).toString());
                collTableData.setDistrictName(detailsForAggregationField.get(DISTRICT_NAME).toString());
                collTableData.setUlbGrade(detailsForAggregationField.get(CITY_GRADE).toString());
                collTableData.setUlbName(detailsForAggregationField.get(CITY_NAME).toString());
            }
            collTableData.setTotalCollection(totalCollMap.get(name) == null ? BigDecimal.ZERO : totalCollMap.get(name));
            collTableData.setTodaysCollection(todaysCollMap.get(name) == null ? BigDecimal.ZERO : todaysCollMap.get(name));
            collIndDataList.add(collTableData);
        }
        timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken for setting values in getResponseTableData() is : " + timeTaken + MILLISECS);
        }
        return collIndDataList;
    }

    private Map getDetailsForAggregationType(CollectionDashBoardRequest collectionDashBoardRequest, String name, String aggregationField) {
        String[] requiredFields = null;
        BoolQueryBuilder boolQuery = this.prepareBoolQuery(collectionDashBoardRequest);
        if (REVENUE_WARD.equalsIgnoreCase(aggregationField)) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)REVENUE_WARD, (Object)name));
            requiredFields = new String[]{REGION_NAME, DISTRICT_NAME, CITY_GRADE, CITY_NAME};
        }
        Map collectionTypeDetails = new HashMap();
        SearchResponse response = (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"receipts"}).setQuery((QueryBuilder)boolQuery).setSize(1).setFetchSource(requiredFields, null).execute().actionGet();
        for (SearchHit hit : response.getHits()) {
            collectionTypeDetails = hit.sourceAsMap();
        }
        return collectionTypeDetails;
    }

    private BoolQueryBuilder prepareBoolQuery(CollectionDashBoardRequest collectionDashBoardRequest) {
        BoolQueryBuilder boolQuery = new BoolQueryBuilder();
        if (StringUtils.isNotBlank((CharSequence)collectionDashBoardRequest.getRevenueWard())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)REVENUE_WARD, (Object)collectionDashBoardRequest.getRevenueWard()));
        }
        return boolQuery;
    }

    public Map<String, BigDecimal> getCollectionAndDemandValues(CollectionDashBoardRequest collectionDashBoardRequest, Date fromDate, Date toDate, String fieldName, String aggregationField, List<String> serviceDetails) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDashBoardRequest);
        if (!serviceDetails.isEmpty()) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)BILLING_SERVICE, serviceDetails));
        }
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)RECEIPT_DATE).gte(CollectionConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(CollectionConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false)).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)STATUS, (Object)CANCELLED));
        AggregationBuilder aggregation = ((TermsBuilder)AggregationBuilders.terms((String)BY_CITY).field(aggregationField)).size(120).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"total").field(fieldName));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"receipts"}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)aggregation).build();
        Aggregations collAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
        StringTerms cityAggr = (StringTerms)collAggr.get(BY_CITY);
        HashMap<String, BigDecimal> cytdCollMap = new HashMap<String, BigDecimal>();
        for (Terms.Bucket entry : cityAggr.getBuckets()) {
            Sum aggr = (Sum)entry.getAggregations().get("total");
            cytdCollMap.put(String.valueOf(entry.getKey()), BigDecimal.valueOf(aggr.getValue()).setScale(0, 4));
        }
        return cytdCollMap;
    }

    public List<CollectionDashBoardTrend> getMonthwiseCollectionDetails(CollectionDashBoardRequest collectionDashBoardRequest, List<String> serviceDetail, CFinancialYear financialYear) {
        Date toDate;
        Date fromDate;
        ArrayList<CollectionDashBoardTrend> collTrendsList = new ArrayList<CollectionDashBoardTrend>();
        Date finYearStartDate = financialYear.getStartingDate();
        Date finYearEndDate = financialYear.getEndingDate();
        Map monthValuesMap = DateUtils.getAllMonthsWithFullNames();
        ArrayList yearwiseMonthlyCollList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)collectionDashBoardRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDashBoardRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDashBoardRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)DateUtils.getDate((String)collectionDashBoardRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = DateUtils.startOfDay((Date)financialYear.getStartingDate());
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)new Date(), (int)1);
        }
        Long startTime = System.currentTimeMillis();
        for (int count = 0; count <= 2; ++count) {
            LinkedHashMap<String, BigDecimal> monthwiseColl = new LinkedHashMap<String, BigDecimal>();
            Aggregations collAggr = this.getMonthwiseCollectionsForConsecutiveYears(collectionDashBoardRequest, fromDate, toDate, serviceDetail);
            Histogram dateaggs = (Histogram)collAggr.get(DATE_AGG);
            for (Histogram.Bucket entry : dateaggs.getBuckets()) {
                String[] dateArr = entry.getKeyAsString().split("T");
                Date dateForMonth = DateUtils.getDate((String)dateArr[0], (String)"yyyy-MM-dd");
                Integer month = Integer.valueOf(dateArr[0].split("-", 3)[1]);
                String monthName = (String)monthValuesMap.get(month);
                Sum aggregateSum = (Sum)entry.getAggregations().get("current_total");
                if (!DateUtils.between((Date)dateForMonth, (Date)finYearStartDate, (Date)finYearEndDate) || BigDecimal.valueOf(aggregateSum.getValue()).setScale(0, 4).compareTo(BigDecimal.ZERO) <= 0) continue;
                monthwiseColl.put(monthName, BigDecimal.valueOf(aggregateSum.getValue()).setScale(0, 4));
            }
            yearwiseMonthlyCollList.add(monthwiseColl);
            if (StringUtils.isNotBlank((CharSequence)collectionDashBoardRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDashBoardRequest.getToDate())) {
                fromDate = org.apache.commons.lang3.time.DateUtils.addYears((Date)fromDate, (int)-1);
                toDate = org.apache.commons.lang3.time.DateUtils.addYears((Date)toDate, (int)-1);
            } else {
                fromDate = org.apache.commons.lang3.time.DateUtils.addYears((Date)finYearStartDate, (int)-1);
                toDate = org.apache.commons.lang3.time.DateUtils.addYears((Date)finYearEndDate, (int)-1);
            }
            finYearStartDate = org.apache.commons.lang3.time.DateUtils.addYears((Date)finYearStartDate, (int)-1);
            finYearEndDate = org.apache.commons.lang3.time.DateUtils.addYears((Date)finYearEndDate, (int)-1);
        }
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken by getMonthwiseCollectionsForConsecutiveYears() for 3 consecutive years is : " + timeTaken + MILLISECS);
        }
        startTime = System.currentTimeMillis();
        if (StringUtils.isBlank((CharSequence)collectionDashBoardRequest.getFromDate()) && StringUtils.isBlank((CharSequence)collectionDashBoardRequest.getToDate())) {
            for (Map.Entry entry : DateUtils.getAllFinancialYearMonthsWithFullNames().entrySet()) {
                CollectionDashBoardTrend collTrend = new CollectionDashBoardTrend();
                collTrend.setMonth((String)entry.getValue());
                collTrend.setCyColl(((Map)yearwiseMonthlyCollList.get(0)).get(collTrend.getMonth()) == null ? BigDecimal.ZERO : (BigDecimal)((Map)yearwiseMonthlyCollList.get(0)).get(collTrend.getMonth()));
                collTrend.setLyColl(((Map)yearwiseMonthlyCollList.get(1)).get(collTrend.getMonth()) == null ? BigDecimal.ZERO : (BigDecimal)((Map)yearwiseMonthlyCollList.get(1)).get(collTrend.getMonth()));
                collTrend.setPyColl(((Map)yearwiseMonthlyCollList.get(2)).get(collTrend.getMonth()) == null ? BigDecimal.ZERO : (BigDecimal)((Map)yearwiseMonthlyCollList.get(2)).get(collTrend.getMonth()));
                collTrendsList.add(collTrend);
            }
        } else {
            for (Map.Entry entry : ((Map)yearwiseMonthlyCollList.get(0)).entrySet()) {
                CollectionDashBoardTrend collTrend = new CollectionDashBoardTrend();
                collTrend.setMonth((String)entry.getKey());
                collTrend.setCyColl((BigDecimal)entry.getValue());
                collTrend.setLyColl(((Map)yearwiseMonthlyCollList.get(1)).get(collTrend.getMonth()) == null ? BigDecimal.ZERO : (BigDecimal)((Map)yearwiseMonthlyCollList.get(1)).get(collTrend.getMonth()));
                collTrend.setPyColl(((Map)yearwiseMonthlyCollList.get(2)).get(collTrend.getMonth()) == null ? BigDecimal.ZERO : (BigDecimal)((Map)yearwiseMonthlyCollList.get(2)).get(collTrend.getMonth()));
                collTrendsList.add(collTrend);
            }
        }
        timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken setting values in getMonthwiseCollectionDetails() is : " + timeTaken + MILLISECS);
        }
        return collTrendsList;
    }

    private Aggregations getMonthwiseCollectionsForConsecutiveYears(CollectionDashBoardRequest collectionDashBoardRequest, Date fromDate, Date toDate, List<String> serviceDetail) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDashBoardRequest);
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)RECEIPT_DATE).gte(CollectionConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(CollectionConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false)).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)STATUS, (Object)CANCELLED));
        if (!serviceDetail.isEmpty()) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)BILLING_SERVICE, serviceDetail));
        }
        AggregationBuilder monthAggregation = ((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)DATE_AGG).field(RECEIPT_DATE)).interval(DateHistogramInterval.MONTH).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"current_total").field(TOTAL_AMOUNT));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"receipts"}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)monthAggregation).build();
        return (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
    }

    public List<TaxPayerDashBoardDetails> returnUlbWiseAggregationResults(CollectionDashBoardRequest collectionDashBoardRequest, String indexName, Boolean order, String orderingAggregationName, int size, List<String> serviceDetails) {
        ArrayList<TaxPayerDashBoardDetails> taxPayers = new ArrayList<TaxPayerDashBoardDetails>();
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDashBoardRequest);
        if (!serviceDetails.isEmpty()) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)BILLING_SERVICE, serviceDetails));
        }
        String groupingField = StringUtils.isNotBlank((CharSequence)collectionDashBoardRequest.getUlbCode()) || StringUtils.isNotBlank((CharSequence)collectionDashBoardRequest.getType()) && collectionDashBoardRequest.getType().equals("ward") ? REVENUE_WARD : CITY_NAME;
        Long startTime = System.currentTimeMillis();
        AggregationBuilder aggregation = ((TermsBuilder)AggregationBuilders.terms((String)BY_AGGREGATION_FIELD).field(groupingField)).size(size).order(Terms.Order.aggregation((String)orderingAggregationName, (boolean)order)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)TOTAL_COLLECTION).field(TOTAL_AMOUNT));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{indexName}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)aggregation).build();
        Aggregations collAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken by ulbWiseAggregations is : " + timeTaken + MILLISECS);
        }
        boolean isWard = false;
        startTime = System.currentTimeMillis();
        Date fromDate = new DateTime().withMonthOfYear(4).dayOfMonth().withMinimumValue().toDate();
        Date toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)new Date(), (int)1);
        Date lastYearFromDate = org.apache.commons.lang3.time.DateUtils.addYears((Date)fromDate, (int)-1);
        Date lastYearToDate = org.apache.commons.lang3.time.DateUtils.addYears((Date)toDate, (int)-1);
        StringTerms totalAmountAggr = (StringTerms)collAggr.get(BY_AGGREGATION_FIELD);
        for (Terms.Bucket entry : totalAmountAggr.getBuckets()) {
            TaxPayerDashBoardDetails taxDetail = new TaxPayerDashBoardDetails();
            taxDetail.setRegionName(collectionDashBoardRequest.getRegionName());
            taxDetail.setDistrictName(collectionDashBoardRequest.getDistrictName());
            taxDetail.setUlbGrade(collectionDashBoardRequest.getUlbGrade());
            String fieldName = String.valueOf(entry.getKey());
            if (groupingField.equals(REVENUE_WARD)) {
                taxDetail.setWardName(fieldName);
                isWard = true;
            } else {
                taxDetail.setUlbName(fieldName);
            }
            Sum totalCollectionAggregation = (Sum)entry.getAggregations().get(TOTAL_COLLECTION);
            BigDecimal totalCollections = BigDecimal.valueOf(totalCollectionAggregation.getValue()).setScale(0, 4);
            taxDetail.setCytdColl(totalCollections);
            BigDecimal lastYearCollection = this.getCollectionBetweenDates(collectionDashBoardRequest, lastYearFromDate, lastYearToDate, fieldName, serviceDetails, isWard);
            taxDetail.setLytdColl(lastYearCollection);
            BigDecimal variation = lastYearCollection.compareTo(BigDecimal.ZERO) == 0 ? CollectionConstants.BIGDECIMAL_100 : totalCollections.subtract(lastYearCollection).multiply(CollectionConstants.BIGDECIMAL_100).divide(lastYearCollection, 1, 4);
            taxDetail.setLyVar(variation);
            taxPayers.add(taxDetail);
        }
        timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken for setting values in returnUlbWiseAggregationResults() is : " + timeTaken + MILLISECS);
        }
        return this.returnTopResults(taxPayers, size, order);
    }

    private List<TaxPayerDashBoardDetails> returnTopResults(List<TaxPayerDashBoardDetails> taxPayers, int size, Boolean order) {
        if (size >= 10) {
            if (order.booleanValue()) {
                Collections.sort(taxPayers);
            } else {
                Collections.sort(taxPayers, Collections.reverseOrder());
            }
            return taxPayers.subList(0, taxPayers.size() < 10 ? taxPayers.size() : 10);
        }
        return taxPayers;
    }

    public TaxPayerDashBoardResponseDetails getBottomTenTaxPerformers(CollectionDashBoardRequest collectionDashBoardRequest, List<String> serviceList) {
        TaxPayerDashBoardResponseDetails topTaxPerformers = new TaxPayerDashBoardResponseDetails();
        List<TaxPayerDashBoardDetails> taxProducers = this.returnUlbWiseAggregationResults(collectionDashBoardRequest, "receipts", true, TOTAL_COLLECTION, 10, serviceList);
        topTaxPerformers.setProducers(taxProducers);
        return topTaxPerformers;
    }

    public TaxPayerDashBoardResponseDetails getTopTenTaxPerformers(CollectionDashBoardRequest collectionDashBoardRequest, List<String> serviceList) {
        TaxPayerDashBoardResponseDetails topTaxPerformers = new TaxPayerDashBoardResponseDetails();
        List<TaxPayerDashBoardDetails> taxProducers = this.returnUlbWiseAggregationResults(collectionDashBoardRequest, "receipts", false, TOTAL_COLLECTION, 10, serviceList);
        topTaxPerformers.setProducers(taxProducers);
        return topTaxPerformers;
    }
}

