/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.collection.entity.CollectionSummaryReport;
import org.egov.collection.entity.CollectionSummaryReportResult;
import org.egov.collection.entity.OnlinePaymentResult;
import org.egov.infra.config.core.EnvironmentSettings;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CollectionReportService {
    private static final Logger LOGGER = Logger.getLogger(CollectionReportService.class);
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private EnvironmentSettings environmentSettings;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public SQLQuery getOnlinePaymentReportData(String districtName, String ulbName, String fromDate, String toDate, String transactionId) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("dd/MM/yyyy");
        StringBuilder queryStr = new StringBuilder(500);
        queryStr.append("select * from ").append(this.environmentSettings.statewideSchemaName()).append(".onlinepayment_view opv where 1=1");
        if (StringUtils.isNotBlank((String)districtName)) {
            queryStr.append(" and opv.districtName=:districtName ");
        }
        if (StringUtils.isNotBlank((String)ulbName)) {
            queryStr.append(" and opv.ulbName=:ulbName ");
        }
        if (StringUtils.isNotBlank((String)fromDate)) {
            queryStr.append(" and opv.transactiondate>=:fromDate ");
        }
        if (StringUtils.isNotBlank((String)toDate)) {
            queryStr.append(" and opv.transactiondate<=:toDate ");
        }
        if (StringUtils.isNotBlank((String)transactionId)) {
            queryStr.append(" and opv.transactionnumber like :transactionnumber ");
        }
        queryStr.append(" order by receiptdate desc ");
        SQLQuery query = this.getCurrentSession().createSQLQuery(queryStr.toString());
        if (StringUtils.isNotBlank((String)districtName)) {
            query.setString("districtName", districtName);
        }
        if (StringUtils.isNotBlank((String)ulbName)) {
            query.setString("ulbName", ulbName);
        }
        try {
            if (StringUtils.isNotBlank((String)fromDate)) {
                query.setDate("fromDate", dateFormatter.parse(fromDate));
            }
            if (StringUtils.isNotBlank((String)toDate)) {
                query.setDate("toDate", dateFormatter.parse(toDate));
            }
        }
        catch (ParseException e) {
            LOGGER.error((Object)("Exception parsing Date" + e.getMessage()));
        }
        if (StringUtils.isNotBlank((String)transactionId)) {
            query.setString("transactionnumber", "%" + transactionId + "%");
        }
        queryStr.append(" order by opv.receiptdate desc");
        query.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(OnlinePaymentResult.class));
        return query;
    }

    public List<Object[]> getUlbNames(String districtName) {
        StringBuilder queryStr = new StringBuilder("select distinct ulbname from ").append(this.environmentSettings.statewideSchemaName()).append(".onlinepayment_view opv where 1=1");
        if (StringUtils.isNotBlank((String)districtName)) {
            queryStr.append(" and opv.districtName=:districtName ");
        }
        SQLQuery query = this.getCurrentSession().createSQLQuery(queryStr.toString());
        if (StringUtils.isNotBlank((String)districtName)) {
            query.setString("districtName", districtName);
        }
        return query.list();
    }

    public List<Object[]> getDistrictNames() {
        StringBuilder queryStr = new StringBuilder("select distinct districtname from ").append(this.environmentSettings.statewideSchemaName()).append(".onlinepayment_view");
        SQLQuery query = this.getCurrentSession().createSQLQuery(queryStr.toString());
        return query.list();
    }

    public CollectionSummaryReportResult getCollectionSummaryReport(Date fromDate, Date toDate, String paymentMode, String source, Long serviceId, int status, String serviceType) {
        SimpleDateFormat fromDateFormatter = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        SimpleDateFormat toDateFormatter = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
        StringBuilder aggregateQuery = new StringBuilder();
        StringBuilder userwiseQuery = new StringBuilder();
        StringBuilder finalUserwiseQuery = new StringBuilder();
        StringBuilder finalAggregateQuery = new StringBuilder();
        StringBuilder selectQuery = new StringBuilder("SELECT (CASE WHEN EGF_INSTRUMENTTYPE.TYPE='cash' THEN count(distinct(EGCL_COLLECTIONHEADER.ID)) END) AS cashCount,  (CASE WHEN EGF_INSTRUMENTTYPE.TYPE='cheque' THEN count(distinct(EGCL_COLLECTIONHEADER.ID)) WHEN EGF_INSTRUMENTTYPE.TYPE='dd' THEN count(distinct(EGCL_COLLECTIONHEADER.ID)) END) AS chequeddCount,  (CASE WHEN EGF_INSTRUMENTTYPE.TYPE= 'online' THEN count(distinct(EGCL_COLLECTIONHEADER.ID)) END) AS onlineCount,  EGCL_COLLECTIONHEADER.SOURCE AS source, SER.NAME AS serviceName, (CASE WHEN EGF_INSTRUMENTTYPE.TYPE='cash' THEN SUM(EGF_INSTRUMENTHEADER.INSTRUMENTAMOUNT) END) AS cashAmount,  (CASE WHEN EGF_INSTRUMENTTYPE.TYPE='cheque' THEN SUM(EGF_INSTRUMENTHEADER.INSTRUMENTAMOUNT) WHEN EGF_INSTRUMENTTYPE.TYPE='dd' THEN SUM(EGF_INSTRUMENTHEADER.INSTRUMENTAMOUNT) END) AS chequeddAmount, (CASE WHEN EGF_INSTRUMENTTYPE.TYPE= 'online' THEN SUM(EGF_INSTRUMENTHEADER.INSTRUMENTAMOUNT) END) AS onlineAmount,  (CASE WHEN EGF_INSTRUMENTTYPE.TYPE='bankchallan' THEN count(distinct(EGCL_COLLECTIONHEADER.ID)) END) AS bankCount,  (CASE WHEN EGF_INSTRUMENTTYPE.TYPE='bankchallan' THEN SUM(EGF_INSTRUMENTHEADER.INSTRUMENTAMOUNT) END) AS bankAmount,  (CASE WHEN EGF_INSTRUMENTTYPE.TYPE='card' THEN count(distinct(EGCL_COLLECTIONHEADER.ID)) END) AS cardCount,  (CASE WHEN EGF_INSTRUMENTTYPE.TYPE='card' THEN SUM(EGF_INSTRUMENTHEADER.INSTRUMENTAMOUNT) END) AS cardAmount,  count(distinct(EGCL_COLLECTIONHEADER.ID)) as totalReceiptCount ");
        StringBuilder fromQuery = new StringBuilder(" FROM EGCL_COLLECTIONHEADER EGCL_COLLECTIONHEADER INNER JOIN EGCL_COLLECTIONINSTRUMENT EGCL_COLLECTIONINSTRUMENT ON EGCL_COLLECTIONHEADER.ID = EGCL_COLLECTIONINSTRUMENT.COLLECTIONHEADER INNER JOIN EGF_INSTRUMENTHEADER EGF_INSTRUMENTHEADER ON EGCL_COLLECTIONINSTRUMENT.INSTRUMENTHEADER = EGF_INSTRUMENTHEADER.ID INNER JOIN EGW_STATUS EGW_STATUS ON EGCL_COLLECTIONHEADER.STATUS = EGW_STATUS.ID INNER JOIN EGF_INSTRUMENTTYPE EGF_INSTRUMENTTYPE ON EGF_INSTRUMENTHEADER.INSTRUMENTTYPE = EGF_INSTRUMENTTYPE.ID INNER JOIN EGCL_COLLECTIONMIS EGCL_COLLECTIONMIS ON EGCL_COLLECTIONHEADER.ID = EGCL_COLLECTIONMIS.COLLECTIONHEADER INNER JOIN EGCL_SERVICEDETAILS SER ON SER.ID = EGCL_COLLECTIONHEADER.SERVICEDETAILS ");
        StringBuilder whereQuery = new StringBuilder(" WHERE EGW_STATUS.DESCRIPTION != 'Cancelled'");
        StringBuilder groupQuery = new StringBuilder(" GROUP BY  source, counterName, employeeName, USERID,serviceName, EGF_INSTRUMENTTYPE.TYPE");
        aggregateQuery.append((CharSequence)selectQuery).append(" , '' AS counterName, '' AS employeeName, 0 AS USERID ").append((CharSequence)fromQuery);
        userwiseQuery.append((CharSequence)selectQuery).append(" , EG_LOCATION.NAME AS counterName, EG_USER.NAME AS employeeName, EG_USER.ID AS USERID").append((CharSequence)fromQuery).append(" LEFT JOIN EG_LOCATION EG_LOCATION ON EGCL_COLLECTIONHEADER.LOCATION = EG_LOCATION.ID  INNER JOIN EG_USER EG_USER ON EGCL_COLLECTIONHEADER.CREATEDBY = EG_USER.ID ");
        if (fromDate != null && toDate != null) {
            whereQuery.append(" AND EGCL_COLLECTIONHEADER.RECEIPTDATE between to_timestamp('" + fromDateFormatter.format(fromDate) + "', 'YYYY-MM-DD HH24:MI:SS') and " + " to_timestamp('" + toDateFormatter.format(toDate) + "', 'YYYY-MM-DD HH24:MI:SS') ");
        }
        if (!source.isEmpty() && !source.equals("ALL")) {
            whereQuery.append(" AND EGCL_COLLECTIONHEADER.SOURCE=:source");
        } else {
            userwiseQuery.setLength(0);
            userwiseQuery.append((CharSequence)aggregateQuery);
        }
        if (serviceId != null && serviceId != -1L) {
            whereQuery.append(" AND EGCL_COLLECTIONHEADER.SERVICEDETAILS =:serviceId");
        }
        if (status != -1) {
            whereQuery.append(" AND EGCL_COLLECTIONHEADER.STATUS =:searchStatus");
        }
        if (!serviceType.equals("ALL")) {
            whereQuery.append(" AND SER.SERVICETYPE =:serviceType");
        }
        if (StringUtils.isNotBlank((String)paymentMode) && !paymentMode.equals("ALL")) {
            whereQuery.append(" AND EGF_INSTRUMENTTYPE.TYPE in (:paymentMode)");
            if (paymentMode.equals("online")) {
                userwiseQuery.setLength(0);
                userwiseQuery.append((CharSequence)aggregateQuery);
            }
            userwiseQuery.append((CharSequence)whereQuery).append((CharSequence)groupQuery);
            aggregateQuery.append((CharSequence)whereQuery).append((CharSequence)groupQuery);
        } else {
            userwiseQuery.append((CharSequence)whereQuery);
            aggregateQuery.append((CharSequence)whereQuery);
            userwiseQuery = this.prepareQueryForAllPaymentMode(userwiseQuery, groupQuery);
            aggregateQuery = this.prepareQueryForAllPaymentMode(aggregateQuery, groupQuery);
        }
        StringBuilder finalSelectQuery = new StringBuilder("SELECT cast(sum(cashCount) AS NUMERIC) AS cashCount,cast(sum(chequeddCount) AS NUMERIC) AS chequeddCount,cast(sum(onlineCount) AS NUMERIC) AS onlineCount,source,counterName,employeeName,serviceName,cast(sum(cashAmount) AS NUMERIC) AS cashAmount, cast(sum(chequeddAmount) AS NUMERIC) AS chequeddAmount, cast(sum(onlineAmount) AS NUMERIC) AS onlineAmount ,USERID,cast(sum(bankCount) AS NUMERIC) AS bankCount, cast(sum(bankAmount) AS NUMERIC) AS bankAmount,   cast(sum(cardCount) AS NUMERIC) AS cardCount, cast(sum(cardAmount) AS NUMERIC) AS cardAmount, cast(sum(totalReceiptCount) AS NUMERIC) as totalReceiptCount  FROM (");
        StringBuilder finalGroupQuery = new StringBuilder(" ) AS RESULT GROUP BY RESULT.source,RESULT.counterName,RESULT.employeeName,RESULT.USERID,RESULT.serviceName order by source,employeeName, serviceName ");
        finalUserwiseQuery.append((CharSequence)finalSelectQuery).append((CharSequence)userwiseQuery).append((CharSequence)finalGroupQuery);
        finalAggregateQuery.append((CharSequence)finalSelectQuery).append((CharSequence)aggregateQuery).append((CharSequence)finalGroupQuery);
        SQLQuery userwiseSqluery = this.createSQLQuery(finalUserwiseQuery.toString());
        SQLQuery aggregateSqlQuery = this.createSQLQuery(finalAggregateQuery.toString());
        if (!source.isEmpty() && !source.equals("ALL")) {
            userwiseSqluery.setString("source", source);
            aggregateSqlQuery.setString("source", source);
        }
        if (serviceId != null && serviceId != -1L) {
            userwiseSqluery.setLong("serviceId", serviceId.longValue());
            aggregateSqlQuery.setLong("serviceId", serviceId.longValue());
        }
        if (status != -1) {
            userwiseSqluery.setLong("searchStatus", (long)status);
            aggregateSqlQuery.setLong("searchStatus", (long)status);
        }
        if (!serviceType.equals("ALL")) {
            userwiseSqluery.setString("serviceType", serviceType);
            aggregateSqlQuery.setString("serviceType", serviceType);
        }
        if (StringUtils.isNotBlank((String)paymentMode) && !paymentMode.equals("ALL")) {
            if (paymentMode.equals("cheque/dd")) {
                userwiseSqluery.setParameterList("paymentMode", new ArrayList<String>(Arrays.asList("cheque", "dd")));
                aggregateSqlQuery.setParameterList("paymentMode", new ArrayList<String>(Arrays.asList("cheque", "dd")));
            } else {
                userwiseSqluery.setString("paymentMode", paymentMode);
                aggregateSqlQuery.setString("paymentMode", paymentMode);
            }
        }
        List<CollectionSummaryReport> reportResults = this.populateQueryResults(userwiseSqluery.list());
        List<CollectionSummaryReport> aggrReportResults = this.populateQueryResults(aggregateSqlQuery.list());
        CollectionSummaryReportResult collResult = new CollectionSummaryReportResult();
        collResult.setCollectionSummaryReportList(reportResults);
        collResult.setAggrCollectionSummaryReportList(aggrReportResults);
        return collResult;
    }

    public StringBuilder prepareQueryForAllPaymentMode(StringBuilder query, StringBuilder groupQuery) {
        String unionString = " union ";
        StringBuilder queryString = new StringBuilder();
        queryString.append((CharSequence)query);
        queryString.append(" AND EGF_INSTRUMENTTYPE.TYPE = 'cash'");
        queryString.append((CharSequence)groupQuery);
        queryString.append(unionString);
        queryString.append((CharSequence)query);
        queryString.append(" AND EGF_INSTRUMENTTYPE.TYPE = 'bankchallan'");
        queryString.append((CharSequence)groupQuery);
        queryString.append(unionString);
        queryString.append((CharSequence)query);
        queryString.append(" AND EGF_INSTRUMENTTYPE.TYPE in( 'cheque','dd')");
        queryString.append((CharSequence)groupQuery);
        queryString.append(unionString);
        queryString.append((CharSequence)query);
        queryString.append(" AND EGF_INSTRUMENTTYPE.TYPE = 'online'");
        queryString.append((CharSequence)groupQuery);
        queryString.append(unionString);
        queryString.append((CharSequence)query);
        queryString.append(" AND EGF_INSTRUMENTTYPE.TYPE  = 'card' ");
        queryString.append((CharSequence)groupQuery);
        return queryString;
    }

    public SQLQuery createSQLQuery(String query) {
        return (SQLQuery)this.getCurrentSession().createSQLQuery(query).addScalar("cashCount", (Type)StringType.INSTANCE).addScalar("cashAmount", (Type)BigDecimalType.INSTANCE).addScalar("chequeddCount", (Type)StringType.INSTANCE).addScalar("chequeddAmount", (Type)BigDecimalType.INSTANCE).addScalar("onlineCount", (Type)StringType.INSTANCE).addScalar("onlineAmount", (Type)BigDecimalType.INSTANCE).addScalar("source", (Type)StringType.INSTANCE).addScalar("serviceName", (Type)StringType.INSTANCE).addScalar("counterName", (Type)StringType.INSTANCE).addScalar("employeeName", (Type)StringType.INSTANCE).addScalar("bankCount", (Type)StringType.INSTANCE).addScalar("bankAmount", (Type)BigDecimalType.INSTANCE).addScalar("cardAmount", (Type)BigDecimalType.INSTANCE).addScalar("cardCount", (Type)StringType.INSTANCE).addScalar("totalReceiptCount", (Type)StringType.INSTANCE).setResultTransformer(Transformers.aliasToBean(CollectionSummaryReport.class));
    }

    public List<CollectionSummaryReport> populateQueryResults(List<CollectionSummaryReport> queryResults) {
        for (CollectionSummaryReport collectionSummaryReport : queryResults) {
            if (collectionSummaryReport.getCashCount() == null) {
                collectionSummaryReport.setCashCount("");
            }
            if (collectionSummaryReport.getChequeddCount() == null) {
                collectionSummaryReport.setChequeddCount("");
            }
            if (collectionSummaryReport.getOnlineCount() == null) {
                collectionSummaryReport.setOnlineCount("");
            }
            if (collectionSummaryReport.getBankCount() == null) {
                collectionSummaryReport.setBankCount("");
            }
            if (collectionSummaryReport.getCardCount() == null) {
                collectionSummaryReport.setCardCount("");
            }
            if (collectionSummaryReport.getTotalReceiptCount() == null) {
                collectionSummaryReport.setTotalReceiptCount("");
            }
            if (collectionSummaryReport.getCashAmount() == null) {
                collectionSummaryReport.setCashAmount(BigDecimal.ZERO);
            }
            if (collectionSummaryReport.getChequeddAmount() == null) {
                collectionSummaryReport.setChequeddAmount(BigDecimal.ZERO);
            }
            if (collectionSummaryReport.getOnlineAmount() == null) {
                collectionSummaryReport.setOnlineAmount(BigDecimal.ZERO);
            }
            if (collectionSummaryReport.getBankAmount() == null) {
                collectionSummaryReport.setBankAmount(BigDecimal.ZERO);
            }
            if (collectionSummaryReport.getCardAmount() == null) {
                collectionSummaryReport.setCardAmount(BigDecimal.ZERO);
            }
            collectionSummaryReport.setTotalAmount(collectionSummaryReport.getCardAmount().add(collectionSummaryReport.getBankAmount()).add(collectionSummaryReport.getOnlineAmount()).add(collectionSummaryReport.getChequeddAmount()).add(collectionSummaryReport.getCashAmount()));
        }
        return queryResults;
    }
}

