/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.StringUtils;
import org.egov.collection.entity.CollectionSummaryHeadWiseReport;
import org.egov.collection.entity.CollectionSummaryHeadWiseReportResult;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.Transformers;
import org.hibernate.type.DoubleType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.springframework.stereotype.Service;

@Service
public class CollectionReportHeadWiseService {
    @PersistenceContext
    EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public CollectionSummaryHeadWiseReportResult getCollectionSummaryReport(Date fromDate, Date toDate, String paymentMode, String source, String glCode, int status, Integer branchId) {
        SimpleDateFormat fromDateFormatter = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        SimpleDateFormat toDateFormatter = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
        StringBuilder defaultQueryStr = new StringBuilder(500);
        StringBuilder aggregateQueryStr = new StringBuilder();
        StringBuilder rebateQueryStr = new StringBuilder("");
        StringBuilder revenueHeadQueryStr = new StringBuilder("");
        StringBuilder selectQueryStr = new StringBuilder("SELECT  (CASE WHEN EGF_INSTRUMENTTYPE.TYPE='cash' THEN count(distinct(EGCL_COLLECTIONHEADER.id)) END) AS cashCount,   (CASE WHEN EGF_INSTRUMENTTYPE.TYPE='cheque' THEN count(distinct(EGCL_COLLECTIONHEADER.id)) WHEN EGF_INSTRUMENTTYPE.TYPE='dd' THEN count(distinct(EGCL_COLLECTIONHEADER.id)) END) AS chequeddCount,  (CASE WHEN EGF_INSTRUMENTTYPE.TYPE= 'online' THEN count(distinct(EGCL_COLLECTIONHEADER.id)) END) AS onlineCount,  (CASE WHEN EGF_INSTRUMENTTYPE.TYPE='card' THEN count(distinct(EGCL_COLLECTIONHEADER.id)) END) AS cardCount,  count(*) as totalReceiptCount,  EGCL_COLLECTIONHEADER.SOURCE AS source,CAO.NAME || '-' || CAO.GLCODE AS GLCODE,");
        StringBuilder revSelectQueryStr = new StringBuilder(selectQueryStr).append(" (CASE WHEN EGF_INSTRUMENTTYPE.TYPE='cash' THEN SUM(EGCL_COLLECTIONDETAILS.CRAMOUNT) END) AS cashAmount,  (CASE WHEN EGF_INSTRUMENTTYPE.TYPE='cheque' THEN SUM(EGCL_COLLECTIONDETAILS.CRAMOUNT) WHEN EGF_INSTRUMENTTYPE.TYPE='dd' THEN SUM(EGCL_COLLECTIONDETAILS.CRAMOUNT) END) AS chequeddAmount, (CASE WHEN EGF_INSTRUMENTTYPE.TYPE='card' THEN SUM(EGCL_COLLECTIONDETAILS.CRAMOUNT) END) AS cardAmount,  (CASE WHEN EGF_INSTRUMENTTYPE.TYPE= 'online' THEN SUM(EGCL_COLLECTIONDETAILS.CRAMOUNT) END) AS onlineAmount");
        StringBuilder rebateSelectQueryStr = new StringBuilder(selectQueryStr).append(" (CASE WHEN EGF_INSTRUMENTTYPE.TYPE='cash' THEN SUM(EGCL_COLLECTIONDETAILS.DRAMOUNT) END) AS cashAmount,  (CASE WHEN EGF_INSTRUMENTTYPE.TYPE='cheque' THEN SUM(EGCL_COLLECTIONDETAILS.DRAMOUNT) WHEN EGF_INSTRUMENTTYPE.TYPE='dd' THEN SUM(EGCL_COLLECTIONDETAILS.DRAMOUNT) END) AS chequeddAmount, (CASE WHEN EGF_INSTRUMENTTYPE.TYPE='card' THEN SUM(EGCL_COLLECTIONDETAILS.DRAMOUNT) END) AS cardAmount,  (CASE WHEN EGF_INSTRUMENTTYPE.TYPE= 'online' THEN SUM(EGCL_COLLECTIONDETAILS.DRAMOUNT) END) AS onlineAmount");
        StringBuilder fromQueryStr = new StringBuilder(" FROM  EGCL_COLLECTIONHEADER EGCL_COLLECTIONHEADER INNER JOIN EGCL_COLLECTIONINSTRUMENT EGCL_COLLECTIONINSTRUMENT ON EGCL_COLLECTIONHEADER.ID = EGCL_COLLECTIONINSTRUMENT.COLLECTIONHEADER  INNER JOIN EGF_INSTRUMENTHEADER EGF_INSTRUMENTHEADER ON EGCL_COLLECTIONINSTRUMENT.INSTRUMENTHEADER = EGF_INSTRUMENTHEADER.ID  INNER JOIN EGW_STATUS EGW_STATUS ON EGCL_COLLECTIONHEADER.STATUS = EGW_STATUS.ID INNER JOIN EGF_INSTRUMENTTYPE EGF_INSTRUMENTTYPE ON EGF_INSTRUMENTHEADER.INSTRUMENTTYPE = EGF_INSTRUMENTTYPE.ID INNER JOIN EGCL_COLLECTIONMIS EGCL_COLLECTIONMIS ON EGCL_COLLECTIONHEADER.ID = EGCL_COLLECTIONMIS.COLLECTIONHEADER  INNER JOIN EGCL_COLLECTIONDETAILS EGCL_COLLECTIONDETAILS ON EGCL_COLLECTIONHEADER.ID = EGCL_COLLECTIONDETAILS.COLLECTIONHEADER  INNER JOIN CHARTOFACCOUNTS CAO ON CAO.ID = EGCL_COLLECTIONDETAILS.CHARTOFACCOUNT ");
        StringBuilder whereQueryStr = new StringBuilder(" WHERE EGW_STATUS.DESCRIPTION != 'Cancelled' ");
        StringBuilder creditWhereQueryStr = new StringBuilder("  AND EGCL_COLLECTIONDETAILS.CRAMOUNT>0 ");
        StringBuilder debitWhereQueryStr = new StringBuilder("  AND EGCL_COLLECTIONDETAILS.DRAMOUNT>0 AND CAO.purposeid in (select id from EGF_ACCOUNTCODE_PURPOSE where name ='REBATE')");
        StringBuilder queryStrGroup = new StringBuilder(" GROUP BY source,CAO.NAME,CAO.GLCODE,EGF_INSTRUMENTTYPE.TYPE ");
        StringBuilder finalSelectQueryStr = new StringBuilder("SELECT sum(cashCount) AS cashCount,sum(chequeddCount) AS chequeddCount,sum(onlineCount) AS onlineCount,SOURCE,glCode,sum(cashAmount) AS cashAmount, sum(chequeddAmount) AS chequeddAmount,    sum(cardCount) AS cardCount, sum(cardAmount) AS cardAmount, cast(sum(totalReceiptCount) AS NUMERIC) as totalReceiptCount,sum(onlineAmount) AS onlineAmount  FROM (");
        StringBuilder finalGroupQuery = new StringBuilder(" ) AS RESULT GROUP BY RESULT.SOURCE,RESULT.glCode order by source, glCode");
        if (fromDate != null && toDate != null) {
            whereQueryStr.append(" AND EGCL_COLLECTIONHEADER.RECEIPTDATE between to_timestamp('" + fromDateFormatter.format(fromDate) + "', 'YYYY-MM-DD HH24:MI:SS') and " + " to_timestamp('" + toDateFormatter.format(toDate) + "', 'YYYY-MM-DD HH24:MI:SS') ");
        }
        if (!source.isEmpty() && !source.equals("ALL")) {
            whereQueryStr.append(" AND EGCL_COLLECTIONHEADER.SOURCE=:source");
        }
        if (glCode != null) {
            whereQueryStr.append(" AND CAO.GLCODE =:glCode");
        }
        if (branchId != null && branchId != -1) {
            whereQueryStr.append(" AND EGCL_COLLECTIONMIS.DEPOSITEDBRANCH=:branchId");
        }
        if (status != -1) {
            whereQueryStr.append(" AND EGCL_COLLECTIONHEADER.STATUS =:searchStatus");
        }
        if (StringUtils.isNotBlank((String)paymentMode) && !paymentMode.equals("ALL")) {
            whereQueryStr.append(" AND EGF_INSTRUMENTTYPE.TYPE in (:paymentMode)");
            revenueHeadQueryStr.append((CharSequence)revSelectQueryStr).append((CharSequence)fromQueryStr).append((CharSequence)whereQueryStr).append((CharSequence)creditWhereQueryStr).append((CharSequence)queryStrGroup);
            rebateQueryStr.append((CharSequence)rebateSelectQueryStr).append((CharSequence)fromQueryStr).append((CharSequence)whereQueryStr).append((CharSequence)debitWhereQueryStr).append((CharSequence)queryStrGroup);
        } else {
            revenueHeadQueryStr.append((CharSequence)revSelectQueryStr).append((CharSequence)fromQueryStr).append((CharSequence)whereQueryStr).append((CharSequence)creditWhereQueryStr).append(" AND EGF_INSTRUMENTTYPE.TYPE = 'cash'").append((CharSequence)queryStrGroup);
            revenueHeadQueryStr.append(" union ");
            revenueHeadQueryStr.append((CharSequence)revSelectQueryStr).append((CharSequence)fromQueryStr).append((CharSequence)whereQueryStr).append((CharSequence)creditWhereQueryStr).append(" AND EGF_INSTRUMENTTYPE.TYPE  in( 'cheque','dd') ").append((CharSequence)queryStrGroup);
            revenueHeadQueryStr.append(" union ");
            revenueHeadQueryStr.append((CharSequence)revSelectQueryStr).append((CharSequence)fromQueryStr).append((CharSequence)whereQueryStr).append((CharSequence)creditWhereQueryStr).append(" AND EGF_INSTRUMENTTYPE.TYPE = 'card'").append((CharSequence)queryStrGroup);
            revenueHeadQueryStr.append(" union ");
            revenueHeadQueryStr.append((CharSequence)revSelectQueryStr).append((CharSequence)fromQueryStr).append((CharSequence)whereQueryStr).append((CharSequence)creditWhereQueryStr).append(" AND EGF_INSTRUMENTTYPE.TYPE = 'online'").append((CharSequence)queryStrGroup);
            rebateQueryStr.append((CharSequence)rebateSelectQueryStr).append((CharSequence)fromQueryStr).append((CharSequence)whereQueryStr).append((CharSequence)debitWhereQueryStr).append(" AND EGF_INSTRUMENTTYPE.TYPE = 'cash'").append((CharSequence)queryStrGroup);
            rebateQueryStr.append(" union ");
            rebateQueryStr.append((CharSequence)rebateSelectQueryStr).append((CharSequence)fromQueryStr).append((CharSequence)whereQueryStr).append((CharSequence)debitWhereQueryStr).append(" AND EGF_INSTRUMENTTYPE.TYPE  in( 'cheque','dd') ").append((CharSequence)queryStrGroup);
            rebateQueryStr.append(" union ");
            rebateQueryStr.append((CharSequence)rebateSelectQueryStr).append((CharSequence)fromQueryStr).append((CharSequence)whereQueryStr).append((CharSequence)debitWhereQueryStr).append(" AND EGF_INSTRUMENTTYPE.TYPE = 'card'").append((CharSequence)queryStrGroup);
            rebateQueryStr.append(" union ");
            rebateQueryStr.append((CharSequence)rebateSelectQueryStr).append((CharSequence)fromQueryStr).append((CharSequence)whereQueryStr).append((CharSequence)debitWhereQueryStr).append(" AND EGF_INSTRUMENTTYPE.TYPE = 'online'").append((CharSequence)queryStrGroup);
        }
        StringBuilder finalRevQueryStr = new StringBuilder(finalSelectQueryStr).append((CharSequence)revenueHeadQueryStr).append((CharSequence)finalGroupQuery);
        StringBuilder finalRebateQueryStr = new StringBuilder(finalSelectQueryStr).append((CharSequence)rebateQueryStr).append((CharSequence)finalGroupQuery);
        SQLQuery aggrQuery = (SQLQuery)this.getCurrentSession().createSQLQuery(finalRevQueryStr.toString()).addScalar("cashCount", (Type)StringType.INSTANCE).addScalar("cashAmount", (Type)DoubleType.INSTANCE).addScalar("chequeddCount", (Type)StringType.INSTANCE).addScalar("chequeddAmount", (Type)DoubleType.INSTANCE).addScalar("onlineCount", (Type)StringType.INSTANCE).addScalar("onlineAmount", (Type)DoubleType.INSTANCE).addScalar("source", (Type)StringType.INSTANCE).addScalar("glCode", (Type)StringType.INSTANCE).addScalar("cardAmount", (Type)DoubleType.INSTANCE).addScalar("cardCount", (Type)StringType.INSTANCE).addScalar("totalReceiptCount", (Type)StringType.INSTANCE).setResultTransformer(Transformers.aliasToBean(CollectionSummaryHeadWiseReport.class));
        SQLQuery rebateQuery = (SQLQuery)this.getCurrentSession().createSQLQuery(finalRebateQueryStr.toString()).addScalar("cashCount", (Type)StringType.INSTANCE).addScalar("cashAmount", (Type)DoubleType.INSTANCE).addScalar("chequeddCount", (Type)StringType.INSTANCE).addScalar("chequeddAmount", (Type)DoubleType.INSTANCE).addScalar("onlineCount", (Type)StringType.INSTANCE).addScalar("onlineAmount", (Type)DoubleType.INSTANCE).addScalar("source", (Type)StringType.INSTANCE).addScalar("glCode", (Type)StringType.INSTANCE).addScalar("cardAmount", (Type)DoubleType.INSTANCE).addScalar("cardCount", (Type)StringType.INSTANCE).addScalar("totalReceiptCount", (Type)StringType.INSTANCE).setResultTransformer(Transformers.aliasToBean(CollectionSummaryHeadWiseReport.class));
        if (!source.isEmpty() && !source.equals("ALL")) {
            aggrQuery.setString("source", source);
            rebateQuery.setString("source", source);
        }
        if (glCode != null) {
            aggrQuery.setString("glCode", glCode);
            rebateQuery.setString("glCode", glCode);
        }
        if (status != -1) {
            aggrQuery.setLong("searchStatus", (long)status);
            rebateQuery.setLong("searchStatus", (long)status);
        }
        if (StringUtils.isNotBlank((String)paymentMode) && !paymentMode.equals("ALL")) {
            if (paymentMode.equals("cheque/dd")) {
                aggrQuery.setParameterList("paymentMode", new ArrayList<String>(Arrays.asList("cheque", "dd")));
                rebateQuery.setParameterList("paymentMode", new ArrayList<String>(Arrays.asList("cheque", "dd")));
            } else {
                aggrQuery.setString("paymentMode", paymentMode);
                rebateQuery.setString("paymentMode", paymentMode);
            }
        }
        if (branchId != null && branchId != -1) {
            aggrQuery.setInteger("branchId", branchId.intValue());
            rebateQuery.setInteger("branchId", branchId.intValue());
        }
        List<CollectionSummaryHeadWiseReport> rebateReportResultList = this.populateQueryResults(rebateQuery.list());
        List<CollectionSummaryHeadWiseReport> aggrReportResults = this.populateQueryResults(aggrQuery.list());
        CollectionSummaryHeadWiseReportResult collResult = new CollectionSummaryHeadWiseReportResult();
        if (!aggrReportResults.isEmpty()) {
            this.rebateTotal(aggrReportResults.get(0), rebateReportResultList);
        }
        collResult.setAggrCollectionSummaryReportList(aggrReportResults);
        collResult.setRebateCollectionSummaryReportList(rebateReportResultList);
        return collResult;
    }

    public void rebateTotal(CollectionSummaryHeadWiseReport collectionSummaryHeadWiseReport, List<CollectionSummaryHeadWiseReport> rebateResultList) {
        for (CollectionSummaryHeadWiseReport rebate : rebateResultList) {
            if (!rebate.getCashAmount().equals(new Double(0.0))) {
                collectionSummaryHeadWiseReport.setTotalCashRebateAmount(Double.sum(collectionSummaryHeadWiseReport.getTotalCashRebateAmount(), rebate.getCashAmount()));
            }
            if (!rebate.getChequeddAmount().equals(new Double(0.0))) {
                collectionSummaryHeadWiseReport.setTotalChequeddRebateAmount(Double.sum(collectionSummaryHeadWiseReport.getTotalChequeddRebateAmount(), rebate.getChequeddAmount()));
            }
            if (!rebate.getCardAmount().equals(new Double(0.0))) {
                collectionSummaryHeadWiseReport.setTotalCardRebateAmount(Double.sum(collectionSummaryHeadWiseReport.getTotalCardRebateAmount(), rebate.getCardAmount()));
            }
            if (!rebate.getOnlineAmount().equals(new Double(0.0))) {
                collectionSummaryHeadWiseReport.setTotalOnlineRebateAmount(Double.sum(collectionSummaryHeadWiseReport.getTotalOnlineRebateAmount(), rebate.getOnlineAmount()));
            }
            if (rebate.getTotalAmount().equals(new Double(0.0))) continue;
            collectionSummaryHeadWiseReport.setTotalRebateAmount(Double.sum(collectionSummaryHeadWiseReport.getTotalRebateAmount(), rebate.getTotalAmount()));
        }
    }

    public List<CollectionSummaryHeadWiseReport> populateQueryResults(List<CollectionSummaryHeadWiseReport> queryResults) {
        for (CollectionSummaryHeadWiseReport collectionSummaryHeadWiseReport : queryResults) {
            if (collectionSummaryHeadWiseReport.getCashCount() == null) {
                collectionSummaryHeadWiseReport.setCashCount("");
            }
            if (collectionSummaryHeadWiseReport.getChequeddCount() == null) {
                collectionSummaryHeadWiseReport.setChequeddCount("");
            }
            if (collectionSummaryHeadWiseReport.getOnlineCount() == null) {
                collectionSummaryHeadWiseReport.setOnlineCount("");
            }
            if (collectionSummaryHeadWiseReport.getCardCount() == null) {
                collectionSummaryHeadWiseReport.setCardCount("");
            }
            if (collectionSummaryHeadWiseReport.getTotalReceiptCount() == null) {
                collectionSummaryHeadWiseReport.setTotalReceiptCount("");
            }
            if (collectionSummaryHeadWiseReport.getCashAmount() == null) {
                collectionSummaryHeadWiseReport.setCashAmount(0.0);
            }
            if (collectionSummaryHeadWiseReport.getChequeddAmount() == null) {
                collectionSummaryHeadWiseReport.setChequeddAmount(0.0);
            }
            if (collectionSummaryHeadWiseReport.getOnlineAmount() == null) {
                collectionSummaryHeadWiseReport.setOnlineAmount(0.0);
            }
            if (collectionSummaryHeadWiseReport.getCardAmount() == null) {
                collectionSummaryHeadWiseReport.setCardAmount(0.0);
            }
            collectionSummaryHeadWiseReport.getOnlineAmount();
            collectionSummaryHeadWiseReport.setTotalAmount(Double.sum(collectionSummaryHeadWiseReport.getCardAmount(), Double.sum(collectionSummaryHeadWiseReport.getChequeddAmount(), collectionSummaryHeadWiseReport.getCashAmount())));
        }
        return queryResults;
    }
}

