/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.service;

import java.util.Date;
import org.apache.log4j.Logger;
import org.egov.collection.entity.Challan;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.workflow.entity.OwnerGroup;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ChallanService
extends PersistenceService<Challan, Long> {
    private static final Logger LOGGER = Logger.getLogger(ChallanService.class);
    @Autowired
    private CollectionsUtil collectionsUtil;

    public ChallanService() {
        super(Challan.class);
    }

    public ChallanService(Class<Challan> type) {
        super(type);
    }

    public void workflowtransition(Challan challan, Position position, String actionName, String remarks) throws ApplicationRuntimeException {
        if (challan.getState() == null && "CHALLAN_NEW".equals(actionName)) {
            challan.setStatus(this.collectionsUtil.getStatusForModuleAndCode("Challan", "CREATED"));
            challan.transition().start().withComments("Challan created").withStateValue("CREATED").withOwner((OwnerGroup)position).withSenderName(challan.getCreatedBy().getUsername() + "::" + challan.getCreatedBy().getName()).withDateInfo(new Date());
        }
        if ("CHALLAN_MODIFY".equals(actionName)) {
            challan.transition().progressWithStateCopy().withComments("Challan created").withStateValue("CREATED").withOwner((OwnerGroup)position).withSenderName(challan.getCreatedBy().getUsername() + "::" + challan.getCreatedBy().getName()).withDateInfo(new Date());
            LOGGER.debug((Object)"Challan Workflow Started.");
        }
        if ("CHALLAN_APPROVE".equals(actionName)) {
            challan.setStatus(this.collectionsUtil.getStatusForModuleAndCode("Challan", "APPROVED"));
            challan.transition().progressWithStateCopy().withComments(remarks).withStateValue("APPROVED").withOwner((OwnerGroup)position).withSenderName(challan.getCreatedBy().getUsername() + "::" + challan.getCreatedBy().getName()).withDateInfo(new Date());
        }
        if ("CHALLAN_VALIDATE".equals(actionName)) {
            challan.setStatus(this.collectionsUtil.getStatusForModuleAndCode("Challan", "VALIDATED"));
        }
        if ("CHALLAN_REJECT".equals(actionName)) {
            challan.setStatus(this.collectionsUtil.getStatusForModuleAndCode("Challan", "REJECTED"));
            challan.transition().progressWithStateCopy().withComments(remarks).withStateValue("REJECTED").withOwner((OwnerGroup)this.collectionsUtil.getPositionOfUser(challan.getCreatedBy())).withSenderName(challan.getCreatedBy().getUsername() + "::" + challan.getCreatedBy().getName()).withDateInfo(new Date());
        }
        if ("CHALLAN_CANCEL".equals(actionName)) {
            challan.setStatus(this.collectionsUtil.getStatusForModuleAndCode("Challan", "CANCELLED"));
            challan.transition().end().withComments(remarks).withStateValue("CANCELLED").withSenderName(challan.getCreatedBy().getUsername() + "::" + challan.getCreatedBy().getName()).withDateInfo(new Date());
        }
        if ("CHALLAN_CANCEL".equals(actionName) || "CHALLAN_VALIDATE".equals(actionName) && challan.getState() != null) {
            challan.transition().end().withComments("End of challan worklow").withStateValue("END").withSenderName(challan.getCreatedBy().getUsername() + "::" + challan.getCreatedBy().getName()).withDateInfo(new Date());
            LOGGER.debug((Object)"End of Challan Workflow.");
        }
        if (challan.getState() == null && "CHALLAN_VALIDATE".equals(actionName)) {
            challan.transition().start().end().withComments("End of challan worklow").withStateValue("END").withSenderName(challan.getCreatedBy().getUsername() + "::" + challan.getCreatedBy().getName()).withDateInfo(new Date());
            LOGGER.debug((Object)"End of Challan Workflow.");
        }
        this.persist((Object)challan);
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }
}

