/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.integration.services;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.egov.collection.constants.CollectionConstants;
import org.egov.collection.entity.OnlinePayment;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.integration.pgi.AtomAdaptor;
import org.egov.collection.integration.pgi.AxisAdaptor;
import org.egov.collection.integration.pgi.PaymentResponse;
import org.egov.collection.integration.services.ReconciliationService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SchedularService {
    private static final Logger LOGGER = Logger.getLogger(SchedularService.class);
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private ReconciliationService reconciliationService;
    @Autowired
    private AxisAdaptor axisAdaptor;
    @Autowired
    private AtomAdaptor atomAdaptor;

    @Transactional
    public void reconcileAXIS() {
        LOGGER.debug((Object)"Inside reconcileAXIS");
        Calendar cal = Calendar.getInstance();
        cal.add(12, -30);
        Query qry = this.persistenceService.getSession().createQuery("select receipt from org.egov.collection.entity.OnlinePayment as receipt where receipt.status.code=:onlinestatuscode and receipt.service.code=:paymentservicecode and receipt.createdDate<:thirtyminslesssysdate").setMaxResults(50);
        qry.setString("onlinestatuscode", "ONLINE_STATUS_PENDING");
        qry.setString("paymentservicecode", "AXIS");
        qry.setParameter("thirtyminslesssysdate", (Object)new Date(cal.getTimeInMillis()));
        List reconcileList = qry.list();
        LOGGER.debug((Object)("Thread ID = " + Thread.currentThread().getId() + ": got " + reconcileList.size() + " results."));
        if (!reconcileList.isEmpty()) {
            for (OnlinePayment onlinePaymentObj : reconcileList) {
                long startTimeInMilis = System.currentTimeMillis();
                LOGGER.info((Object)("AXIS Receiptid::::" + onlinePaymentObj.getReceiptHeader().getId()));
                PaymentResponse paymentResponse = this.axisAdaptor.createOfflinePaymentRequest(onlinePaymentObj);
                if (paymentResponse == null || !StringUtils.isNotBlank((CharSequence)paymentResponse.getReceiptId())) continue;
                LOGGER.info((Object)("paymentResponse.getReceiptId():" + paymentResponse.getReceiptId()));
                LOGGER.info((Object)("paymentResponse.getAdditionalInfo6():" + paymentResponse.getAdditionalInfo6()));
                LOGGER.info((Object)("paymentResponse.getAuthStatus():" + paymentResponse.getAuthStatus()));
                ReceiptHeader onlinePaymentReceiptHeader = (ReceiptHeader)((Object)this.persistenceService.findByNamedQuery("QUERY_RECEIPT_BY_ID_AND_CITYCODE", new Object[]{Long.valueOf(paymentResponse.getReceiptId()), ApplicationThreadLocals.getCityCode()}));
                if ("0300".equals(paymentResponse.getAuthStatus())) {
                    this.reconciliationService.processSuccessMsg(onlinePaymentReceiptHeader, paymentResponse);
                } else {
                    this.reconciliationService.processFailureMsg(onlinePaymentReceiptHeader, paymentResponse);
                }
                long elapsedTimeInMillis = System.currentTimeMillis() - startTimeInMilis;
                LOGGER.info((Object)("$$$$$$ Online Receipt Persisted with Receipt Number: " + onlinePaymentReceiptHeader.getReceiptnumber() + (onlinePaymentReceiptHeader.getConsumerCode() != null ? " and consumer code: " + onlinePaymentReceiptHeader.getConsumerCode() : "") + "; Time taken(ms) = " + elapsedTimeInMillis));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Transactional
    public void reconcileATOM() {
        LOGGER.debug((Object)"Inside reconcileATOM");
        Calendar fourDaysBackCalender = Calendar.getInstance();
        fourDaysBackCalender.add(5, -4);
        Calendar cal = Calendar.getInstance();
        cal.add(12, -30);
        Query qry = this.persistenceService.getSession().createQuery("select receipt from org.egov.collection.entity.OnlinePayment as receipt where receipt.status.code=:onlinestatuscode and receipt.service.code=:paymentservicecode and receipt.createdDate<:thirtyminslesssysdate order by receipt.id desc ").setMaxResults(50);
        qry.setString("onlinestatuscode", "ONLINE_STATUS_PENDING");
        qry.setString("paymentservicecode", "ATOM");
        qry.setParameter("thirtyminslesssysdate", (Object)new Date(cal.getTimeInMillis()));
        List reconcileList = qry.list();
        LOGGER.debug((Object)("Thread ID = " + Thread.currentThread().getId() + ": got " + reconcileList.size() + " results."));
        if (!reconcileList.isEmpty()) {
            for (OnlinePayment onlinePaymentObj : reconcileList) {
                long startTimeInMilis = System.currentTimeMillis();
                LOGGER.info((Object)("ATOM Receiptid::::" + onlinePaymentObj.getReceiptHeader().getId()));
                PaymentResponse paymentResponse = this.atomAdaptor.createOfflinePaymentRequest(onlinePaymentObj);
                if (paymentResponse == null || !StringUtils.isNotBlank((CharSequence)paymentResponse.getReceiptId())) continue;
                LOGGER.info((Object)("paymentResponse.getReceiptId():" + paymentResponse.getReceiptId()));
                LOGGER.info((Object)("paymentResponse.getAdditionalInfo6():" + paymentResponse.getAdditionalInfo6()));
                LOGGER.info((Object)("paymentResponse.getAuthStatus():" + paymentResponse.getAuthStatus()));
                ReceiptHeader onlinePaymentReceiptHeader = null;
                if (paymentResponse.getAdditionalInfo2() != null && !paymentResponse.getAdditionalInfo2().isEmpty()) {
                    if (!paymentResponse.getAdditionalInfo2().equals(ApplicationThreadLocals.getCityCode())) {
                        LOGGER.error((Object)"City code is not match");
                        throw new ValidationException(Arrays.asList(new ValidationError("City code is not match", "City code is not match")));
                    }
                    onlinePaymentReceiptHeader = (ReceiptHeader)((Object)this.persistenceService.findByNamedQuery("QUERY_RECEIPT_BY_ID_AND_CITYCODE", new Object[]{Long.valueOf(paymentResponse.getReceiptId()), paymentResponse.getAdditionalInfo2()}));
                } else {
                    onlinePaymentReceiptHeader = (ReceiptHeader)((Object)this.persistenceService.findByNamedQuery("QUERY_RECEIPT_BY_ID_AND_CITYCODE", new Object[]{Long.valueOf(paymentResponse.getReceiptId()), ApplicationThreadLocals.getCityCode()}));
                }
                if ("0300".equals(paymentResponse.getAuthStatus())) {
                    this.reconciliationService.processSuccessMsg(onlinePaymentReceiptHeader, paymentResponse);
                } else if (DateUtils.compareDates((Date)onlinePaymentReceiptHeader.getCreatedDate(), (Date)fourDaysBackCalender.getTime()) && onlinePaymentReceiptHeader.getService().getCode().equals("ATOM") && CollectionConstants.ATOM_AUTHORISATION_CODES_WAITINGFOR_PAY_GATEWAY_RESPONSE.contains(paymentResponse.getAuthStatus())) {
                    onlinePaymentReceiptHeader.getOnlinePayment().setAuthorisationStatusCode(paymentResponse.getAuthStatus());
                    onlinePaymentReceiptHeader.getOnlinePayment().setRemarks(paymentResponse.getErrorDescription());
                } else {
                    this.reconciliationService.processFailureMsg(onlinePaymentReceiptHeader, paymentResponse);
                }
                long elapsedTimeInMillis = System.currentTimeMillis() - startTimeInMilis;
                LOGGER.info((Object)("$$$$$$ Online Receipt Persisted with Receipt Number: " + onlinePaymentReceiptHeader.getReceiptnumber() + (onlinePaymentReceiptHeader.getConsumerCode() != null ? " and consumer code: " + onlinePaymentReceiptHeader.getConsumerCode() : "") + "; Time taken(ms) = " + elapsedTimeInMillis));
            }
        }
    }
}

