/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.integration.pgi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.log4j.Logger;
import org.egov.collection.config.properties.CollectionApplicationProperties;
import org.egov.collection.entity.OnlinePayment;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.integration.pgi.DefaultPaymentRequest;
import org.egov.collection.integration.pgi.DefaultPaymentResponse;
import org.egov.collection.integration.pgi.PaymentGatewayAdaptor;
import org.egov.collection.integration.pgi.PaymentRequest;
import org.egov.collection.integration.pgi.PaymentResponse;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.models.ServiceDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AxisAdaptor
implements PaymentGatewayAdaptor {
    private static final Logger LOGGER = Logger.getLogger(AxisAdaptor.class);
    private static final BigDecimal PAISE_RUPEE_CONVERTER = BigDecimal.valueOf(100L);
    private static final String UTF8 = "UTF-8";
    private static final String NO_VALUE_RETURNED = "No Value Returned";
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private CollectionApplicationProperties collectionApplicationProperties;
    @Autowired
    private CityService cityService;

    @Override
    public PaymentRequest createPaymentRequest(ServiceDetails paymentServiceDetails, ReceiptHeader receiptHeader) {
        LOGGER.debug((Object)"inside createPaymentRequest");
        DefaultPaymentRequest paymentRequest = new DefaultPaymentRequest();
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>(0);
        StringBuilder requestURL = new StringBuilder();
        BigDecimal amount = receiptHeader.getTotalAmount();
        float rupees = Float.parseFloat(amount.toString());
        Integer rupee = (int)rupees;
        Float exponent = Float.valueOf(rupees - (float)rupee.intValue());
        Integer paise = (int)((float)(rupee * PAISE_RUPEE_CONVERTER.intValue()) + exponent.floatValue() * (float)PAISE_RUPEE_CONVERTER.intValue());
        StringBuilder returnUrl = new StringBuilder();
        returnUrl.append(paymentServiceDetails.getCallBackurl()).append("?paymentServiceId=").append(paymentServiceDetails.getId());
        fields.put("vpc_AccessCode", this.collectionApplicationProperties.axisAccessCode());
        fields.put("vpc_Amount", paise.toString());
        fields.put("vpc_Command", this.collectionApplicationProperties.axisCommand());
        fields.put("vpc_Locale", this.collectionApplicationProperties.axisLocale());
        fields.put("vpc_MerchTxnRef", ApplicationThreadLocals.getCityCode() + "-" + receiptHeader.getId().toString());
        fields.put("vpc_Merchant", this.collectionApplicationProperties.axisMerchant());
        fields.put("vpc_OrderInfo", ApplicationThreadLocals.getCityCode() + "-" + ApplicationThreadLocals.getCityName());
        fields.put("vpc_ReturnURL", returnUrl.toString());
        fields.put("vpc_TicketNumber", receiptHeader.getConsumerCode());
        fields.put("vpc_Version", this.collectionApplicationProperties.axisVersion());
        String axisSecureSecret = this.collectionApplicationProperties.axisSecureSecret();
        if (axisSecureSecret != null) {
            String secureHash = this.hashAllFields(fields);
            fields.put("vpc_SecureHash", secureHash);
        }
        fields.put("vpc_SecureHashType", "SHA256");
        requestURL.append(paymentServiceDetails.getServiceUrl()).append('?');
        this.appendQueryFields(requestURL, fields);
        paymentRequest.setParameter("paymentGatewayURL", requestURL);
        LOGGER.info((Object)("AXIS payment gateway request: " + paymentRequest.getRequestParameters()));
        return paymentRequest;
    }

    private String hashAllFields(LinkedHashMap<String, String> fields) {
        String axisSecureSecret = this.collectionApplicationProperties.axisSecureSecret();
        byte[] hashValue = null;
        ArrayList<String> fieldNames = new ArrayList<String>(fields.keySet());
        Collections.sort(fieldNames);
        Iterator itr = fieldNames.iterator();
        StringBuilder hashingMessage = new StringBuilder();
        int i = 0;
        while (itr.hasNext()) {
            String fieldName = (String)itr.next();
            String fieldValue = fields.get(fieldName);
            if (fieldValue == null || fieldValue.length() <= 0) continue;
            if (i != 0) {
                hashingMessage.append("&");
            }
            hashingMessage.append(fieldName).append("=").append(fieldValue);
            ++i;
        }
        try {
            byte[] decodedKey = Hex.decodeHex((char[])axisSecureSecret.toCharArray());
            SecretKeySpec keySpec = new SecretKeySpec(decodedKey, "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(keySpec);
            byte[] hashingMessageBytes = hashingMessage.toString().getBytes(UTF8);
            hashValue = mac.doFinal(hashingMessageBytes);
        }
        catch (DecoderException e1) {
            e1.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return DatatypeConverter.printHexBinary(hashValue);
    }

    @Override
    public PaymentResponse parsePaymentResponse(String response) {
        String secureHash;
        LOGGER.info((Object)("Response message from Axis Payment gateway: " + response));
        String[] keyValueStr = response.replace("{", "").replace("}", "").split(",");
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>(0);
        for (String pair : keyValueStr) {
            String[] entry = pair.split("=");
            if (entry.length != 2) continue;
            fields.put(entry[0].trim(), entry[1].trim());
        }
        String vpcTxnSecureHash = AxisAdaptor.null2unknown((String)fields.remove("vpc_SecureHash"));
        String axisSecureSecret = this.collectionApplicationProperties.axisSecureSecret();
        if (axisSecureSecret == null || fields.get("vpc_TxnResponseCode") == null && !NO_VALUE_RETURNED.equals(fields.get("vpc_TxnResponseCode")) || !vpcTxnSecureHash.equalsIgnoreCase(secureHash = this.hashAllFields(fields))) {
            // empty if block
        }
        return this.preparePaymentResponse(fields);
    }

    private PaymentResponse preparePaymentResponse(Map<String, String> fields) {
        DefaultPaymentResponse axisResponse = new DefaultPaymentResponse();
        try {
            String[] merchantRef = fields.get("vpc_MerchTxnRef").split("-");
            String receiptId = merchantRef[1];
            String ulbCode = merchantRef[0];
            Query qry = this.entityManager.createNamedQuery("QUERY_RECEIPT_BY_ID_AND_CITYCODE");
            qry.setParameter(1, (Object)Long.valueOf(receiptId));
            qry.setParameter(2, (Object)ulbCode);
            ReceiptHeader receiptHeader = (ReceiptHeader)((Object)qry.getSingleResult());
            axisResponse.setAuthStatus("0".equals(fields.get("vpc_TxnResponseCode")) ? "0300" : fields.get("vpc_TxnResponseCode"));
            axisResponse.setErrorDescription(fields.get("vpc_Message"));
            axisResponse.setAdditionalInfo6(receiptHeader.getConsumerCode().replace("-", "").replace("/", ""));
            axisResponse.setReceiptId(receiptId);
            axisResponse.setTxnAmount(new BigDecimal(fields.get("vpc_Amount")).divide(PAISE_RUPEE_CONVERTER));
            axisResponse.setTxnReferenceNo(fields.get("vpc_TransactionNo"));
            axisResponse.setAdditionalInfo2(fields.get("vpc_OrderInfo"));
            axisResponse.setTxnDate(this.getTransactionDate(fields.get("vpc_BatchNo")));
        }
        catch (Exception exp) {
            LOGGER.error((Object)exp);
            throw new ApplicationRuntimeException("Exception during prepare payment response" + exp.getMessage());
        }
        return axisResponse;
    }

    private static String null2unknown(String in) {
        if (in == null || in.length() == 0) {
            return NO_VALUE_RETURNED;
        }
        return in;
    }

    private void appendQueryFields(StringBuilder buf, LinkedHashMap<String, String> fields) {
        ArrayList<String> fieldNames = new ArrayList<String>(fields.keySet());
        Iterator itr = fieldNames.iterator();
        while (itr.hasNext()) {
            String fieldName = (String)itr.next();
            String fieldValue = fields.get(fieldName);
            if (fieldValue != null && fieldValue.length() > 0) {
                try {
                    buf.append(URLEncoder.encode(fieldName, UTF8));
                    buf.append('=');
                    buf.append(URLEncoder.encode(fieldValue, UTF8));
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error((Object)("Error appending QueryFields" + e));
                    throw new ApplicationRuntimeException(e.getMessage());
                }
            }
            if (!itr.hasNext()) continue;
            buf.append('&');
        }
    }

    @Transactional
    public PaymentResponse createOfflinePaymentRequest(OnlinePayment onlinePayment) {
        LOGGER.debug((Object)"Inside createOfflinePaymentRequest");
        DefaultPaymentResponse axisResponse = new DefaultPaymentResponse();
        try {
            HttpPost httpPost = new HttpPost(this.collectionApplicationProperties.axisReconcileUrl());
            httpPost.setEntity((HttpEntity)this.prepareEncodedFormEntity(onlinePayment));
            CloseableHttpClient httpclient = HttpClients.createDefault();
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            LOGGER.debug((Object)("Response Status >>>>>" + response.getStatusLine()));
            HttpEntity responseAxis = response.getEntity();
            Map<String, String> responseAxisMap = this.prepareResponseMap(responseAxis.getContent());
            axisResponse.setAdditionalInfo6(onlinePayment.getReceiptHeader().getConsumerCode().replace("-", "").replace("/", ""));
            axisResponse.setReceiptId(onlinePayment.getReceiptHeader().getId().toString());
            if (null != responseAxisMap.get("vpc_TxnResponseCode") && !"".equals(responseAxisMap.get("vpc_TxnResponseCode"))) {
                axisResponse.setAuthStatus(null != responseAxisMap.get("vpc_TxnResponseCode") && "0".equals(responseAxisMap.get("vpc_TxnResponseCode")) ? "0300" : responseAxisMap.get("vpc_TxnResponseCode"));
                axisResponse.setErrorDescription(responseAxisMap.get("vpc_Message"));
                if ("0300".equals(axisResponse.getAuthStatus())) {
                    axisResponse.setTxnReferenceNo(responseAxisMap.get("vpc_TransactionNo"));
                    axisResponse.setTxnAmount(new BigDecimal(responseAxisMap.get("vpc_Amount")).divide(PAISE_RUPEE_CONVERTER));
                    axisResponse.setAdditionalInfo2(responseAxisMap.get("vpc_OrderInfo"));
                    axisResponse.setTxnDate(this.getTransactionDate(responseAxisMap.get("vpc_BatchNo")));
                }
            } else if (null != responseAxisMap.get("vpc_DRExists") && "N".equals(responseAxisMap.get("vpc_DRExists"))) {
                axisResponse.setErrorDescription("Failed/Aborted Transaction.");
                axisResponse.setAuthStatus("A");
            }
            LOGGER.debug((Object)("receiptid=" + axisResponse.getReceiptId() + "consumercode=" + axisResponse.getAdditionalInfo6()));
        }
        catch (Exception exp) {
            LOGGER.error((Object)exp);
            throw new ApplicationRuntimeException("Exception during create offline requests" + exp.getMessage());
        }
        return axisResponse;
    }

    private UrlEncodedFormEntity prepareEncodedFormEntity(OnlinePayment onlinePayment) {
        ArrayList<BasicNameValuePair> formData = new ArrayList<BasicNameValuePair>();
        formData.add(new BasicNameValuePair("vpc_Version", this.collectionApplicationProperties.axisVersion()));
        formData.add(new BasicNameValuePair("vpc_Command", this.collectionApplicationProperties.axisCommandQuery()));
        formData.add(new BasicNameValuePair("vpc_AccessCode", this.collectionApplicationProperties.axisAccessCode()));
        formData.add(new BasicNameValuePair("vpc_Merchant", this.collectionApplicationProperties.axisMerchant()));
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        formData.add(new BasicNameValuePair("vpc_MerchTxnRef", cityWebsite.getCode() + "-" + onlinePayment.getReceiptHeader().getId().toString()));
        formData.add(new BasicNameValuePair("vpc_User", this.collectionApplicationProperties.axisOperator()));
        formData.add(new BasicNameValuePair("vpc_Password", this.collectionApplicationProperties.axisPassword()));
        formData.add(new BasicNameValuePair("vpc_OrderInfo", cityWebsite.getCode() + "-" + cityWebsite.getName()));
        UrlEncodedFormEntity urlEncodedFormEntity = null;
        try {
            urlEncodedFormEntity = new UrlEncodedFormEntity(formData);
        }
        catch (UnsupportedEncodingException e1) {
            LOGGER.error((Object)("Error in Create Offline Payment Request" + e1));
        }
        return urlEncodedFormEntity;
    }

    private Date getTransactionDate(String transDate) throws ApplicationException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd", Locale.getDefault());
        try {
            return sdf.parse(transDate);
        }
        catch (ParseException e) {
            LOGGER.error((Object)("Error occured in parsing the transaction date [" + transDate + "]"), (Throwable)e);
            throw new ApplicationException(".transactiondate.parse.error", (Throwable)e);
        }
    }

    private Map<String, String> prepareResponseMap(InputStream responseContent) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(responseContent));
        StringBuilder data = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                data.append(line);
            }
            reader.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)("Error Reading InsputStrem from Axis Bank Response" + e));
        }
        LOGGER.info((Object)("ResponseAXIS: " + data.toString()));
        String[] pairs = data.toString().split("&");
        LinkedHashMap<String, String> responseAxisMap = new LinkedHashMap<String, String>();
        for (String pair : pairs) {
            int idx = pair.indexOf(61);
            try {
                responseAxisMap.put(URLDecoder.decode(pair.substring(0, idx), UTF8), URLDecoder.decode(pair.substring(idx + 1), UTF8));
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error((Object)("Error Decoding Axis Bank Response" + e));
            }
        }
        return responseAxisMap;
    }
}

