/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.integration.pgi;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.log4j.Logger;
import org.egov.collection.config.properties.CollectionApplicationProperties;
import org.egov.collection.entity.OnlinePayment;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.integration.models.ResponseAtomMmp;
import org.egov.collection.integration.models.ResponseAtomParam;
import org.egov.collection.integration.models.ResponseAtomReconcilation;
import org.egov.collection.integration.pgi.DefaultPaymentRequest;
import org.egov.collection.integration.pgi.DefaultPaymentResponse;
import org.egov.collection.integration.pgi.PaymentGatewayAdaptor;
import org.egov.collection.integration.pgi.PaymentRequest;
import org.egov.collection.integration.pgi.PaymentResponse;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.utils.DateUtils;
import org.egov.infstr.models.ServiceDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AtomAdaptor
implements PaymentGatewayAdaptor {
    private static final Logger LOGGER = Logger.getLogger(AtomAdaptor.class);
    @Autowired
    private CollectionApplicationProperties collectionApplicationProperties;
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public PaymentRequest createPaymentRequest(ServiceDetails paymentServiceDetails, ReceiptHeader receiptHeader) {
        LOGGER.debug((Object)"inside  AtomAdaptor createPaymentRequest");
        DefaultPaymentRequest paymentRequest = new DefaultPaymentRequest();
        String ttype = null;
        String tempTxnId = null;
        String token = null;
        String txnStage = null;
        HttpPost httpPost = new HttpPost(paymentServiceDetails.getServiceUrl());
        ArrayList<BasicNameValuePair> formData = new ArrayList<BasicNameValuePair>(0);
        formData.add(new BasicNameValuePair("login", this.collectionApplicationProperties.atomLogin()));
        formData.add(new BasicNameValuePair("pass", this.collectionApplicationProperties.atomPass()));
        formData.add(new BasicNameValuePair("ttype", this.collectionApplicationProperties.atomTtype()));
        formData.add(new BasicNameValuePair("prodid", this.collectionApplicationProperties.atomProdid()));
        formData.add(new BasicNameValuePair("amt", receiptHeader.getTotalAmount().setScale(2, 0).toString()));
        formData.add(new BasicNameValuePair("txncurr", this.collectionApplicationProperties.atomTxncurr()));
        formData.add(new BasicNameValuePair("txnscamt", this.collectionApplicationProperties.atomTxnscamt()));
        formData.add(new BasicNameValuePair("clientcode", this.collectionApplicationProperties.atomClientcode()));
        formData.add(new BasicNameValuePair("txnid", receiptHeader.getId().toString()));
        formData.add(new BasicNameValuePair("date", DateUtils.getFormattedDate((Date)receiptHeader.getCreatedDate(), (String)"dd/MM/yyyy HH:mm:ss")));
        formData.add(new BasicNameValuePair("custacc", this.collectionApplicationProperties.atomCustacc()));
        formData.add(new BasicNameValuePair("mdd", this.collectionApplicationProperties.atomMdd()));
        StringBuilder returnUrl = new StringBuilder();
        returnUrl.append(paymentServiceDetails.getCallBackurl()).append("?paymentServiceId=").append(paymentServiceDetails.getId());
        formData.add(new BasicNameValuePair("ru", returnUrl.toString()));
        formData.add(new BasicNameValuePair("udf9", ApplicationThreadLocals.getCityCode() + "|" + receiptHeader.getConsumerCode().replace("-", "").replace("/", "")));
        LOGGER.info((Object)("First request ATOM: " + formData));
        UrlEncodedFormEntity urlEncodedFormEntity = null;
        try {
            String line;
            urlEncodedFormEntity = new UrlEncodedFormEntity(formData);
            httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
            CloseableHttpClient httpclient = HttpClients.createDefault();
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            HttpEntity responseAtom = response.getEntity();
            BufferedReader reader = new BufferedReader(new InputStreamReader(responseAtom.getContent()));
            StringBuilder data = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                data.append(line);
            }
            reader.close();
            LOGGER.info((Object)("First Response ATOM: " + data.toString()));
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ResponseAtomMmp.class});
            Unmarshaller unMarshaller = jaxbContext.createUnmarshaller();
            StringReader strReader = new StringReader(data.toString());
            ResponseAtomMmp responseMmp = (ResponseAtomMmp)unMarshaller.unmarshal((Reader)strReader);
            for (ResponseAtomParam responseParam : responseMmp.getMERCHANT().getRESPONSE().getParam()) {
                if (null == responseParam.getName() || responseParam.getName().isEmpty()) continue;
                if (responseParam.getName().equals("ttype")) {
                    ttype = responseParam.getValue();
                    continue;
                }
                if (responseParam.getName().equals("tempTxnId")) {
                    tempTxnId = responseParam.getValue();
                    continue;
                }
                if (responseParam.getName().equals("token")) {
                    token = responseParam.getValue();
                    continue;
                }
                if (!responseParam.getName().equals("txnStage")) continue;
                txnStage = responseParam.getValue();
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        String secondRequestStr = paymentServiceDetails.getServiceUrl() + "?ttype=" + ttype + "&tempTxnId=" + tempTxnId + "&token=" + token + "&txnStage=" + txnStage;
        LOGGER.debug((Object)("Second request ATOM : " + secondRequestStr));
        paymentRequest.setParameter("paymentGatewayURL", secondRequestStr);
        LOGGER.info((Object)("Second paymentRequest: " + paymentRequest.getRequestParameters()));
        return paymentRequest;
    }

    @Override
    public PaymentResponse parsePaymentResponse(String response) {
        LOGGER.debug((Object)"inside  ATOM createPaymentRequest");
        LOGGER.info((Object)("Response message from Atom Payment gateway: " + response));
        String[] keyValueStr = response.replace("{", "").replace("}", "").split(",");
        DefaultPaymentResponse atomResponse = new DefaultPaymentResponse();
        HashMap<String, String> responseMap = new HashMap<String, String>(0);
        for (String pair : keyValueStr) {
            String[] entry = pair.split("=");
            responseMap.put(entry[0].trim(), entry[1].trim());
        }
        atomResponse.setAuthStatus(((String)responseMap.get("f_code")).equalsIgnoreCase("Ok") ? "0300" : (String)responseMap.get("f_code"));
        atomResponse.setErrorDescription((String)responseMap.get("f_code"));
        atomResponse.setReceiptId((String)responseMap.get("mer_txn"));
        atomResponse.setTxnAmount(new BigDecimal((String)responseMap.get("amt")));
        atomResponse.setTxnReferenceNo((String)responseMap.get("mmp_txn"));
        if (responseMap.get("udf9") != null) {
            String[] udf9 = ((String)responseMap.get("udf9")).split("\\|");
            atomResponse.setAdditionalInfo6(udf9[1]);
            atomResponse.setAdditionalInfo2(udf9[0]);
        } else {
            String receiptId = (String)responseMap.get("mer_txn");
            String ulbCode = ApplicationThreadLocals.getCityCode();
            Query qry = this.entityManager.createNamedQuery("QUERY_RECEIPT_BY_ID_AND_CITYCODE");
            qry.setParameter(1, (Object)Long.valueOf(receiptId));
            qry.setParameter(2, (Object)ulbCode);
            ReceiptHeader receiptHeader = (ReceiptHeader)((Object)qry.getSingleResult());
            atomResponse.setAdditionalInfo6(receiptHeader.getConsumerCode().replace("-", "").replace("/", ""));
            atomResponse.setAdditionalInfo2(ulbCode);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.getDefault());
        Date transactionDate = null;
        try {
            transactionDate = sdf.parse((String)responseMap.get("date"));
            atomResponse.setTxnDate(transactionDate);
        }
        catch (ParseException e) {
            LOGGER.error((Object)("Error occured in parsing the transaction date [" + transactionDate + "]"), (Throwable)e);
            try {
                throw new ApplicationException(".transactiondate.parse.error", (Throwable)e);
            }
            catch (ApplicationException e1) {
                e1.printStackTrace();
            }
        }
        return atomResponse;
    }

    @Transactional
    public PaymentResponse createOfflinePaymentRequest(OnlinePayment onlinePayment) {
        DefaultPaymentResponse atomResponse;
        block6: {
            LOGGER.debug((Object)"Inside AtomAdaptor createOfflinePaymentRequest");
            atomResponse = new DefaultPaymentResponse();
            try {
                String line;
                HttpPost httpPost = new HttpPost(this.collectionApplicationProperties.atomReconcileUrl());
                ArrayList<BasicNameValuePair> formData = new ArrayList<BasicNameValuePair>(0);
                formData.add(new BasicNameValuePair("merchantid", this.collectionApplicationProperties.atomLogin()));
                formData.add(new BasicNameValuePair("merchanttxnid", onlinePayment.getReceiptHeader().getId().toString()));
                formData.add(new BasicNameValuePair("amt", onlinePayment.getReceiptHeader().getTotalAmount().setScale(2, 0).toString()));
                formData.add(new BasicNameValuePair("tdate", DateUtils.getFormattedDate((Date)onlinePayment.getCreatedDate(), (String)"yyyy-MM-dd")));
                LOGGER.debug((Object)("ATOM  Reconcilation request : " + formData));
                UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(formData);
                httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
                CloseableHttpClient httpclient = HttpClients.createDefault();
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
                HttpEntity responseAtom = response.getEntity();
                BufferedReader reader = new BufferedReader(new InputStreamReader(responseAtom.getContent()));
                StringBuilder data = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    data.append(line);
                }
                reader.close();
                LOGGER.info((Object)("ATOM Reconcile Response : " + data.toString()));
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ResponseAtomReconcilation.class});
                Unmarshaller unMarshaller = jaxbContext.createUnmarshaller();
                StringReader strReader = new StringReader(data.toString());
                ResponseAtomReconcilation responseAtomReconcilation = (ResponseAtomReconcilation)unMarshaller.unmarshal((Reader)strReader);
                atomResponse.setAuthStatus(null != responseAtomReconcilation.getVerified() && responseAtomReconcilation.getVerified().equals("SUCCESS") ? "0300" : responseAtomReconcilation.getVerified());
                atomResponse.setErrorDescription(responseAtomReconcilation.getVerified());
                atomResponse.setReceiptId(responseAtomReconcilation.getMerchantTxnID());
                if ("0300".equals(atomResponse.getAuthStatus())) {
                    atomResponse.setTxnReferenceNo(responseAtomReconcilation.getAtomtxnId());
                    atomResponse.setTxnAmount(new BigDecimal(responseAtomReconcilation.getAmt()));
                    String[] udf9 = responseAtomReconcilation.getUdf9().split("\\|");
                    atomResponse.setAdditionalInfo6(udf9[1]);
                    atomResponse.setAdditionalInfo2(udf9[0]);
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
                    Date transactionDate = null;
                    try {
                        transactionDate = sdf.parse(responseAtomReconcilation.getTxnDate());
                        atomResponse.setTxnDate(transactionDate);
                        break block6;
                    }
                    catch (ParseException e) {
                        LOGGER.error((Object)("Error occured in parsing the transaction date [" + responseAtomReconcilation.getTxnDate() + "]"), (Throwable)e);
                        throw new ApplicationException(".transactiondate.parse.error", (Throwable)e);
                    }
                }
                atomResponse.setAdditionalInfo6(onlinePayment.getReceiptHeader().getConsumerCode().replace("-", "").replace("/", ""));
                atomResponse.setAdditionalInfo2(ApplicationThreadLocals.getCityCode());
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
        return atomResponse;
    }
}

