/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.integration.models;

import java.math.BigDecimal;
import java.util.Date;
import org.egov.collection.integration.models.ReceiptInstrumentInfo;
import org.egov.commons.Bank;
import org.egov.commons.Bankaccount;
import org.egov.commons.EgwStatus;
import org.egov.model.instrument.InstrumentHeader;

public class ReceiptInstrumentInfoImpl
implements ReceiptInstrumentInfo {
    private final InstrumentHeader instrumentHeader;

    public ReceiptInstrumentInfoImpl(InstrumentHeader instrumentHeader) {
        this.instrumentHeader = instrumentHeader;
    }

    @Override
    public String getInstrumentNumber() {
        return this.instrumentHeader.getInstrumentNumber();
    }

    @Override
    public Date getInstrumentDate() {
        return this.instrumentHeader.getInstrumentDate();
    }

    @Override
    public String getInstrumentType() {
        return this.instrumentHeader.getInstrumentType() == null ? null : this.instrumentHeader.getInstrumentType().getType();
    }

    @Override
    public BigDecimal getInstrumentAmount() {
        return this.instrumentHeader.getInstrumentAmount();
    }

    @Override
    public EgwStatus getInstrumentStatus() {
        return this.instrumentHeader.getStatusId();
    }

    @Override
    public String getTransactionNumber() {
        return this.instrumentHeader.getTransactionNumber();
    }

    @Override
    public Date getTransactionDate() {
        return this.instrumentHeader.getTransactionDate();
    }

    @Override
    public boolean isBounced() {
        return this.instrumentHeader.getStatusId().getDescription().equals("Dishonored");
    }

    @Override
    public String getBankName() {
        if ("bankchallan".equals(this.instrumentHeader.getInstrumentType().getType())) {
            Bankaccount bankAccount = this.instrumentHeader.getBankAccountId();
            return bankAccount.getBankbranch().getBank().getName();
        }
        Bank bank = this.instrumentHeader.getBankId();
        if (bank == null) {
            return null;
        }
        return bank.getName();
    }

    @Override
    public String getBankAccountNumber() {
        Bankaccount bankAccount = this.instrumentHeader.getBankAccountId();
        if (bankAccount == null) {
            return null;
        }
        return bankAccount.getAccountnumber();
    }

    @Override
    public String getBankBranchName() {
        return this.instrumentHeader.getBankBranchName();
    }
}

