/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.handler;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.BooleanConverter;
import com.thoughtworks.xstream.converters.basic.DateConverter;
import org.egov.collection.integration.models.BillDetails;
import org.egov.collection.integration.models.BillInfoImpl;
import org.egov.infra.config.core.LocalizationSettings;

public class BillInfoMarshaller {
    private static final XStream BILL_MARSHALLER = BillInfoMarshaller.createXStream();

    private static XStream createXStream() {
        XStream billInfoMarshaller = new XStream();
        billInfoMarshaller.aliasAttribute(BillDetails.class, "billDate", "billDate");
        XStream.setupDefaultSecurity((XStream)billInfoMarshaller);
        billInfoMarshaller.allowTypesByWildcard(new String[]{"org.egov.**"});
        String[] array = new String[]{LocalizationSettings.datePattern()};
        billInfoMarshaller.registerConverter((SingleValueConverter)new DateConverter(LocalizationSettings.datePattern(), array));
        billInfoMarshaller.registerConverter((SingleValueConverter)BooleanConverter.BINARY);
        billInfoMarshaller.processAnnotations(BillInfoImpl.class);
        return billInfoMarshaller;
    }

    public static String toXML(Object obj) {
        return BILL_MARSHALLER.toXML(obj);
    }

    public static BillInfoImpl toObject(String xml) {
        return (BillInfoImpl)BILL_MARSHALLER.fromXML(xml);
    }
}

