/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.utils;

import org.egov.collection.autonumber.ChallanNumberGenerator;
import org.egov.collection.autonumber.ReceiptNumberGenerator;
import org.egov.collection.autonumber.RemittanceNumberGenerator;
import org.egov.collection.entity.Challan;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.commons.CFinancialYear;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class CollectionsNumberGenerator {
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;

    public String generateReceiptNumber(ReceiptHeader receiptHeader) {
        ReceiptNumberGenerator receiptNumberGen = (ReceiptNumberGenerator)this.beanResolver.getAutoNumberServiceFor(ReceiptNumberGenerator.class);
        return receiptNumberGen.generateReceiptNumber(receiptHeader);
    }

    public String generateChallanNumber(Challan challan, CFinancialYear financialYear) {
        ChallanNumberGenerator challanNumberGen = (ChallanNumberGenerator)this.beanResolver.getAutoNumberServiceFor(ChallanNumberGenerator.class);
        return challanNumberGen.generateChallanNumber(challan, financialYear);
    }

    public String generateRemittanceNumber(CFinancialYear financialYear) {
        RemittanceNumberGenerator remittanceNumberGen = (RemittanceNumberGenerator)this.beanResolver.getAutoNumberServiceFor(RemittanceNumberGenerator.class);
        return remittanceNumberGen.generateRemittanceNumber(financialYear);
    }
}

