/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.service.dashboard;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.egov.collection.bean.dashboard.CollectionDashBoardRequest;
import org.egov.collection.bean.dashboard.CollectionDashBoardStats;
import org.egov.collection.bean.dashboard.CollectionDashBoardTrend;
import org.egov.collection.bean.dashboard.CollectionDocumentDetails;
import org.egov.collection.bean.dashboard.CollectionTableData;
import org.egov.collection.bean.dashboard.TaxPayerDashBoardResponseDetails;
import org.egov.collection.bean.dashboard.TotalCollectionDashBoardStats;
import org.egov.collection.bean.dashboard.TotalCollectionStatistics;
import org.egov.collection.constants.CollectionConstants;
import org.egov.collection.service.elasticsearch.CollectionDocumentElasticSearchService;
import org.egov.commons.CFinancialYear;
import org.egov.commons.service.CFinancialYearService;
import org.egov.infstr.models.ServiceDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CollectionDashboardService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionDashboardService.class);
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private CFinancialYearService cFinancialYearService;
    @Autowired
    private CollectionDocumentElasticSearchService collectionDocumentElasticSearchService;
    private static final String MILLISECS = " (millisecs) ";

    public TotalCollectionDashBoardStats getTotalCollectionStats(CollectionDashBoardRequest collectionDashBoardRequest) {
        TotalCollectionDashBoardStats consolidatedCollectionDetails = new TotalCollectionDashBoardStats();
        ArrayList<CollectionDashBoardStats> totalStatistics = new ArrayList<CollectionDashBoardStats>();
        ArrayList<String> toBeExcluded = new ArrayList<String>();
        CFinancialYear currFinYear = this.cFinancialYearService.getFinancialYearByDate(new Date());
        for (String service : collectionDashBoardRequest.getIncludeServices()) {
            if (!service.equalsIgnoreCase("OTHERS")) {
                this.setConsolidatedData(totalStatistics, new ArrayList<String>(Arrays.asList(service)), service, currFinYear);
            }
            toBeExcluded.add(service);
        }
        List<String> serviceList = this.getServiceList(collectionDashBoardRequest.getExcludeServices(), toBeExcluded);
        if (!serviceList.isEmpty()) {
            this.setConsolidatedData(totalStatistics, serviceList, "OTHERS", currFinYear);
        }
        consolidatedCollectionDetails.setCollection(totalStatistics);
        BigDecimal currColl = BigDecimal.ZERO;
        BigDecimal lastColl = BigDecimal.ZERO;
        if (!totalStatistics.isEmpty()) {
            for (CollectionDashBoardStats stat : totalStatistics) {
                currColl = currColl.add(stat.getCytdColl());
                lastColl = lastColl.add(stat.getLytdColl());
            }
        }
        consolidatedCollectionDetails.setTotalCurrentCollection(currColl);
        consolidatedCollectionDetails.setTotalLastYearCollection(lastColl);
        return consolidatedCollectionDetails;
    }

    private void setConsolidatedData(List<CollectionDashBoardStats> totalStatistics, List<String> serviceList, String service, CFinancialYear financialYear) {
        Long startTime = System.currentTimeMillis();
        CollectionDashBoardStats consolidatedData = new CollectionDashBoardStats();
        Map<String, BigDecimal> consolidatedColl = this.collectionDocumentElasticSearchService.getFinYearsCollByService(serviceList, financialYear);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken by getFinYearsCollByService() for Property Tax is : " + timeTaken + MILLISECS);
        }
        if (!consolidatedColl.isEmpty()) {
            consolidatedData.setCytdColl(consolidatedColl.get("cytdColln"));
            consolidatedData.setLytdColl(consolidatedColl.get("lytdColln"));
        }
        consolidatedData.setServiceName(service);
        startTime = System.currentTimeMillis();
        timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken by Property Tax getTotalDemand() is : " + timeTaken + MILLISECS);
        }
        BigDecimal variance = consolidatedData.getLytdColl().compareTo(BigDecimal.ZERO) == 0 ? CollectionConstants.BIGDECIMAL_100 : consolidatedData.getCytdColl().subtract(consolidatedData.getLytdColl()).multiply(CollectionConstants.BIGDECIMAL_100).divide(consolidatedData.getLytdColl(), 1, 4);
        consolidatedData.setLyVar(variance);
        totalStatistics.add(consolidatedData);
    }

    public List<TotalCollectionStatistics> getCollectionIndexDetails(CollectionDashBoardRequest collectionDashBoardRequest) {
        ArrayList<TotalCollectionStatistics> totalStats = new ArrayList<TotalCollectionStatistics>();
        ArrayList<String> toBeExcluded = new ArrayList<String>();
        CFinancialYear currFinYear = this.cFinancialYearService.getFinancialYearByDate(new Date());
        for (String service : collectionDashBoardRequest.getIncludeServices()) {
            if (!service.equalsIgnoreCase("OTHERS")) {
                this.setCollectionIndexStats(collectionDashBoardRequest, totalStats, new ArrayList<String>(Arrays.asList(service)), service, currFinYear);
            }
            toBeExcluded.add(service);
        }
        List<String> serviceList = this.getServiceList(collectionDashBoardRequest.getExcludeServices(), toBeExcluded);
        if (!serviceList.isEmpty()) {
            this.setCollectionIndexStats(collectionDashBoardRequest, totalStats, serviceList, "OTHERS", currFinYear);
        }
        return totalStats;
    }

    private void setCollectionIndexStats(CollectionDashBoardRequest collectionDashBoardRequest, List<TotalCollectionStatistics> totalStats, List<String> serviceList, String service, CFinancialYear financialYear) {
        ArrayList<CollectionDocumentDetails> collectionDocumentDetails = new ArrayList<CollectionDocumentDetails>();
        TotalCollectionStatistics totalCollStat = new TotalCollectionStatistics();
        CollectionDocumentDetails collectionDocDetails = this.collectionDocumentElasticSearchService.getCompleteCollectionIndexDetails(collectionDashBoardRequest, serviceList, financialYear);
        List<CollectionDashBoardTrend> collectionTrends = this.collectionDocumentElasticSearchService.getMonthwiseCollectionDetails(collectionDashBoardRequest, serviceList, financialYear);
        List<CollectionTableData> collTableData = this.collectionDocumentElasticSearchService.getResponseTableData(collectionDashBoardRequest, serviceList, financialYear);
        collectionDocDetails.setCollTrends(collectionTrends);
        collectionDocDetails.setResponseDetails(collTableData);
        collectionDocDetails.setServiceName(service);
        collectionDocumentDetails.add(collectionDocDetails);
        totalCollStat.setCollectionDashBoardStats(collectionDocumentDetails);
        totalStats.add(totalCollStat);
    }

    public List<TaxPayerDashBoardResponseDetails> getTopTenTaxProducers(CollectionDashBoardRequest collectionDashBoardRequest) {
        TaxPayerDashBoardResponseDetails topTenResponse;
        ArrayList<TaxPayerDashBoardResponseDetails> topTenCollectionsList = new ArrayList<TaxPayerDashBoardResponseDetails>();
        ArrayList<String> toBeExcluded = new ArrayList<String>();
        for (String service : collectionDashBoardRequest.getIncludeServices()) {
            if (!service.equalsIgnoreCase("OTHERS")) {
                topTenResponse = this.collectionDocumentElasticSearchService.getTopTenTaxPerformers(collectionDashBoardRequest, new ArrayList<String>(Arrays.asList(service)));
                topTenResponse.setServiceName(service);
                topTenCollectionsList.add(topTenResponse);
            }
            toBeExcluded.add(service);
        }
        List<String> serviceList = this.getServiceList(collectionDashBoardRequest.getExcludeServices(), toBeExcluded);
        if (!serviceList.isEmpty()) {
            topTenResponse = this.collectionDocumentElasticSearchService.getTopTenTaxPerformers(collectionDashBoardRequest, serviceList);
            topTenResponse.setServiceName("OTHERS");
            topTenCollectionsList.add(topTenResponse);
        }
        return topTenCollectionsList;
    }

    public List<TaxPayerDashBoardResponseDetails> getBottomTenTaxProducers(CollectionDashBoardRequest collectionDashBoardRequest) {
        TaxPayerDashBoardResponseDetails bottomTenResponse;
        ArrayList<TaxPayerDashBoardResponseDetails> bottomTenCollectionsList = new ArrayList<TaxPayerDashBoardResponseDetails>();
        ArrayList<String> toBeExcluded = new ArrayList<String>();
        for (String service : collectionDashBoardRequest.getIncludeServices()) {
            if (!service.equalsIgnoreCase("OTHERS")) {
                bottomTenResponse = this.collectionDocumentElasticSearchService.getBottomTenTaxPerformers(collectionDashBoardRequest, new ArrayList<String>(Arrays.asList(service)));
                bottomTenResponse.setServiceName(service);
                bottomTenCollectionsList.add(bottomTenResponse);
            }
            toBeExcluded.add(service);
        }
        List<String> serviceList = this.getServiceList(collectionDashBoardRequest.getExcludeServices(), toBeExcluded);
        if (!serviceList.isEmpty()) {
            bottomTenResponse = this.collectionDocumentElasticSearchService.getBottomTenTaxPerformers(collectionDashBoardRequest, serviceList);
            bottomTenResponse.setServiceName("OTHERS");
            bottomTenCollectionsList.add(bottomTenResponse);
        }
        return bottomTenCollectionsList;
    }

    private List<String> getServiceList(List<String> excludeServices, List<String> toBeExcluded) {
        ArrayList<String> serviceList = new ArrayList<String>();
        if (!excludeServices.contains("OTHERS")) {
            TypedQuery qry = this.entityManager.createNamedQuery("DISTINCT_SERVICE_DETAILS", ServiceDetails.class);
            List serviceDetails = qry.getResultList();
            for (ServiceDetails sd : serviceDetails) {
                serviceList.add(sd.getName());
            }
            serviceList.removeAll(toBeExcluded);
            serviceList.removeAll(excludeServices);
        }
        return serviceList;
    }
}

