/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.integration.services;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.egov.billsaccounting.services.CreateVoucher;
import org.egov.billsaccounting.services.VoucherConstant;
import org.egov.collection.entity.AccountPayeeDetail;
import org.egov.collection.entity.CollectionDishonorCheque;
import org.egov.collection.entity.CollectionDishonorChequeDetails;
import org.egov.collection.entity.CollectionDishonorChequeSubLedgerDetails;
import org.egov.collection.entity.DishonoredChequeBean;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.service.ReceiptHeaderService;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.collection.utils.FinancialsUtil;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CGeneralLedger;
import org.egov.commons.CGeneralLedgerDetail;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.service.ChartOfAccountsService;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.instrument.DishonorCheque;
import org.egov.model.instrument.DishonorChequeDetails;
import org.egov.model.instrument.DishonorChequeSubLedgerDetails;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.services.instrument.FinancialIntegrationService;
import org.egov.services.instrument.InstrumentHeaderService;
import org.egov.services.voucher.GeneralLedgerDetailService;
import org.egov.services.voucher.GeneralLedgerService;
import org.egov.services.voucher.VoucherHeaderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DishonorChequeService
implements FinancialIntegrationService {
    private static final Logger LOGGER = Logger.getLogger(DishonorChequeService.class);
    @Autowired
    private FinancialsUtil financialsUtil;
    @Autowired
    @Qualifier(value="instrumentHeaderService")
    public InstrumentHeaderService instrumentHeaderService;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    @Qualifier(value="voucherHeaderService")
    private VoucherHeaderService voucherHeaderService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusDAO;
    @Autowired
    @Qualifier(value="generalLedgerService")
    private GeneralLedgerService generalLedgerService;
    @Autowired
    @Qualifier(value="generalLedgerDetailService")
    private GeneralLedgerDetailService generalLedgerDetailService;
    @Autowired
    @Qualifier(value="chartOfAccountsService")
    private ChartOfAccountsService chartOfAccountsService;
    @Autowired
    @Qualifier(value="createVoucher")
    private CreateVoucher createVoucher;
    @Autowired
    @Qualifier(value="receiptHeaderService")
    public ReceiptHeaderService receiptHeaderService;
    @Autowired
    @Qualifier(value="collectionsUtil")
    public CollectionsUtil collectionsUtil;

    @Transactional
    public DishonorCheque createDishonorCheque(DishonoredChequeBean chequeForm) throws Exception {
        DishonorCheque dishonorChq = new DishonorCheque();
        try {
            CVoucherHeader originalVoucher = null;
            if (!chequeForm.getVoucherHeaderIds().isEmpty()) {
                originalVoucher = (CVoucherHeader)this.voucherHeaderService.findById((Serializable)Long.valueOf(chequeForm.getVoucherHeaderIds().split(",")[0]), false);
            }
            InstrumentHeader instrumentHeader = (InstrumentHeader)this.instrumentHeaderService.findById((Serializable)Long.valueOf(chequeForm.getInstHeaderIds().split(",")[0]), false);
            if (originalVoucher != null) {
                this.createDishonorChequeForVoucher(chequeForm, dishonorChq, originalVoucher, instrumentHeader);
            } else {
                this.createDishonorChequeWithoutVoucher(chequeForm, instrumentHeader);
            }
        }
        catch (ValidationException e) {
            LOGGER.error((Object)("Error in DishonorCheque >>>>" + (Object)((Object)e)));
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error in DishonorCheque >>>>" + e));
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        return dishonorChq;
    }

    @Transactional
    public void createDishonorChequeForVoucher(DishonoredChequeBean chequeForm, DishonorCheque dishonorChq, CVoucherHeader originalVoucher, InstrumentHeader instrumentHeader) throws Exception {
        DishonorChequeDetails dishonourChqDetails = new DishonorChequeDetails();
        DishonorChequeSubLedgerDetails dishonourChqSLDetails = new DishonorChequeSubLedgerDetails();
        dishonorChq.setStatus(this.egwStatusDAO.getStatusByModuleAndCode("DISHONORCHEQUE", "Approved"));
        dishonorChq.setTransactionDate(chequeForm.getTransactionDate());
        dishonorChq.setBankReferenceNumber(chequeForm.getReferenceNo());
        dishonorChq.setInstrumentDishonorReason(chequeForm.getRemarks());
        dishonorChq.setOriginalVoucherHeader(originalVoucher);
        instrumentHeader.setSurrendarReason(chequeForm.getDishonorReason());
        this.instrumentHeaderService.update((Object)instrumentHeader);
        dishonorChq.setInstrumentHeader(instrumentHeader);
        String[] receiptGeneralLedger = chequeForm.getReceiptGLDetails().split(",");
        String[] remittanceGeneralLedger = chequeForm.getRemittanceGLDetails().split(",");
        CGeneralLedger ledger = new CGeneralLedger();
        for (String gl : receiptGeneralLedger) {
            ledger = (CGeneralLedger)this.generalLedgerService.find("from CGeneralLedger where voucherHeaderId.id = ? and glcode = ?", new Object[]{originalVoucher.getId(), gl.split("-")[0].trim()});
            List ledgerDetailSet = this.generalLedgerDetailService.findAllBy("from CGeneralLedgerDetail where generalLedgerId.id=?", new Object[]{ledger.getId()});
            dishonourChqDetails = new DishonorChequeDetails();
            dishonourChqDetails.setHeader(dishonorChq);
            CChartOfAccounts glCode = (CChartOfAccounts)this.chartOfAccountsService.find("from CChartOfAccounts where glcode=?", new Object[]{ledger.getGlcode()});
            dishonourChqDetails.setGlcodeId(glCode);
            if (ledger.getFunctionId() != null) {
                dishonourChqDetails.setFunctionId(ledger.getFunctionId());
            }
            dishonourChqDetails.setDebitAmt(BigDecimal.valueOf(Double.valueOf(gl.split("-")[1].trim())));
            dishonourChqDetails.setCreditAmount(BigDecimal.valueOf(Double.valueOf(gl.split("-")[2].trim())));
            for (CGeneralLedgerDetail ledgerDetail : ledgerDetailSet) {
                dishonourChqSLDetails = new DishonorChequeSubLedgerDetails();
                dishonourChqSLDetails.setDetails(dishonourChqDetails);
                dishonourChqSLDetails.setAmount(dishonourChqDetails.getDebitAmt().compareTo(BigDecimal.ZERO) == 0 ? dishonourChqDetails.getCreditAmount() : dishonourChqDetails.getDebitAmt());
                dishonourChqSLDetails.setDetailTypeId(ledgerDetail.getDetailTypeId().getId());
                dishonourChqSLDetails.setDetailKeyId(ledgerDetail.getDetailKeyId());
                dishonourChqDetails.getSubLedgerDetails().add(dishonourChqSLDetails);
            }
            dishonorChq.getDetails().add(dishonourChqDetails);
        }
        for (String gl : remittanceGeneralLedger) {
            CVoucherHeader remittanceVoucher = (CVoucherHeader)this.voucherHeaderService.find("select gl.voucherHeaderId from CGeneralLedger gl ,InstrumentOtherDetails iod where gl.voucherHeaderId.id = iod.payinslipId.id and iod.instrumentHeaderId.id   in (" + chequeForm.getInstHeaderIds() + ") ");
            ledger = (CGeneralLedger)this.generalLedgerService.find("from CGeneralLedger where voucherHeaderId.id = ? and glcode = ?", new Object[]{remittanceVoucher.getId(), gl.split("-")[0].trim()});
            List ledgerDetailSet = this.generalLedgerDetailService.findAllBy("from CGeneralLedgerDetail where generalLedgerId.id=?", new Object[]{ledger.getId()});
            dishonourChqDetails = new DishonorChequeDetails();
            dishonourChqDetails.setHeader(dishonorChq);
            CChartOfAccounts glCode = (CChartOfAccounts)this.chartOfAccountsService.find("from CChartOfAccounts where glcode=?", new Object[]{ledger.getGlcode()});
            dishonourChqDetails.setGlcodeId(glCode);
            if (ledger.getFunctionId() != null) {
                dishonourChqDetails.setFunctionId(ledger.getFunctionId());
            }
            dishonourChqDetails.setDebitAmt(BigDecimal.valueOf(Double.valueOf(gl.split("-")[1].trim())));
            dishonourChqDetails.setCreditAmount(BigDecimal.valueOf(Double.valueOf(gl.split("-")[2].trim())));
            Iterator iterator = ledgerDetailSet.iterator();
            if (iterator.hasNext()) {
                CGeneralLedgerDetail ledgerDetail = (CGeneralLedgerDetail)iterator.next();
                dishonourChqSLDetails = new DishonorChequeSubLedgerDetails();
                dishonourChqSLDetails.setDetails(dishonourChqDetails);
                dishonourChqSLDetails.setAmount(dishonourChqDetails.getDebitAmt().compareTo(BigDecimal.ZERO) == 0 ? dishonourChqDetails.getCreditAmount() : dishonourChqDetails.getDebitAmt());
                dishonourChqSLDetails.setDetailTypeId(ledgerDetail.getDetailTypeId().getId());
                dishonourChqSLDetails.setDetailKeyId(ledgerDetail.getDetailKeyId());
                dishonourChqDetails.getSubLedgerDetails().add(dishonourChqSLDetails);
            }
            dishonorChq.getDetails().add(dishonourChqDetails);
        }
        this.persistenceService.applyAuditing((AbstractAuditable)dishonorChq);
        this.persistenceService.persist((Object)dishonorChq);
        this.approve(chequeForm, dishonorChq, originalVoucher, instrumentHeader);
    }

    @Transactional
    public CollectionDishonorCheque populateAndPersistDishonorCheque(DishonoredChequeBean chequeForm) throws Exception {
        CollectionDishonorCheque dishonorChq = new CollectionDishonorCheque();
        try {
            InstrumentHeader instrumentHeader = (InstrumentHeader)this.instrumentHeaderService.findById((Serializable)Long.valueOf(chequeForm.getInstHeaderIds().split(",")[0]), false);
            ReceiptHeader collectionHeader = (ReceiptHeader)((Object)this.receiptHeaderService.findById(Long.valueOf(chequeForm.getReceiptHeaderIds().split(",")[0]), false));
            dishonorChq.setStatus(this.egwStatusDAO.getStatusByModuleAndCode("DishonorCheque", "APPROVED"));
            dishonorChq.setTransactionDate(chequeForm.getTransactionDate());
            dishonorChq.setCollectionHeader(collectionHeader);
            dishonorChq.setBankReferenceNumber(chequeForm.getReferenceNo());
            dishonorChq.setInstrumentDishonorReason(chequeForm.getRemarks());
            instrumentHeader.setSurrendarReason(chequeForm.getDishonorReason());
            this.instrumentHeaderService.update((Object)instrumentHeader);
            dishonorChq.setInstrumentHeader(instrumentHeader);
            String[] receiptGeneralLedger = chequeForm.getReceiptGLDetails().split(",");
            String[] remittanceGeneralLedger = chequeForm.getRemittanceGLDetails().split(",");
            dishonorChq.getDetails().add(this.populateDischonourChequedetails(chequeForm, dishonorChq, receiptGeneralLedger));
            dishonorChq.getDetails().add(this.populateDischonourChequedetails(chequeForm, dishonorChq, remittanceGeneralLedger));
            this.persistenceService.applyAuditing((AbstractAuditable)dishonorChq);
            this.persistenceService.persist((Object)dishonorChq);
        }
        catch (ValidationException e) {
            LOGGER.error((Object)("Error in DishonorCheque >>>>" + e.getMessage()));
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error in DishonorCheque >>>>" + e.getMessage()));
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        return dishonorChq;
    }

    public CollectionDishonorChequeDetails populateDischonourChequedetails(DishonoredChequeBean chequeForm, CollectionDishonorCheque dishonorChq, String[] receiptGeneralLedger) throws NumberFormatException {
        CollectionDishonorChequeDetails dishonourChqDetails = new CollectionDishonorChequeDetails();
        ReceiptDetail ledger = new ReceiptDetail();
        for (String gl : receiptGeneralLedger) {
            ledger = (ReceiptDetail)this.persistenceService.find("from ReceiptDetail where collectionheader = ? and accounthead.glcode = ?", new Object[]{Long.valueOf(chequeForm.getReceiptHeaderIds().split(",")[0]), gl.split("-")[0].trim()});
            Set<AccountPayeeDetail> ledgerDetailSet = ledger.getAccountPayeeDetails();
            dishonourChqDetails = new CollectionDishonorChequeDetails();
            dishonourChqDetails.setDishonorcheque(dishonorChq);
            dishonourChqDetails.setChartofaccounts(ledger.getAccounthead());
            if (ledger.getFunction() != null) {
                dishonourChqDetails.setFunction(ledger.getFunction());
            }
            dishonourChqDetails.setDebitAmount(BigDecimal.valueOf(Double.valueOf(gl.split("-")[1].trim())));
            dishonourChqDetails.setCreditAmount(BigDecimal.valueOf(Double.valueOf(gl.split("-")[2].trim())));
            for (AccountPayeeDetail ledgerDetail : ledgerDetailSet) {
                CollectionDishonorChequeSubLedgerDetails dishonourChqSLDetails = new CollectionDishonorChequeSubLedgerDetails();
                dishonourChqSLDetails.setDishonorchequedetail(dishonourChqDetails);
                dishonourChqSLDetails.setAmount(dishonourChqDetails.getDebitAmount().compareTo(BigDecimal.ZERO) == 0 ? dishonourChqDetails.getCreditAmount() : dishonourChqDetails.getDebitAmount());
                dishonourChqSLDetails.setDetailType(ledgerDetail.getAccountDetailType().getId());
                dishonourChqSLDetails.setDetailKey(ledgerDetail.getAccountDetailKey().getId());
                dishonourChqDetails.getSubLedgerDetails().add(dishonourChqSLDetails);
            }
        }
        return dishonourChqDetails;
    }

    @Transactional
    public void createDishonorChequeWithoutVoucher(DishonoredChequeBean chequeForm, InstrumentHeader instrumentHeader) throws Exception {
        instrumentHeader.setSurrendarReason(chequeForm.getDishonorReason());
        this.persistenceService.update((Object)instrumentHeader);
        this.populateAndPersistDishonorCheque(chequeForm);
        this.updateCollectionsOnInstrumentDishonor(instrumentHeader.getId());
    }

    @Transactional
    public void approve(DishonoredChequeBean chequeForm, DishonorCheque dishonorChq, CVoucherHeader originalVoucher, InstrumentHeader instrumentHeader) {
        try {
            String[] instrumentHeaderIds = chequeForm.getInstHeaderIds().split(",");
            CVoucherHeader reversalVoucher = this.createReversalVoucher(chequeForm, dishonorChq, originalVoucher, instrumentHeader);
            dishonorChq.setReversalVoucherHeader(reversalVoucher);
            this.persistenceService.update((Object)dishonorChq);
            CollectionDishonorCheque collDisCheque = this.populateAndPersistDishonorCheque(chequeForm);
            collDisCheque.setReversalVoucherHeader(reversalVoucher);
            this.persistenceService.update((Object)collDisCheque);
            for (String instHeadId : instrumentHeaderIds) {
                this.updateCollectionsOnInstrumentDishonor(Long.valueOf(instHeadId));
            }
        }
        catch (ValidationException e) {
            LOGGER.error((Object)("Error in DishonorCheque >>>>" + (Object)((Object)e)));
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error in DishonorCheque >>>>" + e));
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
    }

    @Transactional
    public CVoucherHeader createReversalVoucher(DishonoredChequeBean chequeForm, DishonorCheque dishonorChq, CVoucherHeader originalVoucher, InstrumentHeader instrumentHeader) {
        HashMap<String, Object> headerDetails = this.createHeaderAndMisDetails(originalVoucher, instrumentHeader);
        ArrayList accountdetails = new ArrayList();
        ArrayList subledgerdetails = new ArrayList();
        CVoucherHeader reversalVoucher = new CVoucherHeader();
        try {
            ArrayList dishonorChequeDetails = new ArrayList();
            dishonorChequeDetails.addAll(dishonorChq.getDetails());
            HashMap<String, Object> detailMap = null;
            HashMap<String, Object> subledgerMap = null;
            for (DishonorChequeDetails gl : dishonorChequeDetails) {
                detailMap = new HashMap<String, Object>();
                detailMap.put("glcode", gl.getGlcodeId().getGlcode());
                detailMap.put("debitamount", gl.getDebitAmt());
                detailMap.put("creditamount", gl.getCreditAmount());
                accountdetails.add(detailMap);
                Set dishonorChequeSubLedgerDetails = gl.getSubLedgerDetails();
                Iterator iterator = dishonorChequeSubLedgerDetails.iterator();
                if (!iterator.hasNext()) continue;
                DishonorChequeSubLedgerDetails slLedgerDetail = (DishonorChequeSubLedgerDetails)iterator.next();
                subledgerMap = new HashMap<String, Object>();
                subledgerMap.put("glcode", gl.getGlcodeId().getGlcode());
                subledgerMap.put("detailtypeid", slLedgerDetail.getDetailTypeId());
                subledgerMap.put("detailkeyid", slLedgerDetail.getDetailKeyId());
                subledgerMap.put("debitamount", slLedgerDetail.getAmount());
                subledgerdetails.add(subledgerMap);
            }
            reversalVoucher = this.createVoucher.createVoucher(headerDetails, accountdetails, subledgerdetails);
            reversalVoucher.setStatus(Integer.valueOf(0));
            this.voucherHeaderService.applyAuditing((AbstractAuditable)reversalVoucher);
            this.voucherHeaderService.persist((Object)reversalVoucher);
        }
        catch (ValidationException e) {
            LOGGER.error((Object)("Error in DishonorCheque >>>>" + (Object)((Object)e)));
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error in DishonorCheque >>>>" + e));
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        return reversalVoucher;
    }

    private HashMap<String, Object> createHeaderAndMisDetails(CVoucherHeader voucherHeader, InstrumentHeader instrumentHeader) throws ValidationException {
        HashMap<String, Object> headerdetails = new HashMap<String, Object>();
        headerdetails.put("vouchername", "Receipt Reversal");
        headerdetails.put("vouchertype", "Journal Voucher");
        headerdetails.put((String)VoucherConstant.VOUCHERSUBTYPE, voucherHeader.getVoucherSubType());
        headerdetails.put("vouchernumber", null);
        headerdetails.put("voucherdate", voucherHeader.getVoucherDate());
        headerdetails.put("description", " Reversal Voucher Entry for receipt number " + voucherHeader.getVoucherNumber() + ", Cheque Number " + instrumentHeader.getInstrumentNumber() + " Cheque Dated :" + instrumentHeader.getInstrumentDate());
        if (voucherHeader.getVouchermis().getDepartmentid() != null) {
            headerdetails.put("departmentcode", voucherHeader.getVouchermis().getDepartmentid().getCode());
        }
        if (voucherHeader.getFundId() != null) {
            headerdetails.put("fundcode", voucherHeader.getFundId().getCode());
        }
        if (voucherHeader.getVouchermis().getSchemeid() != null) {
            headerdetails.put("schemecode", voucherHeader.getVouchermis().getSchemeid().getCode());
        }
        if (voucherHeader.getVouchermis().getSubschemeid() != null) {
            headerdetails.put("subschemecode", voucherHeader.getVouchermis().getSubschemeid().getCode());
        }
        if (voucherHeader.getVouchermis().getFundsource() != null) {
            headerdetails.put("fundsourcecode", voucherHeader.getVouchermis().getFundsource().getCode());
        }
        if (voucherHeader.getVouchermis().getDivisionid() != null) {
            headerdetails.put("divisionid", voucherHeader.getVouchermis().getDivisionid().getId());
        }
        if (voucherHeader.getVouchermis().getFunctionary() != null) {
            headerdetails.put("functionarycode", voucherHeader.getVouchermis().getFunctionary().getCode());
        }
        if (voucherHeader.getVouchermis().getFunction() != null) {
            headerdetails.put("functioncode", voucherHeader.getVouchermis().getFunction().getCode());
        }
        return headerdetails;
    }

    @Transactional
    public void updateCollectionsOnInstrumentDishonor(Long instrumentHeaderId) {
        LOGGER.debug((Object)("Update Collection and Billing system for dishonored instrument id: " + instrumentHeaderId));
        EgwStatus receiptInstrumentBounceStatus = this.collectionsUtil.getReceiptStatusForCode("INSTR_BOUNCED");
        EgwStatus receiptCancellationStatus = this.collectionsUtil.getReceiptStatusForCode("CANCELLED");
        ReceiptHeader receiptHeader = (ReceiptHeader)((Object)this.persistenceService.find("select DISTINCT (receipt) from ReceiptHeader receipt join receipt.receiptInstrument as instruments where instruments.id=? and instruments.statusId.code not in (?,?)", new Object[]{(long)instrumentHeaderId, receiptInstrumentBounceStatus.getCode(), receiptCancellationStatus.getCode()}));
        InstrumentHeader instrumentHeader = (InstrumentHeader)this.persistenceService.findByNamedQuery("INSTRUMENTHEADERBYID", new Object[]{instrumentHeaderId});
        instrumentHeader.setStatusId(this.getDishonoredStatus());
        this.financialsUtil.updateInstrumentHeader(instrumentHeader);
        this.receiptHeaderService.updateDishonoredInstrumentStatus(receiptHeader, instrumentHeader, receiptInstrumentBounceStatus, false);
        LOGGER.debug((Object)("Updated receipt status to " + receiptInstrumentBounceStatus.getCode() + " set reconcilation to false"));
    }

    private EgwStatus getDishonoredStatus() {
        return this.collectionsUtil.getStatusForModuleAndCode("Instrument", "Dishonored");
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    public void setReceiptHeaderService(ReceiptHeaderService receiptHeaderService) {
        this.receiptHeaderService = receiptHeaderService;
    }

    public void setFinancialsUtil(FinancialsUtil financialsUtil) {
        this.financialsUtil = financialsUtil;
    }

    public void updateSourceInstrumentVoucher(String event, Long instrumentHeaderId) {
    }
}

