/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.integration.services;

import java.math.BigDecimal;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.integration.models.BillAccountDetails;
import org.egov.collection.integration.services.DebitAccountHeadDetailsService;
import org.egov.commons.CChartOfAccounts;
import org.egov.infstr.services.PersistenceService;

public class DebitAccountHeadDetailsServiceImpl
implements DebitAccountHeadDetailsService {
    protected PersistenceService persistenceService;

    @Override
    public ReceiptDetail addDebitAccountHeadDetails(BigDecimal debitAmount, ReceiptHeader receiptHeader, BigDecimal chequeInstrumenttotal, BigDecimal otherInstrumenttotal, String instrumentType) {
        ReceiptDetail newReceiptDetail = new ReceiptDetail();
        newReceiptDetail.setPurpose(BillAccountDetails.PURPOSE.OTHERS.toString());
        if (chequeInstrumenttotal.toString() != null && !chequeInstrumenttotal.toString().trim().equals("0") && !chequeInstrumenttotal.toString().trim().equals("0.0")) {
            newReceiptDetail.setAccounthead((CChartOfAccounts)this.persistenceService.findByNamedQuery("getChartofAccountByInstrumentType", new Object[]{"cheque"}));
            newReceiptDetail.setDramount(debitAmount);
            newReceiptDetail.setCramount(BigDecimal.valueOf(0L));
            newReceiptDetail.setReceiptHeader(receiptHeader);
            newReceiptDetail.setFunction(receiptHeader.getReceiptDetails().iterator().next().getFunction());
        }
        if (otherInstrumenttotal.toString() != null && !otherInstrumenttotal.toString().trim().equals("0") && !otherInstrumenttotal.toString().trim().equals("0.0")) {
            if (instrumentType.equals("cash")) {
                newReceiptDetail.setAccounthead((CChartOfAccounts)this.persistenceService.findByNamedQuery("getChartofAccountByInstrumentType", new Object[]{"cash"}));
            } else if (instrumentType.equals("card")) {
                newReceiptDetail.setAccounthead((CChartOfAccounts)this.persistenceService.findByNamedQuery("getChartofAccountByInstrumentType", new Object[]{"card"}));
            } else if (instrumentType.equals("bankchallan")) {
                newReceiptDetail.setAccounthead(receiptHeader.getReceiptInstrument().iterator().next().getBankAccountId().getChartofaccounts());
            } else if (instrumentType.equals("online")) {
                newReceiptDetail.setAccounthead((CChartOfAccounts)this.persistenceService.findByNamedQuery("getCOAByInstrumentTypeAndService", new Object[]{"online", receiptHeader.getOnlinePayment().getService().getId()}));
            }
            newReceiptDetail.setDramount(debitAmount);
            newReceiptDetail.setCramount(BigDecimal.ZERO);
            newReceiptDetail.setReceiptHeader(receiptHeader);
            newReceiptDetail.setFunction(receiptHeader.getReceiptDetails().iterator().next().getFunction());
        }
        return newReceiptDetail;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }
}

