/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.integration.services;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.collection.integration.models.BillReceiptInfoImpl;
import org.egov.collection.integration.models.ReceiptAmountInfo;
import org.egov.collection.integration.services.BillingIntegrationService;
import org.egov.collection.xml.converter.BillReceiptInfoConverter;
import org.egov.collection.xml.converter.ReceiptAccountInfoConverter;
import org.egov.collection.xml.converter.ReceiptInstrumentInfoConverter;
import org.egov.infra.exception.ApplicationRuntimeException;

public class BillingIntegrationServiceStub
implements BillingIntegrationService {
    private static final Logger LOGGER = Logger.getLogger(BillingIntegrationServiceStub.class);

    @Override
    public void updateReceiptDetails(Set<BillReceiptInfo> billReceipts) throws ApplicationRuntimeException {
        try {
            String xml = this.convertToXML(billReceipts);
            LOGGER.debug((Object)("Written bill details to file successfully " + xml));
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error occrured while updating dishonored cheque status to billing system : " + e));
            throw new ApplicationRuntimeException("Exception Occured" + e);
        }
    }

    @Override
    public void apportionPaidAmount(String billReferenceNumber, BigDecimal actualAmountPaid, ArrayList<ReceiptDetail> receiptDetailsArray) {
    }

    private String convertToXML(Set<BillReceiptInfo> billReceipts) {
        XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xStream.registerConverter((Converter)new BillReceiptInfoConverter());
        xStream.registerConverter((Converter)new ReceiptAccountInfoConverter());
        xStream.registerConverter((Converter)new ReceiptInstrumentInfoConverter());
        xStream.alias("Bill-Receipt", BillReceiptInfoImpl.class);
        return xStream.toXML(billReceipts);
    }

    @Override
    public List<ReceiptDetail> reconstructReceiptDetail(String billReferenceNumber, BigDecimal actualAmountPaid, List<ReceiptDetail> receiptDetailList) {
        return receiptDetailList;
    }

    @Override
    public String constructAdditionalInfoForReceipt(BillReceiptInfo billReceiptInfo) {
        return null;
    }

    @Override
    public ReceiptAmountInfo receiptAmountBifurcation(BillReceiptInfo billReceiptInfo) {
        return new ReceiptAmountInfo();
    }
}

