/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.collection.config.properties.CollectionApplicationProperties;
import org.egov.collection.entity.Challan;
import org.egov.collection.entity.CollectionIndex;
import org.egov.collection.entity.OnlinePayment;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.integration.models.BillReceiptInfoImpl;
import org.egov.collection.integration.models.ReceiptAmountInfo;
import org.egov.collection.integration.services.BillingIntegrationService;
import org.egov.commons.CFinancialYear;
import org.egov.commons.EgwStatus;
import org.egov.commons.Fund;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.commons.dao.InstallmentHibDao;
import org.egov.commons.exception.NoSuchObjectException;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.EmployeeView;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.EisCommonService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.Location;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.messaging.MessagingService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.models.ServiceDetails;
import org.egov.infstr.services.EISServeable;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.pims.model.PersonalInformation;
import org.egov.pims.service.SearchPositionService;
import org.egov.pims.utils.EisManagersUtill;
import org.hibernate.Query;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class CollectionsUtil {
    public static final SimpleDateFormat CHEQUE_DATE_FORMAT = new SimpleDateFormat("dd-MM-yyyy");
    private static final Logger LOGGER = Logger.getLogger(CollectionsUtil.class);
    @Autowired
    protected AssignmentService assignmentService;
    private PersistenceService persistenceService;
    @Autowired
    private UserService userService;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    private SearchPositionService searchPositionService;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private EISServeable eisService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private PositionMasterService posService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private InstallmentHibDao installmentHibDao;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusDAO;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    @Autowired
    private FinancialYearDAO financialYearDAO;
    private ReportService reportService;
    @Autowired
    private MessagingService messagingService;
    @Autowired
    private CollectionApplicationProperties collectionApplicationProperties;

    public EgwStatus getReceiptStatusForCode(String statusCode) {
        return this.getStatusForModuleAndCode("ReceiptHeader", statusCode);
    }

    public EgwStatus getStatusForModuleAndCode(String moduleName, String statusCode) {
        return this.egwStatusDAO.getStatusByModuleAndCode(moduleName, statusCode);
    }

    public List<EgwStatus> getAllReceiptHeaderStatus() {
        return this.egwStatusDAO.getStatusByModule("ReceiptHeader");
    }

    public String getLoggedInUserName() {
        return this.securityUtils.getCurrentUser().getName();
    }

    public User getLoggedInUser() {
        return this.securityUtils.getCurrentUser();
    }

    public Department getDepartmentOfUser(User user) {
        if (this.assignmentService.getPrimaryAssignmentForUser(user.getId()) == null) {
            return null;
        }
        return this.eisCommonService.getDepartmentForUser(user.getId());
    }

    public Department getDepartmentOfLoggedInUser() {
        User user = this.securityUtils.getCurrentUser();
        return this.getDepartmentOfUser(user);
    }

    public User getUserByUserName(String userName) {
        return this.userService.getUserByUsername(userName);
    }

    public Location getLocationOfUser(Map<String, Object> sessionMap) {
        Location location = null;
        String locationId = (String)sessionMap.get("locationId");
        if (locationId != null && !locationId.isEmpty()) {
            location = this.getLocationById(Long.valueOf(locationId));
        }
        if (location == null) {
            throw new ValidationException(Arrays.asList(new ValidationError("Location Not Found", "submitcollections.validation.error.location.notfound")));
        }
        return location;
    }

    public Location getLocationById(Long locationId) {
        return (Location)this.persistenceService.findByNamedQuery("getLocationById", new Object[]{locationId});
    }

    public List getAllCounters() {
        return this.persistenceService.findAllByNamedQuery("getAllCounters", new Object[0]);
    }

    public List getChallanServiceList() {
        return this.persistenceService.findAllByNamedQuery("getServicesByType", new Object[]{"C"});
    }

    public List getBillingServiceList() {
        return this.persistenceService.findAllByNamedQuery("getServicesByType", new Object[]{"B"});
    }

    public List getReceiptCreators() {
        return this.persistenceService.findAllByNamedQuery("CREATEDBYUSERS_OF_RECEIPTS", new Object[0]);
    }

    public List getReceiptZoneList() {
        return this.persistenceService.findAllByNamedQuery("getAllReceiptBoundary", new Object[0]);
    }

    public List<String> getCollectionModesNotAllowed(User loggedInUser) {
        ArrayList<String> collectionsModeNotAllowed = new ArrayList<String>(0);
        List deptCodesApp = this.appConfigValuesService.getConfigValuesByModuleAndKey("Collection", "COLLECTIONDEPARTMENTCOLLMODES");
        ArrayList<String> deptCodes = new ArrayList<String>();
        for (AppConfigValues deptCode : deptCodesApp) {
            deptCodes.add(deptCode.getValue());
        }
        Boolean isDeptAllowed = false;
        Boolean isEmp = this.isEmployee(loggedInUser);
        if (isEmp.booleanValue()) {
            List assignList = this.assignmentService.getAllActiveEmployeeAssignmentsByEmpId(loggedInUser.getId());
            for (Assignment assign : assignList) {
                if (deptCodes.isEmpty() || !deptCodes.contains(assign.getDepartment().getCode())) continue;
                isDeptAllowed = true;
            }
        }
        if (isEmp.booleanValue() && !isDeptAllowed.booleanValue()) {
            throw new ValidationException(Arrays.asList(new ValidationError("Department", "billreceipt.counter.deptcode.null")));
        }
        return collectionsModeNotAllowed;
    }

    public Boolean isEmployee(User user) {
        for (Role role : user.getRoles()) {
            for (AppConfigValues appconfig : this.getThirdPartyUserRoles()) {
                if (role == null || !role.getName().equals(appconfig.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    public List<AppConfigValues> getThirdPartyUserRoles() {
        List appConfigValueList = this.appConfigValuesService.getConfigValuesByModuleAndKey("Collection", "COLLECTIONROLEFORNONEMPLOYEE");
        return !appConfigValueList.isEmpty() ? appConfigValueList : null;
    }

    public String getDepartmentForWorkFlow() {
        String department = "";
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Collection", "COLLECTIONDEPARTMENTFORWORKFLOW");
        if (null != appConfigValue && !appConfigValue.isEmpty()) {
            department = ((AppConfigValues)appConfigValue.get(0)).getValue();
        }
        return department;
    }

    public Position getPositionByDeptDesgAndBoundary(Boundary boundary) {
        Position position = null;
        String designationStr = this.getDesignationForThirdPartyUser();
        String departmentStr = this.getDepartmentForWorkFlow();
        String[] department = departmentStr.split(",");
        String[] designation = designationStr.split(",");
        List assignment = new ArrayList();
        for (String dept : department) {
            for (String desg : designation) {
                assignment = this.assignmentService.findByDepartmentDesignationAndBoundary(this.departmentService.getDepartmentByName(dept).getId(), this.designationService.getDesignationByName(desg).getId(), boundary.getId());
                if (!assignment.isEmpty()) break;
            }
            if (!assignment.isEmpty()) break;
        }
        if (!assignment.isEmpty()) {
            position = ((Assignment)assignment.get(0)).getPosition();
        }
        return position;
    }

    public String getDesignationForThirdPartyUser() {
        String designation = "";
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Collection", "COLLECTIONDESIGNATIONFORCSCOPERATORASCLERK");
        if (null != appConfigValue && !appConfigValue.isEmpty()) {
            designation = ((AppConfigValues)appConfigValue.get(0)).getValue();
        }
        return designation;
    }

    public Position getPositionOfUser(User user) {
        return this.posService.getCurrentPositionForUser(user.getId());
    }

    public List<Position> getPositionsForEmployee(User user) {
        return this.posService.getPositionsForEmployee(user.getId(), null);
    }

    public Position getPositionByName(String positionName) {
        return this.posService.getPositionByName(positionName);
    }

    public CFinancialYear getFinancialYearforDate(Date date) {
        return (CFinancialYear)this.persistenceService.getSession().createQuery("from CFinancialYear cfinancialyear where ? between cfinancialyear.startingDate and cfinancialyear.endingDate").setDate(0, date).list().get(0);
    }

    public boolean checkChallanValidity(Challan challan) {
        Calendar current = Calendar.getInstance();
        current.clear(11);
        current.clear(12);
        current.clear(13);
        current.clear(14);
        Calendar validityStart = Calendar.getInstance();
        validityStart.setTime(challan.getChallanDate());
        validityStart.clear(11);
        validityStart.clear(12);
        validityStart.clear(13);
        validityStart.clear(14);
        Calendar validityEnd = Calendar.getInstance();
        validityEnd.setTime(challan.getValidUpto());
        validityEnd.clear(11);
        validityEnd.clear(12);
        validityEnd.clear(13);
        validityEnd.clear(14);
        return validityStart.compareTo(current) <= 0 && validityEnd.compareTo(current) >= 0;
    }

    public Object getBean(String beanName) {
        Object bean = null;
        try {
            bean = this.context.getBean(beanName);
            LOGGER.debug((Object)(" Got bean : " + beanName));
        }
        catch (BeansException e) {
            String errorMsg = "Could not locate bean [" + beanName + "]";
            LOGGER.error((Object)errorMsg, (Throwable)e);
            throw new ApplicationRuntimeException(errorMsg, (Throwable)e);
        }
        return bean;
    }

    public String getAppConfigValue(String moduleName, String key, String defaultValue) {
        AppConfigValues configVal = this.appConfigValuesService.getAppConfigValueByDate(moduleName, key, new Date());
        return configVal == null ? defaultValue : configVal.getValue();
    }

    public String getAppConfigValue(String moduleName, String key) {
        List appConfValues = this.appConfigValuesService.getConfigValuesByModuleAndKey(moduleName, key);
        if (appConfValues != null && !appConfValues.isEmpty()) {
            return ((AppConfigValues)appConfValues.get(0)).getValue();
        }
        return "";
    }

    public List<AppConfigValues> getAppConfigValues(String moduleName, String key) {
        return this.appConfigValuesService.getConfigValuesByModuleAndKey(moduleName, key);
    }

    public Position getPositionById(Long positionId) {
        return this.posService.getPositionById(positionId);
    }

    public Position getPositionforEmp(Long employeeId) {
        return this.posService.getPositionByUserId(employeeId);
    }

    public PersonalInformation getEmployeeByDepartmentDesignationBoundaryandFunctionary(Long deptId, Long designationId, Integer boundaryId, Integer functionaryId) {
        PersonalInformation personalInformation = null;
        try {
            personalInformation = EisManagersUtill.getEmployeeService().getEmployeeByFunctionary(deptId, designationId, Long.valueOf(boundaryId.intValue()), functionaryId);
        }
        catch (Exception e) {
            String errorMsg = "Could not get PersonalInformation";
            LOGGER.error((Object)"Could not get PersonalInformation", (Throwable)e);
            throw new ApplicationRuntimeException("Could not get PersonalInformation", (Throwable)e);
        }
        return personalInformation;
    }

    public List<Department> getAllNonPrimaryAssignmentsOfLoggedInUser() {
        return this.getAllNonPrimaryAssignmentsOfUser(this.getLoggedInUser());
    }

    public List<Department> getAllNonPrimaryAssignmentsOfUser(User user) {
        ArrayList<Department> departmentlist = new ArrayList<Department>();
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("code", EisManagersUtill.getEmployeeService().getEmpForUserId(user.getId()).getCode());
            List employeeViewList = this.eisService.getEmployeeInfoList(paramMap);
            if (!employeeViewList.isEmpty()) {
                for (EmployeeView employeeView : employeeViewList) {
                    if (employeeView.getAssignment().getPrimary()) continue;
                    departmentlist.add(employeeView.getAssignment().getDepartment());
                }
            }
        }
        catch (Exception e) {
            String errorMsg = "Could not get list of assignments";
            LOGGER.error((Object)"Could not get list of assignments", (Throwable)e);
            throw new ApplicationRuntimeException("Could not get list of assignments", (Throwable)e);
        }
        return departmentlist;
    }

    public Department getNonPrimaryDeptOfUser(User user) {
        List<Department> nonPrimaryAssignments = this.getAllNonPrimaryAssignmentsOfUser(user);
        return nonPrimaryAssignments.isEmpty() ? null : nonPrimaryAssignments.get(0);
    }

    public List<Designation> getDesignationsAllowedForChallanApproval(Integer departmentId) {
        List designations = this.designationService.getAllDesignationByDepartment(Long.valueOf(departmentId.intValue()), new Date());
        ArrayList<Designation> designation = new ArrayList<Designation>(0);
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Collection", "COLLECTIONDESIGCHALLANWORKFLOW");
        for (Designation desig : designations) {
            for (AppConfigValues app : appConfigValue) {
                if (!desig.getName().equals(app.getValue())) continue;
                designation.add(desig);
            }
        }
        return designation;
    }

    public List<Department> getDepartmentsAllowedForChallanApproval() {
        ArrayList<Department> departments = new ArrayList<Department>(0);
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Collection", "COLLECTIONDESIGCHALLANWORKFLOW");
        if (null != appConfigValue && !appConfigValue.isEmpty()) {
            for (AppConfigValues app : appConfigValue) {
                List assignments = this.assignmentService.findPrimaryAssignmentForDesignationName(app.getValue());
                for (Assignment assign : assignments) {
                    if (departments.contains(assign.getDepartment())) continue;
                    departments.add(assign.getDepartment());
                }
            }
        }
        return departments;
    }

    public boolean isPropertyTaxArrearAccountHead(String glcode, String description) {
        boolean retValue;
        List list = this.appConfigValuesService.getConfigValuesByModuleAndKey("Property Tax", "ISARREARACCOUNT");
        AppConfigValues penaltyGlCode = this.appConfigValuesService.getAppConfigValueByDate("Property Tax", "PTPENALTYGLCODE", new Date());
        LOGGER.debug((Object)("isPropertyTaxArrearAccountHead glcode " + glcode + " description " + description));
        if (penaltyGlCode != null && penaltyGlCode.getValue().equals(glcode)) {
            Module module = this.moduleService.getModuleByName("Property Tax");
            String currInst = this.installmentHibDao.getInsatllmentByModuleForGivenDate(module, new Date()).getDescription();
            retValue = !currInst.equals(description.substring(16, description.length()));
        } else {
            ArrayList<String> accValues = new ArrayList<String>(0);
            for (AppConfigValues value : list) {
                accValues.add(value.getValue());
            }
            retValue = accValues.contains(glcode);
        }
        return retValue;
    }

    public List<EmployeeView> getPositionBySearchParameters(String beginsWith, Integer desId, Integer deptId, Integer jurdId, Integer roleId, Date userDate, Integer maxResults) throws NoSuchObjectException {
        return this.searchPositionService.getPositionBySearchParameters(beginsWith, desId, deptId, jurdId != null ? Long.valueOf(jurdId.intValue()) : null, roleId, userDate, maxResults);
    }

    public List<OnlinePayment> getOnlineTransactionHistory(String consumerCode) {
        String hql = "select online from ReceiptHeader rh, org.egov.collection.entity.OnlinePayment online where rh.id = online.receiptHeader.id and rh.consumerCode =:consumercode  order by online.id desc";
        Query query = this.persistenceService.getSession().createQuery("select online from ReceiptHeader rh, org.egov.collection.entity.OnlinePayment online where rh.id = online.receiptHeader.id and rh.consumerCode =:consumercode  order by online.id desc");
        query.setString("consumercode", consumerCode);
        query.setMaxResults(3);
        return query.list();
    }

    public List getAllLocations() {
        return this.persistenceService.findAllByNamedQuery("getAllLocations", new Object[0]);
    }

    public List<Fund> getAllFunds() {
        return this.persistenceService.findAllByNamedQuery("getAllFund", new Object[0]);
    }

    public User getUserById(Long userId) {
        return this.userService.getUserById(userId);
    }

    public boolean isValidTemplate(String templateName) {
        return this.reportService.isValidTemplate(templateName);
    }

    public ReportOutput createReport(ReportRequest reportRequest) {
        return this.reportService.createReport(reportRequest);
    }

    public CollectionIndex constructCollectionIndex(ReceiptHeader receiptHeader) {
        ReceiptAmountInfo receiptAmountInfo = new ReceiptAmountInfo();
        ServiceDetails billingService = receiptHeader.getService();
        String instrumentType = "";
        if (!receiptHeader.getReceiptInstrument().isEmpty()) {
            instrumentType = receiptHeader.getReceiptInstrument().iterator().next().getInstrumentType().getType();
        }
        if (receiptHeader.getReceipttype() == 'B') {
            BillingIntegrationService billingServiceBean = (BillingIntegrationService)this.getBean(billingService.getCode() + "CollectionsInterface");
            try {
                receiptAmountInfo = billingServiceBean.receiptAmountBifurcation(new BillReceiptInfoImpl(receiptHeader, this.chartOfAccountsHibernateDAO, this.persistenceService, null));
            }
            catch (Exception e) {
                String errMsg = "Exception while constructing collection index for receipt number [" + receiptHeader.getReceiptnumber() + "]!";
                LOGGER.error((Object)errMsg, (Throwable)e);
                throw new ApplicationRuntimeException(errMsg, (Throwable)e);
            }
        }
        CollectionIndex collectionIndex = CollectionIndex.builder().withReceiptDate(receiptHeader.getReceiptdate()).withReceiptnumber(receiptHeader.getReceiptnumber()).withBillingservice(billingService.getName()).withPaymentMode(instrumentType).withTotalamount(receiptHeader.getTotalAmount()).withChannel(receiptHeader.getSource()).withStatus(receiptHeader.getStatus().getDescription()).withConsumerCode(receiptHeader.getConsumerCode() != null ? receiptHeader.getConsumerCode() : "").withBillNumber(receiptHeader.getReferencenumber() != null ? receiptHeader.getReferencenumber() : null).withPaymentGateway(receiptHeader.getOnlinePayment() != null ? receiptHeader.getOnlinePayment().getService().getName() : "").withConsumerName(receiptHeader.getPayeeName() != null ? receiptHeader.getPayeeName() : "").withReceiptCreator(receiptHeader.getCreatedBy() != null ? receiptHeader.getCreatedBy().getName() : "").withArrearAmount(receiptAmountInfo.getArrearsAmount()).withAdvanceAmount(receiptAmountInfo.getAdvanceAmount()).withCurrentAmount(receiptAmountInfo.getCurrentInstallmentAmount()).withPenaltyAmount(receiptAmountInfo.getPenaltyAmount()).withArrearCess(receiptAmountInfo.getArrearCess()).withLatePaymentChargesAmount(receiptAmountInfo.getLatePaymentCharges()).withCurrentCess(receiptAmountInfo.getCurrentCess()).withReductionAmount(receiptAmountInfo.getReductionAmount()).withInstallmentFrom(receiptAmountInfo.getInstallmentFrom() != null ? receiptAmountInfo.getInstallmentFrom() : "").withInstallmentTo(receiptAmountInfo.getInstallmentTo() != null ? receiptAmountInfo.getInstallmentTo() : "").withRevenueWard(receiptAmountInfo.getRevenueWard()).withConsumerType(receiptHeader.getConsumerType() != null ? receiptHeader.getConsumerType() : "").withConflict(receiptAmountInfo.getConflict() != null ? receiptAmountInfo.getConflict() : 0).build();
        return collectionIndex;
    }

    public Boolean checkVoucherCreation(ReceiptHeader receiptHeader) {
        Boolean createVoucherForBillingService = Boolean.FALSE;
        if (receiptHeader.getService().getVoucherCutOffDate() != null && receiptHeader.getReceiptDate().compareTo(receiptHeader.getService().getVoucherCutOffDate()) > 0) {
            if (receiptHeader.getService().getVoucherCreation() != null) {
                createVoucherForBillingService = receiptHeader.getService().getVoucherCreation();
            }
        } else if (receiptHeader.getService().getVoucherCutOffDate() == null && receiptHeader.getService().getVoucherCreation() != null) {
            createVoucherForBillingService = receiptHeader.getService().getVoucherCreation();
        }
        return createVoucherForBillingService;
    }

    public Designation getDesignationForApprover() {
        return this.designationService.getDesignationByName(this.getAppConfigValue("Collection", "COLLECTIONDESIGNATIONFORAPPROVER"));
    }

    public String getApproverName(Position position) {
        String approver = null;
        List assignments = this.assignmentService.getAssignmentsForPosition(position.getId());
        for (Assignment assignment : assignments) {
            if (!assignment.getPrimary()) continue;
            approver = assignment.getEmployee().getName().concat("~").concat(assignment.getEmployee().getCode()).concat("~").concat(assignment.getPosition().getName());
        }
        return approver;
    }

    public List<ReceiptDetail> reconstructReceiptDetail(ReceiptHeader receiptHeader, List<ReceiptDetail> receiptDetailList) {
        BillingIntegrationService billingService = (BillingIntegrationService)this.getBean(receiptHeader.getService().getCode() + "CollectionsInterface");
        return billingService.reconstructReceiptDetail(receiptHeader.getReferencenumber(), receiptHeader.getTotalAmount(), receiptDetailList);
    }

    public Date getRemittanceVoucherDate(Date receiptDate) {
        Date voucherDate;
        Boolean useReceiptDateAsContraVoucherDate = false;
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        Date rcptDate = null;
        if (this.getAppConfigValue("Collection", "USERECEIPTDATEFORCONTRA").equals("Y")) {
            useReceiptDateAsContraVoucherDate = true;
        }
        try {
            Date finDate = null;
            if (receiptDate != null) {
                rcptDate = receiptDate;
                finDate = this.financialYearDAO.getFinancialYearByDate(rcptDate).getStartingDate();
            }
            voucherDate = finDate != null && finDate.toString().equals(this.financialYearDAO.getCurrYearStartDate()) ? (useReceiptDateAsContraVoucherDate.booleanValue() ? rcptDate : sdf.parse(sdf.format(new Date()))) : this.financialYearDAO.getPreviousFinancialYearByDate(new Date()).getEndingDate();
        }
        catch (ParseException e) {
            LOGGER.debug((Object)("Exception in parsing date  " + rcptDate + " - " + e.getMessage()));
            throw new ApplicationRuntimeException("Exception while parsing date", (Throwable)e);
        }
        return voucherDate;
    }

    public Boolean getVoucherType() {
        Boolean voucherTypeForChequeDDCard = false;
        if (this.getAppConfigValue("Collection", "REMITTANCEVOUCHERTYPEFORCHEQUEDDCARD").equals("Receipt")) {
            voucherTypeForChequeDDCard = true;
        }
        return voucherTypeForChequeDDCard;
    }

    public String getReceiptTemplateName(char receiptType, String serviceCode) {
        String templateName = null;
        switch (receiptType) {
            case 'B': {
                templateName = serviceCode + "_" + "collection_receipt";
                if (this.isValidTemplate(templateName)) break;
                LOGGER.info((Object)("Billing system specific report template [" + templateName + "] not available. Using the default template [" + "collection_receipt" + "]"));
                templateName = "PT_collection_receipt";
                if (this.isValidTemplate(templateName)) break;
                String errMsg = "Report template [" + templateName + "] not available! Receipt report cannot be generated.";
                LOGGER.error((Object)errMsg);
                throw new ApplicationRuntimeException(errMsg);
            }
            case 'C': {
                templateName = "collection_receipt_challan";
                break;
            }
            case 'A': {
                templateName = "collection_receipt";
            }
        }
        return templateName;
    }

    public void emailReceiptAsAttachment(ReceiptHeader receiptHeader, byte[] attachment) {
        String emailBody = this.collectionApplicationProperties.getEmailBody();
        emailBody = String.format(emailBody, ApplicationThreadLocals.getCityName(), receiptHeader.getTotalAmount().toString(), receiptHeader.getService().getName(), receiptHeader.getConsumerCode(), receiptHeader.getReceiptdate().toString(), ApplicationThreadLocals.getCityName());
        String emailSubject = this.collectionApplicationProperties.getEmailSubject();
        emailSubject = String.format(emailSubject, receiptHeader.getService().getName());
        this.messagingService.sendEmailWithAttachment(receiptHeader.getPayeeEmail(), emailSubject, emailBody, "application/pdf", "Receipt" + receiptHeader.getReceiptdate().toString(), attachment);
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }
}

