/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.egov.collection.entity.AccountPayeeDetail;
import org.egov.collection.entity.Challan;
import org.egov.collection.entity.CollectionIndex;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.entity.ReceiptMisc;
import org.egov.collection.entity.ReceiptVoucher;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.collection.integration.models.BillReceiptInfoImpl;
import org.egov.collection.integration.services.BillingIntegrationService;
import org.egov.collection.service.ChallanService;
import org.egov.collection.service.CollectionIndexService;
import org.egov.collection.utils.CollectionsNumberGenerator;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.collection.utils.FinancialsUtil;
import org.egov.collection.utils.es.CollectionIndexUtils;
import org.egov.commons.Bankaccount;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.entity.Jurisdiction;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EmployeeService;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.models.ServiceDetails;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.model.instrument.InstrumentType;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class ReceiptHeaderService
extends PersistenceService<ReceiptHeader, Long> {
    private static final Logger LOGGER = Logger.getLogger(ReceiptHeaderService.class);
    private CollectionsUtil collectionsUtil;
    private CollectionsNumberGenerator collectionsNumberGenerator;
    private FinancialsUtil financialsUtil;
    private PersistenceService persistenceService;
    @Autowired
    private EmployeeService employeeService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private AssignmentService assignmentService;
    private ChallanService challanService;
    @Autowired
    private CollectionIndexService collectionIndexService;
    @Autowired
    private CollectionIndexUtils collectionIndexUtils;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;

    public ReceiptHeaderService() {
        super(ReceiptHeader.class);
    }

    public ReceiptHeaderService(Class<ReceiptHeader> type) {
        super(type);
    }

    public List<ReceiptHeader> findAllByPositionAndInboxItemDetails(List<Long> positionIds, String groupingCriteria) {
        StringBuilder query = new StringBuilder("from org.egov.collection.entity.ReceiptHeader where 1=1 and state.value != 'END' and state.status != 2");
        String wfAction = null;
        String serviceCode = null;
        String userName = null;
        String receiptDate = null;
        String receiptType = null;
        Integer counterId = null;
        String[] params = groupingCriteria.split("-", -1);
        if (params.length == 6) {
            wfAction = params[0];
            serviceCode = params[1];
            userName = params[2];
            counterId = Integer.valueOf(params[4]);
            receiptDate = params[3];
            receiptType = params[5];
        }
        boolean allCounters = counterId == null || counterId < 0;
        boolean allServices = serviceCode == null || serviceCode.equals("ALL");
        boolean allWfAction = wfAction == null || wfAction.equals("ALL");
        boolean allUserName = userName == null || userName.equals("ALL");
        boolean allDate = receiptDate == null || receiptDate.equals("ALL");
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        Date rcptDate = null;
        try {
            rcptDate = formatter.parse(receiptDate);
        }
        catch (ParseException e) {
            LOGGER.error((Object)("Exception while parsing ReceiptDate" + e.getMessage()));
        }
        query.append(" and state.ownerPosition.id in :positionIds");
        if (!allCounters) {
            query.append(" and location.id = :counterId");
        }
        if (!allServices && receiptType.equals("B")) {
            query.append(" and service.code = :serviceCode");
        }
        if (!allWfAction) {
            query.append(" and state.nextAction = :wfAction");
        }
        if (!allUserName) {
            query.append(" and createdBy.username = :userName");
        }
        if (!allDate) {
            query.append(" and (cast(receiptDate as date)) = :rcptDate");
        }
        if (receiptType.equals("B")) {
            query.append(" and receipttype = :receiptType");
        } else {
            query.append(" and receipttype in ('A', 'C')");
        }
        query.append(" order by receiptdate  desc");
        Query listQuery = this.getSession().createQuery(query.toString());
        listQuery.setParameterList("positionIds", positionIds);
        if (!allCounters) {
            listQuery.setInteger("counterId", counterId.intValue());
        }
        if (!allServices && receiptType.equals("B")) {
            listQuery.setString("serviceCode", serviceCode);
        }
        if (!allWfAction) {
            listQuery.setString("wfAction", wfAction);
        }
        if (!allUserName) {
            listQuery.setString("userName", userName);
        }
        if (!allDate) {
            listQuery.setDate("rcptDate", rcptDate);
        }
        if (receiptType.equals("B")) {
            listQuery.setCharacter("receiptType", receiptType.charAt(0));
        }
        return listQuery.list();
    }

    protected CVoucherHeader createVoucher(ReceiptHeader receiptHeader) {
        ReceiptMisc receiptMisc;
        HashMap<String, Object> headerdetails = new HashMap<String, Object>(0);
        ArrayList<HashMap<String, Object>> accountCodeList = new ArrayList<HashMap<String, Object>>(0);
        ArrayList<HashMap<String, Object>> subledgerList = new ArrayList<HashMap<String, Object>>(0);
        String fundCode = null;
        String fundsourceCode = null;
        String departmentCode = null;
        Boolean isVoucherApproved = Boolean.FALSE;
        if (receiptHeader.getService().getIsVoucherApproved() != null) {
            isVoucherApproved = receiptHeader.getService().getIsVoucherApproved();
        }
        if ((receiptMisc = receiptHeader.getReceiptMisc()).getFund() != null) {
            fundCode = receiptMisc.getFund().getCode();
        }
        if (receiptMisc.getFundsource() != null) {
            fundsourceCode = receiptMisc.getFundsource().getCode();
        }
        if (receiptMisc.getDepartment() != null) {
            departmentCode = receiptMisc.getDepartment().getCode();
        }
        for (InstrumentHeader instrumentHeader : receiptHeader.getReceiptInstrument()) {
            if (instrumentHeader.getInstrumentType().getType().equals("cash") || instrumentHeader.getInstrumentType().getType().equals("cheque") || instrumentHeader.getInstrumentType().getType().equals("dd") || instrumentHeader.getInstrumentType().getType().equals("online") || instrumentHeader.getInstrumentType().getType().equals("card")) {
                headerdetails.put("vouchername", "Other receipts");
                headerdetails.put("vouchertype", "Receipt");
                continue;
            }
            if (!instrumentHeader.getInstrumentType().getType().equals("bankchallan")) continue;
            headerdetails.put("vouchername", "Pay in slip");
            headerdetails.put("vouchertype", "Contra");
        }
        headerdetails.put("description", "Collection Module");
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
        try {
            String dateString;
            if (receiptHeader.getVoucherDate() == null) {
                dateString = format.format(new Date());
                headerdetails.put("voucherdate", format.parse(dateString));
            } else {
                dateString = format.format(receiptHeader.getVoucherDate());
                headerdetails.put("voucherdate", format.parse(dateString));
            }
        }
        catch (ParseException e) {
            LOGGER.error((Object)"Exception while voucher date", (Throwable)e);
            throw new ApplicationRuntimeException(e.getMessage());
        }
        if (receiptHeader.getVoucherNum() != null && !receiptHeader.getVoucherNum().isEmpty()) {
            headerdetails.put("vouchernumber", receiptHeader.getVoucherNum());
        }
        headerdetails.put("fundcode", fundCode);
        headerdetails.put("departmentcode", departmentCode);
        headerdetails.put("fundsourcecode", fundsourceCode);
        headerdetails.put("moduleid", "10");
        headerdetails.put("sourcepath", "/collection/receipts/receipt-viewReceipts.action?selectedReceipts=" + receiptHeader.getId());
        Set<ReceiptDetail> receiptDetailSet = receiptHeader.getReceipttype() == 'B' ? this.aggregateDuplicateReceiptDetailObject(new ArrayList<ReceiptDetail>(receiptHeader.getReceiptDetails())) : receiptHeader.getReceiptDetails();
        for (ReceiptDetail receiptDetail : receiptDetailSet) {
            if (receiptDetail.getCramount().compareTo(BigDecimal.ZERO) == 0 && receiptDetail.getDramount().compareTo(BigDecimal.ZERO) == 0) continue;
            HashMap<String, Object> accountcodedetailsHashMap = new HashMap<String, Object>(0);
            accountcodedetailsHashMap.put("glcode", receiptDetail.getAccounthead().getGlcode());
            accountcodedetailsHashMap.put("debitamount", receiptDetail.getDramount().compareTo(BigDecimal.ZERO) == 0 ? Integer.valueOf(0) : receiptDetail.getDramount());
            accountcodedetailsHashMap.put("creditamount", receiptDetail.getCramount().compareTo(BigDecimal.ZERO) == 0 ? Integer.valueOf(0) : receiptDetail.getCramount());
            if (receiptDetail.getFunction() != null) {
                accountcodedetailsHashMap.put("functioncode", receiptDetail.getFunction().getCode());
            }
            accountCodeList.add(accountcodedetailsHashMap);
            for (AccountPayeeDetail accpayeeDetail : receiptDetail.getAccountPayeeDetails()) {
                if (accpayeeDetail.getAmount().compareTo(BigDecimal.ZERO) == 0) continue;
                HashMap<String, Object> subledgerdetailsHashMap = new HashMap<String, Object>(0);
                subledgerdetailsHashMap.put("glcode", accpayeeDetail.getReceiptDetail().getAccounthead().getGlcode());
                subledgerdetailsHashMap.put("detailtypeid", accpayeeDetail.getAccountDetailType().getId());
                subledgerdetailsHashMap.put("detailkeyid", accpayeeDetail.getAccountDetailKey().getDetailkey());
                if (accpayeeDetail.getReceiptDetail().getCramount().compareTo(BigDecimal.ZERO) != 0) {
                    subledgerdetailsHashMap.put("creditamount", accpayeeDetail.getAmount().compareTo(BigDecimal.ZERO) == 0 ? Integer.valueOf(0) : accpayeeDetail.getAmount());
                } else if (accpayeeDetail.getReceiptDetail().getDramount().compareTo(BigDecimal.ZERO) != 0) {
                    subledgerdetailsHashMap.put("debitamount", accpayeeDetail.getAmount().compareTo(BigDecimal.ZERO) == 0 ? Integer.valueOf(0) : accpayeeDetail.getAmount());
                }
                subledgerList.add(subledgerdetailsHashMap);
            }
        }
        return this.financialsUtil.createVoucher(headerdetails, accountCodeList, subledgerList, isVoucherApproved);
    }

    public CVoucherHeader createVoucherForReceipt(ReceiptHeader receiptHeader) {
        CVoucherHeader voucherheader = null;
        boolean isParentReceiptInstrumentDeposited = false;
        if (receiptHeader.getReceiptHeader() != null) {
            for (InstrumentHeader instrumentHeader : receiptHeader.getReceiptHeader().getReceiptInstrument()) {
                if (instrumentHeader.getInstrumentType().getType().equals("cash")) {
                    if (!instrumentHeader.getStatusId().getDescription().equals("Reconciled")) continue;
                    isParentReceiptInstrumentDeposited = true;
                    break;
                }
                if (!instrumentHeader.getStatusId().getDescription().equals("Deposited")) continue;
                isParentReceiptInstrumentDeposited = true;
                break;
            }
        }
        if ((receiptHeader.getReceiptHeader() == null || receiptHeader.getReceiptHeader() != null && !isParentReceiptInstrumentDeposited) && (voucherheader = this.createVoucher(receiptHeader)) != null) {
            ReceiptVoucher receiptVoucher = new ReceiptVoucher();
            receiptVoucher.setVoucherheader(voucherheader);
            receiptVoucher.setReceiptHeader(receiptHeader);
            receiptHeader.addReceiptVoucher(receiptVoucher);
        }
        this.updateInstrument(receiptHeader);
        LOGGER.debug((Object)("Created voucher for receipt : " + receiptHeader.getReceiptnumber()));
        return voucherheader;
    }

    public void startWorkflow(ReceiptHeader receiptHeader) {
        Boolean createVoucherForBillingService = this.collectionsUtil.checkVoucherCreation(receiptHeader);
        Position position = this.collectionsUtil.isEmployee(receiptHeader.getCreatedBy()) == false ? this.collectionsUtil.getPositionByDeptDesgAndBoundary(receiptHeader.getReceiptMisc().getBoundary()) : this.collectionsUtil.getPositionOfUser(receiptHeader.getCreatedBy());
        if (receiptHeader.getState() == null && !createVoucherForBillingService.booleanValue()) {
            receiptHeader.transition().start().withSenderName(receiptHeader.getCreatedBy().getUsername() + "::" + receiptHeader.getCreatedBy().getName()).withComments("Receipt Created").withStateValue("Receipt Created").withOwner(position).withDateInfo(new Date()).withNextAction("Submit for Approval");
        } else if (createVoucherForBillingService.booleanValue()) {
            this.createVoucherForReceipt(receiptHeader);
            receiptHeader.transition().start().withSenderName(receiptHeader.getCreatedBy().getUsername() + "::" + receiptHeader.getCreatedBy().getName()).withComments("Receipt voucher created").withStateValue("Create Receipt Voucher").withOwner(position).withDateInfo(new Date()).withNextAction("Submit for Approval");
        }
        if (receiptHeader.getReceiptMisc().getDepositedInBank() != null) {
            receiptHeader.transition().progressWithStateCopy().withSenderName(receiptHeader.getCreatedBy().getUsername() + "::" + receiptHeader.getCreatedBy().getName()).withComments("Receipts Submitted for Approval").withStateValue("Create Receipt Voucher").withOwner(position).withDateInfo(new Date()).withNextAction("Submit for Approval");
        }
        LOGGER.debug((Object)"Workflow state transition complete");
    }

    public int checkIfMapObjectExist(List<HashMap<String, Object>> paramList, Object[] arrayObjectInitialIndexTemp) {
        int check = -1;
        for (int m = 0; m < paramList.size(); ++m) {
            HashMap<String, Object> objHashMapTemp = paramList.get(m);
            if (arrayObjectInitialIndexTemp[1] == null || arrayObjectInitialIndexTemp[2] == null || !arrayObjectInitialIndexTemp[1].equals(objHashMapTemp.get("RECEIPTDATE")) || !arrayObjectInitialIndexTemp[2].equals(objHashMapTemp.get("SERVICENAME")) || !arrayObjectInitialIndexTemp[6].equals(objHashMapTemp.get("FUNDCODE")) || !arrayObjectInitialIndexTemp[7].equals(objHashMapTemp.get("DEPARTMENTCODE"))) continue;
            check = m;
            break;
        }
        return check;
    }

    @Transactional
    public void updateChequeCardRemittance(Map<String, Object> instrumentDepositeMap, String voucherWorkflowMsg, Boolean voucherTypeForChequeDDCard, Date voucherDate, Bankaccount depositedBankAccount, String serviceGlCode, List<InstrumentHeader> instrumentHeaderListCheque, CVoucherHeader voucherHeaderCheque) {
        EgwStatus instrumentStatusDeposited = this.collectionsUtil.getStatusForModuleAndCode("Instrument", "Deposited");
        int counter = 1;
        for (InstrumentHeader instrumentHeader : instrumentHeaderListCheque) {
            instrumentHeader = this.financialsUtil.updateInstrumentHeaderStatus(instrumentHeader, instrumentStatusDeposited, depositedBankAccount);
            if (voucherHeaderCheque.getId() != null && serviceGlCode != null) {
                Map<String, Object> chequeMap = this.constructInstrumentMap(instrumentDepositeMap, depositedBankAccount, instrumentHeader, voucherHeaderCheque, voucherDate);
                if (voucherTypeForChequeDDCard.booleanValue()) {
                    this.financialsUtil.updateCheque_DD_Card_Deposit_Receipt(chequeMap);
                } else {
                    this.financialsUtil.updateCheque_DD_Card_Deposit(chequeMap);
                }
            }
            if (counter % 20 == 0) {
                this.getSession().flush();
                this.getSession().clear();
            }
            ++counter;
        }
    }

    @Transactional
    public void updateCashRemittance(Map<String, Object> instrumentDepositeMap, String voucherWorkflowMsg, Date voucherDate, Bankaccount depositedBankAccount, String serviceGlCode, List<InstrumentHeader> instrumentHeaderListCash, CVoucherHeader voucherHeaderCash) {
        int counter = 1;
        for (InstrumentHeader instrumentHeader : instrumentHeaderListCash) {
            if (voucherHeaderCash.getId() != null && serviceGlCode != null) {
                Map<String, Object> cashMap = this.constructInstrumentMap(instrumentDepositeMap, depositedBankAccount, instrumentHeader, voucherHeaderCash, voucherDate);
                this.financialsUtil.updateCashDeposit(cashMap);
            }
            if (counter % 20 == 0) {
                this.getSession().flush();
                this.getSession().clear();
            }
            ++counter;
        }
    }

    public Set<ReceiptDetail> aggregateDuplicateReceiptDetailObject(List<ReceiptDetail> receiptDetailSetParam) {
        ArrayList<ReceiptDetail> newReceiptDetailList = new ArrayList<ReceiptDetail>(0);
        int counter = 0;
        for (ReceiptDetail receiptDetailObj : receiptDetailSetParam) {
            if (counter == 0) {
                newReceiptDetailList.add(receiptDetailObj);
            } else {
                int checknew = this.checkIfReceiptDetailObjectExist(newReceiptDetailList, receiptDetailObj);
                if (checknew == -1) {
                    newReceiptDetailList.add(receiptDetailObj);
                } else {
                    ReceiptDetail receiptDetail = new ReceiptDetail();
                    ReceiptDetail newReceiptDetailObj = (ReceiptDetail)newReceiptDetailList.get(checknew);
                    newReceiptDetailList.remove(checknew);
                    receiptDetail.setAccounthead(newReceiptDetailObj.getAccounthead());
                    receiptDetail.setAccountPayeeDetails(newReceiptDetailObj.getAccountPayeeDetails());
                    receiptDetail.setCramount(newReceiptDetailObj.getCramount().add(receiptDetailObj.getCramount()));
                    receiptDetail.setCramountToBePaid(newReceiptDetailObj.getCramountToBePaid());
                    receiptDetail.setDescription(newReceiptDetailObj.getDescription());
                    receiptDetail.setDramount(newReceiptDetailObj.getDramount().add(receiptDetailObj.getDramount()));
                    receiptDetail.setFinancialYear(newReceiptDetailObj.getFinancialYear());
                    receiptDetail.setFunction(newReceiptDetailObj.getFunction());
                    receiptDetail.setOrdernumber(newReceiptDetailObj.getOrdernumber());
                    newReceiptDetailList.add(receiptDetail);
                }
            }
            ++counter;
        }
        return new HashSet<ReceiptDetail>(newReceiptDetailList);
    }

    public int checkIfReceiptDetailObjectExist(List<ReceiptDetail> newReceiptDetailSet, ReceiptDetail receiptDetailObj) {
        int check = -1;
        for (int m = 0; m < newReceiptDetailSet.size(); ++m) {
            ReceiptDetail receiptDetail = newReceiptDetailSet.get(m);
            if (!receiptDetailObj.getAccounthead().getId().equals(receiptDetail.getAccounthead().getId())) continue;
            check = m;
            break;
        }
        return check;
    }

    public void endReceiptWorkFlowOnCancellation(ReceiptHeader receiptHeaderToBeCancelled) {
        Position position = this.collectionsUtil.isEmployee(receiptHeaderToBeCancelled.getCreatedBy()) == false ? this.collectionsUtil.getPositionByDeptDesgAndBoundary(receiptHeaderToBeCancelled.getReceiptMisc().getBoundary()) : this.collectionsUtil.getPositionOfUser(receiptHeaderToBeCancelled.getCreatedBy());
        if (position != null) {
            receiptHeaderToBeCancelled.transition().end().withSenderName(receiptHeaderToBeCancelled.getCreatedBy().getUsername() + "::" + receiptHeaderToBeCancelled.getCreatedBy().getName()).withComments("Receipt Cancelled - Workflow ends").withStateValue("END").withOwner(position).withDateInfo(new Date());
        }
    }

    @Transactional
    public ReceiptHeader persist(ReceiptHeader receiptHeader) throws ApplicationRuntimeException {
        if (receiptHeader.getReceipttype() != 'C' && !"PENDING".equals(receiptHeader.getStatus().getCode()) && !"FAILED".equals(receiptHeader.getStatus().getCode()) && receiptHeader.getReceiptnumber() == null) {
            this.setReceiptNumber(receiptHeader);
        }
        if (receiptHeader.getChallan() != null) {
            Challan challan = receiptHeader.getChallan();
            if (challan.getChallanNumber() == null) {
                this.setChallanNumber(challan);
            }
            receiptHeader.setChallan(challan);
            LOGGER.info((Object)("Persisted challan with challan number " + challan.getChallanNumber()));
        }
        if ("CANCELLED".equals(receiptHeader.getStatus().getCode())) {
            if (receiptHeader.getState() != null && !receiptHeader.getState().getValue().equals("END")) {
                this.endReceiptWorkFlowOnCancellation(receiptHeader);
            }
            if (receiptHeader.getReceipttype() == 'B') {
                this.updateBillingSystemWithReceiptInfo(receiptHeader, null, null);
            }
        }
        return (ReceiptHeader)((Object)super.persist((Object)receiptHeader));
    }

    @Transactional
    public ReceiptHeader persistChallan(ReceiptHeader receiptHeader, Position position, String actionName, String approvalRemarks) {
        Integer validUpto = Integer.valueOf(this.collectionsUtil.getAppConfigValue("Collection", "CHALLANVALIDUPTO"));
        Challan challan = receiptHeader.getChallan();
        DateTime date = new DateTime((Object)challan.getChallanDate());
        date = date.plusDays(validUpto.intValue());
        challan.setValidUpto(date.toDate());
        if (challan.getChallanNumber() == null) {
            this.setChallanNumber(challan);
        }
        challan.setReceiptHeader(receiptHeader);
        receiptHeader.setChallan(challan);
        super.persist((Object)receiptHeader);
        LOGGER.info((Object)("Persisting challan with challan number " + challan.getChallanNumber()));
        this.challanService.workflowtransition(receiptHeader.getChallan(), position, actionName, approvalRemarks);
        return receiptHeader;
    }

    @Transactional
    public ReceiptHeader persistReceiptObject(ReceiptHeader receiptHeader) {
        return (ReceiptHeader)((Object)super.persist((Object)receiptHeader));
    }

    public void setReceiptNumber(ReceiptHeader entity) {
        entity.setReceiptnumber(this.collectionsNumberGenerator.generateReceiptNumber(entity));
    }

    private void setChallanNumber(Challan challan) {
        CFinancialYear financialYear = this.collectionsUtil.getFinancialYearforDate(new Date());
        challan.setChallanNumber(this.collectionsNumberGenerator.generateChallanNumber(challan, financialYear));
    }

    public void setCollectionsNumberGenerator(CollectionsNumberGenerator collectionsNumberGenerator) {
        this.collectionsNumberGenerator = collectionsNumberGenerator;
    }

    private BillingIntegrationService getBillingServiceBean(String serviceCode) {
        return (BillingIntegrationService)this.collectionsUtil.getBean(serviceCode + "CollectionsInterface");
    }

    @Transactional
    public Boolean updateBillingSystem(ServiceDetails serviceDetails, Set<BillReceiptInfo> billReceipts, BillingIntegrationService billingService) {
        if (!serviceDetails.getServiceType().equals("B")) {
            return true;
        }
        if (billingService == null && serviceDetails.getServiceType().equals("B")) {
            billingService = this.getBillingServiceBean(serviceDetails.getCode());
        }
        if (billingService == null && serviceDetails.getServiceType().equals("B")) {
            return false;
        }
        try {
            billingService.updateReceiptDetails(billReceipts);
            return true;
        }
        catch (Exception e) {
            String errMsg = "Exception while updating billing system [" + serviceDetails.getCode() + "] with receipt details!";
            LOGGER.error((Object)errMsg, (Throwable)e);
            throw new ApplicationRuntimeException(errMsg, (Throwable)e);
        }
    }

    public String getAdditionalInfoForReceipt(String serviceCode, BillReceiptInfo billReceipt) {
        BillingIntegrationService billingService = this.getBillingServiceBean(serviceCode);
        if (billingService == null) {
            throw new ApplicationRuntimeException("Unable to load bean for billing system: " + serviceCode);
        }
        try {
            return billingService.constructAdditionalInfoForReceipt(billReceipt);
        }
        catch (Exception e) {
            String errMsg = "Exception while constructing additional info for receipt [" + serviceCode + "]!";
            LOGGER.error((Object)errMsg, (Throwable)e);
            throw new ApplicationRuntimeException(errMsg, (Throwable)e);
        }
    }

    public void createReversalVoucher(ReceiptVoucher receiptVoucher) {
        ArrayList<HashMap<String, Object>> reversalVoucherInfoList = new ArrayList<HashMap<String, Object>>(0);
        HashMap<String, Object> reversalVoucherInfo = new HashMap<String, Object>(0);
        if (receiptVoucher.getVoucherheader() != null) {
            reversalVoucherInfo.put("Original voucher header id", receiptVoucher.getVoucherheader().getId());
            reversalVoucherInfo.put("Reversal voucher date", new Date());
            if (receiptVoucher.getVoucherheader().getType().equals("Journal Voucher")) {
                reversalVoucherInfo.put("Reversal voucher type", "Journal Voucher");
                reversalVoucherInfo.put("Reversal voucher name", "JVGeneral");
            } else if (receiptVoucher.getVoucherheader().getType().equals("Receipt")) {
                reversalVoucherInfo.put("Reversal voucher type", "Payment");
                reversalVoucherInfo.put("Reversal voucher name", "Direct Bank Payment");
            }
        }
        reversalVoucherInfoList.add(reversalVoucherInfo);
        try {
            this.financialsUtil.getReversalVoucher(reversalVoucherInfoList);
        }
        catch (Exception exp) {
            String errorMsg = "Receipt Service Exception while creating reversal voucher!";
            LOGGER.error((Object)"Receipt Service Exception while creating reversal voucher!", (Throwable)exp);
            throw new ApplicationRuntimeException("Receipt Service Exception while creating reversal voucher!", (Throwable)exp);
        }
    }

    public void updateInstrument(ReceiptHeader receiptHeader) {
        CVoucherHeader voucherHeader;
        ArrayList<Map<String, Object>> instrumentVoucherList = new ArrayList<Map<String, Object>>(0);
        if (receiptHeader.getReceiptVoucher() != null && !receiptHeader.getReceiptVoucher().isEmpty() && (voucherHeader = receiptHeader.getReceiptVoucher().iterator().next().getVoucherheader()) != null && receiptHeader.getReceiptInstrument() != null) {
            for (InstrumentHeader instrumentHeader : receiptHeader.getReceiptInstrument()) {
                HashMap<String, Object> iVoucherMap = new HashMap<String, Object>(0);
                iVoucherMap.put("Instrument header", instrumentHeader);
                iVoucherMap.put("Voucher header", voucherHeader);
                instrumentVoucherList.add(iVoucherMap);
            }
            this.financialsUtil.updateInstrumentVoucher(instrumentVoucherList);
        }
    }

    public List<InstrumentHeader> createInstrument(List<InstrumentHeader> instrumentHeaderList) {
        ArrayList<Map<String, Object>> instrumentHeaderMapList = new ArrayList<Map<String, Object>>(0);
        if (instrumentHeaderList != null) {
            for (InstrumentHeader instrumentHeader : instrumentHeaderList) {
                HashMap<String, Object> instrumentHeaderMap = new HashMap<String, Object>(0);
                instrumentHeaderMap.put("Instrument number", instrumentHeader.getInstrumentNumber());
                instrumentHeaderMap.put("Instrument date", instrumentHeader.getInstrumentDate());
                instrumentHeaderMap.put("Instrument amount", instrumentHeader.getInstrumentAmount());
                instrumentHeaderMap.put("Instrument type", instrumentHeader.getInstrumentType().getType());
                instrumentHeaderMap.put("Is pay cheque", instrumentHeader.getIsPayCheque());
                if (instrumentHeader.getBankId() != null) {
                    instrumentHeaderMap.put("Bank code", instrumentHeader.getBankId().getCode());
                }
                instrumentHeaderMap.put("Bank branch name", instrumentHeader.getBankBranchName());
                instrumentHeaderMap.put("Transaction number", instrumentHeader.getTransactionNumber());
                instrumentHeaderMap.put("Transaction date", instrumentHeader.getTransactionDate());
                if (instrumentHeader.getBankAccountId() != null) {
                    instrumentHeaderMap.put("Bank account id", instrumentHeader.getBankAccountId().getId());
                }
                instrumentHeaderMapList.add(instrumentHeaderMap);
            }
        }
        return this.financialsUtil.createInstrument(instrumentHeaderMapList);
    }

    private Map<String, Object> constructInstrumentMap(Map<String, Object> instrumentDepositeMap, Bankaccount bankaccount, InstrumentHeader instrumentHeader, CVoucherHeader voucherHeader, Date voucherDate) {
        InstrumentType instrumentType = (InstrumentType)this.persistenceService.find("select it from InstrumentType it,InstrumentHeader ih where ih.instrumentType=it.id and ih.id=?", new Object[]{instrumentHeader.getId()});
        instrumentDepositeMap.put("instrumentheader", instrumentHeader.getId());
        instrumentDepositeMap.put("bankaccountid", bankaccount.getId());
        instrumentDepositeMap.put("instrumentamount", instrumentHeader.getInstrumentAmount());
        instrumentDepositeMap.put("instrumenttype", instrumentType.getType());
        instrumentDepositeMap.put("depositdate", voucherDate);
        instrumentDepositeMap.put("createdby", voucherHeader.getCreatedBy().getId());
        instrumentDepositeMap.put("ispaycheque", instrumentHeader.getIsPayCheque());
        instrumentDepositeMap.put("payinid", voucherHeader.getId());
        return instrumentDepositeMap;
    }

    @Transactional
    public void performWorkflow(String actionName, ReceiptHeader receiptHeader, String remarks) {
        try {
            Employee employee = this.employeeService.getEmployeeById(receiptHeader.getCreatedBy().getId());
            Department department = this.departmentService.getDepartmentByName(this.collectionsUtil.getAppConfigValue("Collection", "COLLECTIONDEPARTMENTFORWORKFLOWAPPROVER"));
            Designation designation = this.collectionsUtil.getDesignationForApprover();
            Boolean isEmployee = this.collectionsUtil.isEmployee(receiptHeader.getCreatedBy());
            if (!isEmployee.booleanValue()) {
                employee = this.employeeService.getEmployeeById(this.collectionsUtil.getLoggedInUser().getId());
            }
            Boundary boundary = null;
            for (Jurisdiction jur : employee.getJurisdictions()) {
                boundary = jur.getBoundary();
            }
            List emp = this.employeeService.findByDepartmentDesignationAndBoundary(department.getId(), designation.getId(), boundary.getId());
            if (emp.isEmpty() && boundary.getParent() != null && (emp = this.employeeService.findByDepartmentDesignationAndBoundary(department.getId(), designation.getId(), boundary.getParent().getId())).isEmpty() && boundary.getParent().getParent() != null) {
                emp = this.employeeService.findByDepartmentDesignationAndBoundary(department.getId(), designation.getId(), boundary.getParent().getParent().getId());
            }
            if (emp.isEmpty()) {
                throw new ValidationException(Arrays.asList(new ValidationError("Manager does not exists", "submitcollections.validation.error.manager.notexists")));
            }
            Position approverPosition = null;
            List assignments = this.assignmentService.getAllActiveEmployeeAssignmentsByEmpId(((Employee)emp.get(0)).getId());
            for (Assignment assign : assignments) {
                if (!assign.getDesignation().equals(designation)) continue;
                approverPosition = assign.getPosition();
            }
            if (actionName.equals("Submit for Approval")) {
                this.perform(receiptHeader, "Approve", "SUBMITTED", "Approve", approverPosition, remarks);
            } else if (actionName.equals("Approve")) {
                this.perform(receiptHeader, "Approved", "APPROVED", "", approverPosition, remarks);
            } else if (actionName.equals("Reject")) {
                Position operatorPosition = isEmployee == false ? this.collectionsUtil.getPositionByDeptDesgAndBoundary(receiptHeader.getReceiptMisc().getBoundary()) : this.collectionsUtil.getPositionOfUser(receiptHeader.getCreatedBy());
                this.perform(receiptHeader, "Rejected", "TO_BE_SUBMITTED", "Submit for Approval", operatorPosition, remarks);
            }
        }
        catch (Exception e) {
            String errorMsg = "Receipt Service Exception while workflow transition!";
            LOGGER.error((Object)"Receipt Service Exception while workflow transition!", (Throwable)e);
            throw new ApplicationRuntimeException(e.getMessage());
        }
    }

    @Transactional
    public void performWorkflowForAllReceipts(String actionName, List<ReceiptHeader> receiptHeaders, String remarks) {
        try {
            Position approverPosition = this.getApproverPosition(receiptHeaders.get(0));
            for (ReceiptHeader receiptHeader : receiptHeaders) {
                if (actionName.equals("Submit for Approval")) {
                    this.perform(receiptHeader, "Approve", "SUBMITTED", "Approve", approverPosition, remarks);
                    continue;
                }
                if (actionName.equals("Approve")) {
                    this.perform(receiptHeader, "Approved", "APPROVED", "", approverPosition, remarks);
                    continue;
                }
                if (!actionName.equals("Reject")) continue;
                Position operatorPosition = this.getOperatorPosition(receiptHeaders.get(0));
                this.perform(receiptHeader, "Rejected", "TO_BE_SUBMITTED", "Submit for Approval", operatorPosition, remarks);
            }
        }
        catch (ValidationException e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            LOGGER.error(errors, (Throwable)e);
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            String errorMsg = "Receipt Service Exception while workflow transition!";
            LOGGER.error((Object)"Receipt Service Exception while workflow transition!", (Throwable)e);
            throw new ApplicationRuntimeException(e.getMessage());
        }
    }

    public Position getApproverPosition(ReceiptHeader receiptHeader) {
        Boolean isEmployee = this.collectionsUtil.isEmployee(receiptHeader.getCreatedBy());
        Employee employee = isEmployee == false ? this.employeeService.getEmployeeById(this.collectionsUtil.getLoggedInUser().getId()) : this.employeeService.getEmployeeById(receiptHeader.getCreatedBy().getId());
        Department department = this.departmentService.getDepartmentByName(this.collectionsUtil.getAppConfigValue("Collection", "COLLECTIONDEPARTMENTFORWORKFLOWAPPROVER"));
        Designation designation = this.collectionsUtil.getDesignationForApprover();
        Boundary boundary = null;
        for (Jurisdiction jur : employee.getJurisdictions()) {
            boundary = jur.getBoundary();
        }
        List emp = this.employeeService.findByDepartmentDesignationAndBoundary(department.getId(), designation.getId(), boundary.getId());
        if (emp.isEmpty() && boundary.getParent() != null && (emp = this.employeeService.findByDepartmentDesignationAndBoundary(department.getId(), designation.getId(), boundary.getParent().getId())).isEmpty() && boundary.getParent().getParent() != null) {
            emp = this.employeeService.findByDepartmentDesignationAndBoundary(department.getId(), designation.getId(), boundary.getParent().getParent().getId());
        }
        if (emp.isEmpty()) {
            throw new ValidationException(Arrays.asList(new ValidationError("Manager does not exists", "submitcollections.validation.error.manager.notexists")));
        }
        Position approverPosition = null;
        List assignments = this.assignmentService.getAllActiveEmployeeAssignmentsByEmpId(((Employee)emp.get(0)).getId());
        for (Assignment assign : assignments) {
            if (!assign.getDesignation().equals(designation)) continue;
            approverPosition = assign.getPosition();
        }
        return approverPosition;
    }

    public Position getOperatorPosition(ReceiptHeader receiptHeader) {
        Boolean isEmployee = this.collectionsUtil.isEmployee(receiptHeader.getCreatedBy());
        Position operatorPosition = isEmployee == false ? this.collectionsUtil.getPositionByDeptDesgAndBoundary(receiptHeader.getReceiptMisc().getBoundary()) : this.collectionsUtil.getPositionOfUser(receiptHeader.getCreatedBy());
        return operatorPosition;
    }

    @Transactional
    public void perform(ReceiptHeader receiptHeader, String wfState, String newStatusCode, String nextAction, Position ownerPosition, String remarks) {
        receiptHeader.setStatus(this.collectionsUtil.getReceiptStatusForCode(newStatusCode));
        if (receiptHeader.getStatus().getCode().equals("APPROVED")) {
            receiptHeader.transition().end().withSenderName(receiptHeader.getCreatedBy().getUsername() + "::" + receiptHeader.getCreatedBy().getName()).withComments("Receipt Approved - Workflow ends").withStateValue("END").withOwner(ownerPosition).withDateInfo(new Date());
        } else {
            receiptHeader.transition().progress().withSenderName(receiptHeader.getCreatedBy().getUsername() + "::" + receiptHeader.getCreatedBy().getName()).withComments(remarks).withStateValue(wfState).withOwner(ownerPosition).withDateInfo(new Date()).withNextAction(nextAction);
        }
        super.persist((Object)receiptHeader);
        this.updateCollectionIndexAndPushMail(receiptHeader);
    }

    public Set<InstrumentHeader> createOnlineInstrument(Date transactionDate, String transactionId, BigDecimal transactionAmt) {
        InstrumentHeader onlineInstrumentHeader = new InstrumentHeader();
        onlineInstrumentHeader.setInstrumentType(this.financialsUtil.getInstrumentTypeByType("online"));
        onlineInstrumentHeader.setTransactionDate(transactionDate);
        onlineInstrumentHeader.setIsPayCheque("0");
        onlineInstrumentHeader.setTransactionNumber(transactionId);
        onlineInstrumentHeader.setInstrumentAmount(transactionAmt);
        ArrayList<InstrumentHeader> instHeaderList = new ArrayList<InstrumentHeader>();
        instHeaderList.add(onlineInstrumentHeader);
        HashSet<InstrumentHeader> instrumentHeaderSet = new HashSet<InstrumentHeader>(this.createInstrument(instHeaderList));
        return instrumentHeaderSet;
    }

    public String getReceiptHeaderforDishonor(Long mode, Long bankAccId, Long bankId, String chequeDDNo, String chqueDDDate) {
        StringBuilder sb = new StringBuilder();
        sb.append("FROM egcl_collectionheader rpt,egcl_collectioninstrument ci,egf_instrumentheader ih,egw_status status,bank b,bankbranch bb,bankaccount ba WHERE rpt.id = ci.collectionheader AND ci.instrumentheader = ih.id AND status.id = ih.id_status AND b.id = bb.bankid AND bb.id = ba.branchid AND ba.id = ih.bankaccountid AND ih.instrumenttype = '" + mode + "' AND ((ih.ispaycheque ='0' AND status.moduletype ='" + "Instrument" + "'" + "AND status.description = '" + "Deposited" + "'))");
        if (bankAccId != null && bankAccId != -1L) {
            sb.append(" AND ih.bankaccountid=" + bankAccId + "");
        }
        if ((bankAccId == null || bankAccId == -1L) && bankId != null && bankId != 0L) {
            sb.append(" AND ih.bankid=" + bankId + "");
        }
        if (!"".equals(chequeDDNo) && chequeDDNo != null) {
            sb.append(" AND ih.instrumentnumber=trim('" + chequeDDNo + "') ");
        }
        if (!"".equals(chqueDDDate) && chqueDDDate != null) {
            sb.append(" AND ih.instrumentdate = '" + chqueDDDate + "' ");
        }
        return sb.toString();
    }

    @Transactional
    public void populateAndPersistReceipts(ReceiptHeader receiptHeader, List<InstrumentHeader> receiptInstrList) {
        try {
            this.persist(receiptHeader);
            LOGGER.info((Object)"Persisted receipts");
            this.startWorkflow(receiptHeader);
            LOGGER.info((Object)"Workflow started for newly created receipts");
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            Date cutOffDate = this.getDataEntryCutOffDate(sdf);
            if (!receiptHeader.getService().getServiceType().equalsIgnoreCase("B")) {
                if (cutOffDate != null && receiptHeader.getReceiptdate().before(cutOffDate)) {
                    this.performWorkflow("Approve", receiptHeader, "Legacy data Receipt Approval based on cutoff date");
                } else {
                    this.updateCollectionIndexAndPushMail(receiptHeader);
                }
            }
            if (receiptHeader.getService().getServiceType().equalsIgnoreCase("B")) {
                this.updateBillingSystemWithReceiptInfo(receiptHeader, null, null);
                LOGGER.info((Object)"Updated billing system ");
            }
        }
        catch (HibernateException e) {
            LOGGER.error((Object)"Receipt Service HException while persisting ReceiptHeader", (Throwable)e);
            throw new ApplicationRuntimeException("Receipt Service Exception while persisting ReceiptHeader : ", (Throwable)e);
        }
        catch (ApplicationRuntimeException e) {
            LOGGER.error((Object)"Receipt Service AException while persisting ReceiptHeader!", (Throwable)e);
            throw new ApplicationRuntimeException("Receipt Service Exception while persisting ReceiptHeader : ", (Throwable)e);
        }
    }

    public Date getDataEntryCutOffDate(SimpleDateFormat sdf) {
        Date cutOffDate = null;
        try {
            cutOffDate = sdf.parse(this.collectionsUtil.getAppConfigValue("Collection", "COLLECTIONDATAENTRYCUTOFFDATE"));
        }
        catch (ParseException e) {
            LOGGER.error((Object)("Error parsing Cut Off Date" + e.getMessage()));
        }
        return cutOffDate;
    }

    @Transactional
    public void updateBillingSystemWithReceiptInfo(ReceiptHeader receiptHeader, BillingIntegrationService billingService, InstrumentHeader bouncedInstrumentInfo) {
        LOGGER.info((Object)("$$$$$$ Update Billing system for Service Code :" + receiptHeader.getService().getCode() + (receiptHeader.getConsumerCode() != null ? " and consumer code: " + receiptHeader.getConsumerCode() : "")));
        HashSet<BillReceiptInfo> billReceipts = new HashSet<BillReceiptInfo>(0);
        billReceipts.add(new BillReceiptInfoImpl(receiptHeader, this.chartOfAccountsHibernateDAO, this.persistenceService, bouncedInstrumentInfo));
        if (this.updateBillingSystem(receiptHeader.getService(), billReceipts, billingService).booleanValue()) {
            receiptHeader.setIsReconciled(true);
            super.persist((Object)receiptHeader);
            this.updateCollectionIndexAndPushMail(receiptHeader);
        }
        LOGGER.info((Object)("$$$$$$ Billing system updated for Service Code :" + receiptHeader.getService().getCode() + (receiptHeader.getConsumerCode() != null ? " and consumer code: " + receiptHeader.getConsumerCode() : "")));
    }

    @Transactional
    public void updateCollectionIndexAndPushMail(ReceiptHeader receiptHeader) {
        CollectionIndex collectionIndexObj;
        if (receiptHeader.getPayeeEmail() != null && !receiptHeader.getPayeeEmail().isEmpty() && (receiptHeader.getCollectiontype().equals(Character.valueOf('O')) && receiptHeader.getStatus().getCode().equals("APPROVED") || !receiptHeader.getCollectiontype().equals(Character.valueOf('O')) && receiptHeader.getStatus().getCode().equals("TO_BE_SUBMITTED"))) {
            this.pushMail(receiptHeader);
        }
        if ((collectionIndexObj = this.collectionIndexUtils.findByReceiptNumber(receiptHeader.getReceiptnumber())) != null) {
            collectionIndexObj.setStatus(receiptHeader.getStatus().getDescription());
            this.collectionIndexService.persistCollectionIndex(collectionIndexObj);
        } else {
            collectionIndexObj = this.collectionsUtil.constructCollectionIndex(receiptHeader);
            this.collectionIndexService.pushCollectionIndex(collectionIndexObj);
        }
    }

    private void pushMail(ReceiptHeader receiptHeader) {
        this.collectionsUtil.emailReceiptAsAttachment(receiptHeader, this.collectionsUtil.createReport(this.getReportRequest(receiptHeader)).getReportOutputData());
    }

    public ReportRequest getReportRequest(ReceiptHeader receiptHeader) {
        ArrayList<BillReceiptInfoImpl> receiptList = new ArrayList<BillReceiptInfoImpl>(0);
        HashMap<String, CollectionsUtil> reportParams = new HashMap<String, CollectionsUtil>(0);
        String serviceCode = receiptHeader.getService().getCode();
        reportParams.put("EGOV_COLLECTIONS_UTIL", this.collectionsUtil);
        String templateName = this.collectionsUtil.getReceiptTemplateName(receiptHeader.getReceipttype(), serviceCode);
        if (receiptHeader.getReceipttype() == 'B') {
            String additionalMessage = this.getAdditionalInfoForReceipt(serviceCode, new BillReceiptInfoImpl(receiptHeader, this.chartOfAccountsHibernateDAO, this.persistenceService, null));
            if (additionalMessage != null) {
                receiptList.add(new BillReceiptInfoImpl(receiptHeader, additionalMessage, this.chartOfAccountsHibernateDAO, this.persistenceService));
            } else {
                receiptList.add(new BillReceiptInfoImpl(receiptHeader, this.chartOfAccountsHibernateDAO, this.persistenceService, null));
            }
        }
        ReportRequest reportInput = new ReportRequest(templateName, receiptList, reportParams);
        reportInput.setReportFormat(ReportConstants.FileFormat.PDF);
        reportInput.setPrintDialogOnOpenReport(false);
        return reportInput;
    }

    @Transactional
    public ReceiptHeader createOnlineSuccessPayment(ReceiptHeader receiptHeader, Date transactionDate, String transactionId, BigDecimal transactionAmt, String authStatusCode, String remarks, BillingIntegrationService billingService) {
        receiptHeader.setStatus(this.collectionsUtil.getReceiptStatusForCode("APPROVED"));
        receiptHeader.setReceiptInstrument(this.createOnlineInstrument(transactionDate, transactionId, transactionAmt));
        receiptHeader.setIsReconciled(Boolean.FALSE);
        receiptHeader.getOnlinePayment().setAuthorisationStatusCode(authStatusCode);
        receiptHeader.getOnlinePayment().setTransactionNumber(transactionId);
        receiptHeader.getOnlinePayment().setTransactionAmount(transactionAmt);
        receiptHeader.getOnlinePayment().setTransactionDate(transactionDate);
        receiptHeader.getOnlinePayment().setRemarks(remarks);
        receiptHeader.getOnlinePayment().setStatus(this.collectionsUtil.getStatusForModuleAndCode("OnlinePayment", "ONLINE_STATUS_SUCCESS"));
        this.persist(receiptHeader);
        LOGGER.debug((Object)"Persisted receipt after receiving success message from the payment gateway");
        return this.updateFinancialAndBillingSystem(receiptHeader, billingService);
    }

    @Transactional
    public ReceiptHeader updateFinancialAndBillingSystem(ReceiptHeader receiptHeader, BillingIntegrationService billingService) {
        try {
            Boolean createVoucherForBillingService = this.collectionsUtil.checkVoucherCreation(receiptHeader);
            if (createVoucherForBillingService.booleanValue()) {
                this.createVoucherForReceipt(receiptHeader);
                LOGGER.debug((Object)"Updated financial systems and created voucher.");
            }
        }
        catch (ApplicationRuntimeException ex) {
            LOGGER.error((Object)"Receipt Service Exception while updateFinancialAndBillingSystem", (Throwable)ex);
            throw new ApplicationRuntimeException("Failed to create voucher in Financials");
        }
        this.updateBillingSystemWithReceiptInfo(receiptHeader, billingService, null);
        return receiptHeader;
    }

    @Transactional
    public void persistFieldReceipt(ReceiptHeader receiptHeader, List<InstrumentHeader> instrumentHeaderList) {
        HashSet<InstrumentHeader> instHeaderSet = new HashSet<InstrumentHeader>(this.createInstrument(instrumentHeaderList));
        receiptHeader.setReceiptInstrument(instHeaderSet);
        this.persist(receiptHeader);
        LOGGER.info((Object)("Receipt Created with receipt number: " + receiptHeader.getReceiptnumber()));
        this.updateFinancialAndBillingSystem(receiptHeader, null);
        LOGGER.info((Object)"Billing system updated with receipt info");
    }

    @Transactional
    public void updateDishonoredInstrumentStatus(ReceiptHeader receiptHeader, InstrumentHeader bounceInstrumentInfo, EgwStatus receiptStatus, boolean isReconciled) {
        this.financialsUtil.updateInstrumentHeader(bounceInstrumentInfo);
        this.updateReceiptHeaderStatus(receiptHeader, receiptStatus, false);
        LOGGER.debug((Object)("Updated receipt status to " + receiptStatus.getCode() + " set reconcilation to false"));
        this.updateBillingSystemWithReceiptInfo(receiptHeader, null, bounceInstrumentInfo);
    }

    @Transactional
    public void updateReceiptHeaderStatus(ReceiptHeader receiptHeader, EgwStatus status, boolean isReconciled) {
        if (status != null) {
            receiptHeader.setStatus(status);
        }
        receiptHeader.setIsReconciled(isReconciled);
        this.update((Object)receiptHeader);
    }

    @Transactional
    public ReceiptHeader reconcileOnlineSuccessPayment(ReceiptHeader onlinePaymentReceiptHeader, Date txnDate, String txnRefNo, BigDecimal txnAmount, String txnAuthStatus, List<ReceiptDetail> reconstructedList, ReceiptDetail debitAccountDetail) {
        BillingIntegrationService billingService = (BillingIntegrationService)this.collectionsUtil.getBean(onlinePaymentReceiptHeader.getService().getCode() + "CollectionsInterface");
        if (reconstructedList != null) {
            onlinePaymentReceiptHeader.getReceiptDetails().clear();
            this.persistReceiptObject(onlinePaymentReceiptHeader);
            LOGGER.debug((Object)("Reconstructed receiptDetailList : " + reconstructedList.toString()));
            for (ReceiptDetail receiptDetail : reconstructedList) {
                receiptDetail.setReceiptHeader(onlinePaymentReceiptHeader);
                onlinePaymentReceiptHeader.addReceiptDetail(receiptDetail);
            }
            onlinePaymentReceiptHeader.addReceiptDetail(debitAccountDetail);
        }
        return this.createOnlineSuccessPayment(onlinePaymentReceiptHeader, txnDate, txnRefNo, txnAmount, txnAuthStatus, null, billingService);
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    public void setFinancialsUtil(FinancialsUtil financialsUtil) {
        this.financialsUtil = financialsUtil;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setChallanService(ChallanService challanService) {
        this.challanService = challanService;
    }
}

