/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.utils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.collection.entity.AccountPayeeDetail;
import org.egov.collection.entity.BranchUserMap;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.entity.ReceiptDetailInfo;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.entity.ReceiptMisc;
import org.egov.collection.entity.ReceiptVoucher;
import org.egov.collection.integration.models.BillAccountDetails;
import org.egov.collection.integration.models.BillDetails;
import org.egov.collection.integration.models.BillInfo;
import org.egov.collection.integration.models.BillPayeeDetails;
import org.egov.collection.integration.models.BillReceiptInfoImpl;
import org.egov.collection.integration.models.PaymentInfoBank;
import org.egov.collection.integration.models.PaymentInfoCash;
import org.egov.collection.integration.models.PaymentInfoChequeDD;
import org.egov.collection.integration.pgi.PaymentGatewayAdaptor;
import org.egov.collection.integration.pgi.PaymentRequest;
import org.egov.collection.integration.pgi.PaymentResponse;
import org.egov.collection.integration.services.BillingIntegrationService;
import org.egov.collection.service.ReceiptHeaderService;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.collection.utils.FinancialsUtil;
import org.egov.commons.Bank;
import org.egov.commons.Bankaccount;
import org.egov.commons.Bankbranch;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.Fundsource;
import org.egov.commons.dao.BankHibernateDAO;
import org.egov.commons.dao.BankaccountHibernateDAO;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.dao.FunctionHibernateDAO;
import org.egov.commons.dao.FundSourceHibernateDAO;
import org.egov.commons.utils.EntityType;
import org.egov.egf.commons.EgovCommon;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.reporting.engine.ReportFormat;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.egov.infra.utils.MoneyUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.models.ServiceDetails;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.instrument.InstrumentHeader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class CollectionCommon {
    private static final Logger LOGGER = Logger.getLogger(CollectionCommon.class);
    protected PersistenceService persistenceService;
    private ReceiptHeaderService receiptHeaderService;
    @Autowired
    private BoundaryService boundaryService;
    private EgovCommon egovCommon;
    private CollectionsUtil collectionsUtil;
    private FinancialsUtil financialsUtil;
    @Autowired
    private FundSourceHibernateDAO fundSourceDAO;
    @Autowired
    private FunctionHibernateDAO functionDAO;
    @Autowired
    private BankHibernateDAO bankDAO;
    @Autowired
    private BankaccountHibernateDAO bankAccountDAO;
    @Autowired
    private EgwStatusHibernateDAO statusDAO;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    @Autowired
    private ReportViewerUtil reportViewerUtil;
    @Autowired
    @Qualifier(value="branchUserMapService")
    private PersistenceService<BranchUserMap, Long> branchUserMapService;

    public void setReceiptHeaderService(ReceiptHeaderService receiptHeaderService) {
        this.receiptHeaderService = receiptHeaderService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    public void setFinancialsUtil(FinancialsUtil financialsUtil) {
        this.financialsUtil = financialsUtil;
    }

    public ReceiptHeader initialiseReceiptModelWithBillInfo(BillInfo collDetails, Fund fund, Department dept) throws ValidationException {
        ReceiptHeader receiptHeader = null;
        StringBuilder collModesNotAllowed = new StringBuilder();
        if (collDetails.getCollectionModesNotAllowed() != null) {
            for (String collModeNotAllwd : collDetails.getCollectionModesNotAllowed()) {
                if (collModesNotAllowed.length() > 0) {
                    collModesNotAllowed.append(',');
                }
                collModesNotAllowed.append(collModeNotAllwd);
            }
        }
        for (BillPayeeDetails billPayee : collDetails.getPayees()) {
            receiptHeader = new ReceiptHeader();
            for (BillDetails billDetail : billPayee.getBillDetails()) {
                BranchUserMap branchUserMap;
                ServiceDetails service = (ServiceDetails)this.persistenceService.findByNamedQuery("getServiceByCode", new Object[]{collDetails.getServiceCode()});
                if (service == null) {
                    throw new ValidationException(Arrays.asList(new ValidationError("billreceipt.improperbilldata.missingservice", "billreceipt.improperbilldata.missingservice")));
                }
                receiptHeader = new ReceiptHeader(billDetail.getRefNo(), billDetail.getBilldate(), billDetail.getConsumerCode(), billDetail.getDescription(), billDetail.getTotalAmount(), billDetail.getMinimumAmount(), collDetails.getPartPaymentAllowed(), collDetails.getOverrideAccountHeadsAllowed(), collDetails.getCallbackForApportioning(), collDetails.getDisplayMessage(), service, collModesNotAllowed.toString(), billPayee.getPayeeName(), billPayee.getPayeeAddress(), billPayee.getPayeeEmail(), billDetail.getConsumerType());
                if (collDetails.getTransactionReferenceNumber() != null) {
                    receiptHeader.setManualreceiptnumber(collDetails.getTransactionReferenceNumber());
                    receiptHeader.setManualreceiptdate(new Date());
                }
                Boundary boundary = this.boundaryService.getActiveBoundaryByBndryNumAndTypeAndHierarchyTypeCode(Long.valueOf(billDetail.getBoundaryNum()), billDetail.getBoundaryType(), "ADMIN");
                Functionary functionary = (Functionary)this.persistenceService.findByNamedQuery("getFunctionaryByCode", new Object[]{collDetails.getFunctionaryCode()});
                Fundsource fundSource = this.fundSourceDAO.getFundSourceByCode(collDetails.getFundSourceCode());
                User loggedInUser = this.collectionsUtil.getLoggedInUser();
                Bankbranch bankBranch = null;
                if (this.collectionsUtil.isBankCollectionOperator(loggedInUser).booleanValue() && (branchUserMap = (BranchUserMap)((Object)this.branchUserMapService.findByNamedQuery("QUERY_ACTIVE_BRANCHUSER_BY_USER", new Object[]{loggedInUser.getId()}))) != null && branchUserMap.getBankbranch() != null) {
                    bankBranch = branchUserMap.getBankbranch();
                }
                ReceiptMisc receiptMisc = new ReceiptMisc(boundary, fund, functionary, fundSource, dept, receiptHeader, null, null, bankBranch);
                receiptHeader.setReceiptMisc(receiptMisc);
                BigDecimal totalAmountToBeCollected = BigDecimal.valueOf(0L);
                Collections.sort(billDetail.getAccounts());
                for (BillAccountDetails billAccount : billDetail.getAccounts()) {
                    CChartOfAccounts account = this.chartOfAccountsHibernateDAO.getCChartOfAccountsByGlCode(billAccount.getGlCode());
                    CFunction function = this.functionDAO.getFunctionByCode(billAccount.getFunctionCode());
                    if (billAccount.getIsActualDemand().booleanValue()) {
                        totalAmountToBeCollected = totalAmountToBeCollected.add(billAccount.getCrAmount()).subtract(billAccount.getDrAmount());
                    }
                    ReceiptDetail receiptDetail = new ReceiptDetail(account, function, billAccount.getCrAmount().subtract(billAccount.getDrAmount()), billAccount.getDrAmount(), billAccount.getCrAmount(), (long)billAccount.getOrder(), billAccount.getDescription(), billAccount.getIsActualDemand(), receiptHeader, billAccount.getPurpose().toString());
                    receiptHeader.addReceiptDetail(receiptDetail);
                }
                receiptHeader.setTotalAmountToBeCollected(totalAmountToBeCollected);
            }
        }
        return receiptHeader;
    }

    public PaymentResponse createPaymentResponse(ServiceDetails paymentServiceDetails, String response) {
        PaymentGatewayAdaptor paymentGatewayAdaptor = this.getPaymentGatewayAdaptor(paymentServiceDetails.getCode());
        return paymentGatewayAdaptor.parsePaymentResponse(response);
    }

    public String generateReport(ReceiptHeader[] receipts, boolean flag) {
        String serviceCode = receipts[0].getService().getCode();
        char receiptType = receipts[0].getReceipttype();
        ArrayList<BillReceiptInfoImpl> receiptList = new ArrayList<BillReceiptInfoImpl>(0);
        String templateName = this.collectionsUtil.getReceiptTemplateName(receiptType, serviceCode);
        LOGGER.info((Object)(" template name : " + templateName));
        HashMap<String, CollectionsUtil> reportParams = new HashMap<String, CollectionsUtil>(0);
        reportParams.put("EGOV_COLLECTIONS_UTIL", this.collectionsUtil);
        if (receiptType == 'C') {
            reportParams.put("EGOV_COMMON", (CollectionsUtil)this.egovCommon);
            for (ReceiptHeader receiptHeader : receipts) {
                ReceiptHeader receipHeaderRefObj = (ReceiptHeader)((Object)this.persistenceService.findByNamedQuery("CHALLANRECEIPT_BY_REFERENCEID", new Object[]{receiptHeader.getId()}));
                receiptList.add(new BillReceiptInfoImpl(receiptHeader, this.egovCommon, receipHeaderRefObj, this.chartOfAccountsHibernateDAO, this.persistenceService));
            }
        } else {
            for (ReceiptHeader receiptHeader : receipts) {
                String additionalMessage = null;
                if (receiptType == 'B') {
                    additionalMessage = this.receiptHeaderService.getAdditionalInfoForReceipt(serviceCode, new BillReceiptInfoImpl(receiptHeader, this.chartOfAccountsHibernateDAO, this.persistenceService, null));
                }
                if (additionalMessage != null) {
                    receiptList.add(new BillReceiptInfoImpl(receiptHeader, additionalMessage, this.chartOfAccountsHibernateDAO, this.persistenceService));
                    continue;
                }
                receiptList.add(new BillReceiptInfoImpl(receiptHeader, this.chartOfAccountsHibernateDAO, this.persistenceService, null));
            }
        }
        ReportRequest reportInput = new ReportRequest(templateName, receiptList, reportParams);
        reportInput.setReportFormat(ReportFormat.PDF);
        reportInput.setPrintDialogOnOpenReport(flag);
        return this.reportViewerUtil.addReportToTempCache(this.collectionsUtil.createReport(reportInput));
    }

    public String generateChallan(ReceiptHeader receipt, boolean flag) {
        ArrayList<BillReceiptInfoImpl> receiptList = new ArrayList<BillReceiptInfoImpl>(0);
        receiptList.add(new BillReceiptInfoImpl(receipt, this.egovCommon, new ReceiptHeader(), this.chartOfAccountsHibernateDAO, this.persistenceService));
        String templateName = "collection_challan";
        HashMap<String, EgovCommon> reportParams = new HashMap<String, EgovCommon>(0);
        reportParams.put("EGOV_COMMON", this.egovCommon);
        ReportRequest reportInput = new ReportRequest("collection_challan", receiptList, reportParams);
        reportInput.setPrintDialogOnOpenReport(flag);
        return this.reportViewerUtil.addReportToTempCache(this.collectionsUtil.createReport(reportInput));
    }

    public PaymentRequest createPaymentRequest(ServiceDetails paymentServiceDetails, ReceiptHeader receiptHeader) {
        PaymentGatewayAdaptor paymentGatewayAdaptor = this.getPaymentGatewayAdaptor(paymentServiceDetails.getCode());
        return paymentGatewayAdaptor.createPaymentRequest(paymentServiceDetails, receiptHeader);
    }

    protected PaymentGatewayAdaptor getPaymentGatewayAdaptor(String serviceCode) {
        return (PaymentGatewayAdaptor)this.collectionsUtil.getBean(serviceCode + "PaymentGatewayAdaptor");
    }

    public void setEgovCommon(EgovCommon egovCommon) {
        this.egovCommon = egovCommon;
    }

    public List<ReceiptDetailInfo> setReceiptDetailsList(ReceiptHeader rh, String amountType) {
        ArrayList<ReceiptDetailInfo> billDetailslist = new ArrayList<ReceiptDetailInfo>(0);
        List bankCOAList = this.chartOfAccountsHibernateDAO.getBankChartofAccountCodeList();
        for (ReceiptDetail rDetails : rh.getReceiptDetails()) {
            if (FinancialsUtil.isRevenueAccountHead(rDetails.getAccounthead(), bankCOAList, this.persistenceService)) continue;
            ReceiptDetailInfo rInfo = new ReceiptDetailInfo();
            rInfo.setGlcodeDetail(rDetails.getAccounthead().getGlcode());
            rInfo.setGlcodeIdDetail(rDetails.getAccounthead().getId());
            rInfo.setCreditAmountDetail(rDetails.getCramount().setScale(2, 0));
            rInfo.setDebitAmountDetail(rDetails.getDramount().setScale(2, 0));
            rInfo.setAccounthead(rDetails.getAccounthead().getName());
            rInfo.setAmount(BigDecimal.ZERO);
            if (rDetails.getFinancialYear() != null) {
                rInfo.setFinancialYearId(rDetails.getFinancialYear().getId());
                rInfo.setFinancialYearRange(rDetails.getFinancialYear().getFinYearRange());
            }
            if (rDetails.getFunction() != null) {
                rInfo.setFunctionDetail(rDetails.getFunction().getCode());
                rInfo.setFunctionIdDetail(rDetails.getFunction().getId());
            }
            if ((amountType.equals("credit") || amountType.equals("both")) && rDetails.getCramount().compareTo(BigDecimal.ZERO) != 0) {
                billDetailslist.add(rInfo);
                continue;
            }
            if (!amountType.equals("debit") && !amountType.equals("both") || rDetails.getDramount().compareTo(BigDecimal.ZERO) == 0) continue;
            billDetailslist.add(rInfo);
        }
        if (billDetailslist.isEmpty()) {
            billDetailslist.add(new ReceiptDetailInfo());
        }
        return billDetailslist;
    }

    public List<ReceiptDetailInfo> setAccountPayeeList(ReceiptHeader rh) {
        ArrayList<ReceiptDetailInfo> subLedgerlist = new ArrayList<ReceiptDetailInfo>(0);
        try {
            for (ReceiptDetail rDetails : rh.getReceiptDetails()) {
                for (AccountPayeeDetail aDetail : rDetails.getAccountPayeeDetails()) {
                    ReceiptDetailInfo rInfo = new ReceiptDetailInfo();
                    rInfo.setAmount(aDetail.getAmount().setScale(2, 0));
                    rInfo.setCreditAmountDetail(BigDecimal.ZERO);
                    rInfo.setDebitAmountDetail(BigDecimal.ZERO);
                    EntityType entityType = this.egovCommon.getEntityType(aDetail.getAccountDetailType(), (Serializable)aDetail.getAccountDetailKey().getDetailkey());
                    if (entityType != null) {
                        rInfo.setDetailCode(entityType.getCode());
                        rInfo.setDetailKey(entityType.getName());
                    }
                    rInfo.setDetailKeyId(aDetail.getAccountDetailKey().getDetailkey());
                    rInfo.setDetailType(aDetail.getAccountDetailType());
                    rInfo.setDetailTypeName(aDetail.getAccountDetailType().getName());
                    rInfo.setGlcode(rDetails.getAccounthead());
                    rInfo.setGlcodeDetail(rDetails.getAccounthead().getGlcode());
                    rInfo.setSubledgerCode("");
                    subLedgerlist.add(rInfo);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception while setting subledger details", (Throwable)e);
            throw new ApplicationRuntimeException("Exception while setting subledger details", (Throwable)e);
        }
        if (subLedgerlist.isEmpty()) {
            subLedgerlist.add(new ReceiptDetailInfo());
        }
        return subLedgerlist;
    }

    public void cancelChallanReceiptOnCreation(ReceiptHeader receiptHeader) {
        ReceiptHeader receiptHeaderToBeCancelled = (ReceiptHeader)((Object)this.receiptHeaderService.findById(receiptHeader.getReceiptHeader().getId(), false));
        receiptHeaderToBeCancelled.setStatus(this.collectionsUtil.getStatusForModuleAndCode("ReceiptHeader", "CANCELLED"));
        this.receiptHeaderService.persist(receiptHeaderToBeCancelled);
    }

    public ReceiptHeader createPendingReceiptFromCancelledChallanReceipt(ReceiptHeader oldReceiptHeader) {
        ReceiptHeader newReceiptHeader = new ReceiptHeader(true, oldReceiptHeader.getIsModifiable(), oldReceiptHeader.getReceipttype(), oldReceiptHeader.getCollectiontype(), oldReceiptHeader.getPaidBy(), oldReceiptHeader.getService(), oldReceiptHeader.getReferencenumber(), oldReceiptHeader.getReferenceDesc(), oldReceiptHeader.getTotalAmount());
        newReceiptHeader.setStatus(this.collectionsUtil.getStatusForModuleAndCode("ReceiptHeader", "PENDING"));
        newReceiptHeader.setReceiptHeader(oldReceiptHeader);
        ReceiptMisc receiptMisc = new ReceiptMisc(oldReceiptHeader.getReceiptMisc().getBoundary(), oldReceiptHeader.getReceiptMisc().getFund(), null, null, oldReceiptHeader.getReceiptMisc().getDepartment(), newReceiptHeader, null, null, null);
        newReceiptHeader.setReceiptMisc(receiptMisc);
        newReceiptHeader.setReceiptdate(new Date());
        List bankCOAList = this.chartOfAccountsHibernateDAO.getBankChartofAccountCodeList();
        for (ReceiptDetail oldDetail : oldReceiptHeader.getReceiptDetails()) {
            if (FinancialsUtil.isRevenueAccountHead(oldDetail.getAccounthead(), bankCOAList, this.persistenceService)) continue;
            ReceiptDetail receiptDetail = new ReceiptDetail(oldDetail.getAccounthead(), oldDetail.getFunction(), oldDetail.getCramountToBePaid(), oldDetail.getDramount(), oldDetail.getCramount(), oldDetail.getOrdernumber(), oldDetail.getDescription(), oldDetail.getIsActualDemand(), newReceiptHeader, oldDetail.getPurpose());
            receiptDetail.setCramount(oldDetail.getCramount());
            receiptDetail.setFinancialYear(oldDetail.getFinancialYear());
            for (AccountPayeeDetail oldAccountPayeeDetail : oldDetail.getAccountPayeeDetails()) {
                AccountPayeeDetail accPayeeDetail = new AccountPayeeDetail(oldAccountPayeeDetail.getAccountDetailType(), oldAccountPayeeDetail.getAccountDetailKey(), oldAccountPayeeDetail.getAmount(), receiptDetail);
                receiptDetail.addAccountPayeeDetail(accPayeeDetail);
            }
            newReceiptHeader.addReceiptDetail(receiptDetail);
        }
        if (oldReceiptHeader.getChallan() != null) {
            oldReceiptHeader.getChallan().setReceiptHeader(newReceiptHeader);
            newReceiptHeader.setChallan(oldReceiptHeader.getChallan());
        }
        return newReceiptHeader;
    }

    @Transactional
    public void cancelChallanReceipt(ReceiptHeader receiptHeader, boolean cancelInstrument) {
        receiptHeader.setStatus(this.collectionsUtil.getStatusForModuleAndCode("ReceiptHeader", "CANCELLED"));
        receiptHeader.setIsReconciled(true);
        if (cancelInstrument) {
            for (InstrumentHeader instrumentHeader : receiptHeader.getReceiptInstrument()) {
                instrumentHeader.setStatusId(this.statusDAO.getStatusByModuleAndCode("Instrument", "Cancelled"));
            }
        }
        for (ReceiptVoucher receiptVoucher : receiptHeader.getReceiptVoucher()) {
            this.receiptHeaderService.createReversalVoucher(receiptVoucher);
        }
        this.receiptHeaderService.persist(receiptHeader);
        LOGGER.info((Object)("Receipt " + receiptHeader.getReceiptnumber() + " has been cancelled"));
    }

    public String getFinancialYearIdByDate(Date date) {
        CFinancialYear fYear = (CFinancialYear)this.persistenceService.findByNamedQuery("getFinancialYearByDate", new Object[]{date});
        if (fYear != null) {
            return fYear.getId().toString();
        }
        return "0";
    }

    public InstrumentHeader validateAndConstructCashInstrument(PaymentInfoCash paytInfoCash) {
        if (paytInfoCash.getInstrumentAmount() == null || paytInfoCash.getInstrumentAmount().compareTo(BigDecimal.ZERO) == 0) {
            throw new ApplicationRuntimeException("Invalid Cash Instrument Amount[" + paytInfoCash.getInstrumentAmount() + "]");
        }
        InstrumentHeader instrHeaderCash = new InstrumentHeader();
        instrHeaderCash.setInstrumentType(this.financialsUtil.getInstrumentTypeByType("cash"));
        instrHeaderCash.setIsPayCheque("0");
        instrHeaderCash.setInstrumentAmount(paytInfoCash.getInstrumentAmount());
        return instrHeaderCash;
    }

    public InstrumentHeader validateAndConstructBankInstrument(PaymentInfoBank paytInfoBank) {
        StringBuilder invalidBankPaytMsg = new StringBuilder();
        if (paytInfoBank.getInstrumentAmount() == null || paytInfoBank.getInstrumentAmount().compareTo(BigDecimal.ZERO) <= 0) {
            invalidBankPaytMsg.append("Invalid Bank Instrument Amount[" + paytInfoBank.getInstrumentAmount()).append("] \n");
        }
        if (paytInfoBank.getTransactionNumber() == null || paytInfoBank.getTransactionNumber() < 0 || String.valueOf(paytInfoBank.getTransactionNumber()).length() != 6) {
            invalidBankPaytMsg.append("Invalid Bank Transaction Number[").append(paytInfoBank.getInstrumentAmount()).append("] \n");
        }
        if (paytInfoBank.getTransactionDate() == null) {
            invalidBankPaytMsg.append("Missing Bank Transaction Date \n");
        }
        if (new Date().compareTo(paytInfoBank.getTransactionDate()) == -1) {
            invalidBankPaytMsg.append("Bank Transaction Date[" + paytInfoBank.getTransactionDate()).append("] cannot be a future date \n");
        }
        Bankaccount account = null;
        if (paytInfoBank.getBankAccountId() == null) {
            invalidBankPaytMsg.append("Missing Bank Account Id \n");
        } else {
            account = this.bankAccountDAO.findById((Number)paytInfoBank.getBankAccountId().intValue(), false);
            if (account == null) {
                invalidBankPaytMsg.append("No account found for bank account id[" + paytInfoBank.getBankAccountId()).append("] \n");
            }
        }
        if (!"".equals(invalidBankPaytMsg)) {
            throw new ApplicationRuntimeException(invalidBankPaytMsg.toString());
        }
        InstrumentHeader instrHeaderBank = new InstrumentHeader();
        instrHeaderBank.setInstrumentType(this.financialsUtil.getInstrumentTypeByType("bankchallan"));
        instrHeaderBank.setBankAccountId(account);
        instrHeaderBank.setBankId(account.getBankbranch().getBank());
        instrHeaderBank.setBankBranchName(account.getBankbranch().getBranchname());
        instrHeaderBank.setTransactionNumber(String.valueOf(paytInfoBank.getTransactionNumber()));
        instrHeaderBank.setInstrumentAmount(paytInfoBank.getInstrumentAmount());
        instrHeaderBank.setTransactionDate(paytInfoBank.getTransactionDate());
        instrHeaderBank.setIsPayCheque("0");
        return instrHeaderBank;
    }

    public InstrumentHeader validateAndConstructChequeDDInstrument(PaymentInfoChequeDD paytInfoChequeDD) {
        StringBuilder invalidChequeDDPaytMsg = new StringBuilder();
        if (paytInfoChequeDD.getInstrumentAmount() == null || paytInfoChequeDD.getInstrumentAmount().compareTo(BigDecimal.ZERO) <= 0) {
            invalidChequeDDPaytMsg.append("Invalid cheque/DD Instrument Amount[").append(paytInfoChequeDD.getInstrumentAmount()).append("] \n");
        }
        if (paytInfoChequeDD.getInstrumentNumber() == null || "".equals(paytInfoChequeDD.getInstrumentNumber()) || !MoneyUtils.isInteger((String)paytInfoChequeDD.getInstrumentNumber()) || paytInfoChequeDD.getInstrumentNumber().length() != 6) {
            invalidChequeDDPaytMsg.append("Invalid Cheque/DD Instrument Number[").append(paytInfoChequeDD.getInstrumentNumber()).append("]. \n");
        }
        if (paytInfoChequeDD.getInstrumentDate() == null) {
            invalidChequeDDPaytMsg.append("Missing Cheque/DD Transaction Date \n");
        }
        if (new Date().compareTo(paytInfoChequeDD.getInstrumentDate()) == -1) {
            invalidChequeDDPaytMsg.append("Cheque/DD Transaction Date[").append(paytInfoChequeDD.getInstrumentDate()).append("] cannot be a future date \n");
        }
        Bank bank = null;
        if (paytInfoChequeDD.getBankId() != null && (bank = this.bankDAO.findById((Number)paytInfoChequeDD.getBankId().intValue(), false)) == null) {
            invalidChequeDDPaytMsg.append("No bank present for bank id [").append(paytInfoChequeDD.getBankId()).append("] \n");
        }
        if (!invalidChequeDDPaytMsg.toString().isEmpty()) {
            throw new ApplicationRuntimeException(invalidChequeDDPaytMsg.toString());
        }
        InstrumentHeader instrHeaderChequeDD = new InstrumentHeader();
        instrHeaderChequeDD.setIsPayCheque("0");
        instrHeaderChequeDD.setInstrumentAmount(paytInfoChequeDD.getInstrumentAmount());
        instrHeaderChequeDD.setInstrumentType(this.financialsUtil.getInstrumentTypeByType(paytInfoChequeDD.getInstrumentType().toString()));
        instrHeaderChequeDD.setInstrumentNumber(String.valueOf(paytInfoChequeDD.getInstrumentNumber()));
        instrHeaderChequeDD.setBankBranchName(paytInfoChequeDD.getBranchName());
        instrHeaderChequeDD.setInstrumentDate(paytInfoChequeDD.getInstrumentDate());
        instrHeaderChequeDD.setBankId(bank);
        return instrHeaderChequeDD;
    }

    public List<ReceiptDetail> apportionBillAmount(BigDecimal actualAmountPaid, ArrayList<ReceiptDetail> receiptDetails) {
        BigDecimal totalCreditAmount = BigDecimal.ZERO;
        ReceiptHeader receiptHeader = receiptDetails.get(0).getReceiptHeader();
        BillingIntegrationService billingService = (BillingIntegrationService)this.collectionsUtil.getBean(receiptHeader.getService().getCode() + "CollectionsInterface");
        billingService.apportionPaidAmount(receiptHeader.getReferencenumber(), actualAmountPaid, receiptDetails);
        for (ReceiptDetail receiptDetail : receiptDetails) {
            totalCreditAmount = totalCreditAmount.add(receiptDetail.getCramount());
        }
        if (totalCreditAmount.intValue() == 0) {
            throw new ApplicationRuntimeException("Apportioning Failed at the Billing System: " + receiptHeader.getService().getCode() + ", for bill number: " + receiptHeader.getReferencenumber());
        }
        return receiptDetails;
    }

    public PersistenceService<BranchUserMap, Long> getBranchUserMapService() {
        return this.branchUserMapService;
    }

    public void setBranchUserMapService(PersistenceService<BranchUserMap, Long> branchUserMapService) {
        this.branchUserMapService = branchUserMapService;
    }
}

