/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.entity;

import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EG_COLLECTIONINDEX")
@SequenceGenerator(name="SEQ_EG_COLLECTIONINDEX", sequenceName="SEQ_EG_COLLECTIONINDEX", allocationSize=1)
public class CollectionIndex
extends AbstractAuditable {
    private static final long serialVersionUID = 1L;
    public static final String SEQ_COLLECTIONINDEX = "SEQ_EG_COLLECTIONINDEX";
    @Id
    @GeneratedValue(generator="SEQ_EG_COLLECTIONINDEX", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    private Date receiptDate;
    @NotNull
    @Length(max=50)
    private String receiptNumber;
    @NotNull
    @Length(max=100)
    private String billingService;
    @NotNull
    @Length(max=50)
    private String paymentMode;
    private BigDecimal arrearAmount;
    private BigDecimal penaltyAmount;
    private BigDecimal currentAmount;
    @NotNull
    private BigDecimal totalAmount;
    private BigDecimal advanceAmount;
    @NotNull
    @Length(max=50)
    private String channel;
    @Length(max=100)
    private String paymentGateway;
    private String billNumber;
    @Length(max=50)
    private String consumerCode;
    @NotNull
    @Length(max=250)
    private String cityName;
    @Length(max=250)
    private String districtName;
    @Length(max=250)
    private String regionName;
    @NotNull
    @Length(max=50)
    private String status;
    private BigDecimal latePaymentCharges;
    private BigDecimal arrearCess;
    private BigDecimal currentCess;
    @Length(max=50)
    private String installmentFrom;
    @Length(max=50)
    private String installmentTo;
    @Length(max=256)
    private String consumerName;
    private BigDecimal reductionAmount;
    @Length(max=50)
    private String cityGrade;
    @Length(max=10)
    private String cityCode;
    @Length(max=100)
    private String receiptCreator;
    private String revenueWard;
    @Length(max=100)
    private String consumerType;
    private Integer conflict;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getReceiptDate() {
        return this.receiptDate;
    }

    public void setReceiptDate(Date receiptDate) {
        this.receiptDate = receiptDate;
    }

    public String getReceiptNumber() {
        return this.receiptNumber;
    }

    public void setReceiptNumber(String receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    public String getBillingService() {
        return this.billingService;
    }

    public void setBillingService(String billingService) {
        this.billingService = billingService;
    }

    public String getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(String paymentMode) {
        this.paymentMode = paymentMode;
    }

    public BigDecimal getAdvanceAmount() {
        return this.advanceAmount;
    }

    public void setAdvanceAmount(BigDecimal advanceAmount) {
        this.advanceAmount = advanceAmount;
    }

    public BigDecimal getArrearAmount() {
        return this.arrearAmount;
    }

    public void setArrearAmount(BigDecimal arrearAmount) {
        this.arrearAmount = arrearAmount;
    }

    public BigDecimal getPenaltyAmount() {
        return this.penaltyAmount;
    }

    public void setPenaltyAmount(BigDecimal penaltyAmount) {
        this.penaltyAmount = penaltyAmount;
    }

    public BigDecimal getCurrentAmount() {
        return this.currentAmount;
    }

    public void setCurrentAmount(BigDecimal currentAmount) {
        this.currentAmount = currentAmount;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getPaymentGateway() {
        return this.paymentGateway;
    }

    public void setPaymentGateway(String paymentGateway) {
        this.paymentGateway = paymentGateway;
    }

    public String getBillNumber() {
        return this.billNumber;
    }

    public void setBillNumber(String billNumber) {
        this.billNumber = billNumber;
    }

    public String getConsumerCode() {
        return this.consumerCode;
    }

    public void setConsumerCode(String consumerCode) {
        this.consumerCode = consumerCode;
    }

    public String getCityName() {
        return this.cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getDistrictName() {
        return this.districtName;
    }

    public void setDistrictName(String districtName) {
        this.districtName = districtName;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public BigDecimal getLatePaymentCharges() {
        return this.latePaymentCharges;
    }

    public void setLatePaymentCharges(BigDecimal latePaymentCharges) {
        this.latePaymentCharges = latePaymentCharges;
    }

    public BigDecimal getArrearCess() {
        return this.arrearCess;
    }

    public void setArrearCess(BigDecimal arrearCess) {
        this.arrearCess = arrearCess;
    }

    public BigDecimal getCurrentCess() {
        return this.currentCess;
    }

    public void setCurrentCess(BigDecimal currentCess) {
        this.currentCess = currentCess;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    public String getInstallmentFrom() {
        return this.installmentFrom;
    }

    public void setInstallmentFrom(String installmentFrom) {
        this.installmentFrom = installmentFrom;
    }

    public String getInstallmentTo() {
        return this.installmentTo;
    }

    public void setInstallmentTo(String installmentTo) {
        this.installmentTo = installmentTo;
    }

    public BigDecimal getReductionAmount() {
        return this.reductionAmount;
    }

    public void setReductionAmount(BigDecimal reductionAmount) {
        this.reductionAmount = reductionAmount;
    }

    public String getCityGrade() {
        return this.cityGrade;
    }

    public void setCityGrade(String cityGrade) {
        this.cityGrade = cityGrade;
    }

    public String getCityCode() {
        return this.cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getReceiptCreator() {
        return this.receiptCreator;
    }

    public void setReceiptCreator(String receiptCreator) {
        this.receiptCreator = receiptCreator;
    }

    public String getRevenueWard() {
        return this.revenueWard;
    }

    public void setRevenueWard(String revenueWard) {
        this.revenueWard = revenueWard;
    }

    public String getConsumerType() {
        return this.consumerType;
    }

    public void setConsumerType(String consumerType) {
        this.consumerType = consumerType;
    }

    public Integer getConflict() {
        return this.conflict;
    }

    public void setConflict(Integer conflict) {
        this.conflict = conflict;
    }

    public static CollectionIndexBuilder builder() {
        return new CollectionIndexBuilder();
    }

    private void validate() throws ApplicationRuntimeException {
        if (this.getReceiptDate() == null) {
            throw new ApplicationRuntimeException("Receipt Date is mandatory");
        }
        if (this.getReceiptNumber() == null) {
            throw new ApplicationRuntimeException("Receipt Number is mandatory");
        }
        if (this.getPaymentMode() == null) {
            throw new ApplicationRuntimeException("Payment Mode is mandatory");
        }
        if (this.getTotalAmount() == null) {
            throw new ApplicationRuntimeException("Total Amount is mandatory");
        }
        if (this.getChannel() == null) {
            throw new ApplicationRuntimeException("Channel is mandatory");
        }
        if (this.getStatus() == null) {
            throw new ApplicationRuntimeException("Receipt Status is mandatory");
        }
    }

    public static final class CollectionIndexBuilder {
        private Date receiptdate;
        private String receiptnumber;
        private String billingservice;
        private String paymentmode;
        private BigDecimal totalamount;
        private String channel;
        private BigDecimal arrearamount;
        private BigDecimal penaltyamount;
        private BigDecimal currentamount;
        private BigDecimal advanceamount;
        private String paymentgateway;
        private String billnumber;
        private BigDecimal latepaymentcharges;
        private BigDecimal arrearcess;
        private BigDecimal currentcess;
        private String installmentfrom;
        private String installmentto;
        private String consumername;
        private BigDecimal reductionamount;
        private String receiptcreator;
        private String revenueward;
        private String status;
        private String consumercode;
        private String consumerType;
        private Integer conflict;

        public CollectionIndex build() throws ApplicationRuntimeException {
            CollectionIndex collectionIndex = new CollectionIndex();
            collectionIndex.setReceiptDate(this.receiptdate);
            collectionIndex.setReceiptNumber(this.receiptnumber);
            collectionIndex.setBillingService(this.billingservice);
            collectionIndex.setPaymentMode(this.paymentmode);
            collectionIndex.setConsumerCode(this.consumercode);
            collectionIndex.setTotalAmount(this.totalamount);
            collectionIndex.setArrearAmount(this.arrearamount);
            collectionIndex.setPenaltyAmount(this.penaltyamount);
            collectionIndex.setCurrentAmount(this.currentamount);
            collectionIndex.setAdvanceAmount(this.advanceamount);
            collectionIndex.setPaymentGateway(this.paymentgateway);
            collectionIndex.setBillNumber(this.billnumber);
            collectionIndex.setLatePaymentCharges(this.latepaymentcharges);
            collectionIndex.setArrearCess(this.arrearcess);
            collectionIndex.setCurrentCess(this.currentcess);
            collectionIndex.setInstallmentFrom(this.installmentfrom);
            collectionIndex.setInstallmentTo(this.installmentto);
            collectionIndex.setConsumerName(this.consumername);
            collectionIndex.setReductionAmount(this.reductionamount);
            collectionIndex.setReceiptCreator(this.receiptcreator);
            collectionIndex.setRevenueWard(this.revenueward);
            collectionIndex.setChannel(this.channel);
            collectionIndex.setStatus(this.status);
            collectionIndex.setConsumerType(this.consumerType);
            collectionIndex.setConflict(this.conflict);
            collectionIndex.validate();
            return collectionIndex;
        }

        private CollectionIndexBuilder() {
        }

        public CollectionIndexBuilder withReceiptDate(Date receiptdate) {
            this.receiptdate = receiptdate;
            return this;
        }

        public CollectionIndexBuilder withReceiptnumber(String receiptnumber) {
            this.receiptnumber = receiptnumber;
            return this;
        }

        public CollectionIndexBuilder withBillingservice(String billingService) {
            this.billingservice = billingService;
            return this;
        }

        public CollectionIndexBuilder withPaymentMode(String paymentMode) {
            this.paymentmode = paymentMode;
            return this;
        }

        public CollectionIndexBuilder withConsumerCode(String consumercode) {
            this.consumercode = consumercode;
            return this;
        }

        public CollectionIndexBuilder withTotalamount(BigDecimal totalamount) {
            this.totalamount = totalamount;
            return this;
        }

        public CollectionIndexBuilder withArrearAmount(BigDecimal arrearAmount) {
            this.arrearamount = arrearAmount;
            return this;
        }

        public CollectionIndexBuilder withPenaltyAmount(BigDecimal penaltyAmount) {
            this.penaltyamount = penaltyAmount;
            return this;
        }

        public CollectionIndexBuilder withCurrentAmount(BigDecimal currentAmount) {
            this.currentamount = currentAmount;
            return this;
        }

        public CollectionIndexBuilder withAdvanceAmount(BigDecimal advanceAmount) {
            this.advanceamount = advanceAmount;
            return this;
        }

        public CollectionIndexBuilder withPaymentGateway(String paymentGateway) {
            this.paymentgateway = paymentGateway;
            return this;
        }

        public CollectionIndexBuilder withBillNumber(String billNumber) {
            this.billnumber = billNumber;
            return this;
        }

        public CollectionIndexBuilder withLatePaymentChargesAmount(BigDecimal latePaymentCharges) {
            this.latepaymentcharges = latePaymentCharges;
            return this;
        }

        public CollectionIndexBuilder withArrearCess(BigDecimal arrearCess) {
            this.arrearcess = arrearCess;
            return this;
        }

        public CollectionIndexBuilder withCurrentCess(BigDecimal currentCess) {
            this.currentcess = currentCess;
            return this;
        }

        public CollectionIndexBuilder withInstallmentFrom(String installmentFrom) {
            this.installmentfrom = installmentFrom;
            return this;
        }

        public CollectionIndexBuilder withInstallmentTo(String installmentTo) {
            this.installmentto = installmentTo;
            return this;
        }

        public CollectionIndexBuilder withConsumerName(String consumerName) {
            this.consumername = consumerName;
            return this;
        }

        public CollectionIndexBuilder withReductionAmount(BigDecimal reductionAmount) {
            this.reductionamount = reductionAmount;
            return this;
        }

        public CollectionIndexBuilder withReceiptCreator(String receiptCreator) {
            this.receiptcreator = receiptCreator;
            return this;
        }

        public CollectionIndexBuilder withRevenueWard(String revenueWard) {
            this.revenueward = revenueWard;
            return this;
        }

        public CollectionIndexBuilder withStatus(String status) {
            this.status = status;
            return this;
        }

        public CollectionIndexBuilder withChannel(String channel) {
            this.channel = channel;
            return this;
        }

        public CollectionIndexBuilder withConsumerType(String consumerType) {
            this.consumerType = consumerType;
            return this;
        }

        public CollectionIndexBuilder withConflict(Integer conflict) {
            this.conflict = conflict;
            return this;
        }
    }
}

