/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.config.properties;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;

@Configuration
@PropertySource(name="collectionApplicationProperties", value={"classpath:config/payment-gateway.properties", "classpath:config/egov-erp-${user.name}.properties", "classpath:config/application-config-${client.id}.properties", "classpath:config/egov-erp-override.properties"}, ignoreResourceNotFound=true)
public class CollectionApplicationProperties {
    @Autowired
    private Environment environment;

    public String axisTransactionMessage() {
        return this.environment.getProperty("AXIS.transactionmessage");
    }

    public String axisVersion() {
        return (String)this.environment.getProperty("axis.version", String.class);
    }

    public String axisCommand() {
        return this.environment.getProperty("axis.command");
    }

    public String axisCommandQuery() {
        return this.environment.getProperty("axis.command.query");
    }

    public String axisAccessCode() {
        return this.environment.getProperty("axis.access.code");
    }

    public String axisMerchant() {
        return this.environment.getProperty("axis.merchant");
    }

    public String axisLocale() {
        return this.environment.getProperty("axis.locale");
    }

    public String axisOperator() {
        return this.environment.getProperty("axis.operator.id");
    }

    public String axisPassword() {
        return this.environment.getProperty("axis.password");
    }

    public String axisReconcileUrl() {
        return this.environment.getProperty("axis.reconcile.url");
    }

    public String axisSecureSecret() {
        return this.environment.getProperty("axis.secure.secret");
    }

    public String getEmailSubject() {
        return this.environment.getProperty("email.subject.message");
    }

    public String getEmailBody() {
        return this.environment.getProperty("email.body.message");
    }

    public String getValue(String key) {
        return this.environment.getProperty(key);
    }

    public String sbimopsDdocode(String cityCode) {
        return this.environment.getProperty(cityCode.concat(".sbimops.ddocode"));
    }

    public String sbimopsHoa(String cityCode) {
        return this.environment.getProperty(cityCode.concat(".sbimops.hoa"));
    }

    public String getUpdateDemandUrl(String serviceCode) {
        return this.environment.getProperty(serviceCode.concat(".updatedemand.url"));
    }
}

