/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.autonumber.impl;

import java.io.Serializable;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.egov.collection.autonumber.ChallanNumberGenerator;
import org.egov.collection.entity.Challan;
import org.egov.commons.CFinancialYear;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.utils.DBSequenceGenerator;
import org.egov.infra.persistence.utils.SequenceNumberGenerator;
import org.egov.infra.utils.DateUtils;
import org.hibernate.exception.SQLGrammarException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChallanNumberGeneratorImpl
implements ChallanNumberGenerator {
    @Autowired
    private SequenceNumberGenerator sequenceNumberGenerator;
    @Autowired
    private DBSequenceGenerator dbSequenceGenerator;

    @Override
    public String generateChallanNumber(Challan challan, CFinancialYear financialYear) {
        Serializable sequenceNumber;
        String APP_NUMBER_SEQ_PREFIX = "SQ_CHALLAN%s";
        SimpleDateFormat sdf = new SimpleDateFormat("MM");
        String formattedDate = sdf.format(new Date());
        String currentYear = DateUtils.currentDateToYearFormat();
        String sequenceName = String.format("SQ_CHALLAN%s", currentYear);
        try {
            try {
                sequenceNumber = this.sequenceNumberGenerator.getNextSequence(sequenceName);
            }
            catch (SQLGrammarException e) {
                sequenceNumber = this.dbSequenceGenerator.createAndGetNextSequence(sequenceName);
            }
        }
        catch (SQLException e) {
            throw new ApplicationRuntimeException("Error occurred while generating Application Number", (Throwable)e);
        }
        String result = formattedDate + "/" + financialYear.getFinYearRange() + "/" + sequenceNumber;
        return result;
    }
}

