/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.collection.entity.CollectionSummaryHeadWiseReport;
import org.egov.collection.entity.CollectionSummaryHeadWiseReportResult;
import org.egov.collection.entity.OnlinePaymentResult;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.hibernate.type.DoubleType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.springframework.stereotype.Service;

@Service
public class CollectionReportHeadWiseService {
    @PersistenceContext
    EntityManager entityManager;
    private static final Logger LOGGER = Logger.getLogger(CollectionReportHeadWiseService.class);

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public SQLQuery getOnlinePaymentReportData(String districtName, String ulbName, String fromDate, String toDate, String transactionId) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("dd/MM/yyyy");
        StringBuilder queryStr = new StringBuilder(500);
        queryStr.append("select * from public.onlinepayment_view opv where 1=1");
        if (StringUtils.isNotBlank((String)districtName)) {
            queryStr.append(" and opv.districtName=:districtName ");
        }
        if (StringUtils.isNotBlank((String)ulbName)) {
            queryStr.append(" and opv.ulbName=:ulbName ");
        }
        if (StringUtils.isNotBlank((String)fromDate)) {
            queryStr.append(" and opv.transactiondate>=:fromDate ");
        }
        if (StringUtils.isNotBlank((String)toDate)) {
            queryStr.append(" and opv.transactiondate<=:toDate ");
        }
        if (StringUtils.isNotBlank((String)transactionId)) {
            queryStr.append(" and opv.transactionnumber like :transactionnumber ");
        }
        queryStr.append(" order by receiptdate desc ");
        SQLQuery query = this.getCurrentSession().createSQLQuery(queryStr.toString());
        if (StringUtils.isNotBlank((String)districtName)) {
            query.setString("districtName", districtName);
        }
        if (StringUtils.isNotBlank((String)ulbName)) {
            query.setString("ulbName", ulbName);
        }
        try {
            if (StringUtils.isNotBlank((String)fromDate)) {
                query.setDate("fromDate", dateFormatter.parse(fromDate));
            }
            if (StringUtils.isNotBlank((String)toDate)) {
                query.setDate("toDate", dateFormatter.parse(toDate));
            }
        }
        catch (ParseException e) {
            LOGGER.error((Object)("Exception parsing Date" + e.getMessage()));
        }
        if (StringUtils.isNotBlank((String)transactionId)) {
            query.setString("transactionnumber", "%" + transactionId + "%");
        }
        queryStr.append(" order by opv.receiptdate desc");
        query.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(OnlinePaymentResult.class));
        return query;
    }

    public List<Object[]> getUlbNames(String districtName) {
        StringBuilder queryStr = new StringBuilder("select distinct ulbname from public.onlinepayment_view opv where 1=1");
        if (StringUtils.isNotBlank((String)districtName)) {
            queryStr.append(" and opv.districtName=:districtName ");
        }
        SQLQuery query = this.getCurrentSession().createSQLQuery(queryStr.toString());
        if (StringUtils.isNotBlank((String)districtName)) {
            query.setString("districtName", districtName);
        }
        return query.list();
    }

    public List<Object[]> getDistrictNames() {
        StringBuilder queryStr = new StringBuilder("select distinct districtname from public.onlinepayment_view");
        SQLQuery query = this.getCurrentSession().createSQLQuery(queryStr.toString());
        return query.list();
    }

    public CollectionSummaryHeadWiseReportResult getCollectionSummaryReport(Date fromDate, Date toDate, String paymentMode, String source, String glCode, int status) {
        SimpleDateFormat fromDateFormatter = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        SimpleDateFormat toDateFormatter = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
        StringBuilder defaultQueryStr = new StringBuilder(500);
        StringBuilder queryStr = new StringBuilder(500);
        queryStr.append("SELECT  (CASE WHEN EGF_INSTRUMENTTYPE.TYPE='cash' THEN count(*) END) AS cashCount,  ").append("(CASE WHEN EGF_INSTRUMENTTYPE.TYPE='cheque' THEN count(*) WHEN EGF_INSTRUMENTTYPE.TYPE='dd' THEN count(*) END) AS chequeddCount, ").append(" (CASE WHEN EGF_INSTRUMENTTYPE.TYPE= 'online' THEN count(*) END) AS onlineCount, ").append(" EGCL_COLLECTIONHEADER.SOURCE AS source, EG_LOCATION.NAME AS counterName, EG_USER.NAME AS employeeName,GLCODE,").append(" (CASE WHEN EGF_INSTRUMENTTYPE.TYPE='cash' THEN SUM(EGF_INSTRUMENTHEADER.INSTRUMENTAMOUNT) END) AS cashAmount, ").append(" (CASE WHEN EGF_INSTRUMENTTYPE.TYPE='cheque' THEN SUM(EGCL_COLLECTIONDETAILS.CRAMOUNT) WHEN EGF_INSTRUMENTTYPE.TYPE='dd' THEN SUM(EGCL_COLLECTIONDETAILS.CRAMOUNT) END) AS chequeddAmount,").append(" (CASE WHEN EGF_INSTRUMENTTYPE.TYPE='card' THEN count(*) END) AS cardCount, ").append(" (CASE WHEN EGF_INSTRUMENTTYPE.TYPE='card' THEN SUM(EGF_INSTRUMENTHEADER.INSTRUMENTAMOUNT) END) AS cardAmount, ").append(" count(*) as totalReceiptCount, ").append(" (CASE WHEN EGF_INSTRUMENTTYPE.TYPE= 'online' THEN SUM(EGCL_COLLECTIONDETAILS.CRAMOUNT) END) AS onlineAmount, EG_USER.ID AS USERID FROM").append(" EGCL_COLLECTIONHEADER EGCL_COLLECTIONHEADER INNER JOIN EGCL_COLLECTIONINSTRUMENT EGCL_COLLECTIONINSTRUMENT ON EGCL_COLLECTIONHEADER.ID = EGCL_COLLECTIONINSTRUMENT.COLLECTIONHEADER ").append(" INNER JOIN EGF_INSTRUMENTHEADER EGF_INSTRUMENTHEADER ON EGCL_COLLECTIONINSTRUMENT.INSTRUMENTHEADER = EGF_INSTRUMENTHEADER.ID ").append(" INNER JOIN EGW_STATUS EGW_STATUS ON EGCL_COLLECTIONHEADER.STATUS = EGW_STATUS.ID ").append(" INNER JOIN EG_LOCATION EG_LOCATION ON EGCL_COLLECTIONHEADER.LOCATION = EG_LOCATION.ID ").append(" INNER JOIN EGF_INSTRUMENTTYPE EGF_INSTRUMENTTYPE ON EGF_INSTRUMENTHEADER.INSTRUMENTTYPE = EGF_INSTRUMENTTYPE.ID ").append(" INNER JOIN EGCL_COLLECTIONMIS EGCL_COLLECTIONMIS ON EGCL_COLLECTIONHEADER.ID = EGCL_COLLECTIONMIS.COLLECTIONHEADER ").append(" INNER JOIN EG_USER EG_USER ON EGCL_COLLECTIONHEADER.CREATEDBY = EG_USER.ID ").append(" INNER JOIN EGEIS_EMPLOYEE EG_EMPLOYEE ON EG_USER.ID = EG_EMPLOYEE.ID ").append(" INNER JOIN EGEIS_ASSIGNMENT EGEIS_ASSIGNMENT ON EGEIS_ASSIGNMENT.EMPLOYEE = EG_EMPLOYEE.ID ").append("INNER JOIN EGCL_COLLECTIONDETAILS EGCL_COLLECTIONDETAILS ON EGCL_COLLECTIONHEADER.ID = EGCL_COLLECTIONDETAILS.COLLECTIONHEADER ").append(" INNER JOIN CHARTOFACCOUNTS CAO ON CAO.ID = EGCL_COLLECTIONDETAILS.CHARTOFACCOUNT WHERE").append(" EGW_STATUS.DESCRIPTION != 'Cancelled' AND EGCL_COLLECTIONDETAILS.CRAMOUNT>0");
        StringBuilder onlineQueryStr = new StringBuilder();
        onlineQueryStr.append("SELECT  (CASE WHEN EGF_INSTRUMENTTYPE.TYPE='cash' THEN count(*) END) AS cashCount,  ").append("(CASE WHEN EGF_INSTRUMENTTYPE.TYPE='cheque' THEN count(*) WHEN EGF_INSTRUMENTTYPE.TYPE='dd' THEN count(*) END) AS chequeddCount, ").append(" (CASE WHEN EGF_INSTRUMENTTYPE.TYPE= 'online' THEN count(*) END) AS onlineCount, ").append(" EGCL_COLLECTIONHEADER.SOURCE AS source, '' AS counterName, '' AS employeeName,CAO.NAME || '-' || CAO.GLCODE AS GLCODE,").append(" (CASE WHEN EGF_INSTRUMENTTYPE.TYPE='cash' THEN SUM(EGCL_COLLECTIONDETAILS.CRAMOUNT) END) AS cashAmount, ").append(" (CASE WHEN EGF_INSTRUMENTTYPE.TYPE='cheque' THEN SUM(EGCL_COLLECTIONDETAILS.CRAMOUNT) WHEN EGF_INSTRUMENTTYPE.TYPE='dd' THEN SUM(EGF_INSTRUMENTHEADER.INSTRUMENTAMOUNT) END) AS chequeddAmount,").append(" (CASE WHEN EGF_INSTRUMENTTYPE.TYPE='card' THEN count(*) END) AS cardCount, ").append(" (CASE WHEN EGF_INSTRUMENTTYPE.TYPE='card' THEN SUM(EGF_INSTRUMENTHEADER.INSTRUMENTAMOUNT) END) AS cardAmount, ").append(" count(*) as totalReceiptCount, ").append(" (CASE WHEN EGF_INSTRUMENTTYPE.TYPE= 'online' THEN SUM(EGCL_COLLECTIONDETAILS.CRAMOUNT) END) AS onlineAmount, 0 AS USERID FROM ").append(" EGCL_COLLECTIONHEADER EGCL_COLLECTIONHEADER INNER JOIN EGCL_COLLECTIONINSTRUMENT EGCL_COLLECTIONINSTRUMENT ON EGCL_COLLECTIONHEADER.ID = EGCL_COLLECTIONINSTRUMENT.COLLECTIONHEADER ").append(" INNER JOIN EGF_INSTRUMENTHEADER EGF_INSTRUMENTHEADER ON EGCL_COLLECTIONINSTRUMENT.INSTRUMENTHEADER = EGF_INSTRUMENTHEADER.ID ").append(" INNER JOIN EGW_STATUS EGW_STATUS ON EGCL_COLLECTIONHEADER.STATUS = EGW_STATUS.ID").append(" INNER JOIN EGF_INSTRUMENTTYPE EGF_INSTRUMENTTYPE ON EGF_INSTRUMENTHEADER.INSTRUMENTTYPE = EGF_INSTRUMENTTYPE.ID").append(" INNER JOIN EGCL_COLLECTIONMIS EGCL_COLLECTIONMIS ON EGCL_COLLECTIONHEADER.ID = EGCL_COLLECTIONMIS.COLLECTIONHEADER ").append("INNER JOIN EGCL_COLLECTIONDETAILS EGCL_COLLECTIONDETAILS ON EGCL_COLLECTIONHEADER.ID = EGCL_COLLECTIONDETAILS.COLLECTIONHEADER ").append(" INNER JOIN CHARTOFACCOUNTS CAO ON CAO.ID = EGCL_COLLECTIONDETAILS.CHARTOFACCOUNT WHERE").append(" EGW_STATUS.DESCRIPTION != 'Cancelled' AND EGCL_COLLECTIONDETAILS.CRAMOUNT>0");
        StringBuilder queryStrGroup = new StringBuilder();
        queryStrGroup.append(" GROUP BY  source, counterName, employeeName, USERID,CAO.NAME,CAO.GLCODE,EGF_INSTRUMENTTYPE.TYPE");
        if (fromDate != null && toDate != null) {
            queryStr.append(" AND EGCL_COLLECTIONHEADER.RECEIPTDATE between to_timestamp('" + fromDateFormatter.format(fromDate) + "', 'YYYY-MM-DD HH24:MI:SS') and " + " to_timestamp('" + toDateFormatter.format(toDate) + "', 'YYYY-MM-DD HH24:MI:SS') ");
            onlineQueryStr.append(" AND EGCL_COLLECTIONHEADER.RECEIPTDATE between to_timestamp('" + fromDateFormatter.format(fromDate) + "', 'YYYY-MM-DD HH24:MI:SS') and " + " to_timestamp('" + toDateFormatter.format(toDate) + "', 'YYYY-MM-DD HH24:MI:SS') ");
        }
        if (!source.isEmpty() && !source.equals("ALL")) {
            queryStr.append(" AND EGCL_COLLECTIONHEADER.SOURCE=:source");
            onlineQueryStr.append(" AND EGCL_COLLECTIONHEADER.SOURCE=:source");
        } else {
            queryStr.setLength(0);
            queryStr.append((CharSequence)onlineQueryStr);
        }
        if (glCode != null) {
            queryStr.append(" AND CAO.GLCODE =:glCode");
            onlineQueryStr.append(" AND CAO.GLCODE =:glCode");
        } else {
            queryStr.setLength(0);
            queryStr.append((CharSequence)onlineQueryStr);
        }
        if (status != -1) {
            queryStr.append(" AND EGCL_COLLECTIONHEADER.STATUS =:searchStatus");
            onlineQueryStr.append(" AND EGCL_COLLECTIONHEADER.STATUS =:searchStatus");
        }
        if (StringUtils.isNotBlank((String)paymentMode) && !paymentMode.equals("ALL")) {
            if (paymentMode.equals("online")) {
                queryStr.setLength(0);
                onlineQueryStr.append(" AND EGF_INSTRUMENTTYPE.TYPE in (:paymentMode)");
                queryStr.append((CharSequence)onlineQueryStr);
                queryStr.append((CharSequence)queryStrGroup);
            } else {
                queryStr.append(" AND EGF_INSTRUMENTTYPE.TYPE in (:paymentMode)");
                queryStr.append((CharSequence)queryStrGroup);
                onlineQueryStr.append(" AND EGF_INSTRUMENTTYPE.TYPE in (:paymentMode)");
            }
        } else {
            defaultQueryStr.append((CharSequence)queryStr);
            defaultQueryStr.append(" AND EGF_INSTRUMENTTYPE.TYPE = 'cash'");
            defaultQueryStr.append((CharSequence)queryStrGroup);
            defaultQueryStr.append(" union ");
            defaultQueryStr.append((CharSequence)queryStr);
            defaultQueryStr.append(" AND EGF_INSTRUMENTTYPE.TYPE in ('cheque', 'dd')");
            defaultQueryStr.append((CharSequence)queryStrGroup);
            defaultQueryStr.append(" union ");
            defaultQueryStr.append((CharSequence)queryStr);
            defaultQueryStr.append(" AND EGF_INSTRUMENTTYPE.TYPE = 'card'");
            defaultQueryStr.append((CharSequence)queryStrGroup);
            defaultQueryStr.append(" union ");
            defaultQueryStr.append((CharSequence)onlineQueryStr);
            defaultQueryStr.append(" AND EGF_INSTRUMENTTYPE.TYPE = 'online'");
            defaultQueryStr.append((CharSequence)queryStrGroup);
            queryStr.setLength(0);
            queryStr.append((CharSequence)defaultQueryStr);
        }
        StringBuilder aggregateQueryStr = new StringBuilder();
        aggregateQueryStr.append((CharSequence)onlineQueryStr);
        aggregateQueryStr.append(" AND EGF_INSTRUMENTTYPE.TYPE = 'cash'");
        aggregateQueryStr.append((CharSequence)queryStrGroup);
        aggregateQueryStr.append(" union ");
        aggregateQueryStr.append((CharSequence)onlineQueryStr);
        aggregateQueryStr.append(" AND EGF_INSTRUMENTTYPE.TYPE in( 'cheque','dd')");
        aggregateQueryStr.append((CharSequence)queryStrGroup);
        aggregateQueryStr.append(" union ");
        aggregateQueryStr.append((CharSequence)onlineQueryStr);
        aggregateQueryStr.append(" AND EGF_INSTRUMENTTYPE.TYPE = 'card'");
        aggregateQueryStr.append((CharSequence)queryStrGroup);
        aggregateQueryStr.append(" union ");
        aggregateQueryStr.append((CharSequence)onlineQueryStr);
        aggregateQueryStr.append(" AND EGF_INSTRUMENTTYPE.TYPE = 'online'");
        aggregateQueryStr.append((CharSequence)queryStrGroup);
        StringBuilder finalQueryStr = new StringBuilder();
        finalQueryStr.append("SELECT cast(sum(cashCount) AS NUMERIC) AS cashCount,cast(sum(chequeddCount) AS NUMERIC) AS chequeddCount,cast(sum(onlineCount) AS NUMERIC) AS onlineCount,SOURCE,counterName,employeeName,glCode,cast(sum(cashAmount) AS DOUBLE PRECISION) AS cashAmount, cast(sum(chequeddAmount) AS DOUBLE PRECISION) AS chequeddAmount,   cast(sum(cardCount) AS NUMERIC) AS cardCount,cast(sum(cardAmount) AS DOUBLE PRECISION) AS cardAmount ,   cast(sum(totalReceiptCount) AS NUMERIC) as totalReceiptCount, cast(sum(onlineAmount) AS DOUBLE PRECISION) AS onlineAmount ,USERID FROM (");
        finalQueryStr.append((CharSequence)queryStr).append(" ) AS RESULT GROUP BY RESULT.SOURCE,RESULT.counterName,RESULT.employeeName,RESULT.USERID,RESULT.glCode order by SOURCE,employeeName,glCode");
        StringBuilder finalAggregateQryStr = new StringBuilder();
        finalAggregateQryStr.append("SELECT sum(cashCount) AS cashCount,sum(chequeddCount) AS chequeddCount,sum(onlineCount) AS onlineCount,SOURCE,counterName,employeeName,glCode,sum(cashAmount) AS cashAmount, sum(chequeddAmount) AS chequeddAmount,    sum(cardCount) AS cardCount, sum(cardAmount) AS cardAmount, cast(sum(totalReceiptCount) AS NUMERIC) as totalReceiptCount , sum(onlineAmount) AS onlineAmount ,USERID FROM (");
        finalAggregateQryStr.append((CharSequence)aggregateQueryStr).append(" ) AS RESULT GROUP BY RESULT.SOURCE,RESULT.counterName,RESULT.employeeName,RESULT.USERID,RESULT.glCode order by source,employeeName, glCode");
        SQLQuery query = (SQLQuery)this.getCurrentSession().createSQLQuery(finalQueryStr.toString()).addScalar("cashCount", (Type)StringType.INSTANCE).addScalar("cashAmount", (Type)DoubleType.INSTANCE).addScalar("chequeddCount", (Type)StringType.INSTANCE).addScalar("chequeddAmount", (Type)DoubleType.INSTANCE).addScalar("onlineCount", (Type)StringType.INSTANCE).addScalar("onlineAmount", (Type)DoubleType.INSTANCE).addScalar("source", (Type)StringType.INSTANCE).addScalar("counterName", (Type)StringType.INSTANCE).addScalar("employeeName", (Type)StringType.INSTANCE).addScalar("glCode", (Type)StringType.INSTANCE).addScalar("cardAmount", (Type)DoubleType.INSTANCE).addScalar("cardCount", (Type)StringType.INSTANCE).addScalar("totalReceiptCount", (Type)StringType.INSTANCE).setResultTransformer(Transformers.aliasToBean(CollectionSummaryHeadWiseReport.class));
        SQLQuery aggrQuery = (SQLQuery)this.getCurrentSession().createSQLQuery(finalAggregateQryStr.toString()).addScalar("cashCount", (Type)StringType.INSTANCE).addScalar("cashAmount", (Type)DoubleType.INSTANCE).addScalar("chequeddCount", (Type)StringType.INSTANCE).addScalar("chequeddAmount", (Type)DoubleType.INSTANCE).addScalar("onlineCount", (Type)StringType.INSTANCE).addScalar("onlineAmount", (Type)DoubleType.INSTANCE).addScalar("source", (Type)StringType.INSTANCE).addScalar("counterName", (Type)StringType.INSTANCE).addScalar("employeeName", (Type)StringType.INSTANCE).addScalar("glCode", (Type)StringType.INSTANCE).addScalar("cardAmount", (Type)DoubleType.INSTANCE).addScalar("cardCount", (Type)StringType.INSTANCE).addScalar("totalReceiptCount", (Type)StringType.INSTANCE).setResultTransformer(Transformers.aliasToBean(CollectionSummaryHeadWiseReport.class));
        if (!source.isEmpty() && !source.equals("ALL")) {
            query.setString("source", source);
            aggrQuery.setString("source", source);
        }
        if (glCode != null) {
            query.setString("glCode", glCode);
            aggrQuery.setString("glCode", glCode);
        }
        if (status != -1) {
            query.setLong("searchStatus", (long)status);
            aggrQuery.setLong("searchStatus", (long)status);
        }
        if (StringUtils.isNotBlank((String)paymentMode) && !paymentMode.equals("ALL")) {
            if (paymentMode.equals("cheque/dd")) {
                query.setParameterList("paymentMode", new ArrayList<String>(Arrays.asList("cheque", "dd")));
                aggrQuery.setParameterList("paymentMode", new ArrayList<String>(Arrays.asList("cheque", "dd")));
            } else {
                query.setString("paymentMode", paymentMode);
                aggrQuery.setString("paymentMode", paymentMode);
            }
        }
        List<CollectionSummaryHeadWiseReport> reportResults = this.populateQueryResults(query.list());
        List<CollectionSummaryHeadWiseReport> aggrReportResults = this.populateQueryResults(aggrQuery.list());
        CollectionSummaryHeadWiseReportResult collResult = new CollectionSummaryHeadWiseReportResult();
        collResult.setCollectionSummaryReportList(reportResults);
        collResult.setAggrCollectionSummaryReportList(aggrReportResults);
        return collResult;
    }

    public List<CollectionSummaryHeadWiseReport> populateQueryResults(List<CollectionSummaryHeadWiseReport> queryResults) {
        for (CollectionSummaryHeadWiseReport collectionSummaryHeadWiseReport : queryResults) {
            if (collectionSummaryHeadWiseReport.getCashCount() == null) {
                collectionSummaryHeadWiseReport.setCashCount("");
            }
            if (collectionSummaryHeadWiseReport.getChequeddCount() == null) {
                collectionSummaryHeadWiseReport.setChequeddCount("");
            }
            if (collectionSummaryHeadWiseReport.getOnlineCount() == null) {
                collectionSummaryHeadWiseReport.setOnlineCount("");
            }
            if (collectionSummaryHeadWiseReport.getCardCount() == null) {
                collectionSummaryHeadWiseReport.setCardCount("");
            }
            if (collectionSummaryHeadWiseReport.getTotalReceiptCount() == null) {
                collectionSummaryHeadWiseReport.setTotalReceiptCount("");
            }
            if (collectionSummaryHeadWiseReport.getCashAmount() == null) {
                collectionSummaryHeadWiseReport.setCashAmount(new Double(0.0));
            }
            if (collectionSummaryHeadWiseReport.getChequeddAmount() == null) {
                collectionSummaryHeadWiseReport.setChequeddAmount(new Double(0.0));
            }
            if (collectionSummaryHeadWiseReport.getOnlineAmount() == null) {
                collectionSummaryHeadWiseReport.setOnlineAmount(new Double(0.0));
            }
            if (collectionSummaryHeadWiseReport.getCardAmount() == null) {
                collectionSummaryHeadWiseReport.setCardAmount(new Double(0.0));
            }
            new Double(0.0);
            collectionSummaryHeadWiseReport.getOnlineAmount();
            collectionSummaryHeadWiseReport.setTotalAmount(Double.sum(collectionSummaryHeadWiseReport.getCardAmount(), Double.sum(collectionSummaryHeadWiseReport.getChequeddAmount(), collectionSummaryHeadWiseReport.getCashAmount())));
        }
        return queryResults;
    }
}

