/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.service;

import org.egov.collection.entity.CollectionIndex;
import org.egov.collection.repository.CollectionIndexRepository;
import org.egov.collection.service.elasticsearch.CollectionDocumentService;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CollectionIndexService {
    private CollectionIndexRepository collectionIndexRepository;
    private final CollectionDocumentService collectionDocumentService;
    @Autowired
    private CityService cityService;

    @Autowired
    public CollectionIndexService(CollectionIndexRepository collectionIndexRepository, CollectionDocumentService collectionDocumentService) {
        this.collectionIndexRepository = collectionIndexRepository;
        this.collectionDocumentService = collectionDocumentService;
    }

    @Transactional
    public CollectionIndex persistCollectionIndex(CollectionIndex collectionIndex) {
        this.collectionIndexRepository.save((Object)collectionIndex);
        this.collectionDocumentService.persistCollectionDocument(collectionIndex);
        return collectionIndex;
    }

    @Transactional
    public CollectionIndex pushCollectionIndex(CollectionIndex collectionIndex) {
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        collectionIndex.setCityName(cityWebsite.getName());
        if (cityWebsite.getDistrictName() != null) {
            collectionIndex.setDistrictName(cityWebsite.getDistrictName());
        }
        if (cityWebsite.getRegionName() != null) {
            collectionIndex.setRegionName(cityWebsite.getRegionName());
        }
        if (cityWebsite.getGrade() != null) {
            collectionIndex.setCityGrade(cityWebsite.getGrade());
        }
        if (cityWebsite.getCode() != null) {
            collectionIndex.setCityCode(cityWebsite.getCode());
        }
        this.collectionIndexRepository.save((Object)collectionIndex);
        this.collectionDocumentService.persistCollectionDocument(collectionIndex);
        return collectionIndex;
    }
}

