/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.integration.services;

import java.util.List;
import java.util.Map;
import org.egov.collection.constants.CollectionConstants;
import org.egov.collection.entity.RemittanceInstrument;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.collection.utils.FinancialsUtil;
import org.egov.commons.Bankaccount;
import org.egov.commons.CVoucherHeader;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.model.instrument.InstrumentType;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Service
public class RemittanceSchedulerService {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    @Qualifier(value="remittanceInstrumentService")
    private PersistenceService<RemittanceInstrument, Long> remittanceInstrumentService;
    @Autowired
    private FinancialsUtil financialsUtil;
    @Autowired
    private CollectionsUtil collectionsUtil;

    @Transactional
    public void remittanceInstrumentProcess(String instrumentType, Integer modulo) {
        block9: {
            StringBuilder queryString = new StringBuilder(200);
            queryString.append("select rt from org.egov.collection.entity.RemittanceInstrument rt where rt.reconciled=false and rt.instrumentHeader.instrumentType.type=:instType").append(" and MOD(rt.id, ").append(CollectionConstants.QUARTZ_BULKBILL_JOBS).append(") = :modulo ");
            Query qry = this.persistenceService.getSession().createQuery(queryString.toString()).setMaxResults(500);
            qry.setParameter("instType", (Object)instrumentType);
            qry.setParameter("modulo", (Object)modulo);
            List reconcileList = qry.list();
            Boolean voucherTypeForChequeDDCard = false;
            if (this.collectionsUtil.getAppConfigValue("Collection", "REMITTANCEVOUCHERTYPEFORCHEQUEDDCARD").equals("Receipt")) {
                voucherTypeForChequeDDCard = true;
            }
            Map<String, Object> instrumentDepositMap = this.financialsUtil.prepareForUpdateInstrumentDepositSQL();
            if (reconcileList.isEmpty()) break block9;
            if (instrumentType.equals("cash")) {
                for (RemittanceInstrument remittanceInstrument : reconcileList) {
                    if (remittanceInstrument.getRemittance().getVoucherHeader().getId() != null) {
                        Map<String, Object> cashMap = this.constructInstrumentMap(instrumentDepositMap, remittanceInstrument.getRemittance().getBankAccount(), remittanceInstrument.getInstrumentHeader(), remittanceInstrument.getRemittance().getVoucherHeader());
                        this.financialsUtil.updateCashDeposit(cashMap, remittanceInstrument.getRemittance().getVoucherHeader(), remittanceInstrument.getInstrumentHeader(), remittanceInstrument.getRemittance().getBankAccount());
                    }
                    remittanceInstrument.setReconciled(Boolean.TRUE);
                    this.remittanceInstrumentService.persist((Object)remittanceInstrument);
                }
            } else {
                for (RemittanceInstrument bankRemit : reconcileList) {
                    if (bankRemit.getRemittance().getVoucherHeader().getId() != null) {
                        Map<String, Object> chequeMap = this.constructInstrumentMap(instrumentDepositMap, bankRemit.getRemittance().getBankAccount(), bankRemit.getInstrumentHeader(), bankRemit.getRemittance().getVoucherHeader());
                        if (voucherTypeForChequeDDCard.booleanValue()) {
                            this.financialsUtil.updateCheque_DD_Card_Deposit_Receipt(chequeMap);
                        } else {
                            this.financialsUtil.updateCheque_DD_Card_Deposit(chequeMap, bankRemit.getRemittance().getVoucherHeader(), bankRemit.getInstrumentHeader(), bankRemit.getRemittance().getBankAccount());
                        }
                    }
                    bankRemit.setReconciled(Boolean.TRUE);
                    this.remittanceInstrumentService.persist((Object)bankRemit);
                }
            }
        }
    }

    private Map<String, Object> constructInstrumentMap(Map<String, Object> instrumentDepositMap, Bankaccount bankaccount, InstrumentHeader instrumentHeader, CVoucherHeader voucherHeader) {
        InstrumentType instrumentType = (InstrumentType)this.persistenceService.find("select it from InstrumentType it,InstrumentHeader ih where ih.instrumentType=it.id and ih.id=?", new Object[]{instrumentHeader.getId()});
        instrumentDepositMap.put("instrumentheader", instrumentHeader.getId());
        instrumentDepositMap.put("bankaccountid", bankaccount.getId());
        instrumentDepositMap.put("instrumentamount", instrumentHeader.getInstrumentAmount());
        instrumentDepositMap.put("instrumenttype", instrumentType.getType());
        instrumentDepositMap.put("depositdate", voucherHeader.getVoucherDate());
        instrumentDepositMap.put("createdby", voucherHeader.getCreatedBy().getId());
        instrumentDepositMap.put("ispaycheque", instrumentHeader.getIsPayCheque());
        instrumentDepositMap.put("payinid", voucherHeader.getId());
        return instrumentDepositMap;
    }
}

