/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.integration.pgi;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.collection.config.properties.CollectionApplicationProperties;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.integration.pgi.DefaultPaymentRequest;
import org.egov.collection.integration.pgi.DefaultPaymentResponse;
import org.egov.collection.integration.pgi.PaymentGatewayAdaptor;
import org.egov.collection.integration.pgi.PaymentRequest;
import org.egov.collection.integration.pgi.PaymentResponse;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.models.ServiceDetails;
import org.springframework.beans.factory.annotation.Autowired;

public class SbimopsAdaptor
implements PaymentGatewayAdaptor {
    private static final Logger LOGGER = Logger.getLogger(SbimopsAdaptor.class);
    @Autowired
    private CollectionApplicationProperties collectionApplicationProperties;
    private static final String SBIMOPS_HOAPREFIX = "NVN";
    private static final String SBIMOPS_PMD = "P";

    @Override
    public PaymentRequest createPaymentRequest(ServiceDetails paymentServiceDetails, ReceiptHeader receiptHeader) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)" Inside SbimopsAdaptor-createPaymentRequest ");
        }
        DefaultPaymentRequest sbiPaymentRequest = new DefaultPaymentRequest();
        sbiPaymentRequest.setParameter("MD", SBIMOPS_PMD);
        sbiPaymentRequest.setParameter("deptcode", ApplicationThreadLocals.getCityCode());
        sbiPaymentRequest.setParameter("ddocode", this.collectionApplicationProperties.sbimopsDdocode(ApplicationThreadLocals.getCityCode()).toString());
        StringBuilder hoa = new StringBuilder(this.collectionApplicationProperties.sbimopsHoa(ApplicationThreadLocals.getCityCode()));
        int hoaLength = hoa.length() + 3;
        while (hoaLength < 22) {
            hoa.append("0");
            hoaLength = hoa.length() + 3;
        }
        hoa.append(SBIMOPS_HOAPREFIX);
        sbiPaymentRequest.setParameter("depttransid", receiptHeader.getId().toString());
        sbiPaymentRequest.setParameter("remittersname", receiptHeader.getConsumerCode());
        sbiPaymentRequest.setParameter("tamount", receiptHeader.getTotalAmount());
        sbiPaymentRequest.setParameter("uamount", new BigDecimal(0));
        sbiPaymentRequest.setParameter("bankname", "SBIMOPS");
        sbiPaymentRequest.setParameter("hoa", hoa);
        StringBuilder returnUrl = new StringBuilder(paymentServiceDetails.getCallBackurl());
        returnUrl.append("?paymentServiceId=").append(paymentServiceDetails.getId());
        sbiPaymentRequest.setParameter("dru", returnUrl.toString());
        sbiPaymentRequest.setParameter("paymentGatewayURL", paymentServiceDetails.getServiceUrl());
        Map requestParameters = sbiPaymentRequest.getRequestParameters();
        LOGGER.info((Object)("MD=" + requestParameters.get("MD") + "|" + "deptcode" + "=" + requestParameters.get("deptcode") + "|" + "ddocode" + "=" + requestParameters.get("ddocode") + "|" + "hoa" + "=" + requestParameters.get("hoa") + "|" + "depttransid" + "=" + requestParameters.get("depttransid") + "|" + "remittersname" + "=" + requestParameters.get("remittersname") + "|" + "tamount" + "=" + requestParameters.get("tamount") + "|" + "dru" + "=" + requestParameters.get("dru") + "|" + "paymentGatewayURL" + "=" + requestParameters.get("paymentGatewayURL")));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"End SbimopsAdaptor-createPaymentRequest");
        }
        return sbiPaymentRequest;
    }

    @Override
    public PaymentResponse parsePaymentResponse(String response) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Insider SbimopsAdaptor-parsePaymentResponse");
        }
        DefaultPaymentResponse sbiPaymentResponse = new DefaultPaymentResponse();
        HashMap fields = new HashMap(0);
        sbiPaymentResponse.setAuthStatus(((String)fields.get("bankstatus")).equalsIgnoreCase("Success") ? "0300" : (String)fields.get("bankstatus"));
        sbiPaymentResponse.setErrorDescription((String)fields.get("bankstatus"));
        sbiPaymentResponse.setReceiptId((String)fields.get("depttransid"));
        sbiPaymentResponse.setAdditionalInfo6((String)fields.get("remittersname"));
        sbiPaymentResponse.setTxnAmount(new BigDecimal((String)fields.get("bankamount")));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("", Locale.getDefault());
        Date transDate = null;
        try {
            transDate = simpleDateFormat.parse((String)fields.get("bankdate"));
            sbiPaymentResponse.setTxnDate(transDate);
        }
        catch (ParseException e) {
            LOGGER.error((Object)("Error in parsing transaction date [" + (String)fields.get("bankdate") + "]"), (Throwable)e);
            throw new ApplicationRuntimeException(".transactiondate.parse.error", (Throwable)e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"End SbimopsAdaptor-parsePaymentResponse");
        }
        return sbiPaymentResponse;
    }
}

