/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.entity;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.egov.collection.entity.Challan;
import org.egov.collection.entity.OnlinePayment;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.entity.ReceiptMisc;
import org.egov.collection.entity.ReceiptVoucher;
import org.egov.commons.EgwStatus;
import org.egov.infra.admin.master.entity.Location;
import org.egov.infra.persistence.entity.Auditable;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infstr.models.ServiceDetails;
import org.egov.model.instrument.InstrumentHeader;

public class ReceiptHeader
extends StateAware
implements Auditable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private ReceiptHeader receiptHeader;
    private Set<ReceiptHeader> receiptHeaders = new HashSet<ReceiptHeader>(0);
    private String referencenumber;
    private Date referencedate;
    private String consumerCode;
    private String referenceDesc;
    private char receipttype;
    private String receiptnumber;
    private Date receiptdate;
    private String manualreceiptnumber;
    private Date manualreceiptdate;
    private Boolean isModifiable;
    private ServiceDetails service;
    private Character collectiontype;
    private Set<ReceiptDetail> receiptDetails = new LinkedHashSet<ReceiptDetail>(0);
    private ReceiptMisc receiptMisc;
    private Set<InstrumentHeader> receiptInstrument = new HashSet<InstrumentHeader>(0);
    private Set<ReceiptVoucher> receiptVoucher = new HashSet<ReceiptVoucher>(0);
    private Location location;
    private Boolean isReconciled;
    private EgwStatus status;
    private String reasonForCancellation;
    private String paidBy;
    private Boolean overrideAccountHeads;
    private Boolean partPaymentAllowed;
    private Boolean callbackForApportioning;
    private String collModesNotAllwd;
    private String displayMsg;
    private BigDecimal totalAmount;
    private BigDecimal minimumAmount;
    private BigDecimal totalAmountToBeCollected;
    private Date voucherDate;
    private String voucherNum;
    private OnlinePayment onlinePayment;
    private Challan challan;
    private String payeeName;
    private String payeeAddress;
    private String workflowUserName = "NA";
    private String instrumentsAsString;
    private String source;
    private String remittanceReferenceNumber;
    private String payeeEmail;
    private String consumerType;

    public ReceiptHeader() {
    }

    public ReceiptHeader(String referencenumber, Date referencedate, String consumerCode, String referenceDesc, BigDecimal totalAmount, BigDecimal minimumAmount, Boolean partPaymentAllowed, Boolean overrideAccountHeadsAllowed, Boolean callbackForApportioning, String displayMsg, ServiceDetails service, String collModesNotAllwd, String payeeName, String payeeAddress, String payeeEmail, String consumerType) {
        this.referencenumber = referencenumber;
        this.referencedate = referencedate;
        this.consumerCode = consumerCode;
        this.referenceDesc = referenceDesc;
        this.totalAmount = totalAmount;
        this.minimumAmount = minimumAmount;
        this.partPaymentAllowed = partPaymentAllowed;
        this.overrideAccountHeads = overrideAccountHeadsAllowed;
        this.callbackForApportioning = callbackForApportioning;
        this.displayMsg = displayMsg;
        this.service = service;
        this.collModesNotAllwd = collModesNotAllwd;
        this.payeeName = payeeName;
        this.payeeAddress = payeeAddress;
        this.payeeEmail = payeeEmail;
        this.consumerType = consumerType;
    }

    public ReceiptHeader(Boolean isReconciled, Boolean isModifiable, char receiptType, Character collectionType, String paidBy, ServiceDetails serviceDetails, String referencenumber, String referenceDesc, BigDecimal totalAmount) {
        this.isReconciled = isReconciled;
        this.isModifiable = isModifiable;
        this.receipttype = receiptType;
        this.collectiontype = collectionType;
        this.paidBy = paidBy;
        this.service = serviceDetails;
        this.referencenumber = referencenumber;
        this.referenceDesc = referenceDesc;
        this.totalAmount = totalAmount;
    }

    public String getReferencenumber() {
        return this.referencenumber;
    }

    public void setReferencenumber(String referencenumber) {
        this.referencenumber = referencenumber;
    }

    public Date getReferencedate() {
        return null == this.referencedate ? null : this.referencedate;
    }

    public void setReferencedate(Date referencedate) {
        this.referencedate = referencedate;
    }

    public String getReferenceDesc() {
        return this.referenceDesc;
    }

    public void setReferenceDesc(String referenceDesc) {
        this.referenceDesc = referenceDesc;
    }

    public char getReceipttype() {
        return this.receipttype;
    }

    public void setReceipttype(char receipttype) {
        this.receipttype = receipttype;
    }

    public String getReceiptnumber() {
        return this.receiptnumber;
    }

    public void setReceiptnumber(String receiptnumber) {
        this.receiptnumber = receiptnumber;
    }

    public String getManualreceiptnumber() {
        return this.manualreceiptnumber;
    }

    public void setManualreceiptnumber(String manualreceiptnumber) {
        this.manualreceiptnumber = manualreceiptnumber;
    }

    public Date getManualreceiptdate() {
        return null == this.manualreceiptdate ? null : this.manualreceiptdate;
    }

    public void setManualreceiptdate(Date manualreceiptdate) {
        this.manualreceiptdate = manualreceiptdate;
    }

    public Boolean getIsModifiable() {
        return this.isModifiable;
    }

    public void setIsModifiable(Boolean isModifiable) {
        this.isModifiable = isModifiable;
    }

    public ServiceDetails getService() {
        return this.service;
    }

    public void setService(ServiceDetails service) {
        this.service = service;
    }

    public Character getCollectiontype() {
        return this.collectiontype;
    }

    public void setCollectiontype(Character collectiontype) {
        this.collectiontype = collectiontype;
    }

    public Set<ReceiptDetail> getReceiptDetails() {
        return this.receiptDetails;
    }

    public void setReceiptDetails(Set<ReceiptDetail> receiptDetails) {
        this.receiptDetails = receiptDetails;
    }

    public void addReceiptDetail(ReceiptDetail receiptDetail) {
        this.getReceiptDetails().add(receiptDetail);
    }

    public Date getReceiptDate() {
        return this.getCreatedDate();
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public String getInstrumentType() {
        if (!this.receiptInstrument.isEmpty()) {
            return this.receiptInstrument.iterator().next().getInstrumentType().getType();
        }
        return "";
    }

    public void addInstrument(InstrumentHeader instrumentMaster) {
        this.receiptInstrument.add(instrumentMaster);
    }

    public Set<InstrumentHeader> getReceiptInstrument() {
        return this.receiptInstrument;
    }

    public void setReceiptInstrument(Set<InstrumentHeader> receiptInstrument) {
        this.receiptInstrument = receiptInstrument;
    }

    public List<InstrumentHeader> getInstruments(String type) {
        ArrayList<InstrumentHeader> instrumentList = new ArrayList<InstrumentHeader>(0);
        for (InstrumentHeader instrument : this.getReceiptInstrument()) {
            if (!type.equals(instrument.getInstrumentType().getType())) continue;
            instrumentList.add(instrument);
        }
        return instrumentList;
    }

    public Set<ReceiptVoucher> getReceiptVoucher() {
        return this.receiptVoucher;
    }

    public void setReceiptVoucher(Set<ReceiptVoucher> receiptVoucher) {
        this.receiptVoucher = receiptVoucher;
    }

    public void addReceiptVoucher(ReceiptVoucher receiptVoucher) {
        this.receiptVoucher.add(receiptVoucher);
    }

    public Boolean getIsReconciled() {
        return this.isReconciled;
    }

    public void setIsReconciled(Boolean isReconciled) {
        this.isReconciled = isReconciled;
    }

    public EgwStatus getStatus() {
        return this.status;
    }

    public void setStatus(EgwStatus status) {
        this.status = status;
    }

    public String getReasonForCancellation() {
        return this.reasonForCancellation;
    }

    public void setReasonForCancellation(String reasonforcancellation) {
        this.reasonForCancellation = reasonforcancellation;
    }

    public ReceiptMisc getReceiptMisc() {
        return this.receiptMisc;
    }

    public void setReceiptMisc(ReceiptMisc receiptMisc) {
        this.receiptMisc = receiptMisc;
    }

    public String getPaidBy() {
        return this.paidBy;
    }

    public void setPaidBy(String paidBy) {
        this.paidBy = paidBy;
    }

    public Boolean getOverrideAccountHeads() {
        return this.overrideAccountHeads;
    }

    public void setOverrideAccountHeads(Boolean overrideAccountHeads) {
        this.overrideAccountHeads = overrideAccountHeads;
    }

    public Boolean getCallbackForApportioning() {
        return this.callbackForApportioning;
    }

    public void setCallbackForApportioning(Boolean callbackForApportioning) {
        this.callbackForApportioning = callbackForApportioning;
    }

    public Boolean getPartPaymentAllowed() {
        return this.partPaymentAllowed;
    }

    public void setPartPaymentAllowed(Boolean partPaymentAllowed) {
        this.partPaymentAllowed = partPaymentAllowed;
    }

    public String myLinkId() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy", Locale.getDefault());
        StringBuilder linkId = new StringBuilder();
        linkId.append(this.getCurrentState().getNextAction()).append("-").append(this.service.getCode()).append("-").append(this.getCreatedBy().getUsername()).append("-").append(sdf.format(this.getReceiptdate())).append(this.location == null ? "" : "-" + this.location.getId()).append("-").append(this.receipttype);
        return linkId.toString();
    }

    public String myLinkIdForChallanMisc() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy", Locale.getDefault());
        StringBuilder linkId = new StringBuilder();
        linkId.append(this.getCurrentState().getNextAction()).append("-").append(this.getCreatedBy().getUsername()).append("-").append(sdf.format(this.getReceiptdate())).append(this.location == null ? "" : "-" + this.location.getId());
        return linkId.toString();
    }

    public String getStateDetails() {
        return this.service.getName() + "-" + this.getCreatedBy().getUsername() + (this.location == null ? "" : "-" + this.location.getName());
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getMinimumAmount() {
        return this.minimumAmount;
    }

    public void setMinimumAmount(BigDecimal minimumAmount) {
        this.minimumAmount = minimumAmount;
    }

    public String getDisplayMsg() {
        return this.displayMsg;
    }

    public void setDisplayMsg(String displayMsg) {
        this.displayMsg = displayMsg;
    }

    public BigDecimal getTotalAmountToBeCollected() {
        return this.totalAmountToBeCollected;
    }

    public void setTotalAmountToBeCollected(BigDecimal totalAmountToBeCollected) {
        this.totalAmountToBeCollected = totalAmountToBeCollected;
    }

    public Date getVoucherDate() {
        return null == this.voucherDate ? null : this.voucherDate;
    }

    public void setVoucherDate(Date voucherDate) {
        this.voucherDate = voucherDate;
    }

    public String getVoucherNum() {
        return this.voucherNum;
    }

    public void setVoucherNum(String voucherNum) {
        this.voucherNum = voucherNum;
    }

    public String getCollModesNotAllwd() {
        return this.collModesNotAllwd;
    }

    public void setCollModesNotAllwd(String collModesNotAllwd) {
        this.collModesNotAllwd = collModesNotAllwd;
    }

    public String getConsumerCode() {
        return this.consumerCode;
    }

    public void setConsumerCode(String consumerCode) {
        this.consumerCode = consumerCode;
    }

    public String toString() {
        String str = "ReceiptHeader( Id : " + this.getId() + "ReceiptNo: " + this.receiptnumber + ",totalAmount : " + this.totalAmount + ",referencenumber: " + this.referencenumber + ",paidBy: " + this.paidBy + ",service: " + this.service + ",receiptMisc: " + this.receiptMisc + ",receiptDetails " + this.receiptDetails + " , Challan : " + (Object)((Object)this.challan) + "]";
        return str;
    }

    public OnlinePayment getOnlinePayment() {
        return this.onlinePayment;
    }

    public void setOnlinePayment(OnlinePayment onlinePayment) {
        this.onlinePayment = onlinePayment;
    }

    public Challan getChallan() {
        return this.challan;
    }

    public void setChallan(Challan challan) {
        this.challan = challan;
    }

    public ReceiptHeader getReceiptHeader() {
        return this.receiptHeader;
    }

    public void setReceiptHeader(ReceiptHeader receiptHeader) {
        this.receiptHeader = receiptHeader;
    }

    public Set<ReceiptHeader> getReceiptHeaders() {
        return this.receiptHeaders;
    }

    public void setReceiptHeaders(Set<ReceiptHeader> receiptHeaders) {
        this.receiptHeaders = receiptHeaders;
    }

    public String getReceiptChallanNumber() {
        String stringObj = null;
        if (this.receipttype == 'C') {
            if (this.getChallan() == null) {
                Set<ReceiptHeader> receiptHeadersSet = this.getReceiptHeaders();
                Iterator<ReceiptHeader> iter = receiptHeadersSet.iterator();
                while (iter.hasNext()) {
                    ReceiptHeader receiptHeaderObj = iter.next();
                    if (receiptHeaderObj.getChallan() == null) {
                        receiptHeadersSet = receiptHeaderObj.getReceiptHeaders();
                        iter = receiptHeadersSet.iterator();
                        continue;
                    }
                    stringObj = receiptHeaderObj.getChallan().getChallanNumber();
                    break;
                }
            } else {
                stringObj = this.getChallan().getChallanNumber();
            }
        }
        return stringObj;
    }

    public String getPayeeName() {
        return this.payeeName;
    }

    public void setPayeeName(String payeeName) {
        this.payeeName = payeeName;
    }

    public String getPayeeAddress() {
        return this.payeeAddress;
    }

    public void setPayeeAddress(String payeeAddress) {
        this.payeeAddress = payeeAddress;
    }

    public Date getReceiptdate() {
        return null == this.receiptdate ? null : this.receiptdate;
    }

    public void setReceiptdate(Date receiptdate) {
        this.receiptdate = receiptdate;
    }

    public void setWorkflowUserName(String workflowUserName) {
        this.workflowUserName = workflowUserName;
    }

    public String getWorkflowUserName() {
        return this.workflowUserName;
    }

    public String getInstrumentsAsString() {
        return this.instrumentsAsString;
    }

    public void setInstrumentsAsString(String instrumentsAsString) {
        this.instrumentsAsString = instrumentsAsString;
    }

    public String getInstrumentDetailAsString() {
        StringBuilder instrumentDetailsBuilder = new StringBuilder();
        for (InstrumentHeader instrument : this.receiptInstrument) {
            if (instrumentDetailsBuilder.length() > 0) {
                instrumentDetailsBuilder.append(", ");
            }
            String instrumentType = instrument.getInstrumentType().getType();
            instrumentDetailsBuilder.append(instrumentType);
            if (instrumentType.equals("dd") || instrumentType.equals("cheque") || instrumentType.equals("card")) {
                instrumentDetailsBuilder.append(" # " + instrument.getInstrumentNumber());
            }
            if (instrumentType.equals("bankchallan") || instrumentType.equals("online")) {
                instrumentDetailsBuilder.append(" # " + instrument.getTransactionNumber());
            }
            if (instrumentType.equals("dd") || instrumentType.equals("cheque")) {
                instrumentDetailsBuilder.append(" - " + new SimpleDateFormat("dd/MM/yyyy", Locale.getDefault()).format(instrument.getInstrumentDate()));
            }
            instrumentDetailsBuilder.append(" - " + instrument.getInstrumentAmount().setScale(2, 4));
        }
        return instrumentDetailsBuilder.toString();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getRemittanceReferenceNumber() {
        return this.remittanceReferenceNumber;
    }

    public void setRemittanceReferenceNumber(String remittanceReferenceNumber) {
        this.remittanceReferenceNumber = remittanceReferenceNumber;
    }

    public String getPayeeEmail() {
        return this.payeeEmail;
    }

    public void setPayeeEmail(String payeeEmail) {
        this.payeeEmail = payeeEmail;
    }

    public String getConsumerType() {
        return this.consumerType;
    }

    public void setConsumerType(String consumerType) {
        this.consumerType = consumerType;
    }
}

