/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.service.CollectionRemittanceService;
import org.egov.collection.service.ReceiptHeaderService;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.collection.utils.FinancialsUtil;
import org.egov.commons.Bankaccount;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.EgwStatus;
import org.egov.commons.entity.Source;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.models.ServiceDetails;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.instrument.InstrumentHeader;
import org.hibernate.SQLQuery;
import org.springframework.transaction.annotation.Transactional;

public class CollectionRemittanceServiceImpl
extends CollectionRemittanceService {
    private static final long serialVersionUID = 5581301494846870670L;
    private static final Logger LOGGER = Logger.getLogger(ReceiptHeaderService.class);
    private CollectionsUtil collectionsUtil;
    private FinancialsUtil financialsUtil;
    private ReceiptHeaderService receiptHeaderService;
    private PersistenceService persistenceService;

    @Override
    @Transactional
    public List<ReceiptHeader> createBankRemittance(String[] serviceNameArr, String[] totalCashAmount, String[] totalChequeAmount, String[] totalCardAmount, String[] totalOnlineAmount, String[] receiptDateArray, String[] fundCodeArray, String[] departmentCodeArray, Integer accountNumberId, Integer positionUser, String[] receiptNumberArray, Date remittanceDate) {
        ArrayList<ReceiptHeader> bankRemittanceList = new ArrayList<ReceiptHeader>(0);
        SimpleDateFormat dateFomatter = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        Map<String, Object> instrumentDepositeMap = this.financialsUtil.prepareForUpdateInstrumentDepositSQL();
        String instrumentGlCodeQueryString = "SELECT COA.GLCODE FROM CHARTOFACCOUNTS COA,EGF_INSTRUMENTACCOUNTCODES IAC,EGF_INSTRUMENTTYPE IT WHERE IT.ID=IAC.TYPEID AND IAC.GLCODEID=COA.ID AND IT.TYPE=";
        String receiptInstrumentQueryString = "select DISTINCT (instruments) from org.egov.collection.entity.ReceiptHeader receipt join receipt.receiptInstrument as instruments where ";
        String serviceNameCondition = "receipt.service.name=? ";
        String receiptDateCondition = "and date(receipt.receiptdate)=? ";
        String instrumentStatusCondition = "and instruments.statusId.id=? ";
        String instrumentTypeCondition = "and instruments.instrumentType.type = ? ";
        String receiptFundCondition = "and receipt.receiptMisc.fund.code = ? ";
        String receiptDepartmentCondition = "and receipt.receiptMisc.department.code = ? ";
        String receiptSourceCondition = "and receipt.source = ? ";
        String cashInHandQueryString = "SELECT COA.GLCODE FROM CHARTOFACCOUNTS COA,EGF_INSTRUMENTACCOUNTCODES IAC,EGF_INSTRUMENTTYPE IT WHERE IT.ID=IAC.TYPEID AND IAC.GLCODEID=COA.ID AND IT.TYPE='cash'";
        String chequeInHandQueryString = "SELECT COA.GLCODE FROM CHARTOFACCOUNTS COA,EGF_INSTRUMENTACCOUNTCODES IAC,EGF_INSTRUMENTTYPE IT WHERE IT.ID=IAC.TYPEID AND IAC.GLCODEID=COA.ID AND IT.TYPE='cheque'";
        String cardPaymentQueryString = "SELECT COA.GLCODE FROM CHARTOFACCOUNTS COA,EGF_INSTRUMENTACCOUNTCODES IAC,EGF_INSTRUMENTTYPE IT WHERE IT.ID=IAC.TYPEID AND IAC.GLCODEID=COA.ID AND IT.TYPE='card'";
        String onlinePaymentQueryString = "SELECT COA.GLCODE FROM CHARTOFACCOUNTS COA,EGF_INSTRUMENTACCOUNTCODES IAC,EGF_INSTRUMENTTYPE IT WHERE IT.ID=IAC.TYPEID AND IAC.GLCODEID=COA.ID AND IT.TYPE='online'";
        SQLQuery cashInHand = this.persistenceService.getSession().createSQLQuery("SELECT COA.GLCODE FROM CHARTOFACCOUNTS COA,EGF_INSTRUMENTACCOUNTCODES IAC,EGF_INSTRUMENTTYPE IT WHERE IT.ID=IAC.TYPEID AND IAC.GLCODEID=COA.ID AND IT.TYPE='cash'");
        SQLQuery chequeInHand = this.persistenceService.getSession().createSQLQuery("SELECT COA.GLCODE FROM CHARTOFACCOUNTS COA,EGF_INSTRUMENTACCOUNTCODES IAC,EGF_INSTRUMENTTYPE IT WHERE IT.ID=IAC.TYPEID AND IAC.GLCODEID=COA.ID AND IT.TYPE='cheque'");
        SQLQuery cardPaymentAccount = this.persistenceService.getSession().createSQLQuery("SELECT COA.GLCODE FROM CHARTOFACCOUNTS COA,EGF_INSTRUMENTACCOUNTCODES IAC,EGF_INSTRUMENTTYPE IT WHERE IT.ID=IAC.TYPEID AND IAC.GLCODEID=COA.ID AND IT.TYPE='card'");
        SQLQuery onlinePaymentAccount = this.persistenceService.getSession().createSQLQuery("SELECT COA.GLCODE FROM CHARTOFACCOUNTS COA,EGF_INSTRUMENTACCOUNTCODES IAC,EGF_INSTRUMENTTYPE IT WHERE IT.ID=IAC.TYPEID AND IAC.GLCODEID=COA.ID AND IT.TYPE='online'");
        String cashInHandGLCode = null;
        String chequeInHandGlcode = null;
        String cardPaymentGlCode = null;
        String onlinePaymentGlCode = null;
        String voucherWorkflowMsg = "Voucher Workflow Started";
        String createVoucher = this.collectionsUtil.getAppConfigValue("Collection", "CREATEVOUCHER_FOR_REMITTANCE");
        String functionCode = this.collectionsUtil.getAppConfigValue("Collection", "COLLECTION_BANKREMITTANCE_FUNCTIONCODE");
        EgwStatus instrmentStatusNew = this.collectionsUtil.getStatusForModuleAndCode("Instrument", "New");
        EgwStatus receiptStatusRemitted = this.collectionsUtil.getReceiptStatusForCode("REMITTED");
        if (!cashInHand.list().isEmpty()) {
            cashInHandGLCode = cashInHand.list().get(0).toString();
        }
        if (!chequeInHand.list().isEmpty()) {
            chequeInHandGlcode = chequeInHand.list().get(0).toString();
        }
        if (!cardPaymentAccount.list().isEmpty()) {
            cardPaymentGlCode = cardPaymentAccount.list().get(0).toString();
        }
        if (!onlinePaymentAccount.list().isEmpty()) {
            onlinePaymentGlCode = onlinePaymentAccount.list().get(0).toString();
        }
        Boolean voucherTypeForChequeDDCard = false;
        if (this.collectionsUtil.getAppConfigValue("Collection", "REMITTANCEVOUCHERTYPEFORCHEQUEDDCARD").equals("Receipt")) {
            voucherTypeForChequeDDCard = true;
        }
        EgwStatus instrumentStatusDeposited = this.collectionsUtil.getStatusForModuleAndCode("Instrument", "Deposited");
        Date voucherDate = null;
        for (int i = 0; i < serviceNameArr.length; ++i) {
            HashMap<String, Object> accountcodedetailsCreditOnlineHashMap;
            ArrayList<HashMap<String, Object>> accountCodeOnlineList;
            StringBuilder onlineQueryBuilder;
            List<ReceiptHeader> receiptHeaders;
            HashMap<String, Object> accountcodedetailsDebitHashMap;
            Object headerdetails;
            Object[] arguments;
            String serviceName = serviceNameArr[i].trim();
            if (this.collectionsUtil.getAppConfigValue("Collection", "COLLECTION_BANKREMITTANCE_SHOWREMITDATE").equals("Y") && remittanceDate != null) {
                voucherDate = remittanceDate;
            } else {
                try {
                    voucherDate = this.collectionsUtil.getRemittanceVoucherDate(dateFomatter.parse(receiptDateArray[i]));
                }
                catch (ParseException e) {
                    LOGGER.error((Object)"Error Parsing Date", (Throwable)e);
                }
            }
            if (serviceName == null || serviceName.length() <= 0) continue;
            Bankaccount depositedBankAccount = (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{accountNumberId.longValue()});
            ServiceDetails serviceDetails = (ServiceDetails)this.persistenceService.findByNamedQuery("getServicesByName", new Object[]{serviceName});
            String serviceGlCode = depositedBankAccount.getChartofaccounts().getGlcode();
            if (totalCashAmount[i].trim() != null && totalCashAmount[i].trim().length() > 0 && cashInHandGLCode != null) {
                StringBuilder cashQueryBuilder = new StringBuilder("select DISTINCT (instruments) from org.egov.collection.entity.ReceiptHeader receipt join receipt.receiptInstrument as instruments where ");
                cashQueryBuilder.append("receipt.service.name=? ");
                cashQueryBuilder.append("and date(receipt.receiptdate)=? ");
                cashQueryBuilder.append("and instruments.statusId.id=? ");
                cashQueryBuilder.append("and instruments.instrumentType.type = ? ");
                cashQueryBuilder.append("and receipt.receiptMisc.fund.code = ? ");
                cashQueryBuilder.append("and receipt.receiptMisc.department.code = ? ");
                cashQueryBuilder.append("and receipt.status.id=(select id from org.egov.commons.EgwStatus where moduletype=? and code=?) ");
                cashQueryBuilder.append("and receipt.source = ? ");
                arguments = new Object[9];
                CVoucherHeader voucherHeaderCash = null;
                arguments[0] = serviceName;
                try {
                    arguments[1] = dateFomatter.parse(receiptDateArray[i]);
                }
                catch (ParseException exp) {
                    LOGGER.debug((Object)("Exception in parsing date  " + receiptDateArray[i] + " - " + exp.getMessage()));
                    throw new ApplicationRuntimeException("Exception while parsing date", (Throwable)exp);
                }
                arguments[2] = instrmentStatusNew.getId();
                arguments[3] = "cash";
                arguments[4] = fundCodeArray[i];
                arguments[5] = departmentCodeArray[i];
                arguments[6] = "ReceiptHeader";
                arguments[7] = "APPROVED";
                arguments[8] = Source.SYSTEM.toString();
                List instrumentHeaderListCash = this.persistenceService.findAllBy(cashQueryBuilder.toString(), arguments);
                if ("Y".equalsIgnoreCase(createVoucher) && serviceDetails.getVoucherCreation().booleanValue()) {
                    headerdetails = new HashMap<String, String>(0);
                    ((HashMap)headerdetails).put("vouchername", "Pay in slip");
                    ((HashMap)headerdetails).put("vouchertype", "Contra");
                    ((HashMap)headerdetails).put("description", "Collection Module");
                    ((HashMap)headerdetails).put("voucherdate", voucherDate);
                    ((HashMap)headerdetails).put("fundcode", fundCodeArray[i]);
                    ((HashMap)headerdetails).put("departmentcode", "ACC");
                    ((HashMap)headerdetails).put("fundsourcecode", serviceDetails.getFundSource() == null ? null : serviceDetails.getFundSource().getCode());
                    ((HashMap)headerdetails).put("functionarycode", serviceDetails.getFunctionary() == null ? null : serviceDetails.getFunctionary().getCode());
                    ((HashMap)headerdetails).put("moduleid", "10");
                    ((HashMap)headerdetails).put("moduleid", "10");
                    ArrayList<HashMap<String, Object>> accountCodeCashList = new ArrayList<HashMap<String, Object>>(0);
                    HashMap<String, Object> accountcodedetailsCreditCashHashMap = new HashMap<String, Object>(0);
                    accountcodedetailsCreditCashHashMap.put("glcode", cashInHandGLCode);
                    accountcodedetailsCreditCashHashMap.put("functioncode", functionCode);
                    accountcodedetailsCreditCashHashMap.put("creditamount", totalCashAmount[i]);
                    accountcodedetailsCreditCashHashMap.put("debitamount", 0);
                    accountCodeCashList.add(accountcodedetailsCreditCashHashMap);
                    accountcodedetailsDebitHashMap = new HashMap(0);
                    accountcodedetailsDebitHashMap.put("glcode", serviceGlCode);
                    accountcodedetailsDebitHashMap.put("functioncode", functionCode);
                    accountcodedetailsDebitHashMap.put("creditamount", 0);
                    accountcodedetailsDebitHashMap.put("debitamount", totalCashAmount[i]);
                    accountCodeCashList.add(accountcodedetailsDebitHashMap);
                    voucherHeaderCash = this.financialsUtil.createRemittanceVoucher((HashMap<String, Object>)headerdetails, accountCodeCashList, new ArrayList<HashMap<String, Object>>(0));
                    this.receiptHeaderService.updateCashRemittance(instrumentDepositeMap, "Voucher Workflow Started", voucherDate, depositedBankAccount, serviceGlCode, instrumentHeaderListCash, voucherHeaderCash);
                } else {
                    this.financialsUtil.updateInstrumentHeader(instrumentHeaderListCash, instrumentStatusDeposited, depositedBankAccount);
                }
                for (InstrumentHeader instHead : instrumentHeaderListCash) {
                    receiptHeaders = this.persistenceService.findAllByNamedQuery("RECEIPTS_BY_INSTRUMENTHEADER_AND_SERVICECODE", new Object[]{instHead.getId(), serviceDetails.getCode()});
                    if (voucherHeaderCash != null) {
                        receiptHeaders = this.receiptHeaderService.setVoucherNumber(receiptHeaders, voucherHeaderCash);
                    }
                    bankRemittanceList.addAll(receiptHeaders);
                }
            }
            if (totalChequeAmount[i].trim() != null && totalChequeAmount[i].trim().length() > 0 && chequeInHandGlcode != null) {
                StringBuilder chequeQueryBuilder = new StringBuilder("select DISTINCT (instruments) from org.egov.collection.entity.ReceiptHeader receipt join receipt.receiptInstrument as instruments where ");
                chequeQueryBuilder.append("receipt.service.name=? ");
                chequeQueryBuilder.append("and date(receipt.receiptdate)=? ");
                chequeQueryBuilder.append("and instruments.statusId.id=? ");
                chequeQueryBuilder.append("and instruments.instrumentType.type in ( ?, ?)");
                chequeQueryBuilder.append("and receipt.status.id=(select id from org.egov.commons.EgwStatus where moduletype=? and code=?) ");
                chequeQueryBuilder.append("and receipt.receiptMisc.fund.code = ? ");
                chequeQueryBuilder.append("and receipt.receiptMisc.department.code = ? ");
                chequeQueryBuilder.append("and receipt.source = ? ");
                arguments = new Object[10];
                arguments[0] = serviceName;
                try {
                    arguments[1] = dateFomatter.parse(receiptDateArray[i]);
                }
                catch (ParseException exp) {
                    LOGGER.debug((Object)("Exception in parsing date  " + receiptDateArray[i] + " - " + exp.getMessage()));
                    throw new ApplicationRuntimeException("Exception while parsing date", (Throwable)exp);
                }
                arguments[2] = instrmentStatusNew.getId();
                arguments[3] = "cheque";
                arguments[4] = "dd";
                arguments[5] = "ReceiptHeader";
                arguments[6] = "APPROVED";
                arguments[7] = fundCodeArray[i];
                arguments[8] = departmentCodeArray[i];
                arguments[9] = Source.SYSTEM.toString();
                CVoucherHeader voucherHeaderCheque = null;
                List instrumentHeaderListCheque = this.persistenceService.findAllBy(chequeQueryBuilder.toString(), arguments);
                if ("Y".equalsIgnoreCase(createVoucher) && serviceDetails.getVoucherCreation().booleanValue()) {
                    headerdetails = new HashMap(0);
                    ArrayList<HashMap<String, Object>> accountCodeChequeList = new ArrayList<HashMap<String, Object>>(0);
                    HashMap<String, Object> accountcodedetailsCreditChequeHashMap = new HashMap<String, Object>(0);
                    if (voucherTypeForChequeDDCard.booleanValue()) {
                        ((HashMap)headerdetails).put("vouchername", "Other receipts");
                        ((HashMap)headerdetails).put("vouchertype", "Receipt");
                    } else {
                        ((HashMap)headerdetails).put("vouchername", "Pay in slip");
                        ((HashMap)headerdetails).put("vouchertype", "Contra");
                    }
                    ((HashMap)headerdetails).put("vouchername", "Pay in slip");
                    ((HashMap)headerdetails).put("vouchertype", "Contra");
                    ((HashMap)headerdetails).put("description", "Collection Module");
                    ((HashMap)headerdetails).put("voucherdate", voucherDate);
                    ((HashMap)headerdetails).put("fundcode", fundCodeArray[i]);
                    ((HashMap)headerdetails).put("departmentcode", "ACC");
                    ((HashMap)headerdetails).put("fundsourcecode", serviceDetails.getFundSource() == null ? null : serviceDetails.getFundSource().getCode());
                    ((HashMap)headerdetails).put("functionarycode", serviceDetails.getFunctionary() == null ? null : serviceDetails.getFunctionary().getCode());
                    ((HashMap)headerdetails).put("moduleid", "10");
                    accountcodedetailsCreditChequeHashMap.put("glcode", chequeInHandGlcode);
                    accountcodedetailsCreditChequeHashMap.put("functioncode", functionCode);
                    accountcodedetailsCreditChequeHashMap.put("creditamount", totalChequeAmount[i]);
                    accountcodedetailsCreditChequeHashMap.put("debitamount", 0);
                    accountCodeChequeList.add(accountcodedetailsCreditChequeHashMap);
                    accountcodedetailsDebitHashMap = new HashMap(0);
                    accountcodedetailsDebitHashMap.put("glcode", serviceGlCode);
                    accountcodedetailsDebitHashMap.put("functioncode", functionCode);
                    accountcodedetailsDebitHashMap.put("creditamount", 0);
                    accountcodedetailsDebitHashMap.put("debitamount", totalChequeAmount[i]);
                    accountCodeChequeList.add(accountcodedetailsDebitHashMap);
                    voucherHeaderCheque = this.financialsUtil.createRemittanceVoucher((HashMap<String, Object>)headerdetails, accountCodeChequeList, new ArrayList<HashMap<String, Object>>(0));
                    this.receiptHeaderService.updateChequeCardRemittance(instrumentDepositeMap, "Voucher Workflow Started", voucherTypeForChequeDDCard, voucherDate, depositedBankAccount, serviceGlCode, instrumentHeaderListCheque, voucherHeaderCheque);
                } else {
                    this.financialsUtil.updateInstrumentHeader(instrumentHeaderListCheque, instrumentStatusDeposited, depositedBankAccount);
                }
                for (InstrumentHeader instHead : instrumentHeaderListCheque) {
                    receiptHeaders = this.persistenceService.findAllByNamedQuery("RECEIPTS_BY_INSTRUMENTHEADER_AND_SERVICECODE", new Object[]{instHead.getId(), serviceDetails.getCode()});
                    if (voucherHeaderCheque != null) {
                        receiptHeaders = this.receiptHeaderService.setVoucherNumber(receiptHeaders, voucherHeaderCheque);
                    }
                    bankRemittanceList.addAll(receiptHeaders);
                }
            }
            if (totalCardAmount[i].trim() != null && totalCardAmount[i].trim().length() > 0 && cardPaymentGlCode != null) {
                onlineQueryBuilder = new StringBuilder("select DISTINCT (instruments) from org.egov.collection.entity.ReceiptHeader receipt join receipt.receiptInstrument as instruments where ");
                onlineQueryBuilder.append("receipt.service.name=? ");
                onlineQueryBuilder.append("and date(receipt.receiptdate)=? ");
                onlineQueryBuilder.append("and instruments.statusId.id=? ");
                onlineQueryBuilder.append("and instruments.instrumentType.type = ? ");
                onlineQueryBuilder.append("and receipt.receiptMisc.fund.code = ? ");
                onlineQueryBuilder.append("and receipt.receiptMisc.department.code = ? ");
                arguments = new Object[7];
                arguments[0] = serviceName;
                try {
                    arguments[1] = dateFomatter.parse(receiptDateArray[i]);
                }
                catch (ParseException exp) {
                    LOGGER.debug((Object)("Exception in parsing date  " + receiptDateArray[i] + " - " + exp.getMessage()));
                    throw new ApplicationRuntimeException("Exception while parsing date", (Throwable)exp);
                }
                arguments[2] = instrmentStatusNew.getId();
                arguments[3] = "card";
                arguments[4] = fundCodeArray[i];
                arguments[5] = departmentCodeArray[i];
                CVoucherHeader voucherHeaderCard = null;
                List instrumentHeaderListOnline = this.persistenceService.findAllBy(onlineQueryBuilder.toString(), arguments);
                if ("Y".equalsIgnoreCase(createVoucher) && serviceDetails.getVoucherCreation().booleanValue()) {
                    headerdetails = new HashMap(0);
                    if (voucherTypeForChequeDDCard.booleanValue()) {
                        ((HashMap)headerdetails).put("vouchername", "Other receipts");
                        ((HashMap)headerdetails).put("vouchertype", "Receipt");
                    } else {
                        ((HashMap)headerdetails).put("vouchername", "Pay in slip");
                        ((HashMap)headerdetails).put("vouchertype", "Contra");
                    }
                    ((HashMap)headerdetails).put("vouchername", "Pay in slip");
                    ((HashMap)headerdetails).put("vouchertype", "Contra");
                    ((HashMap)headerdetails).put("description", "Collection Module");
                    ((HashMap)headerdetails).put("voucherdate", voucherDate);
                    ((HashMap)headerdetails).put("fundcode", fundCodeArray[i]);
                    ((HashMap)headerdetails).put("departmentcode", "ACC");
                    ((HashMap)headerdetails).put("fundsourcecode", serviceDetails.getFundSource() == null ? null : serviceDetails.getFundSource().getCode());
                    ((HashMap)headerdetails).put("functionarycode", serviceDetails.getFunctionary() == null ? null : serviceDetails.getFunctionary().getCode());
                    ((HashMap)headerdetails).put("moduleid", "10");
                    accountCodeOnlineList = new ArrayList<HashMap<String, Object>>(0);
                    accountcodedetailsCreditOnlineHashMap = new HashMap<String, Object>(0);
                    accountcodedetailsCreditOnlineHashMap.put("glcode", cardPaymentGlCode);
                    accountcodedetailsCreditOnlineHashMap.put("functioncode", functionCode);
                    accountcodedetailsCreditOnlineHashMap.put("creditamount", totalCardAmount[i]);
                    accountcodedetailsCreditOnlineHashMap.put("debitamount", 0);
                    accountCodeOnlineList.add(accountcodedetailsCreditOnlineHashMap);
                    accountcodedetailsDebitHashMap = new HashMap<String, Object>(0);
                    accountcodedetailsDebitHashMap.put("glcode", serviceGlCode);
                    accountcodedetailsDebitHashMap.put("functioncode", functionCode);
                    accountcodedetailsDebitHashMap.put("creditamount", 0);
                    accountcodedetailsDebitHashMap.put("debitamount", totalCardAmount[i]);
                    accountCodeOnlineList.add(accountcodedetailsDebitHashMap);
                    voucherHeaderCard = this.financialsUtil.createRemittanceVoucher((HashMap<String, Object>)headerdetails, accountCodeOnlineList, new ArrayList<HashMap<String, Object>>(0));
                    this.receiptHeaderService.updateChequeCardRemittance(instrumentDepositeMap, "Voucher Workflow Started", voucherTypeForChequeDDCard, voucherDate, depositedBankAccount, serviceGlCode, instrumentHeaderListOnline, voucherHeaderCard);
                } else {
                    this.financialsUtil.updateInstrumentHeader(instrumentHeaderListOnline, instrumentStatusDeposited, depositedBankAccount);
                }
                for (InstrumentHeader instHead : instrumentHeaderListOnline) {
                    receiptHeaders = this.persistenceService.findAllByNamedQuery("RECEIPTS_BY_INSTRUMENTHEADER_AND_SERVICECODE", new Object[]{instHead.getId(), serviceDetails.getCode()});
                    if (voucherHeaderCard != null) {
                        receiptHeaders = this.receiptHeaderService.setVoucherNumber(receiptHeaders, voucherHeaderCard);
                    }
                    bankRemittanceList.addAll(receiptHeaders);
                }
            }
            if (totalOnlineAmount[i].trim() == null || totalOnlineAmount[i].trim().length() <= 0 || onlinePaymentGlCode == null) continue;
            onlineQueryBuilder = new StringBuilder("select DISTINCT (instruments) from org.egov.collection.entity.ReceiptHeader receipt join receipt.receiptInstrument as instruments where ");
            onlineQueryBuilder.append("receipt.service.name=? ");
            onlineQueryBuilder.append("and date(receipt.receiptdate)=? ");
            onlineQueryBuilder.append("and instruments.statusId.id=? ");
            onlineQueryBuilder.append("and instruments.instrumentType.type = ? ");
            onlineQueryBuilder.append("and receipt.receiptMisc.fund.code = ? ");
            onlineQueryBuilder.append("and receipt.receiptMisc.department.code = ? ");
            onlineQueryBuilder.append("and receipt.source = ? ");
            arguments = new Object[6];
            arguments[0] = serviceName;
            try {
                arguments[1] = dateFomatter.parse(receiptDateArray[i]);
            }
            catch (ParseException exp) {
                LOGGER.debug((Object)("Exception in parsing date  " + receiptDateArray[i] + " - " + exp.getMessage()));
                throw new ApplicationRuntimeException("Exception while parsing date", (Throwable)exp);
            }
            arguments[2] = instrmentStatusNew.getId();
            arguments[3] = "online";
            arguments[4] = fundCodeArray[i];
            arguments[5] = departmentCodeArray[i];
            arguments[6] = Source.SYSTEM.toString();
            List instrumentHeaderListOnline = this.persistenceService.findAllBy(onlineQueryBuilder.toString(), arguments);
            CVoucherHeader voucherHeaderCard = null;
            if ("Y".equalsIgnoreCase(createVoucher) && serviceDetails.getVoucherCreation().booleanValue()) {
                headerdetails = new HashMap<String, String>(0);
                if (voucherTypeForChequeDDCard.booleanValue()) {
                    ((HashMap)headerdetails).put("vouchername", "Other receipts");
                    ((HashMap)headerdetails).put("vouchertype", "Receipt");
                } else {
                    ((HashMap)headerdetails).put("vouchername", "Pay in slip");
                    ((HashMap)headerdetails).put("vouchertype", "Contra");
                }
                ((HashMap)headerdetails).put("vouchername", "Pay in slip");
                ((HashMap)headerdetails).put("vouchertype", "Contra");
                ((HashMap)headerdetails).put("description", "Collection Module");
                ((HashMap)headerdetails).put("voucherdate", voucherDate);
                ((HashMap)headerdetails).put("fundcode", fundCodeArray[i]);
                ((HashMap)headerdetails).put("departmentcode", "ACC");
                ((HashMap)headerdetails).put("fundsourcecode", serviceDetails.getFundSource() == null ? null : serviceDetails.getFundSource().getCode());
                ((HashMap)headerdetails).put("functionarycode", serviceDetails.getFunctionary() == null ? null : serviceDetails.getFunctionary().getCode());
                ((HashMap)headerdetails).put("moduleid", "10");
                accountCodeOnlineList = new ArrayList(0);
                accountcodedetailsCreditOnlineHashMap = new HashMap(0);
                accountcodedetailsCreditOnlineHashMap.put("glcode", onlinePaymentGlCode);
                accountcodedetailsCreditOnlineHashMap.put("functioncode", functionCode);
                accountcodedetailsCreditOnlineHashMap.put("creditamount", totalOnlineAmount[i]);
                accountcodedetailsCreditOnlineHashMap.put("debitamount", 0);
                accountCodeOnlineList.add(accountcodedetailsCreditOnlineHashMap);
                accountcodedetailsDebitHashMap = new HashMap(0);
                accountcodedetailsDebitHashMap.put("glcode", serviceGlCode);
                accountcodedetailsDebitHashMap.put("functioncode", functionCode);
                accountcodedetailsDebitHashMap.put("creditamount", 0);
                accountcodedetailsDebitHashMap.put("debitamount", totalOnlineAmount[i]);
                accountCodeOnlineList.add(accountcodedetailsDebitHashMap);
                voucherHeaderCard = this.financialsUtil.createRemittanceVoucher((HashMap<String, Object>)headerdetails, accountCodeOnlineList, new ArrayList<HashMap<String, Object>>(0));
                this.receiptHeaderService.updateChequeCardRemittance(instrumentDepositeMap, "Voucher Workflow Started", voucherTypeForChequeDDCard, voucherDate, depositedBankAccount, serviceGlCode, instrumentHeaderListOnline, voucherHeaderCard);
            } else {
                this.financialsUtil.updateInstrumentHeader(instrumentHeaderListOnline, instrumentStatusDeposited, depositedBankAccount);
            }
            for (InstrumentHeader instHead : instrumentHeaderListOnline) {
                receiptHeaders = this.persistenceService.findAllByNamedQuery("RECEIPTS_BY_INSTRUMENTHEADER_AND_SERVICECODE", new Object[]{instHead.getId(), serviceDetails.getCode()});
                if (voucherHeaderCard != null) {
                    receiptHeaders = this.receiptHeaderService.setVoucherNumber(receiptHeaders, voucherHeaderCard);
                }
                bankRemittanceList.addAll(receiptHeaders);
            }
        }
        ArrayList<ReceiptHeader> bankRemitList = new ArrayList<ReceiptHeader>();
        for (ReceiptHeader receiptHeader : bankRemittanceList) {
            receiptHeader.setStatus(receiptStatusRemitted);
            if (!bankRemitList.contains((Object)receiptHeader)) {
                bankRemitList.add(receiptHeader);
            }
            this.persistenceService.update((Object)receiptHeader);
            this.persistenceService.getSession().flush();
        }
        return bankRemitList;
    }

    @Override
    public List<HashMap<String, Object>> findAllRemittanceDetailsForServiceAndFund(String boundaryIdList, String serviceCodes, String fundCodes, Date startDate, Date endDate) {
        ArrayList<HashMap<String, Object>> paramList = new ArrayList<HashMap<String, Object>>();
        String queryBuilder = "SELECT sum(ih.instrumentamount) as INSTRUMENTMAOUNT,date(ch.RECEIPTDATE) AS RECEIPTDATE,sd.NAME as SERVICENAME,it.TYPE as INSTRUMENTTYPE,fnd.name AS FUNDNAME,dpt.name AS DEPARTMENTNAME,fnd.code AS FUNDCODE,dpt.code AS DEPARTMENTCODE from EGCL_COLLECTIONHEADER ch,EGF_INSTRUMENTHEADER ih,EGCL_COLLECTIONINSTRUMENT ci,EGCL_SERVICEDETAILS sd,EGF_INSTRUMENTTYPE it,EGCL_COLLECTIONMIS cm,FUND fnd,EG_DEPARTMENT dpt";
        String whereClauseBeforInstumentType = " where ch.id=cm.collectionheader AND fnd.id=cm.fund AND dpt.id=cm.department and ci.INSTRUMENTHEADER=ih.ID and ch.SERVICEDETAILS=sd.ID and ch.ID=ci.COLLECTIONHEADER and ih.INSTRUMENTTYPE=it.ID and ";
        String whereClauseForServiceAndFund = " sd.code in (" + serviceCodes + ")" + " and fnd.code in (" + fundCodes + ")" + " and ";
        String whereClause = " AND ih.ID_STATUS=(select id from egw_status where moduletype='Instrument' and description='New') and ih.ISPAYCHEQUE='0' and ch.STATUS=(select id from egw_status where moduletype='ReceiptHeader' and code='APPROVED')  AND ch.source='" + Source.SYSTEM + "' ";
        if (startDate != null && endDate != null) {
            whereClause = whereClause + " AND ch.receiptdate between '" + startDate + "' and '" + endDate + "' ";
        }
        String groupByClause = " group by date(ch.RECEIPTDATE),sd.NAME,it.TYPE,fnd.name,dpt.name,fnd.code,dpt.code";
        String orderBy = " order by RECEIPTDATE";
        StringBuilder queryStringForCashChequeDDCard = new StringBuilder("SELECT sum(ih.instrumentamount) as INSTRUMENTMAOUNT,date(ch.RECEIPTDATE) AS RECEIPTDATE,sd.NAME as SERVICENAME,it.TYPE as INSTRUMENTTYPE,fnd.name AS FUNDNAME,dpt.name AS DEPARTMENTNAME,fnd.code AS FUNDCODE,dpt.code AS DEPARTMENTCODE from EGCL_COLLECTIONHEADER ch,EGF_INSTRUMENTHEADER ih,EGCL_COLLECTIONINSTRUMENT ci,EGCL_SERVICEDETAILS sd,EGF_INSTRUMENTTYPE it,EGCL_COLLECTIONMIS cm,FUND fnd,EG_DEPARTMENT dpt,egeis_jurisdiction ujl where ch.id=cm.collectionheader AND fnd.id=cm.fund AND dpt.id=cm.department and ci.INSTRUMENTHEADER=ih.ID and ch.SERVICEDETAILS=sd.ID and ch.ID=ci.COLLECTIONHEADER and ih.INSTRUMENTTYPE=it.ID and " + whereClauseForServiceAndFund + "it.TYPE in ('" + "cash" + "','" + "cheque" + "'," + "'" + "dd" + "','" + "card" + "') " + whereClause + "AND ch.CREATEDBY=ujl.employee and ujl.boundary in (" + boundaryIdList + ")" + " group by date(ch.RECEIPTDATE),sd.NAME,it.TYPE,fnd.name,dpt.name,fnd.code,dpt.code");
        User citizenUser = this.collectionsUtil.getUserByUserName("9999999999");
        if (boundaryIdList != null && citizenUser != null) {
            String queryStringForOnline = " union SELECT sum(ih.instrumentamount) as INSTRUMENTMAOUNT,date(ch.RECEIPTDATE) AS RECEIPTDATE,sd.NAME as SERVICENAME,it.TYPE as INSTRUMENTTYPE,fnd.name AS FUNDNAME,dpt.name AS DEPARTMENTNAME,fnd.code AS FUNDCODE,dpt.code AS DEPARTMENTCODE from EGCL_COLLECTIONHEADER ch,EGF_INSTRUMENTHEADER ih,EGCL_COLLECTIONINSTRUMENT ci,EGCL_SERVICEDETAILS sd,EGF_INSTRUMENTTYPE it,EGCL_COLLECTIONMIS cm,FUND fnd,EG_DEPARTMENT dpt where ch.id=cm.collectionheader AND fnd.id=cm.fund AND dpt.id=cm.department and ci.INSTRUMENTHEADER=ih.ID and ch.SERVICEDETAILS=sd.ID and ch.ID=ci.COLLECTIONHEADER and ih.INSTRUMENTTYPE=it.ID and " + whereClauseForServiceAndFund + "it.TYPE='" + "online" + "'" + whereClause + "AND ch.CREATEDBY=" + citizenUser.getId() + " group by date(ch.RECEIPTDATE),sd.NAME,it.TYPE,fnd.name,dpt.name,fnd.code,dpt.code";
            queryStringForCashChequeDDCard.append(queryStringForOnline);
        }
        SQLQuery query = this.receiptHeaderService.getSession().createSQLQuery(queryStringForCashChequeDDCard.toString() + " order by RECEIPTDATE");
        List queryResults = query.list();
        for (int i = 0; i < queryResults.size(); ++i) {
            Object[] arrayObjectInitialIndex = (Object[])queryResults.get(i);
            HashMap objHashMap = new HashMap(0);
            if (i == 0) {
                objHashMap.put("RECEIPTDATE", arrayObjectInitialIndex[1]);
                objHashMap.put("SERVICENAME", arrayObjectInitialIndex[2]);
                objHashMap.put("FUNDNAME", arrayObjectInitialIndex[4]);
                objHashMap.put("DEPARTMENTNAME", arrayObjectInitialIndex[5]);
                objHashMap.put("FUNDCODE", arrayObjectInitialIndex[6]);
                objHashMap.put("DEPARTMENTCODE", arrayObjectInitialIndex[7]);
                if (arrayObjectInitialIndex[3].equals("cash")) {
                    objHashMap.put("SERVICETOTALCASHAMOUNT", arrayObjectInitialIndex[0]);
                    objHashMap.put("SERVICETOTALCHEQUEAMOUNT", "");
                    objHashMap.put("SERVICETOTALCARDPAYMENTAMOUNT", "");
                    objHashMap.put("SERVICETOTALONLINEPAYMENTAMOUNT", "");
                }
                if (arrayObjectInitialIndex[3].equals("cheque") || arrayObjectInitialIndex[3].equals("dd")) {
                    objHashMap.put("SERVICETOTALCASHAMOUNT", "");
                    objHashMap.put("SERVICETOTALCHEQUEAMOUNT", arrayObjectInitialIndex[0]);
                    objHashMap.put("SERVICETOTALCARDPAYMENTAMOUNT", "");
                    objHashMap.put("SERVICETOTALONLINEPAYMENTAMOUNT", "");
                }
                if (arrayObjectInitialIndex[3].equals("card")) {
                    objHashMap.put("SERVICETOTALCASHAMOUNT", "");
                    objHashMap.put("SERVICETOTALCHEQUEAMOUNT", "");
                    objHashMap.put("SERVICETOTALCARDPAYMENTAMOUNT", arrayObjectInitialIndex[0]);
                    objHashMap.put("SERVICETOTALONLINEPAYMENTAMOUNT", "");
                }
                if (arrayObjectInitialIndex[3].equals("online")) {
                    objHashMap.put("SERVICETOTALCASHAMOUNT", "");
                    objHashMap.put("SERVICETOTALCHEQUEAMOUNT", "");
                    objHashMap.put("SERVICETOTALCARDPAYMENTAMOUNT", "");
                    objHashMap.put("SERVICETOTALONLINEPAYMENTAMOUNT", arrayObjectInitialIndex[0]);
                }
            } else {
                int checknew = this.receiptHeaderService.checkIfMapObjectExist(paramList, arrayObjectInitialIndex);
                if (checknew == -1) {
                    objHashMap.put("RECEIPTDATE", arrayObjectInitialIndex[1]);
                    objHashMap.put("SERVICENAME", arrayObjectInitialIndex[2]);
                    objHashMap.put("FUNDNAME", arrayObjectInitialIndex[4]);
                    objHashMap.put("DEPARTMENTNAME", arrayObjectInitialIndex[5]);
                    objHashMap.put("FUNDCODE", arrayObjectInitialIndex[6]);
                    objHashMap.put("DEPARTMENTCODE", arrayObjectInitialIndex[7]);
                    if (arrayObjectInitialIndex[3].equals("cash")) {
                        objHashMap.put("SERVICETOTALCASHAMOUNT", arrayObjectInitialIndex[0]);
                        objHashMap.put("SERVICETOTALCHEQUEAMOUNT", "");
                        objHashMap.put("SERVICETOTALCARDPAYMENTAMOUNT", "");
                        objHashMap.put("SERVICETOTALONLINEPAYMENTAMOUNT", "");
                    }
                    if (arrayObjectInitialIndex[3].equals("cheque") || arrayObjectInitialIndex[3].equals("dd")) {
                        objHashMap.put("SERVICETOTALCASHAMOUNT", "");
                        objHashMap.put("SERVICETOTALCHEQUEAMOUNT", arrayObjectInitialIndex[0]);
                        objHashMap.put("SERVICETOTALCARDPAYMENTAMOUNT", "");
                        objHashMap.put("SERVICETOTALONLINEPAYMENTAMOUNT", "");
                    }
                    if (arrayObjectInitialIndex[3].equals("card")) {
                        objHashMap.put("SERVICETOTALCASHAMOUNT", "");
                        objHashMap.put("SERVICETOTALCHEQUEAMOUNT", "");
                        objHashMap.put("SERVICETOTALCARDPAYMENTAMOUNT", arrayObjectInitialIndex[0]);
                        objHashMap.put("SERVICETOTALONLINEPAYMENTAMOUNT", "");
                    }
                    if (arrayObjectInitialIndex[3].equals("online")) {
                        objHashMap.put("SERVICETOTALCASHAMOUNT", "");
                        objHashMap.put("SERVICETOTALCHEQUEAMOUNT", "");
                        objHashMap.put("SERVICETOTALCARDPAYMENTAMOUNT", "");
                        objHashMap.put("SERVICETOTALONLINEPAYMENTAMOUNT", arrayObjectInitialIndex[0]);
                    }
                } else {
                    objHashMap = (HashMap)paramList.get(checknew);
                    paramList.remove(checknew);
                    if (arrayObjectInitialIndex[3].equals("cash")) {
                        objHashMap.put("SERVICETOTALCASHAMOUNT", arrayObjectInitialIndex[0]);
                    }
                    if (arrayObjectInitialIndex[3].equals("cheque") || arrayObjectInitialIndex[3].equals("dd")) {
                        BigDecimal existingAmount = BigDecimal.ZERO;
                        if (objHashMap.get("SERVICETOTALCHEQUEAMOUNT") != "") {
                            existingAmount = new BigDecimal(objHashMap.get("SERVICETOTALCHEQUEAMOUNT").toString());
                        }
                        existingAmount = existingAmount.add(new BigDecimal(arrayObjectInitialIndex[0].toString()));
                        objHashMap.put("SERVICETOTALCHEQUEAMOUNT", existingAmount);
                    }
                    if (arrayObjectInitialIndex[3].equals("card")) {
                        objHashMap.put("SERVICETOTALCARDPAYMENTAMOUNT", arrayObjectInitialIndex[0]);
                    }
                    if (arrayObjectInitialIndex[3].equals("online")) {
                        objHashMap.put("SERVICETOTALONLINEPAYMENTAMOUNT", arrayObjectInitialIndex[0]);
                    }
                }
            }
            if (objHashMap.get("RECEIPTDATE") == null || objHashMap.get("SERVICENAME") == null) continue;
            paramList.add(objHashMap);
        }
        return paramList;
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    public void setFinancialsUtil(FinancialsUtil financialsUtil) {
        this.financialsUtil = financialsUtil;
    }

    public void setReceiptHeaderService(ReceiptHeaderService receiptHeaderService) {
        this.receiptHeaderService = receiptHeaderService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }
}

