/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.integration.pgi;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.representation.Form;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.ws.rs.core.MediaType;
import org.apache.log4j.Logger;
import org.egov.collection.config.properties.CollectionApplicationProperties;
import org.egov.collection.constants.CollectionConstants;
import org.egov.collection.entity.OnlinePayment;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.integration.pgi.DefaultPaymentRequest;
import org.egov.collection.integration.pgi.DefaultPaymentResponse;
import org.egov.collection.integration.pgi.PaymentGatewayAdaptor;
import org.egov.collection.integration.pgi.PaymentRequest;
import org.egov.collection.integration.pgi.PaymentResponse;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.models.ServiceDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AxisAdaptor
implements PaymentGatewayAdaptor {
    private static final Logger LOGGER = Logger.getLogger(AxisAdaptor.class);
    @Autowired
    private EntityManager entityManager;
    @Autowired
    private CollectionApplicationProperties collectionApplicationProperties;
    public static final BigDecimal PAISE_RUPEE_CONVERTER = new BigDecimal(100);
    @Autowired
    private CityService cityService;

    @Override
    public PaymentRequest createPaymentRequest(ServiceDetails paymentServiceDetails, ReceiptHeader receiptHeader) {
        DefaultPaymentRequest paymentRequest = new DefaultPaymentRequest();
        LOGGER.debug((Object)"inside createPaymentRequest");
        HashMap<String, String> fields = new HashMap<String, String>(0);
        fields.put("vpc_Version", this.collectionApplicationProperties.axisVersion().toString());
        fields.put("vpc_Command", this.collectionApplicationProperties.axisCommand());
        fields.put("vpc_AccessCode", this.collectionApplicationProperties.axisAccessCode());
        fields.put("vpc_MerchTxnRef", ApplicationThreadLocals.getCityCode() + "-" + receiptHeader.getId().toString());
        fields.put("vpc_Merchant", this.collectionApplicationProperties.axisMerchant());
        fields.put("vpc_Locale", this.collectionApplicationProperties.axisLocale());
        fields.put("vpc_TicketNumber", receiptHeader.getConsumerCode());
        fields.put("vpc_OrderInfo", ApplicationThreadLocals.getCityCode() + "-" + ApplicationThreadLocals.getCityName());
        StringBuilder returnUrl = new StringBuilder();
        returnUrl.append(paymentServiceDetails.getCallBackurl()).append("?paymentServiceId=").append(paymentServiceDetails.getId());
        fields.put("vpc_ReturnURL", returnUrl.toString());
        BigDecimal amount = receiptHeader.getTotalAmount();
        float rupees = Float.parseFloat(amount.toString());
        Integer rupee = (int)rupees;
        Float exponent = Float.valueOf(rupees - (float)rupee.intValue());
        Integer paise = (int)((float)(rupee * PAISE_RUPEE_CONVERTER.intValue()) + exponent.floatValue() * (float)PAISE_RUPEE_CONVERTER.intValue());
        fields.put("vpc_Amount", paise.toString());
        String axisSecureSecret = this.collectionApplicationProperties.axisSecureSecret();
        if (axisSecureSecret != null) {
            String secureHash = this.hashAllFields(fields);
            fields.put("vpc_SecureHash", secureHash);
        }
        StringBuffer buf = new StringBuffer();
        buf.append(paymentServiceDetails.getServiceUrl()).append('?');
        this.appendQueryFields(buf, fields);
        paymentRequest.setParameter("paymentGatewayURL", buf);
        LOGGER.info((Object)("paymentRequest: " + paymentRequest.getRequestParameters()));
        return paymentRequest;
    }

    String hashAllFields(Map<String, String> fields) {
        ArrayList<String> fieldNames = new ArrayList<String>(fields.keySet());
        Collections.sort(fieldNames);
        StringBuffer buf = new StringBuffer();
        String axisSecureSecret = this.collectionApplicationProperties.axisSecureSecret();
        buf.append(axisSecureSecret);
        for (String fieldName : fieldNames) {
            String fieldValue = fields.get(fieldName);
            if (fieldValue == null || fieldValue.length() <= 0) continue;
            buf.append(fieldValue);
        }
        MessageDigest md5 = null;
        byte[] ba = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
            ba = md5.digest(buf.toString().getBytes("UTF-8"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return AxisAdaptor.hex(ba);
    }

    static String hex(byte[] input) {
        StringBuffer sb = new StringBuffer(input.length * 2);
        for (byte element : input) {
            sb.append(CollectionConstants.AXIS_HEX_TABLE[element >> 4 & 0xF]);
            sb.append(CollectionConstants.AXIS_HEX_TABLE[element & 0xF]);
        }
        return sb.toString();
    }

    @Override
    public PaymentResponse parsePaymentResponse(String response) {
        String secureHash;
        LOGGER.info((Object)("Response message from Axis Payment gateway: " + response));
        DefaultPaymentResponse axisResponse = new DefaultPaymentResponse();
        String[] keyValueStr = response.replace("{", "").replace("}", "").split(",");
        HashMap<String, String> fields = new HashMap<String, String>(0);
        for (String pair : keyValueStr) {
            String[] entry = pair.split("=");
            if (entry.length != 2) continue;
            fields.put(entry[0].trim(), entry[1].trim());
        }
        String[] merchantRef = ((String)fields.get("vpc_MerchTxnRef")).split("-");
        String receiptId = merchantRef[1];
        String ulbCode = merchantRef[0];
        Query qry = this.entityManager.createNamedQuery("QUERY_RECEIPT_BY_ID_AND_CITYCODE");
        qry.setParameter(1, (Object)Long.valueOf(receiptId));
        qry.setParameter(2, (Object)ulbCode);
        ReceiptHeader receiptHeader = (ReceiptHeader)((Object)qry.getSingleResult());
        axisResponse.setAuthStatus(((String)fields.get("vpc_TxnResponseCode")).equals("0") ? "0300" : (String)fields.get("vpc_TxnResponseCode"));
        axisResponse.setErrorDescription((String)fields.get("vpc_Message"));
        axisResponse.setAdditionalInfo6(receiptHeader.getConsumerCode());
        axisResponse.setReceiptId(receiptId);
        axisResponse.setTxnAmount(new BigDecimal((String)fields.get("vpc_Amount")).divide(PAISE_RUPEE_CONVERTER));
        axisResponse.setTxnReferenceNo((String)fields.get("vpc_TransactionNo"));
        axisResponse.setAdditionalInfo2((String)fields.get("vpc_OrderInfo"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd", Locale.getDefault());
        Date transactionDate = null;
        try {
            transactionDate = sdf.parse((String)fields.get("vpc_BatchNo"));
            axisResponse.setTxnDate(transactionDate);
        }
        catch (ParseException e) {
            LOGGER.error((Object)("Error occured in parsing the transaction date [" + (String)fields.get("vpc_BatchNo") + "]"), (Throwable)e);
            throw new ApplicationRuntimeException(".transactiondate.parse.error", (Throwable)e);
        }
        String vpc_Txn_Secure_Hash = AxisAdaptor.null2unknown((String)fields.remove("vpc_SecureHash"));
        boolean errorExists = false;
        String axisSecureSecret = this.collectionApplicationProperties.axisSecureSecret();
        if (!(axisSecureSecret == null || fields.get("vpc_TxnResponseCode") == null && fields.get("vpc_TxnResponseCode") == "No Value Returned" || vpc_Txn_Secure_Hash.equalsIgnoreCase(secureHash = this.hashAllFields(fields)))) {
            errorExists = true;
        }
        AxisAdaptor.null2unknown((String)fields.get("Title"));
        AxisAdaptor.null2unknown((String)fields.get("AgainLink"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_Amount"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_Locale"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_BatchNo"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_Command"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_Message"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_Version"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_Card"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_OrderInfo"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_ReceiptNo"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_Merchant"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_MerchTxnRef"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_AuthorizeId"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_TransactionNo"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_AcqResponseCode"));
        String txnResponseCode = AxisAdaptor.null2unknown((String)fields.get("vpc_TxnResponseCode"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_CSCResultCode"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_CSCRequestCode"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_AcqCSCRespCode"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_AVS_City"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_AVS_Country"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_AVS_Street01"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_AVS_PostCode"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_AVS_StateProv"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_AVSResultCode"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_AVSRequestCode"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_AcqAVSRespCode"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_VerType"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_VerStatus"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_VerToken"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_VerSecurityLevel"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_3DSenrolled"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_3DSXID"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_3DSECI"));
        AxisAdaptor.null2unknown((String)fields.get("vpc_3DSstatus"));
        if (txnResponseCode.equals("7") || txnResponseCode.equals("No Value Returned") || errorExists) {
            // empty if block
        }
        return axisResponse;
    }

    private static String null2unknown(String in) {
        if (in == null || in.length() == 0) {
            return "No Value Returned";
        }
        return in;
    }

    void appendQueryFields(StringBuffer buf, Map fields) {
        ArrayList fieldNames = new ArrayList(fields.keySet());
        Iterator itr = fieldNames.iterator();
        while (itr.hasNext()) {
            String fieldName = (String)itr.next();
            String fieldValue = (String)fields.get(fieldName);
            if (fieldValue != null && fieldValue.length() > 0) {
                try {
                    buf.append(URLEncoder.encode(fieldName, "UTF-8"));
                    buf.append('=');
                    buf.append(URLEncoder.encode(fieldValue, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
            if (!itr.hasNext()) continue;
            buf.append('&');
        }
    }

    public PaymentResponse createOfflinePaymentRequest(ServiceDetails paymentServiceDetails, OnlinePayment onlinePayment) {
        LOGGER.debug((Object)"Inside createOfflinePaymentRequest");
        DefaultPaymentResponse axisResponse = new DefaultPaymentResponse();
        try {
            String[] pairs;
            Client client = Client.create();
            WebResource resource = client.resource(this.collectionApplicationProperties.axisReconcileUrl());
            Form formData = new Form();
            formData.add("vpc_Version", (Object)this.collectionApplicationProperties.axisVersion());
            formData.add("vpc_Command", this.collectionApplicationProperties.axisCommandQuery());
            formData.add("vpc_AccessCode", this.collectionApplicationProperties.axisAccessCode());
            formData.add("vpc_Merchant", this.collectionApplicationProperties.axisMerchant());
            City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
            formData.add("vpc_MerchTxnRef", cityWebsite.getCode() + "-" + onlinePayment.getReceiptHeader().getId().toString());
            formData.add("vpc_User", this.collectionApplicationProperties.axisOperator());
            formData.add("vpc_Password", this.collectionApplicationProperties.axisPassword());
            formData.add("vpc_OrderInfo", ApplicationThreadLocals.getCityCode() + "-" + ApplicationThreadLocals.getCityName());
            String responseAxis = (String)resource.type(MediaType.APPLICATION_FORM_URLENCODED_TYPE).post(String.class, (Object)formData);
            LinkedHashMap<String, String> responseAxisMap = new LinkedHashMap<String, String>();
            for (String pair : pairs = responseAxis.split("&")) {
                int idx = pair.indexOf("=");
                try {
                    responseAxisMap.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error((Object)("Error Decoding Axis Bank Response" + e.getMessage()));
                }
            }
            axisResponse.setAdditionalInfo6(onlinePayment.getReceiptHeader().getConsumerCode().replace("-", "").replace("/", ""));
            axisResponse.setReceiptId(onlinePayment.getReceiptHeader().getId().toString());
            LOGGER.info((Object)("ResponseAXIS: " + responseAxis.toString()));
            if (null != responseAxisMap.get("vpc_TxnResponseCode") && !"".equals(responseAxisMap.get("vpc_TxnResponseCode"))) {
                axisResponse.setAuthStatus(null != responseAxisMap.get("vpc_TxnResponseCode") && ((String)responseAxisMap.get("vpc_TxnResponseCode")).equals("0") ? "0300" : (String)responseAxisMap.get("vpc_TxnResponseCode"));
                axisResponse.setErrorDescription((String)responseAxisMap.get("vpc_Message"));
                if ("0300".equals(axisResponse.getAuthStatus())) {
                    axisResponse.setTxnReferenceNo((String)responseAxisMap.get("vpc_TransactionNo"));
                    axisResponse.setTxnAmount(new BigDecimal((String)responseAxisMap.get("vpc_Amount")));
                    axisResponse.setAdditionalInfo2((String)responseAxisMap.get("vpc_OrderInfo"));
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd", Locale.getDefault());
                    Date transactionDate = null;
                    try {
                        transactionDate = sdf.parse((String)responseAxisMap.get("vpc_BatchNo"));
                        axisResponse.setTxnDate(transactionDate);
                    }
                    catch (ParseException e) {
                        LOGGER.error((Object)("Error occured in parsing the transaction date [" + (String)responseAxisMap.get("vpc_BatchNo") + "]"), (Throwable)e);
                        throw new ApplicationException(".transactiondate.parse.error", (Throwable)e);
                    }
                }
            } else if (responseAxis.contains("vpc_DRExists=N")) {
                axisResponse.setErrorDescription("Failed/Aborted Transaction.");
                axisResponse.setAuthStatus("A");
            }
            LOGGER.debug((Object)("receiptid=" + axisResponse.getReceiptId() + "consumercode=" + axisResponse.getAdditionalInfo6()));
        }
        catch (Exception exp) {
            exp.printStackTrace();
            LOGGER.error((Object)exp.getMessage());
        }
        return axisResponse;
    }
}

