/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.integration.models;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.egov.collection.entity.ChallanInfo;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.entity.ReceiptMisc;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.collection.integration.models.ReceiptAccountInfo;
import org.egov.collection.integration.models.ReceiptAccountInfoImpl;
import org.egov.collection.integration.models.ReceiptInstrumentInfo;
import org.egov.collection.integration.models.ReceiptInstrumentInfoImpl;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.egf.commons.EgovCommon;
import org.egov.infra.admin.master.entity.Location;
import org.egov.infra.admin.master.entity.User;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.instrument.InstrumentHeader;

public class BillReceiptInfoImpl
implements BillReceiptInfo {
    private final ReceiptHeader receiptHeader;
    private String event;
    private final Set<ReceiptAccountInfo> accountDetails = new HashSet<ReceiptAccountInfo>(0);
    private final Set<ReceiptInstrumentInfo> instrumentDetails = new HashSet<ReceiptInstrumentInfo>(0);
    private final Set<ReceiptInstrumentInfo> bouncedInstruments = new HashSet<ReceiptInstrumentInfo>(0);
    private final Set<ChallanInfo> challanDetails = new HashSet<ChallanInfo>(0);
    private ChallanInfo challan = null;
    private final String receiptURL;
    private final String additionalInfo;

    public BillReceiptInfoImpl(ReceiptHeader receiptHeader, ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO, PersistenceService persistenceService, InstrumentHeader bouncedInstrumentInfo) {
        this.receiptHeader = receiptHeader;
        this.receiptURL = "/collection/receipts/receipt-viewReceipts.action?selectedReceipts=" + receiptHeader.getId();
        this.additionalInfo = null;
        String receiptStatus = receiptHeader.getStatus().getCode();
        for (ReceiptDetail receiptDetail : receiptHeader.getReceiptDetails()) {
            this.accountDetails.add(new ReceiptAccountInfoImpl(receiptDetail, chartOfAccountsHibernateDAO, persistenceService));
        }
        if (!"INSTR_BOUNCED".equals(receiptStatus)) {
            for (InstrumentHeader instrumentHeader : receiptHeader.getReceiptInstrument()) {
                this.instrumentDetails.add(new ReceiptInstrumentInfoImpl(instrumentHeader));
            }
        } else if (bouncedInstrumentInfo != null) {
            this.instrumentDetails.add(new ReceiptInstrumentInfoImpl(bouncedInstrumentInfo));
        }
        if ("INSTR_BOUNCED".equals(receiptStatus)) {
            this.event = "INSTRUMENT_BOUNCED";
            if (bouncedInstrumentInfo != null) {
                this.findBouncedInstrument();
            }
        } else if ("TO_BE_SUBMITTED".equals(receiptStatus) || "APPROVED".equals(receiptStatus) || "SUBMITTED".equals(receiptStatus)) {
            this.event = "RECEIPT_CREATED";
        } else if ("CANCELLED".equals(receiptStatus)) {
            this.event = "RECEIPT_CANCELLED";
        }
    }

    public BillReceiptInfoImpl(ReceiptHeader receiptHeader, String additionalInfo, ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO, PersistenceService persistenceService) {
        this.receiptHeader = receiptHeader;
        this.receiptURL = "/collection/receipts/receipt-viewReceipts.action?selectedReceipts=" + receiptHeader.getId();
        this.additionalInfo = additionalInfo;
        for (ReceiptDetail receiptDetail : receiptHeader.getReceiptDetails()) {
            this.accountDetails.add(new ReceiptAccountInfoImpl(receiptDetail, chartOfAccountsHibernateDAO, persistenceService));
        }
        for (InstrumentHeader instrumentHeader : receiptHeader.getReceiptInstrument()) {
            this.instrumentDetails.add(new ReceiptInstrumentInfoImpl(instrumentHeader));
        }
        String receiptStatus = receiptHeader.getStatus().getCode();
        if ("INSTR_BOUNCED".equals(receiptStatus)) {
            this.event = "INSTRUMENT_BOUNCED";
            this.findBouncedInstrument();
        } else if ("TO_BE_SUBMITTED".equals(receiptStatus) || "APPROVED".equals(receiptStatus) || "SUBMITTED".equals(receiptStatus)) {
            this.event = "RECEIPT_CREATED";
        } else if ("CANCELLED".equals(receiptStatus)) {
            this.event = "RECEIPT_CANCELLED";
        }
    }

    public BillReceiptInfoImpl(ReceiptHeader receiptHeader, EgovCommon egovCommon, ReceiptHeader receiptHeaderRefObj, ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO, PersistenceService persistenceService) {
        this.receiptHeader = receiptHeader;
        this.receiptURL = "/collection/receipts/receipt-viewReceipts.action?selectedReceipts=" + receiptHeader.getId();
        this.additionalInfo = null;
        for (ReceiptDetail receiptDetail : receiptHeader.getReceiptDetails()) {
            this.accountDetails.add(new ReceiptAccountInfoImpl(receiptDetail, chartOfAccountsHibernateDAO, persistenceService));
        }
        for (InstrumentHeader instrumentHeader : receiptHeader.getReceiptInstrument()) {
            this.instrumentDetails.add(new ReceiptInstrumentInfoImpl(instrumentHeader));
        }
        if (receiptHeader.getReceipttype() == 'C') {
            this.challan = new ChallanInfo(receiptHeader, egovCommon, receiptHeaderRefObj, chartOfAccountsHibernateDAO, persistenceService);
            this.challanDetails.add(this.challan);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getReceiptNum()).append(" ").append(this.getAccountDetails());
        return sb.toString();
    }

    @Override
    public String getBillReferenceNum() {
        return this.receiptHeader.getReferencenumber();
    }

    @Override
    public String getEvent() {
        return this.event;
    }

    @Override
    public String getReceiptNum() {
        return this.receiptHeader.getReceiptnumber();
    }

    @Override
    public Date getReceiptDate() {
        return this.receiptHeader.getReceiptdate();
    }

    @Override
    public Location getReceiptLocation() {
        return this.receiptHeader.getLocation();
    }

    @Override
    public EgwStatus getReceiptStatus() {
        return this.receiptHeader.getStatus();
    }

    @Override
    public String getPayeeName() {
        return StringEscapeUtils.unescapeJavaScript((String)this.receiptHeader.getPayeeName());
    }

    @Override
    public String getPayeeAddress() {
        return this.receiptHeader.getPayeeAddress();
    }

    @Override
    public Set<ReceiptAccountInfo> getAccountDetails() {
        return this.accountDetails;
    }

    @Override
    public Set<ReceiptInstrumentInfo> getInstrumentDetails() {
        return this.instrumentDetails;
    }

    @Override
    public Set<ReceiptInstrumentInfo> getBouncedInstruments() {
        return this.bouncedInstruments;
    }

    @Override
    public String getServiceName() {
        return this.receiptHeader.getService().getName();
    }

    @Override
    public String getPaidBy() {
        return this.receiptHeader.getPaidBy();
    }

    @Override
    public String getDescription() {
        return this.receiptHeader.getReferenceDesc();
    }

    @Override
    public BigDecimal getTotalAmount() {
        return this.receiptHeader.getTotalAmount();
    }

    @Override
    public User getCreatedBy() {
        return this.receiptHeader.getCreatedBy();
    }

    @Override
    public User getModifiedBy() {
        return this.receiptHeader.getLastModifiedBy();
    }

    private void findBouncedInstrument() {
        for (ReceiptInstrumentInfo instrumentInfo : this.instrumentDetails) {
            if (!instrumentInfo.isBounced()) continue;
            this.bouncedInstruments.add(instrumentInfo);
        }
    }

    public ReceiptMisc getReceiptMisc() {
        return this.receiptHeader.getReceiptMisc();
    }

    public Set<ChallanInfo> getChallanDetails() {
        return this.challanDetails;
    }

    public ChallanInfo getChallan() {
        return this.challan;
    }

    @Override
    public String getReceiptURL() {
        return this.receiptURL;
    }

    @Override
    public String getCollectionType() {
        return this.receiptHeader.getCollectiontype().toString();
    }

    public String getConsumerCode() {
        return this.receiptHeader.getConsumerCode();
    }

    @Override
    public String getManualReceiptNumber() {
        return this.receiptHeader.getManualreceiptnumber() == null ? "" : this.receiptHeader.getManualreceiptnumber();
    }

    @Override
    public Date getManualReceiptDate() {
        return this.receiptHeader.getManualreceiptdate() == null ? null : this.receiptHeader.getManualreceiptdate();
    }

    @Override
    public Boolean getLegacy() {
        Boolean legacy = Boolean.FALSE;
        for (ReceiptAccountInfo receiptAccountInfo : this.getAccountDetails()) {
            if (receiptAccountInfo.getDescription() == null || "".equals(receiptAccountInfo.getDescription()) || receiptAccountInfo.getDescription().contains("#") && !receiptAccountInfo.getDescription().contains("Estimation Charges")) continue;
            legacy = Boolean.TRUE;
            break;
        }
        return legacy;
    }

    @Override
    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    @Override
    public String getSource() {
        return this.receiptHeader.getSource() == null ? "" : this.receiptHeader.getSource();
    }

    @Override
    public String getReceiptInstrumentType() {
        String instrumentType = "";
        for (ReceiptInstrumentInfo instrumentInfo : this.instrumentDetails) {
            if (instrumentInfo.getInstrumentType().equals("cheque") || instrumentInfo.getInstrumentType().equals("dd")) {
                instrumentType = "cheque/dd";
                break;
            }
            instrumentType = instrumentInfo.getInstrumentType();
        }
        return instrumentType;
    }
}

