/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.integration.models;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.egov.collection.integration.models.BillAccountDetails;

@XStreamAlias(value="bill")
public class BillDetails {
    @XStreamAsAttribute
    private final String refNo;
    @XStreamAsAttribute
    private final Date billDate;
    @XStreamAsAttribute
    private final String consumerCode;
    private final String boundaryNum;
    private final String boundaryType;
    private final String description;
    private final BigDecimal totalAmount;
    private final BigDecimal minimumAmount;
    @XStreamAlias(value="accounts")
    private final List<BillAccountDetails> accounts = new ArrayList<BillAccountDetails>();

    public BillDetails(String refNo, Date billDate, String consumerCode, String boundaryNum, String boundaryType, String description, BigDecimal totalAmount, BigDecimal minimumAmount) {
        this.refNo = refNo;
        this.billDate = billDate;
        this.boundaryNum = boundaryNum;
        this.boundaryType = boundaryType;
        this.description = description;
        this.totalAmount = totalAmount;
        this.minimumAmount = minimumAmount;
        this.consumerCode = consumerCode;
    }

    public String getRefNo() {
        return this.refNo;
    }

    public List<BillAccountDetails> getAccounts() {
        return this.accounts;
    }

    public void addBillAccountDetails(BillAccountDetails billAccountDetail) {
        this.accounts.add(billAccountDetail);
    }

    public String getDescription() {
        return this.description;
    }

    public Date getBilldate() {
        return this.billDate;
    }

    public String getBoundaryNum() {
        return this.boundaryNum;
    }

    public String getBoundaryType() {
        return this.boundaryType;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public BigDecimal getMinimumAmount() {
        return this.minimumAmount;
    }

    public String getConsumerCode() {
        return this.consumerCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BillDetails) {
            BillDetails billDetail = (BillDetails)obj;
            if (this.refNo.equals(billDetail.refNo) && this.billDate.equals(billDetail.billDate) && this.boundaryNum.equals(billDetail.boundaryNum) && this.boundaryType.equals(billDetail.boundaryType) && this.description.equals(billDetail.description) && this.minimumAmount.equals(billDetail.minimumAmount) && this.consumerCode.equals(billDetail.consumerCode) && this.totalAmount.equals(billDetail.totalAmount)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.billDate.hashCode() + this.refNo.hashCode() + this.boundaryNum.hashCode() + this.boundaryType.hashCode() + this.description.hashCode() + this.minimumAmount.hashCode() + this.consumerCode.hashCode() + this.totalAmount.hashCode();
    }
}

