/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.integration.models;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.math.BigDecimal;

@XStreamAlias(value="account")
public class BillAccountDetails
implements Comparable<BillAccountDetails> {
    @XStreamAsAttribute
    private final String glCode;
    @XStreamAsAttribute
    private final Integer order;
    @XStreamAsAttribute
    private final String description;
    @XStreamAlias(value="crAmount")
    private final BigDecimal crAmount;
    @XStreamAlias(value="drAmount")
    private final BigDecimal drAmount;
    private final String functionCode;
    @XStreamAsAttribute
    private final Boolean isActualDemand;

    public BillAccountDetails(String glCode, Integer order, BigDecimal crAmount, BigDecimal drAmount, String functionCode, String description, Boolean isActualDemand) {
        this.glCode = glCode;
        this.order = order;
        this.crAmount = crAmount;
        this.drAmount = drAmount;
        this.functionCode = functionCode;
        this.description = description;
        this.isActualDemand = isActualDemand;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.order).append(",").append(this.glCode).append(",").append(this.crAmount).append(",").append(this.crAmount).append(",").append(this.description).append(",").append(this.isActualDemand);
        return sb.toString();
    }

    public String getGlCode() {
        return this.glCode;
    }

    public Integer getOrder() {
        return this.order;
    }

    public BigDecimal getDrAmount() {
        return this.drAmount;
    }

    public BigDecimal getCrAmount() {
        return this.crAmount;
    }

    public String getFunctionCode() {
        return this.functionCode;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getIsActualDemand() {
        return this.isActualDemand;
    }

    @Override
    public int compareTo(BillAccountDetails obj) {
        return this.order - obj.order;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BillAccountDetails) {
            BillAccountDetails account = (BillAccountDetails)obj;
            if (this.glCode.equals(account.glCode) && this.order.equals(account.order) && this.crAmount.equals(account.crAmount) && this.drAmount.equals(account.drAmount) && this.description.equals(account.description) && this.functionCode.equals(account.functionCode) && this.isActualDemand.equals(account.isActualDemand)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.glCode.hashCode() + this.order.hashCode() + this.crAmount.hashCode() + this.drAmount.hashCode() + this.description.hashCode() + this.functionCode.hashCode() + this.isActualDemand.hashCode();
    }
}

