/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.egov.collection.entity.CollectionBankRemittanceReport;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.model.instrument.InstrumentHeader;

public abstract class RemittanceService
implements Serializable {
    private static final long serialVersionUID = 1849734164810403255L;

    public abstract List<ReceiptHeader> createBankRemittance(String[] var1, String[] var2, String[] var3, String[] var4, String[] var5, String[] var6, String[] var7, String[] var8, Integer var9, Integer var10, String[] var11, Date var12);

    public abstract List<HashMap<String, Object>> findAllRemittanceDetailsForServiceAndFund(String var1, String var2, String var3, Date var4, Date var5, String var6);

    public List<CollectionBankRemittanceReport> prepareBankRemittanceReport(List<ReceiptHeader> receiptHeaders) {
        ArrayList<CollectionBankRemittanceReport> reportList = new ArrayList<CollectionBankRemittanceReport>(0);
        for (ReceiptHeader receiptHead : receiptHeaders) {
            Iterator<InstrumentHeader> itr = receiptHead.getReceiptInstrument().iterator();
            while (itr.hasNext()) {
                CollectionBankRemittanceReport collBankRemitReport = new CollectionBankRemittanceReport();
                InstrumentHeader instHead = itr.next();
                if (!instHead.getInstrumentType().getType().equals("cash")) {
                    collBankRemitReport.setChequeNo(instHead.getInstrumentNumber());
                    collBankRemitReport.setBranchName(instHead.getBankBranchName());
                    collBankRemitReport.setBankName(instHead.getBankId() != null ? instHead.getBankId().getName() : "");
                    collBankRemitReport.setChequeDate(instHead.getInstrumentDate());
                    collBankRemitReport.setPaymentMode(instHead.getInstrumentType().getType());
                    collBankRemitReport.setAmount(instHead.getInstrumentAmount().doubleValue());
                    collBankRemitReport.setReceiptNumber(receiptHead.getReceiptnumber());
                    collBankRemitReport.setReceiptDate(receiptHead.getReceiptDate());
                    collBankRemitReport.setVoucherNumber(receiptHead.getRemittanceReferenceNumber());
                    reportList.add(collBankRemitReport);
                    continue;
                }
                collBankRemitReport.setVoucherNumber(receiptHead.getRemittanceReferenceNumber());
                reportList.add(collBankRemitReport);
            }
        }
        return reportList;
    }
}

