/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.integration.services;

import org.apache.log4j.Logger;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.service.ReceiptHeaderService;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.collection.utils.FinancialsUtil;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.services.instrument.FinancialIntegrationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class DishonorChequeService
implements FinancialIntegrationService {
    private static final Logger LOGGER = Logger.getLogger(DishonorChequeService.class);
    private CollectionsUtil collectionsUtil;
    private FinancialsUtil financialsUtil;
    private PersistenceService persistenceService;
    private ReceiptHeaderService receiptHeaderService;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;

    @Transactional
    public void updateCollectionsOnInstrumentDishonor(Long instrumentHeaderId) {
        LOGGER.debug((Object)("Update Collection and Billing system for dishonored instrument id: " + instrumentHeaderId));
        EgwStatus receiptInstrumentBounceStatus = this.collectionsUtil.getReceiptStatusForCode("INSTR_BOUNCED");
        EgwStatus receiptCancellationStatus = this.collectionsUtil.getReceiptStatusForCode("CANCELLED");
        ReceiptHeader receiptHeader = (ReceiptHeader)((Object)this.persistenceService.find("select DISTINCT (receipt) from ReceiptHeader receipt join receipt.receiptInstrument as instruments where instruments.id=? and instruments.statusId.code not in (?,?)", new Object[]{(long)instrumentHeaderId, receiptInstrumentBounceStatus.getCode(), receiptCancellationStatus.getCode()}));
        InstrumentHeader instrumentHeader = (InstrumentHeader)this.persistenceService.findByNamedQuery("INSTRUMENTHEADERBYID", new Object[]{instrumentHeaderId});
        instrumentHeader.setStatusId(this.getDishonoredStatus());
        this.financialsUtil.updateInstrumentHeader(instrumentHeader);
        this.receiptHeaderService.updateDishonoredInstrumentStatus(receiptHeader, instrumentHeader, receiptInstrumentBounceStatus, false);
        LOGGER.debug((Object)("Updated receipt status to " + receiptInstrumentBounceStatus.getCode() + " set reconcilation to false"));
    }

    private EgwStatus getDishonoredStatus() {
        return this.collectionsUtil.getStatusForModuleAndCode("Instrument", "Dishonored");
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    public void setReceiptHeaderService(ReceiptHeaderService receiptHeaderService) {
        this.receiptHeaderService = receiptHeaderService;
    }

    public void setFinancialsUtil(FinancialsUtil financialsUtil) {
        this.financialsUtil = financialsUtil;
    }

    public void updateSourceInstrumentVoucher(String event, Long instrumentHeaderId) {
    }
}

