/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.autonumber.impl;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.egov.collection.autonumber.RemittanceNumberGenerator;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.commons.CFinancialYear;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.infra.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemittanceNumberGeneratorImpl
implements RemittanceNumberGenerator {
    @Autowired
    private CollectionsUtil collectionsUtil;
    @Autowired
    private ApplicationSequenceNumberGenerator applicationSequenceNumberGenerator;

    @Override
    public String generateRemittanceNumber(CFinancialYear financialYear) {
        String APP_NUMBER_SEQ_PREFIX = "SQ_REMITTANCE%s";
        SimpleDateFormat sdf = new SimpleDateFormat("MM");
        String formattedDate = sdf.format(new Date());
        String currentYear = DateUtils.currentDateToYearFormat();
        String sequenceName = String.format("SQ_REMITTANCE%s", currentYear);
        Serializable sequenceNumber = this.applicationSequenceNumberGenerator.getNextSequence(sequenceName);
        String result = String.format("%s/%06d/%s/%s", "REM", sequenceNumber, formattedDate, financialYear.getFinYearRange());
        return result;
    }
}

