/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.workflow.renderer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.inbox.DefaultInboxRenderServiceImpl;
import org.egov.infstr.services.PersistenceService;

public class CollectionsWorkflowRenderService
extends DefaultInboxRenderServiceImpl<ReceiptHeader> {
    public CollectionsWorkflowRenderService(PersistenceService<ReceiptHeader, Long> stateAwarePersistenceService) {
        super(stateAwarePersistenceService);
    }

    private List<ReceiptHeader> getGroupedWorkflowItems(List<ReceiptHeader> allItems) {
        ArrayList<ReceiptHeader> receiptHeaderPerGroup = new ArrayList<ReceiptHeader>(0);
        HashMap<String, Integer> assignedItems = new HashMap<String, Integer>(0);
        for (StateAware stateAware : allItems) {
            if (!(stateAware instanceof ReceiptHeader)) continue;
            ReceiptHeader nextReceipt = (ReceiptHeader)stateAware;
            String groupingCriteria = "";
            groupingCriteria = nextReceipt.getReceipttype() == 'B' ? nextReceipt.myLinkId() : nextReceipt.myLinkIdForChallanMisc();
            if (assignedItems.get(groupingCriteria) != null) continue;
            receiptHeaderPerGroup.add(nextReceipt);
            assignedItems.put(groupingCriteria, 1);
        }
        return receiptHeaderPerGroup;
    }

    public List<ReceiptHeader> getDraftWorkflowItems(Long userId, List<Long> owner) {
        return this.getGroupedWorkflowItems(super.getDraftWorkflowItems(userId, owner));
    }

    public List<ReceiptHeader> getAssignedWorkflowItems(Long userId, List<Long> owner) {
        return this.getGroupedWorkflowItems(super.getAssignedWorkflowItems(userId, owner));
    }
}

