/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.integration.services;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.egov.collection.entity.OnlinePayment;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.entity.ReceiptVoucher;
import org.egov.collection.integration.models.BillInfo;
import org.egov.collection.integration.models.BillInfoImpl;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.collection.integration.models.BillReceiptInfoImpl;
import org.egov.collection.integration.models.PaymentInfo;
import org.egov.collection.integration.models.PaymentInfoBank;
import org.egov.collection.integration.models.PaymentInfoCash;
import org.egov.collection.integration.models.PaymentInfoChequeDD;
import org.egov.collection.integration.models.PaymentInfoSearchRequest;
import org.egov.collection.integration.models.RestAggregatePaymentInfo;
import org.egov.collection.integration.models.RestReceiptInfo;
import org.egov.collection.integration.pgi.PaymentRequest;
import org.egov.collection.integration.services.CollectionIntegrationService;
import org.egov.collection.integration.services.PaymentInfoService;
import org.egov.collection.service.ReceiptHeaderService;
import org.egov.collection.utils.CollectionCommon;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.Fund;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.dao.FundHibernateDAO;
import org.egov.commons.entity.Source;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.models.ServiceDetails;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.instrument.InstrumentHeader;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class CollectionIntegrationServiceImpl
extends PersistenceService<ReceiptHeader, Long>
implements CollectionIntegrationService {
    private static final Logger LOGGER = Logger.getLogger(CollectionIntegrationServiceImpl.class);
    @Autowired
    private FundHibernateDAO fundHibernateDAO;
    private PersistenceService persistenceService;
    private CollectionsUtil collectionsUtil;
    private ReceiptHeaderService receiptHeaderService;
    @Autowired
    private EgwStatusHibernateDAO statusDAO;
    private final List<ValidationError> errors = new ArrayList<ValidationError>(0);
    private CollectionCommon collectionCommon;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    @Autowired
    private FundHibernateDAO fundDAO;
    @Autowired
    private ApplicationContext beanProvider;

    public CollectionIntegrationServiceImpl() {
        super(ReceiptHeader.class);
    }

    public void setReceiptHeaderService(ReceiptHeaderService receiptHeaderService) {
        this.receiptHeaderService = receiptHeaderService;
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    @Override
    public List<BillReceiptInfo> getBillReceiptInfo(String serviceCode, String refNum) {
        ArrayList<BillReceiptInfo> receipts = new ArrayList<BillReceiptInfo>(0);
        List receiptHeaders = this.findAllByNamedQuery("RECEIPTS_BY_REFNUM_AND_SERVICECODE", new Object[]{refNum, serviceCode});
        if (receiptHeaders == null || receiptHeaders.isEmpty()) {
            return null;
        }
        for (ReceiptHeader receiptHeader : receiptHeaders) {
            receipts.add(new BillReceiptInfoImpl(receiptHeader, this.chartOfAccountsHibernateDAO, this.persistenceService, null));
        }
        return receipts;
    }

    @Override
    public Map<String, List<BillReceiptInfo>> getBillReceiptInfo(String serviceCode, Set<String> refNums) {
        HashMap<String, List<BillReceiptInfo>> receipts = new HashMap<String, List<BillReceiptInfo>>(0);
        for (String refNum : refNums) {
            receipts.put(refNum, this.getBillReceiptInfo(serviceCode, refNum));
        }
        return receipts;
    }

    @Override
    public List<BillReceiptInfo> getInstrumentReceiptInfo(String serviceCode, String instrumentNum) {
        ArrayList<BillReceiptInfo> receipts = new ArrayList<BillReceiptInfo>(0);
        List receiptHeaders = this.findAllByNamedQuery("RECEIPTS_BY_INSTRUMENTNO_AND_SERVICECODE", new Object[]{instrumentNum, serviceCode});
        if (receiptHeaders == null || receiptHeaders.isEmpty()) {
            return null;
        }
        for (ReceiptHeader receiptHeader : receiptHeaders) {
            receipts.add(new BillReceiptInfoImpl(receiptHeader, this.chartOfAccountsHibernateDAO, this.persistenceService, null));
        }
        return receipts;
    }

    @Override
    public Map<String, List<BillReceiptInfo>> getInstrumentReceiptInfo(String serviceCode, Set<String> instrumentNums) {
        HashMap<String, List<BillReceiptInfo>> receipts = new HashMap<String, List<BillReceiptInfo>>(0);
        for (String instrumentNum : instrumentNums) {
            receipts.put(instrumentNum, this.getInstrumentReceiptInfo(serviceCode, instrumentNum));
        }
        return receipts;
    }

    @Override
    public BillReceiptInfo getReceiptInfo(String serviceCode, String receiptNum) {
        ReceiptHeader receiptHeader = (ReceiptHeader)((Object)this.findByNamedQuery("RECEIPTS_BY_RECEIPTNUM_AND_SERVICECODE", new Object[]{serviceCode, receiptNum, receiptNum}));
        if (receiptHeader == null) {
            return null;
        }
        BillReceiptInfoImpl receiptInfo = new BillReceiptInfoImpl(receiptHeader, this.chartOfAccountsHibernateDAO, this.persistenceService, null);
        return receiptInfo;
    }

    @Override
    public RestReceiptInfo getDetailsByTransactionId(PaymentInfoSearchRequest paymentInfoSearchRequest) {
        LOGGER.info((Object)paymentInfoSearchRequest.getSource());
        ReceiptHeader header = (ReceiptHeader)((Object)this.find("from ReceiptHeader r where r.manualreceiptnumber=? and r.source=? ", new Object[]{paymentInfoSearchRequest.getTransactionId(), paymentInfoSearchRequest.getSource()}));
        if (header == null) {
            throw new RuntimeException("No data found");
        }
        RestReceiptInfo restReceiptInfo = new RestReceiptInfo(header);
        PaymentInfoService paymentInfoService = (PaymentInfoService)this.beanProvider.getBean("paymentInfoService");
        paymentInfoService.setPaymentInfo(restReceiptInfo, header);
        return restReceiptInfo;
    }

    @Override
    public Map<String, BillReceiptInfo> getReceiptInfo(String serviceCode, Set<String> receiptNums) {
        HashMap<String, BillReceiptInfo> receipts = new HashMap<String, BillReceiptInfo>(0);
        for (String receiptNum : receiptNums) {
            receipts.put(receiptNum, this.getReceiptInfo(serviceCode, receiptNum));
        }
        return receipts;
    }

    @Override
    public BillReceiptInfo createReceipt(BillInfo bill, List<PaymentInfo> paymentInfoList) {
        LOGGER.info((Object)"Logs for CreateReceipt : Receipt Creation Started....");
        Fund fund = this.fundHibernateDAO.fundByCode(bill.getFundCode());
        if (fund == null) {
            throw new ApplicationRuntimeException("Fund not present for the fund code [" + bill.getFundCode() + "].");
        }
        Department dept = (Department)this.persistenceService.findByNamedQuery("getDepartmentByCode", new Object[]{bill.getDepartmentCode()});
        if (dept == null) {
            throw new ApplicationRuntimeException("Department not present for the department code [" + bill.getDepartmentCode() + "].");
        }
        ReceiptHeader receiptHeader = this.collectionCommon.initialiseReceiptModelWithBillInfo(bill, fund, dept);
        receiptHeader.setCreatedDate(new Date());
        receiptHeader.setReceiptdate(new Date());
        receiptHeader.setReceipttype('B');
        receiptHeader.setIsModifiable(Boolean.TRUE);
        receiptHeader.setIsReconciled(Boolean.FALSE);
        receiptHeader.setCollectiontype(Character.valueOf('F'));
        receiptHeader.setSource(bill.getSource() != null ? bill.getSource() : "");
        receiptHeader.setStatus(this.collectionsUtil.getStatusForModuleAndCode("ReceiptHeader", "APPROVED"));
        receiptHeader.setPaidBy(bill.getPaidBy());
        if (ApplicationThreadLocals.getUserId() != null) {
            User user = this.collectionsUtil.getUserById(ApplicationThreadLocals.getUserId());
            receiptHeader.setCreatedBy(user);
            receiptHeader.setLastModifiedBy(user);
            receiptHeader.setLastModifiedDate(new Date());
        }
        BigDecimal chequeDDInstrumenttotal = BigDecimal.ZERO;
        BigDecimal otherInstrumenttotal = BigDecimal.ZERO;
        ArrayList<InstrumentHeader> instrumentHeaderList = new ArrayList<InstrumentHeader>(0);
        for (PaymentInfo paytInfo : paymentInfoList) {
            String instrType = paytInfo.getInstrumentType().toString();
            if ("cash".equals(instrType)) {
                PaymentInfoCash paytInfoCash = (PaymentInfoCash)paytInfo;
                instrumentHeaderList.add(this.collectionCommon.validateAndConstructCashInstrument(paytInfoCash));
                otherInstrumenttotal = paytInfo.getInstrumentAmount();
            }
            if ("bankchallan".equals(instrType)) {
                PaymentInfoBank paytInfoBank = (PaymentInfoBank)paytInfo;
                instrumentHeaderList.add(this.collectionCommon.validateAndConstructBankInstrument(paytInfoBank));
                otherInstrumenttotal = paytInfoBank.getInstrumentAmount();
            }
            if (!"cheque".equals(instrType) && !"dd".equals(instrType)) continue;
            PaymentInfoChequeDD paytInfoChequeDD = (PaymentInfoChequeDD)paytInfo;
            instrumentHeaderList.add(this.collectionCommon.validateAndConstructChequeDDInstrument(paytInfoChequeDD));
            chequeDDInstrumenttotal = chequeDDInstrumenttotal.add(paytInfoChequeDD.getInstrumentAmount());
        }
        BigDecimal debitAmount = BigDecimal.ZERO;
        for (ReceiptDetail receiptDetail : receiptHeader.getReceiptDetails()) {
            debitAmount = debitAmount.add(receiptDetail.getCramount());
            debitAmount = debitAmount.subtract(receiptDetail.getDramount());
        }
        receiptHeader.addReceiptDetail(this.collectionCommon.addDebitAccountHeadDetails(debitAmount, receiptHeader, chequeDDInstrumenttotal, otherInstrumenttotal, paymentInfoList.get(0).getInstrumentType().toString()));
        this.receiptHeaderService.persistFieldReceipt(receiptHeader, instrumentHeaderList);
        LOGGER.info((Object)"Logs for CreateReceipt : Receipt Creation Finished....");
        return new BillReceiptInfoImpl(receiptHeader, this.chartOfAccountsHibernateDAO, this.persistenceService, null);
    }

    @Override
    public List<BillReceiptInfo> getOnlinePendingReceipts(String serviceCode, String consumerCode) {
        ArrayList<BillReceiptInfo> receipts = new ArrayList<BillReceiptInfo>(0);
        List receiptHeaders = this.findAllByNamedQuery("QUERY_ONLINE_PENDING_RECEIPTS_BY_CONSUMERCODE_AND_SERVICECODE", new Object[]{serviceCode, consumerCode, "ONLINE_STATUS_PENDING"});
        if (receiptHeaders == null || receiptHeaders.isEmpty()) {
            return null;
        }
        for (ReceiptHeader receiptHeader : receiptHeaders) {
            receipts.add(new BillReceiptInfoImpl(receiptHeader, this.chartOfAccountsHibernateDAO, this.persistenceService, null));
        }
        return receipts;
    }

    @Override
    public BillReceiptInfo createMiscellaneousReceipt(BillInfo bill, List<PaymentInfo> paymentInfoList) {
        LOGGER.info((Object)"Logs For Miscellaneous Receipt : Receipt Creation Started....");
        Fund fund = this.fundHibernateDAO.fundByCode(bill.getFundCode());
        if (fund == null) {
            throw new ApplicationRuntimeException("Fund not present for the fund code [" + bill.getFundCode() + "].");
        }
        Department dept = (Department)this.persistenceService.findByNamedQuery("getDepartmentByCode", new Object[]{bill.getDepartmentCode()});
        if (dept == null) {
            throw new ApplicationRuntimeException("Department not present for the department code [" + bill.getDepartmentCode() + "].");
        }
        ReceiptHeader receiptHeader = this.collectionCommon.initialiseReceiptModelWithBillInfo(bill, fund, dept);
        receiptHeader.setCreatedDate(new Date());
        receiptHeader.setReceipttype('A');
        receiptHeader.setIsModifiable(Boolean.TRUE);
        receiptHeader.setIsReconciled(Boolean.TRUE);
        receiptHeader.setCollectiontype(Character.valueOf('C'));
        receiptHeader.setStatus(this.collectionsUtil.getStatusForModuleAndCode("ReceiptHeader", "APPROVED"));
        receiptHeader.setPaidBy(bill.getPaidBy());
        if (ApplicationThreadLocals.getUserId() != null) {
            receiptHeader.setCreatedBy(this.collectionsUtil.getUserById(ApplicationThreadLocals.getUserId()));
        }
        BigDecimal chequeDDInstrumenttotal = BigDecimal.ZERO;
        BigDecimal otherInstrumenttotal = BigDecimal.ZERO;
        BigDecimal debitAmount = BigDecimal.ZERO;
        for (ReceiptDetail receiptDetail : receiptHeader.getReceiptDetails()) {
            debitAmount = debitAmount.add(receiptDetail.getCramount());
            debitAmount = debitAmount.subtract(receiptDetail.getDramount());
        }
        receiptHeader.addReceiptDetail(this.collectionCommon.addDebitAccountHeadDetails(debitAmount, receiptHeader, chequeDDInstrumenttotal, otherInstrumenttotal, paymentInfoList.get(0).getInstrumentType().toString()));
        this.receiptHeaderService.persist(receiptHeader);
        this.receiptHeaderService.getSession().flush();
        LOGGER.info((Object)("Miscellaneous Receipt Created with receipt number: " + receiptHeader.getReceiptnumber()));
        try {
            this.receiptHeaderService.createVoucherForReceipt(receiptHeader);
            LOGGER.debug((Object)"Updated financial systems and created voucher.");
        }
        catch (ApplicationRuntimeException ex) {
            this.errors.add(new ValidationError("Miscellaneous Receipt creation transaction rolled back as update to financial system failed.", "Miscellaneous Receipt creation transaction rolled back as update to financial system failed."));
            LOGGER.error((Object)"Update to financial systems failed");
        }
        ArrayList<CVoucherHeader> voucherHeaderList = new ArrayList<CVoucherHeader>();
        LOGGER.info((Object)("Receipt Voucher created with vouchernumber:        " + receiptHeader.getVoucherNum()));
        for (ReceiptVoucher receiptVoucher : receiptHeader.getReceiptVoucher()) {
            voucherHeaderList.add(receiptVoucher.getVoucherheader());
        }
        LOGGER.info((Object)"Logs For Miscellaneous Receipt : Receipt Creation Finished....");
        return new BillReceiptInfoImpl(receiptHeader, this.chartOfAccountsHibernateDAO, this.persistenceService, null);
    }

    @Override
    public List<RestAggregatePaymentInfo> getAggregateReceiptTotal(PaymentInfoSearchRequest aggrReq) {
        ArrayList<RestAggregatePaymentInfo> listAggregatePaymentInfo = new ArrayList<RestAggregatePaymentInfo>(0);
        StringBuilder queryBuilder = new StringBuilder("select  sum(recordcount) as records,ulb, sum(total) as total,service  from public.receipt_aggr_view  where receipt_date>=:fromDate and receipt_date<=:toDate and service=:serviceCode  and source=:source and ulb=:ulbCode  group by ulb,service  ");
        SQLQuery query = this.getSession().createSQLQuery(queryBuilder.toString());
        query.setDate("fromDate", aggrReq.getFromdate());
        query.setDate("toDate", aggrReq.getTodate());
        query.setString("serviceCode", aggrReq.getServicecode());
        query.setString("source", aggrReq.getSource());
        query.setString("ulbCode", aggrReq.getUlbCode());
        LOGGER.debug((Object)aggrReq.getSource());
        List queryResults = query.list();
        for (Object[] objectArray : queryResults) {
            RestAggregatePaymentInfo aggregatePaymentInfo = new RestAggregatePaymentInfo();
            aggregatePaymentInfo.setTxncount(Integer.parseInt(objectArray[0].toString()));
            aggregatePaymentInfo.setUlbcode(objectArray[1].toString());
            aggregatePaymentInfo.setTxnamount(new BigDecimal(objectArray[2].toString()));
            aggregatePaymentInfo.setServiceCode(objectArray[3].toString());
            listAggregatePaymentInfo.add(aggregatePaymentInfo);
        }
        if (listAggregatePaymentInfo.size() == 0) {
            listAggregatePaymentInfo.add(new RestAggregatePaymentInfo());
        }
        return listAggregatePaymentInfo;
    }

    @Override
    public List<RestReceiptInfo> getReceiptDetailsByDateAndService(PaymentInfoSearchRequest aggrReq) {
        ArrayList<RestReceiptInfo> receipts = new ArrayList<RestReceiptInfo>(0);
        PaymentInfoService paymentInfoService = (PaymentInfoService)this.beanProvider.getBean("paymentInfoService");
        List receiptHeaders = this.findAllByNamedQuery("RECEIPTS_BY_DATE_AND_SERVICECODE", new Object[]{aggrReq.getFromdate(), aggrReq.getTodate(), aggrReq.getServicecode(), aggrReq.getSource()});
        if (receiptHeaders == null || receiptHeaders.isEmpty()) {
            receipts.add(new RestReceiptInfo());
            return receipts;
        }
        for (ReceiptHeader receiptHeader : receiptHeaders) {
            RestReceiptInfo restReceiptInfo = new RestReceiptInfo(receiptHeader);
            paymentInfoService.setPaymentInfo(restReceiptInfo, receiptHeader);
            receipts.add(restReceiptInfo);
        }
        return receipts;
    }

    @Override
    public String cancelReceipt(PaymentInfoSearchRequest cancelReq) {
        String statusMessage = null;
        String instrumentType = "";
        boolean isInstrumentDeposited = false;
        ReceiptHeader receiptHeaderToBeCancelled = (ReceiptHeader)((Object)this.persistenceService.findByNamedQuery("RECEIPTS_BY_RECEIPTNUM", new Object[]{cancelReq.getReceiptNo()}));
        if (receiptHeaderToBeCancelled == null) {
            throw new RuntimeException("Invalid receiptNumber:" + cancelReq.getReceiptNo());
        }
        if (!cancelReq.getTransactionId().equals(receiptHeaderToBeCancelled.getManualreceiptnumber())) {
            throw new RuntimeException("transactionId doesnot match with receiptNo  " + cancelReq.getReceiptNo());
        }
        if ("CANCELLED".equalsIgnoreCase(receiptHeaderToBeCancelled.getStatus().getCode())) {
            throw new RuntimeException("Receipt is already Cancelled  " + cancelReq.getReceiptNo());
        }
        LOGGER.info((Object)("Receipt Header to be Cancelled : " + receiptHeaderToBeCancelled.getReceiptnumber()));
        for (InstrumentHeader instrumentHeader : receiptHeaderToBeCancelled.getReceiptInstrument()) {
            if (instrumentHeader.getInstrumentType().getType().equals("cash")) {
                if (!instrumentHeader.getStatusId().getDescription().equals("Reconciled")) continue;
                isInstrumentDeposited = true;
                break;
            }
            if (!instrumentHeader.getStatusId().getDescription().equals("Deposited")) continue;
            isInstrumentDeposited = true;
            break;
        }
        if (isInstrumentDeposited) {
            statusMessage = "Receipt cannot be cancelled since Instrument is already deposited";
        } else {
            receiptHeaderToBeCancelled.setStatus(this.statusDAO.getStatusByModuleAndCode("ReceiptHeader", "CANCELLED"));
            receiptHeaderToBeCancelled.setIsReconciled(false);
            receiptHeaderToBeCancelled.setReasonForCancellation("Receipt Cancelled by meSeva");
            for (InstrumentHeader instrumentHeader : receiptHeaderToBeCancelled.getReceiptInstrument()) {
                instrumentHeader.setStatusId(this.statusDAO.getStatusByModuleAndCode("Instrument", "Cancelled"));
                instrumentType = instrumentHeader.getInstrumentType().getType();
            }
            for (ReceiptVoucher receiptVoucher : receiptHeaderToBeCancelled.getReceiptVoucher()) {
                this.receiptHeaderService.createReversalVoucher(receiptVoucher, instrumentType);
            }
            this.receiptHeaderService.persist(receiptHeaderToBeCancelled);
            if (receiptHeaderToBeCancelled.getState() != null && !receiptHeaderToBeCancelled.getState().getValue().equals("END")) {
                this.receiptHeaderService.endReceiptWorkFlowOnCancellation(receiptHeaderToBeCancelled);
            }
            LOGGER.info((Object)("Receipt Cancelled with Receipt Number(saveOnCancel): " + receiptHeaderToBeCancelled.getReceiptnumber() + "; Consumer Code: " + receiptHeaderToBeCancelled.getConsumerCode()));
            statusMessage = "Receipt Cancelled Successfully";
        }
        return statusMessage;
    }

    @Override
    public List<ReceiptDetail> getReceiptDetailListByReceiptNumber(String receiptNumber) {
        List receiptDetList = this.persistenceService.findAllByNamedQuery("QUERY_RECEIPTDETAIL_BY_RECEIPTNUMBER", new Object[]{receiptNumber});
        return receiptDetList;
    }

    @Override
    @Transactional
    public PaymentRequest processMobilePayments(BillInfoImpl billInfo) throws ValidationException {
        ReceiptHeader receiptHeader = new ReceiptHeader();
        BigDecimal totalAmountToBeCollected = BigDecimal.ZERO;
        Fund fund = this.fundDAO.fundByCode(billInfo.getFundCode());
        if (fund == null) {
            throw new ValidationException(Arrays.asList(new ValidationError("billreceipt.improperbilldata.missingfund", "billreceipt.improperbilldata.missingfund")));
        }
        Department dept = (Department)this.persistenceService.findByNamedQuery("getDepartmentByCode", new Object[]{billInfo.getDepartmentCode()});
        if (dept == null) {
            throw new ValidationException(Arrays.asList(new ValidationError("billreceipt.improperbilldata.missingdepartment", "billreceipt.improperbilldata.missingdepartment")));
        }
        receiptHeader = this.collectionCommon.initialiseReceiptModelWithBillInfo(billInfo, fund, dept);
        totalAmountToBeCollected = totalAmountToBeCollected.add(receiptHeader.getTotalAmountToBeCollected());
        for (ReceiptDetail rDetails : receiptHeader.getReceiptDetails()) {
            rDetails.getCramountToBePaid().setScale(2, 0);
        }
        if (totalAmountToBeCollected.compareTo(BigDecimal.ZERO) == -1) {
            LOGGER.info((Object)"Amount to be collected is less than zero, hence cannot proceed.");
            throw new ValidationException(Arrays.asList(new ValidationError("billreceipt.totalamountlessthanzero.error", "billreceipt.totalamountlessthanzero.error")));
        }
        receiptHeader.setTotalAmount(totalAmountToBeCollected.setScale(2, 0));
        ServiceDetails paymentService = (ServiceDetails)this.persistenceService.findByNamedQuery("getServiceByCode", new Object[]{"AXIS"});
        if (receiptHeader.getStatus() == null) {
            receiptHeader.setReceiptdate(new Date());
            receiptHeader.setReceipttype('B');
            receiptHeader.setIsModifiable(Boolean.FALSE);
            receiptHeader.setIsReconciled(Boolean.TRUE);
            receiptHeader.setCollectiontype(Character.valueOf('O'));
            receiptHeader.setStatus(this.collectionsUtil.getReceiptStatusForCode("PENDING"));
            receiptHeader.setSource(Source.MOBILE.toString());
            BigDecimal debitAmount = BigDecimal.ZERO;
            for (ReceiptDetail receiptDetail : receiptHeader.getReceiptDetails()) {
                receiptDetail.setCramount(receiptDetail.getCramount());
                debitAmount = debitAmount.add(receiptDetail.getCramount());
                debitAmount = debitAmount.subtract(receiptDetail.getDramount());
            }
            receiptHeader.addReceiptDetail(this.collectionCommon.addDebitAccountHeadDetails(debitAmount, receiptHeader, BigDecimal.ZERO, receiptHeader.getTotalAmount(), "online"));
            OnlinePayment onlinePayment = new OnlinePayment();
            onlinePayment.setStatus(this.collectionsUtil.getStatusForModuleAndCode("OnlinePayment", "ONLINE_STATUS_PENDING"));
            onlinePayment.setReceiptHeader(receiptHeader);
            onlinePayment.setService(paymentService);
            receiptHeader.setOnlinePayment(onlinePayment);
        }
        this.receiptHeaderService.persistReceiptObject(receiptHeader);
        return this.collectionCommon.createPaymentRequest(paymentService, receiptHeader);
    }

    public void setCollectionCommon(CollectionCommon collectionCommon) {
        this.collectionCommon = collectionCommon;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }
}

