/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.integration.services;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.integration.pgi.PaymentResponse;
import org.egov.collection.service.ReceiptHeaderService;
import org.egov.collection.utils.CollectionCommon;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.collection.utils.FinancialsUtil;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.infstr.services.PersistenceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class ReconciliationService {
    private static final Logger LOGGER = Logger.getLogger(ReconciliationService.class);
    public ReceiptHeaderService receiptHeaderService;
    private CollectionsUtil collectionsUtil;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    private CollectionCommon collectionCommon;
    private PersistenceService persistenceService;

    @Transactional
    public void processSuccessMsg(ReceiptHeader onlinePaymentReceiptHeader, PaymentResponse paymentResponse) {
        ArrayList<ReceiptDetail> existingReceiptDetails = new ArrayList<ReceiptDetail>(0);
        for (ReceiptDetail receiptDetail : onlinePaymentReceiptHeader.getReceiptDetails()) {
            if (FinancialsUtil.isRevenueAccountHead(receiptDetail.getAccounthead(), this.chartOfAccountsHibernateDAO.getBankChartofAccountCodeList(), this.persistenceService)) continue;
            ReceiptDetail newReceiptDetail = new ReceiptDetail();
            if (receiptDetail.getOrdernumber() != null) {
                newReceiptDetail.setOrdernumber(receiptDetail.getOrdernumber());
            }
            if (receiptDetail.getDescription() != null) {
                newReceiptDetail.setDescription(receiptDetail.getDescription());
            }
            if (receiptDetail.getIsActualDemand() != null) {
                newReceiptDetail.setIsActualDemand(receiptDetail.getIsActualDemand());
            }
            if (receiptDetail.getFunction() != null) {
                newReceiptDetail.setFunction(receiptDetail.getFunction());
            }
            if (receiptDetail.getCramountToBePaid() != null) {
                newReceiptDetail.setCramountToBePaid(receiptDetail.getCramountToBePaid());
            }
            newReceiptDetail.setCramount(receiptDetail.getCramount());
            newReceiptDetail.setAccounthead(receiptDetail.getAccounthead());
            newReceiptDetail.setDramount(receiptDetail.getDramount());
            newReceiptDetail.setPurpose(receiptDetail.getPurpose());
            existingReceiptDetails.add(newReceiptDetail);
        }
        List<ReceiptDetail> reconstructedList = this.collectionsUtil.reconstructReceiptDetail(onlinePaymentReceiptHeader, existingReceiptDetails);
        ReceiptDetail debitAccountDetail = null;
        if (reconstructedList != null) {
            debitAccountDetail = this.collectionCommon.addDebitAccountHeadDetails(onlinePaymentReceiptHeader.getTotalAmount(), onlinePaymentReceiptHeader, BigDecimal.ZERO, onlinePaymentReceiptHeader.getTotalAmount(), "online");
        }
        this.receiptHeaderService.reconcileOnlineSuccessPayment(onlinePaymentReceiptHeader, paymentResponse.getTxnDate(), paymentResponse.getTxnReferenceNo(), paymentResponse.getTxnAmount(), paymentResponse.getAuthStatus(), reconstructedList, debitAccountDetail);
        LOGGER.debug((Object)"Persisted receipt after receiving success message from the payment gateway");
    }

    @Transactional
    public void processFailureMsg(ReceiptHeader receiptHeader, PaymentResponse paymentResponse) {
        receiptHeader.setStatus(this.collectionsUtil.getReceiptStatusForCode("FAILED"));
        EgwStatus paymentStatus = "3".equals(paymentResponse.getAuthStatus()) ? this.collectionsUtil.getStatusForModuleAndCode("OnlinePayment", "ONLINE_STATUS_ABORTED") : this.collectionsUtil.getStatusForModuleAndCode("OnlinePayment", "ONLINE_STATUS_FAILURE");
        receiptHeader.getOnlinePayment().setStatus(paymentStatus);
        receiptHeader.getOnlinePayment().setAuthorisationStatusCode(paymentResponse.getAuthStatus());
        receiptHeader.getOnlinePayment().setRemarks(paymentResponse.getErrorDescription());
        this.receiptHeaderService.persist(receiptHeader);
        LOGGER.debug((Object)"Cancelled receipt after receiving failure message from the payment gateway");
    }

    public void setReceiptHeaderService(ReceiptHeaderService receiptHeaderService) {
        this.receiptHeaderService = receiptHeaderService;
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    public void setCollectionCommon(CollectionCommon collectionCommon) {
        this.collectionCommon = collectionCommon;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }
}

