/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import org.egov.collection.entity.AccountPayeeDetail;
import org.egov.commons.Accountdetailkey;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.utils.EntityType;
import org.egov.egf.commons.EgovCommon;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;

public class AccountPayeeDetailInfo {
    private AccountPayeeDetail accountPayeeDetail = null;
    private EntityType entityType;

    public AccountPayeeDetailInfo(AccountPayeeDetail accountPayeeDetail, EgovCommon egovCommon) {
        this.accountPayeeDetail = accountPayeeDetail;
        try {
            this.populateEntityType(accountPayeeDetail, egovCommon);
        }
        catch (ApplicationException e) {
            throw new ApplicationRuntimeException("Could not get entity type for account detail type [" + accountPayeeDetail.getAccountDetailType().getTablename() + "], account detail key id [" + accountPayeeDetail.getAccountDetailKey().getId() + "]", (Throwable)e);
        }
    }

    public void populateEntityType(AccountPayeeDetail accountPayeeDetail, EgovCommon egovCommon) throws ApplicationException {
        this.entityType = egovCommon.getEntityType(accountPayeeDetail.getAccountDetailType(), (Serializable)accountPayeeDetail.getAccountDetailKey().getDetailkey());
    }

    public String getGlCode() {
        return this.accountPayeeDetail.getReceiptDetail().getAccounthead().getGlcode() == null ? null : this.accountPayeeDetail.getReceiptDetail().getAccounthead().getGlcode();
    }

    public String getAccountDetailTypeName() {
        return this.accountPayeeDetail.getAccountDetailType().getName();
    }

    public Accountdetailtype getAccountDetailType() {
        return this.accountPayeeDetail.getAccountDetailType();
    }

    public Accountdetailkey getAccountDetailKey() {
        return this.accountPayeeDetail.getAccountDetailKey();
    }

    public BigDecimal getAmount() {
        return this.accountPayeeDetail.getAmount();
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public Long getOrderNumber() {
        return this.accountPayeeDetail.getReceiptDetail().getOrdernumber() == null ? null : this.accountPayeeDetail.getReceiptDetail().getOrdernumber();
    }
}

