/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.integration.services;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.egov.collection.entity.OnlinePayment;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.integration.pgi.AxisAdaptor;
import org.egov.collection.integration.pgi.PaymentResponse;
import org.egov.collection.integration.services.ReconciliationService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infstr.models.ServiceDetails;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class SchedularService {
    private static final Logger LOGGER = Logger.getLogger(SchedularService.class);
    private PersistenceService persistenceService;
    private ReconciliationService reconciliationService;
    @Autowired
    private AxisAdaptor axisAdaptor;

    @Transactional
    public void reconcileAXIS() {
        LOGGER.debug((Object)"Inside reconcileAXIS");
        Calendar cal = Calendar.getInstance();
        cal.add(12, -30);
        Query qry = this.persistenceService.getSession().createQuery("select receipt from org.egov.collection.entity.OnlinePayment as receipt where receipt.status.code=:onlinestatuscode and receipt.service.code=:paymentservicecode and receipt.createdDate<:thirtyminslesssysdate").setMaxResults(50);
        qry.setString("onlinestatuscode", "ONLINE_STATUS_PENDING");
        qry.setString("paymentservicecode", "AXIS");
        qry.setParameter("thirtyminslesssysdate", (Object)new Date(cal.getTimeInMillis()));
        List reconcileList = qry.list();
        LOGGER.debug((Object)("Thread ID = " + Thread.currentThread().getId() + ": got " + reconcileList.size() + " results."));
        if (!reconcileList.isEmpty()) {
            ServiceDetails paymentService = (ServiceDetails)this.persistenceService.findByNamedQuery("getServiceByCode", new Object[]{"AXIS"});
            for (OnlinePayment onlinePaymentObj : reconcileList) {
                long startTimeInMilis = System.currentTimeMillis();
                LOGGER.info((Object)("AXIS Receiptid::::" + onlinePaymentObj.getReceiptHeader().getId()));
                PaymentResponse paymentResponse = this.axisAdaptor.createOfflinePaymentRequest(paymentService, onlinePaymentObj);
                if (paymentResponse == null || !StringUtils.isNotBlank((CharSequence)paymentResponse.getReceiptId())) continue;
                LOGGER.info((Object)("paymentResponse.getReceiptId():" + paymentResponse.getReceiptId()));
                LOGGER.info((Object)("paymentResponse.getAdditionalInfo6():" + paymentResponse.getAdditionalInfo6()));
                LOGGER.info((Object)("paymentResponse.getAuthStatus():" + paymentResponse.getAuthStatus()));
                ReceiptHeader onlinePaymentReceiptHeader = (ReceiptHeader)((Object)this.persistenceService.findByNamedQuery("QUERY_RECEIPT_BY_ID_AND_CITYCODE", new Object[]{Long.valueOf(paymentResponse.getReceiptId()), ApplicationThreadLocals.getCityCode()}));
                if ("0300".equals(paymentResponse.getAuthStatus())) {
                    this.reconciliationService.processSuccessMsg(onlinePaymentReceiptHeader, paymentResponse);
                } else {
                    this.reconciliationService.processFailureMsg(onlinePaymentReceiptHeader, paymentResponse);
                }
                long elapsedTimeInMillis = System.currentTimeMillis() - startTimeInMilis;
                LOGGER.info((Object)("$$$$$$ Online Receipt Persisted with Receipt Number: " + onlinePaymentReceiptHeader.getReceiptnumber() + (onlinePaymentReceiptHeader.getConsumerCode() != null ? " and consumer code: " + onlinePaymentReceiptHeader.getConsumerCode() : "") + "; Time taken(ms) = " + elapsedTimeInMillis));
            }
        }
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setReconciliationService(ReconciliationService reconciliationService) {
        this.reconciliationService = reconciliationService;
    }
}

