/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.xml.converter;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.collection.integration.models.BillReceiptInfoImpl;
import org.egov.collection.integration.models.ReceiptAccountInfo;
import org.egov.collection.integration.models.ReceiptInstrumentInfo;
import org.egov.collection.xml.converter.ConverterUtil;

public class BillReceiptInfoConverter
implements Converter {
    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        BillReceiptInfo receiptInfo = (BillReceiptInfo)value;
        ConverterUtil.createNode(writer, "event", receiptInfo.getEvent());
        ConverterUtil.createNode(writer, "referenceNumber", receiptInfo.getBillReferenceNum());
        ConverterUtil.createNode(writer, "receiptNumber", receiptInfo.getReceiptNum());
        ConverterUtil.createNode(writer, "receiptDate", String.valueOf(receiptInfo.getReceiptDate()));
        ConverterUtil.createNode(writer, "location", receiptInfo.getReceiptLocation() == null ? "" : receiptInfo.getReceiptLocation().getName());
        ConverterUtil.createNode(writer, "status", receiptInfo.getReceiptStatus().getCode());
        ConverterUtil.createNode(writer, "PayeeName", receiptInfo.getPayeeName());
        ConverterUtil.createNode(writer, "PayeeAddress", receiptInfo.getPayeeAddress());
        writer.startNode("Receipt-Accounts");
        for (ReceiptAccountInfo receiptAccountInfo : receiptInfo.getAccountDetails()) {
            context.convertAnother((Object)receiptAccountInfo);
        }
        writer.endNode();
        writer.startNode("Receipt-Instruments");
        for (ReceiptInstrumentInfo receiptInstrumentInfo : receiptInfo.getInstrumentDetails()) {
            context.convertAnother((Object)receiptInstrumentInfo);
        }
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader arg0, UnmarshallingContext arg1) {
        return null;
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(BillReceiptInfoImpl.class);
    }
}

