/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.integration.services;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.collection.entity.OnlinePayment;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.integration.pgi.AxisAdaptor;
import org.egov.collection.integration.pgi.PaymentResponse;
import org.egov.collection.integration.services.ReconciliationService;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infstr.models.ServiceDetails;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class SchedularService {
    private static final Logger LOGGER = Logger.getLogger(SchedularService.class);
    protected PersistenceService persistenceService;
    private ReceiptHeader onlinePaymentReceiptHeader;
    private PaymentResponse paymentResponse;
    private ReconciliationService reconciliationService;
    @Autowired
    private CityService cityService;
    @Autowired
    AxisAdaptor axisAdaptor;

    @Transactional
    public void reconcileAXIS() {
        LOGGER.debug((Object)"Inside reconcileAXIS");
        Calendar cal = Calendar.getInstance();
        cal.add(12, -30);
        SQLQuery queryCity = this.persistenceService.getSession().createSQLQuery("select domainurl from eg_city");
        List cityList = queryCity.list();
        if (cityList.size() > 1) {
            ApplicationThreadLocals.setDomainName((String)"localhost");
        } else {
            ApplicationThreadLocals.setDomainName((String)cityList.get(0).toString());
        }
        Query qry = this.persistenceService.getSession().createQuery("select receipt from org.egov.collection.entity.OnlinePayment as receipt where receipt.status.code=:onlinestatuscode and receipt.service.code=:paymentservicecode and receipt.createdDate<:thirtyminslesssysdate").setMaxResults(50);
        qry.setString("onlinestatuscode", "ONLINE_STATUS_PENDING");
        qry.setString("paymentservicecode", "AXIS");
        qry.setParameter("thirtyminslesssysdate", (Object)new Date(cal.getTimeInMillis()));
        List reconcileList = qry.list();
        LOGGER.debug((Object)("Thread ID = " + Thread.currentThread().getId() + ": got " + reconcileList.size() + " results."));
        if (reconcileList.size() > 0) {
            ServiceDetails paymentService = (ServiceDetails)this.persistenceService.findByNamedQuery("getServiceByCode", new Object[]{"AXIS"});
            for (OnlinePayment onlinePaymentObj : reconcileList) {
                long startTimeInMilis = System.currentTimeMillis();
                LOGGER.info((Object)("AXIS Receiptid::::" + onlinePaymentObj.getReceiptHeader().getId()));
                this.paymentResponse = this.axisAdaptor.createOfflinePaymentRequest(paymentService, onlinePaymentObj);
                if (null == this.paymentResponse || this.paymentResponse.getReceiptId() == null || this.paymentResponse.getReceiptId().equals("")) continue;
                LOGGER.info((Object)("paymentResponse.getReceiptId():" + this.paymentResponse.getReceiptId()));
                LOGGER.info((Object)("paymentResponse.getAdditionalInfo6():" + this.paymentResponse.getAdditionalInfo6()));
                LOGGER.info((Object)("paymentResponse.getAuthStatus():" + this.paymentResponse.getAuthStatus()));
                City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
                this.onlinePaymentReceiptHeader = (ReceiptHeader)((Object)this.persistenceService.findByNamedQuery("QUERY_RECEIPT_BY_ID_AND_CITYCODE", new Object[]{Long.valueOf(this.paymentResponse.getReceiptId()), cityWebsite.getCode()}));
                if ("0300".equals(this.paymentResponse.getAuthStatus())) {
                    this.reconciliationService.processSuccessMsg(this.onlinePaymentReceiptHeader, this.paymentResponse);
                } else {
                    this.reconciliationService.processFailureMsg(this.onlinePaymentReceiptHeader, this.paymentResponse);
                }
                long elapsedTimeInMillis = System.currentTimeMillis() - startTimeInMilis;
                LOGGER.info((Object)("$$$$$$ Online Receipt Persisted with Receipt Number: " + this.onlinePaymentReceiptHeader.getReceiptnumber() + (this.onlinePaymentReceiptHeader.getConsumerCode() != null ? " and consumer code: " + this.onlinePaymentReceiptHeader.getConsumerCode() : "") + "; Time taken(ms) = " + elapsedTimeInMillis));
            }
        }
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setReconciliationService(ReconciliationService reconciliationService) {
        this.reconciliationService = reconciliationService;
    }
}

