/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.integration.models;

import java.math.BigDecimal;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.integration.models.ReceiptAccountInfo;
import org.egov.collection.utils.FinancialsUtil;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.infstr.services.PersistenceService;

public class ReceiptAccountInfoImpl
implements ReceiptAccountInfo {
    private boolean isRevenueAccount;
    private ReceiptDetail receiptDetail;

    public ReceiptAccountInfoImpl(ReceiptDetail receiptDetail, ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO, PersistenceService persistenceService) {
        this.receiptDetail = receiptDetail;
        this.isRevenueAccount = FinancialsUtil.isRevenueAccountHead(this.receiptDetail.getAccounthead(), chartOfAccountsHibernateDAO.getBankChartofAccountCodeList(), persistenceService);
    }

    public String toString() {
        return this.receiptDetail.toString();
    }

    @Override
    public String getGlCode() {
        return this.receiptDetail.getAccounthead() == null ? null : this.receiptDetail.getAccounthead().getGlcode();
    }

    @Override
    public String getAccountName() {
        return this.receiptDetail.getAccounthead() == null ? null : this.receiptDetail.getAccounthead().getName();
    }

    @Override
    public String getFunction() {
        return this.receiptDetail.getFunction() == null ? null : this.receiptDetail.getFunction().getCode();
    }

    @Override
    public String getFunctionName() {
        return this.receiptDetail.getFunction() == null ? null : this.receiptDetail.getFunction().getName();
    }

    @Override
    public BigDecimal getDrAmount() {
        return this.receiptDetail.getDramount();
    }

    @Override
    public BigDecimal getCrAmount() {
        return this.receiptDetail.getCramount();
    }

    @Override
    public boolean getIsRevenueAccount() {
        return this.isRevenueAccount;
    }

    @Override
    public Long getOrderNumber() {
        return this.receiptDetail.getOrdernumber() == null ? null : this.receiptDetail.getOrdernumber();
    }

    @Override
    public String getDescription() {
        return this.receiptDetail.getDescription();
    }

    @Override
    public String getFinancialYear() {
        return this.receiptDetail.getFinancialYear() == null ? null : this.receiptDetail.getFinancialYear().getFinYearRange();
    }

    @Override
    public BigDecimal getCreditAmountToBePaid() {
        return this.receiptDetail.getCramountToBePaid();
    }
}

