/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.integration.models;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.egov.collection.integration.models.BillInfo;
import org.egov.collection.integration.models.BillPayeeDetails;

@XStreamAlias(value="bill-collect")
public class BillInfoImpl
implements BillInfo {
    private String serviceCode;
    private String fundCode;
    private BigDecimal functionaryCode;
    private String fundSourceCode;
    private String departmentCode;
    private String displayMessage;
    private String paidBy;
    private Boolean partPaymentAllowed;
    private Boolean callbackForApportioning;
    private Boolean overrideAccountHeadsAllowed;
    private BillInfo.COLLECTIONTYPE collectionType;
    @XStreamImplicit(itemFieldName="collectionModeNotAllowed")
    private List<String> collectionModesNotAllowed;
    @XStreamAlias(value="payees")
    private List<BillPayeeDetails> payees = new ArrayList<BillPayeeDetails>(0);
    private String transactionReferenceNumber;
    private String source;

    @Override
    public String getServiceCode() {
        return this.serviceCode;
    }

    public BillInfoImpl() {
    }

    public BillInfoImpl(String serviceCode, String fundCode, BigDecimal functionaryCode, String fundSourceCode, String departmentCode, String displayMessage, String paidBy, Boolean partPaymentAllowed, Boolean overrideAccountHeadsAllowed, List<String> collectionModesNotAllowed, BillInfo.COLLECTIONTYPE collectionType) {
        this.serviceCode = serviceCode;
        this.fundCode = fundCode;
        this.functionaryCode = functionaryCode;
        this.fundSourceCode = fundSourceCode;
        this.departmentCode = departmentCode;
        this.displayMessage = displayMessage;
        this.paidBy = paidBy;
        this.partPaymentAllowed = partPaymentAllowed;
        this.overrideAccountHeadsAllowed = overrideAccountHeadsAllowed;
        this.collectionModesNotAllowed = collectionModesNotAllowed;
        this.collectionType = collectionType;
    }

    @Override
    public String getFundCode() {
        return this.fundCode;
    }

    @Override
    public BigDecimal getFunctionaryCode() {
        return this.functionaryCode;
    }

    @Override
    public String getFundSourceCode() {
        return this.fundSourceCode;
    }

    @Override
    public String getDepartmentCode() {
        return this.departmentCode;
    }

    @Override
    public String getDisplayMessage() {
        return this.displayMessage;
    }

    @Override
    public Boolean getPartPaymentAllowed() {
        return this.partPaymentAllowed;
    }

    @Override
    public Boolean getOverrideAccountHeadsAllowed() {
        return this.overrideAccountHeadsAllowed;
    }

    @Override
    public List<String> getCollectionModesNotAllowed() {
        return this.collectionModesNotAllowed;
    }

    @Override
    public List<BillPayeeDetails> getPayees() {
        return this.payees;
    }

    @Override
    public void setPayees(List<BillPayeeDetails> payees) {
        this.payees = payees;
    }

    @Override
    public void addPayees(BillPayeeDetails payee) {
        this.payees.add(payee);
    }

    @Override
    public BillInfo.COLLECTIONTYPE getCollectionType() {
        return this.collectionType;
    }

    @Override
    public String getPaidBy() {
        return this.paidBy;
    }

    @Override
    public Boolean getCallbackForApportioning() {
        return this.callbackForApportioning;
    }

    public void setCallbackForApportioning(Boolean callbackForApportioning) {
        this.callbackForApportioning = callbackForApportioning;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BillInfoImpl)) {
            return false;
        }
        BillInfoImpl billColl = (BillInfoImpl)obj;
        if (this.serviceCode.equals(billColl.getServiceCode()) && this.fundCode.equals(billColl.fundCode) && this.functionaryCode.equals(billColl.functionaryCode) && this.fundSourceCode.equals(billColl.fundSourceCode) && this.departmentCode.equals(billColl.departmentCode) && this.displayMessage.equals(billColl.displayMessage) && this.partPaymentAllowed == billColl.partPaymentAllowed && this.overrideAccountHeadsAllowed == billColl.overrideAccountHeadsAllowed && this.callbackForApportioning == billColl.callbackForApportioning && this.getPayees().containsAll(billColl.getPayees())) {
            return this.collectionModesNotAllowed == billColl.getCollectionModesNotAllowed() || this.collectionModesNotAllowed != null && this.collectionModesNotAllowed.containsAll(billColl.getCollectionModesNotAllowed());
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this.serviceCode.hashCode() + this.fundCode.hashCode() + this.functionaryCode.hashCode() + this.fundSourceCode.hashCode() + this.departmentCode.hashCode() + this.displayMessage.hashCode() + this.partPaymentAllowed.hashCode() + this.overrideAccountHeadsAllowed.hashCode();
        for (String collectionModeNotAllowed : this.collectionModesNotAllowed) {
            hashCode += collectionModeNotAllowed.hashCode();
        }
        return hashCode;
    }

    @Override
    public String getTransactionReferenceNumber() {
        return this.transactionReferenceNumber;
    }

    public void setTransactionReferenceNumber(String transactionReferenceNumber) {
        this.transactionReferenceNumber = transactionReferenceNumber;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }
}

