/*
 * Decompiled with CFR 0.152.
 */
package org.egov.bpa.application.entity;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.bpa.application.entity.Document;
import org.egov.bpa.application.entity.Noc;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGBPA_MSTR_SERVICETYPE")
@SequenceGenerator(name="SEQ_EGBPA_MSTR_SERVICETYPE", sequenceName="SEQ_EGBPA_MSTR_SERVICETYPE", allocationSize=1)
public class ServiceType
extends AbstractAuditable {
    private static final long serialVersionUID = 3078684328383202788L;
    public static final String SEQ_SERVICETYPE = "SEQ_EGBPA_MSTR_SERVICETYPE";
    @Id
    @GeneratedValue(generator="SEQ_EGBPA_MSTR_SERVICETYPE", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @Length(min=1, max=128)
    @Column(name="code", unique=true)
    private String code;
    @Length(min=1, max=256)
    private String description;
    private Boolean isActive;
    private Boolean buildingPlanApproval;
    @NotNull
    private Boolean siteApproval;
    @NotNull
    private Boolean isApplicationFeeRequired;
    @NotNull
    private Boolean isPtisNumberRequired;
    @NotNull
    private Boolean isAutoDcrNumberRequired;
    @NotNull
    @Length(min=1, max=128)
    private String serviceNumberPrefix;
    @Length(min=1, max=256)
    private String descriptionLocal;
    private Boolean isDocUploadForCitizen;
    private Long sla;
    @OneToMany(mappedBy="serviceType", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private final List<Document> document = new ArrayList<Document>(0);
    @OneToMany(mappedBy="serviceType", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private final List<Noc> noc = new ArrayList<Noc>(0);

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public Boolean getIsPtisNumberRequired() {
        return this.isPtisNumberRequired;
    }

    public void setIsPtisNumberRequired(Boolean isPtisNumberRequired) {
        this.isPtisNumberRequired = isPtisNumberRequired;
    }

    public Boolean getIsAutoDcrNumberRequired() {
        return this.isAutoDcrNumberRequired;
    }

    public void setIsAutoDcrNumberRequired(Boolean isAutoDcrNumberRequired) {
        this.isAutoDcrNumberRequired = isAutoDcrNumberRequired;
    }

    public String getServiceNumberPrefix() {
        return this.serviceNumberPrefix;
    }

    public void setServiceNumberPrefix(String serviceNumberPrefix) {
        this.serviceNumberPrefix = serviceNumberPrefix;
    }

    public String getDescriptionLocal() {
        return this.descriptionLocal;
    }

    public void setDescriptionLocal(String descriptionLocal) {
        this.descriptionLocal = descriptionLocal;
    }

    public Boolean getIsDocUploadForCitizen() {
        return this.isDocUploadForCitizen;
    }

    public void setIsDocUploadForCitizen(Boolean isDocUploadForCitizen) {
        this.isDocUploadForCitizen = isDocUploadForCitizen;
    }

    public Boolean getSiteApproval() {
        return this.siteApproval;
    }

    public Boolean getIsApplicationFeeRequired() {
        return this.isApplicationFeeRequired;
    }

    public Long getSla() {
        return this.sla;
    }

    public void setSiteApproval(Boolean siteApproval) {
        this.siteApproval = siteApproval;
    }

    public void setIsApplicationFeeRequired(Boolean isApplicationFeeRequired) {
        this.isApplicationFeeRequired = isApplicationFeeRequired;
    }

    public void setSla(Long sla) {
        this.sla = sla;
    }

    public Boolean getBuildingPlanApproval() {
        return this.buildingPlanApproval;
    }

    public void setBuildingPlanApproval(Boolean buildingPlanApproval) {
        this.buildingPlanApproval = buildingPlanApproval;
    }

    public List<Document> getDocument() {
        return this.document;
    }

    public List<Noc> getNoc() {
        return this.noc;
    }
}

