/*
 * Decompiled with CFR 0.152.
 */
package org.egov.bpa.application.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.egov.bpa.application.entity.Application;
import org.egov.bpa.application.entity.AutoDcrMap;
import org.egov.bpa.application.entity.Inspection;
import org.egov.bpa.application.entity.LpReason;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGBPA_LETTERTOPARTY")
@SequenceGenerator(name="SEQ_EGBPA_LETTERTOPARTY", sequenceName="SEQ_EGBPA_LETTERTOPARTY", allocationSize=1)
public class LettertoParty
extends AbstractAuditable {
    private static final long serialVersionUID = 3078684328383202788L;
    public static final String SEQ_LETTERTOPARTY = "SEQ_EGBPA_LETTERTOPARTY";
    @Id
    @GeneratedValue(generator="SEQ_EGBPA_LETTERTOPARTY", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Application application;
    @ManyToOne(fetch=FetchType.LAZY)
    private Inspection inspection;
    @Length(min=1, max=32)
    private String acknowledgementNumber;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private LpReason lpReason;
    @Length(min=1, max=128)
    private String lpNumber;
    @NotNull
    @Temporal(value=TemporalType.DATE)
    private Date letterDate;
    @ManyToOne(fetch=FetchType.LAZY)
    private User scheduledby;
    @Length(min=1, max=128)
    private String scheduledPlace;
    private Date scheduledtime;
    @Temporal(value=TemporalType.DATE)
    private Date sentDate;
    @Temporal(value=TemporalType.DATE)
    private Date replyDate;
    @Length(min=1, max=1024)
    private String lpRemarks;
    @Length(min=1, max=1024)
    private String lpReplyRemarks;
    @Length(min=1, max=1024)
    private String lpDesc;
    @Length(min=1, max=1024)
    private String lpReplyDesc;
    private Boolean isHistory;
    @Length(min=1, max=512)
    private String documentid;
    @OneToMany(mappedBy="letterToParty", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private final List<AutoDcrMap> autoDcrMap = new ArrayList<AutoDcrMap>(0);

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Inspection getInspection() {
        return this.inspection;
    }

    public void setInspection(Inspection inspection) {
        this.inspection = inspection;
    }

    public String getAcknowledgementNumber() {
        return this.acknowledgementNumber;
    }

    public void setAcknowledgementNumber(String acknowledgementNumber) {
        this.acknowledgementNumber = acknowledgementNumber;
    }

    public LpReason getLpReason() {
        return this.lpReason;
    }

    public void setLpReason(LpReason lpReason) {
        this.lpReason = lpReason;
    }

    public String getLpNumber() {
        return this.lpNumber;
    }

    public void setLpNumber(String lpNumber) {
        this.lpNumber = lpNumber;
    }

    public Date getLetterDate() {
        return this.letterDate;
    }

    public void setLetterDate(Date letterDate) {
        this.letterDate = letterDate;
    }

    public User getScheduledby() {
        return this.scheduledby;
    }

    public void setScheduledby(User scheduledby) {
        this.scheduledby = scheduledby;
    }

    public String getScheduledPlace() {
        return this.scheduledPlace;
    }

    public void setScheduledPlace(String scheduledPlace) {
        this.scheduledPlace = scheduledPlace;
    }

    public Date getScheduledtime() {
        return this.scheduledtime;
    }

    public void setScheduledtime(Date scheduledtime) {
        this.scheduledtime = scheduledtime;
    }

    public Date getSentDate() {
        return this.sentDate;
    }

    public void setSentDate(Date sentDate) {
        this.sentDate = sentDate;
    }

    public Date getReplyDate() {
        return this.replyDate;
    }

    public void setReplyDate(Date replyDate) {
        this.replyDate = replyDate;
    }

    public String getLpRemarks() {
        return this.lpRemarks;
    }

    public void setLpRemarks(String lpRemarks) {
        this.lpRemarks = lpRemarks;
    }

    public String getLpReplyRemarks() {
        return this.lpReplyRemarks;
    }

    public void setLpReplyRemarks(String lpReplyRemarks) {
        this.lpReplyRemarks = lpReplyRemarks;
    }

    public String getLpDesc() {
        return this.lpDesc;
    }

    public void setLpDesc(String lpDesc) {
        this.lpDesc = lpDesc;
    }

    public String getLpReplyDesc() {
        return this.lpReplyDesc;
    }

    public void setLpReplyDesc(String lpReplyDesc) {
        this.lpReplyDesc = lpReplyDesc;
    }

    public Boolean getIsHistory() {
        return this.isHistory;
    }

    public void setIsHistory(Boolean isHistory) {
        this.isHistory = isHistory;
    }

    public String getDocumentid() {
        return this.documentid;
    }

    public void setDocumentid(String documentid) {
        this.documentid = documentid;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public List<AutoDcrMap> getAutoDcrMap() {
        return this.autoDcrMap;
    }
}

