/*
 * Decompiled with CFR 0.152.
 */
package org.egov.bpa.application.entity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.egov.bpa.application.entity.Application;
import org.egov.bpa.application.entity.ConstructionStages;
import org.egov.bpa.application.entity.Docket;
import org.egov.bpa.application.entity.FloorDetail;
import org.egov.bpa.application.entity.LandBuildingTypes;
import org.egov.bpa.application.entity.LayoutMaster;
import org.egov.bpa.application.entity.StormWaterDrain;
import org.egov.bpa.application.entity.SurroundedBldgDtl;
import org.egov.bpa.application.entity.enums.LandBldngZoneing;
import org.egov.bpa.application.entity.enums.RoadType;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGBPA_INSPECTION")
@SequenceGenerator(name="SEQ_EGBPA_INSPECTION", sequenceName="SEQ_EGBPA_INSPECTION", allocationSize=1)
public class Inspection
extends AbstractAuditable {
    private static final long serialVersionUID = 3078684328383202788L;
    public static final String SEQ_INSPECTION = "SEQ_EGBPA_INSPECTION";
    @Id
    @GeneratedValue(generator="SEQ_EGBPA_INSPECTION", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Length(min=1, max=64)
    private String inspectionNumber;
    @NotNull
    @Temporal(value=TemporalType.DATE)
    private Date inspectionDate;
    @ManyToOne(fetch=FetchType.LAZY)
    private Inspection parent;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private User inspectedBy;
    private Boolean isSiteVacant;
    private Boolean isExistingBuildingAsPerPlan;
    private Boolean isInspected;
    @Length(min=1, max=256)
    private String inspectionRemarks;
    private Boolean isPostponed;
    @Length(min=1, max=256)
    private String postponementReason;
    @Temporal(value=TemporalType.DATE)
    private Date postponedDate;
    private LandBldngZoneing landZoning;
    @ManyToOne(fetch=FetchType.LAZY)
    private LayoutMaster lndLayoutType;
    private BigDecimal lndMinPlotExtent = new BigDecimal(0);
    private BigDecimal lndProposedPlotExtent = new BigDecimal(0);
    private BigDecimal lndOsrLandExtent = new BigDecimal(0);
    private BigDecimal lndGuideLineValue = new BigDecimal(0);
    @ManyToOne(fetch=FetchType.LAZY)
    private LandBuildingTypes landUsage;
    private BigDecimal lndRegularizationArea = new BigDecimal(0);
    private Integer lndPenaltyPeriod;
    private Boolean lndIsRegularisationCharges;
    private LandBldngZoneing buildingZoning;
    @ManyToOne(fetch=FetchType.LAZY)
    private LandBuildingTypes buildingType;
    private BigDecimal bldngBuildUpArea = new BigDecimal(0);
    private BigDecimal bldngProposedPlotFrontage = new BigDecimal(0);
    private BigDecimal bldngRoadWidth = new BigDecimal(0);
    private BigDecimal bldngProposedBldngArea = new BigDecimal(0);
    private BigDecimal bldngGFloor_TiledFloor = new BigDecimal(0);
    private BigDecimal bldngGFloor_OtherTypes = new BigDecimal(0);
    private BigDecimal bldngFrstFloor_TotalArea = new BigDecimal(0);
    @ManyToOne(fetch=FetchType.LAZY)
    private StormWaterDrain bldngStormWaterDrain;
    private BigDecimal bldngCompoundWall = new BigDecimal(0);
    private BigDecimal bldngWellOht_SumpTankArea = new BigDecimal(0);
    private BigDecimal bldngCommercial = new BigDecimal(0);
    private BigDecimal bldngResidential = new BigDecimal(0);
    private Boolean bldngIsRegularisationCharges;
    private Boolean bldngIsImprovementCharges;
    private BigDecimal bldngAge = new BigDecimal(0);
    @Enumerated(value=EnumType.ORDINAL)
    private RoadType roadType;
    private BigDecimal bldngFsiArea;
    private BigDecimal fsb;
    private BigDecimal rsb;
    private BigDecimal ssb1;
    private BigDecimal ssb2;
    private BigDecimal passageWidth;
    private BigDecimal passageLength;
    @ManyToOne(fetch=FetchType.LAZY)
    private SurroundedBldgDtl surroundedByNorth;
    @ManyToOne(fetch=FetchType.LAZY)
    private SurroundedBldgDtl surroundedBySouth;
    @ManyToOne(fetch=FetchType.LAZY)
    private SurroundedBldgDtl surroundedByEast;
    @ManyToOne(fetch=FetchType.LAZY)
    private SurroundedBldgDtl surroundedByWest;
    @ManyToOne(fetch=FetchType.LAZY)
    private ConstructionStages constStages;
    private BigDecimal dwellingUnit;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="docket", unique=true)
    private Docket docket;
    @OneToMany(mappedBy="inspection", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<FloorDetail> floorDetail = new ArrayList<FloorDetail>(0);
    @ManyToOne(fetch=FetchType.LAZY)
    private Application application;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getInspectionNumber() {
        return this.inspectionNumber;
    }

    public void setInspectionNumber(String inspectionNumber) {
        this.inspectionNumber = inspectionNumber;
    }

    public Date getInspectionDate() {
        return this.inspectionDate;
    }

    public void setInspectionDate(Date inspectionDate) {
        this.inspectionDate = inspectionDate;
    }

    public Inspection getParent() {
        return this.parent;
    }

    public void setParent(Inspection parent) {
        this.parent = parent;
    }

    public User getInspectedBy() {
        return this.inspectedBy;
    }

    public void setInspectedBy(User inspectedBy) {
        this.inspectedBy = inspectedBy;
    }

    public Boolean getIsSiteVacant() {
        return this.isSiteVacant;
    }

    public void setIsSiteVacant(Boolean isSiteVacant) {
        this.isSiteVacant = isSiteVacant;
    }

    public Boolean getIsExistingBuildingAsPerPlan() {
        return this.isExistingBuildingAsPerPlan;
    }

    public void setIsExistingBuildingAsPerPlan(Boolean isExistingBuildingAsPerPlan) {
        this.isExistingBuildingAsPerPlan = isExistingBuildingAsPerPlan;
    }

    public Boolean getIsInspected() {
        return this.isInspected;
    }

    public void setIsInspected(Boolean isInspected) {
        this.isInspected = isInspected;
    }

    public String getInspectionRemarks() {
        return this.inspectionRemarks;
    }

    public void setInspectionRemarks(String inspectionRemarks) {
        this.inspectionRemarks = inspectionRemarks;
    }

    public Boolean getIsPostponed() {
        return this.isPostponed;
    }

    public void setIsPostponed(Boolean isPostponed) {
        this.isPostponed = isPostponed;
    }

    public String getPostponementReason() {
        return this.postponementReason;
    }

    public void setPostponementReason(String postponementReason) {
        this.postponementReason = postponementReason;
    }

    public Date getPostponedDate() {
        return this.postponedDate;
    }

    public void setPostponedDate(Date postponedDate) {
        this.postponedDate = postponedDate;
    }

    public LandBldngZoneing getLandZoning() {
        return this.landZoning;
    }

    public void setLandZoning(LandBldngZoneing landZoning) {
        this.landZoning = landZoning;
    }

    public LayoutMaster getLndLayoutType() {
        return this.lndLayoutType;
    }

    public void setLndLayoutType(LayoutMaster lndLayoutType) {
        this.lndLayoutType = lndLayoutType;
    }

    public BigDecimal getLndMinPlotExtent() {
        return this.lndMinPlotExtent;
    }

    public void setLndMinPlotExtent(BigDecimal lndMinPlotExtent) {
        this.lndMinPlotExtent = lndMinPlotExtent;
    }

    public BigDecimal getLndProposedPlotExtent() {
        return this.lndProposedPlotExtent;
    }

    public void setLndProposedPlotExtent(BigDecimal lndProposedPlotExtent) {
        this.lndProposedPlotExtent = lndProposedPlotExtent;
    }

    public BigDecimal getLndOsrLandExtent() {
        return this.lndOsrLandExtent;
    }

    public void setLndOsrLandExtent(BigDecimal lndOsrLandExtent) {
        this.lndOsrLandExtent = lndOsrLandExtent;
    }

    public BigDecimal getLndGuideLineValue() {
        return this.lndGuideLineValue;
    }

    public void setLndGuideLineValue(BigDecimal lndGuideLineValue) {
        this.lndGuideLineValue = lndGuideLineValue;
    }

    public LandBuildingTypes getLandUsage() {
        return this.landUsage;
    }

    public void setLandUsage(LandBuildingTypes landUsage) {
        this.landUsage = landUsage;
    }

    public BigDecimal getLndRegularizationArea() {
        return this.lndRegularizationArea;
    }

    public void setLndRegularizationArea(BigDecimal lndRegularizationArea) {
        this.lndRegularizationArea = lndRegularizationArea;
    }

    public Integer getLndPenaltyPeriod() {
        return this.lndPenaltyPeriod;
    }

    public void setLndPenaltyPeriod(Integer lndPenaltyPeriod) {
        this.lndPenaltyPeriod = lndPenaltyPeriod;
    }

    public Boolean getLndIsRegularisationCharges() {
        return this.lndIsRegularisationCharges;
    }

    public void setLndIsRegularisationCharges(Boolean lndIsRegularisationCharges) {
        this.lndIsRegularisationCharges = lndIsRegularisationCharges;
    }

    public LandBldngZoneing getBuildingZoning() {
        return this.buildingZoning;
    }

    public void setBuildingZoning(LandBldngZoneing buildingZoning) {
        this.buildingZoning = buildingZoning;
    }

    public LandBuildingTypes getBuildingType() {
        return this.buildingType;
    }

    public void setBuildingType(LandBuildingTypes buildingType) {
        this.buildingType = buildingType;
    }

    public BigDecimal getBldngBuildUpArea() {
        return this.bldngBuildUpArea;
    }

    public void setBldngBuildUpArea(BigDecimal bldngBuildUpArea) {
        this.bldngBuildUpArea = bldngBuildUpArea;
    }

    public BigDecimal getBldngProposedPlotFrontage() {
        return this.bldngProposedPlotFrontage;
    }

    public void setBldngProposedPlotFrontage(BigDecimal bldngProposedPlotFrontage) {
        this.bldngProposedPlotFrontage = bldngProposedPlotFrontage;
    }

    public BigDecimal getBldngRoadWidth() {
        return this.bldngRoadWidth;
    }

    public void setBldngRoadWidth(BigDecimal bldngRoadWidth) {
        this.bldngRoadWidth = bldngRoadWidth;
    }

    public BigDecimal getBldngProposedBldngArea() {
        return this.bldngProposedBldngArea;
    }

    public void setBldngProposedBldngArea(BigDecimal bldngProposedBldngArea) {
        this.bldngProposedBldngArea = bldngProposedBldngArea;
    }

    public BigDecimal getBldngGFloor_TiledFloor() {
        return this.bldngGFloor_TiledFloor;
    }

    public void setBldngGFloor_TiledFloor(BigDecimal bldngGFloor_TiledFloor) {
        this.bldngGFloor_TiledFloor = bldngGFloor_TiledFloor;
    }

    public BigDecimal getBldngGFloor_OtherTypes() {
        return this.bldngGFloor_OtherTypes;
    }

    public void setBldngGFloor_OtherTypes(BigDecimal bldngGFloor_OtherTypes) {
        this.bldngGFloor_OtherTypes = bldngGFloor_OtherTypes;
    }

    public BigDecimal getBldngFrstFloor_TotalArea() {
        return this.bldngFrstFloor_TotalArea;
    }

    public void setBldngFrstFloor_TotalArea(BigDecimal bldngFrstFloor_TotalArea) {
        this.bldngFrstFloor_TotalArea = bldngFrstFloor_TotalArea;
    }

    public StormWaterDrain getBldngStormWaterDrain() {
        return this.bldngStormWaterDrain;
    }

    public void setBldngStormWaterDrain(StormWaterDrain bldngStormWaterDrain) {
        this.bldngStormWaterDrain = bldngStormWaterDrain;
    }

    public BigDecimal getBldngCompoundWall() {
        return this.bldngCompoundWall;
    }

    public void setBldngCompoundWall(BigDecimal bldngCompoundWall) {
        this.bldngCompoundWall = bldngCompoundWall;
    }

    public BigDecimal getBldngWellOht_SumpTankArea() {
        return this.bldngWellOht_SumpTankArea;
    }

    public void setBldngWellOht_SumpTankArea(BigDecimal bldngWellOht_SumpTankArea) {
        this.bldngWellOht_SumpTankArea = bldngWellOht_SumpTankArea;
    }

    public BigDecimal getBldngCommercial() {
        return this.bldngCommercial;
    }

    public void setBldngCommercial(BigDecimal bldngCommercial) {
        this.bldngCommercial = bldngCommercial;
    }

    public BigDecimal getBldngResidential() {
        return this.bldngResidential;
    }

    public void setBldngResidential(BigDecimal bldngResidential) {
        this.bldngResidential = bldngResidential;
    }

    public Boolean getBldngIsRegularisationCharges() {
        return this.bldngIsRegularisationCharges;
    }

    public void setBldngIsRegularisationCharges(Boolean bldngIsRegularisationCharges) {
        this.bldngIsRegularisationCharges = bldngIsRegularisationCharges;
    }

    public Boolean getBldngIsImprovementCharges() {
        return this.bldngIsImprovementCharges;
    }

    public void setBldngIsImprovementCharges(Boolean bldngIsImprovementCharges) {
        this.bldngIsImprovementCharges = bldngIsImprovementCharges;
    }

    public BigDecimal getBldngAge() {
        return this.bldngAge;
    }

    public void setBldngAge(BigDecimal bldngAge) {
        this.bldngAge = bldngAge;
    }

    public RoadType getRoadType() {
        return this.roadType;
    }

    public void setRoadType(RoadType roadType) {
        this.roadType = roadType;
    }

    public BigDecimal getBldngFsiArea() {
        return this.bldngFsiArea;
    }

    public void setBldngFsiArea(BigDecimal bldngFsiArea) {
        this.bldngFsiArea = bldngFsiArea;
    }

    public BigDecimal getFsb() {
        return this.fsb;
    }

    public void setFsb(BigDecimal fsb) {
        this.fsb = fsb;
    }

    public BigDecimal getRsb() {
        return this.rsb;
    }

    public void setRsb(BigDecimal rsb) {
        this.rsb = rsb;
    }

    public BigDecimal getSsb1() {
        return this.ssb1;
    }

    public void setSsb1(BigDecimal ssb1) {
        this.ssb1 = ssb1;
    }

    public BigDecimal getSsb2() {
        return this.ssb2;
    }

    public void setSsb2(BigDecimal ssb2) {
        this.ssb2 = ssb2;
    }

    public BigDecimal getPassageWidth() {
        return this.passageWidth;
    }

    public void setPassageWidth(BigDecimal passageWidth) {
        this.passageWidth = passageWidth;
    }

    public BigDecimal getPassageLength() {
        return this.passageLength;
    }

    public void setPassageLength(BigDecimal passageLength) {
        this.passageLength = passageLength;
    }

    public SurroundedBldgDtl getSurroundedByNorth() {
        return this.surroundedByNorth;
    }

    public void setSurroundedByNorth(SurroundedBldgDtl surroundedByNorth) {
        this.surroundedByNorth = surroundedByNorth;
    }

    public SurroundedBldgDtl getSurroundedBySouth() {
        return this.surroundedBySouth;
    }

    public void setSurroundedBySouth(SurroundedBldgDtl surroundedBySouth) {
        this.surroundedBySouth = surroundedBySouth;
    }

    public SurroundedBldgDtl getSurroundedByEast() {
        return this.surroundedByEast;
    }

    public void setSurroundedByEast(SurroundedBldgDtl surroundedByEast) {
        this.surroundedByEast = surroundedByEast;
    }

    public SurroundedBldgDtl getSurroundedByWest() {
        return this.surroundedByWest;
    }

    public void setSurroundedByWest(SurroundedBldgDtl surroundedByWest) {
        this.surroundedByWest = surroundedByWest;
    }

    public ConstructionStages getConstStages() {
        return this.constStages;
    }

    public void setConstStages(ConstructionStages constStages) {
        this.constStages = constStages;
    }

    public BigDecimal getDwellingUnit() {
        return this.dwellingUnit;
    }

    public void setDwellingUnit(BigDecimal dwellingUnit) {
        this.dwellingUnit = dwellingUnit;
    }

    public Docket getDocket() {
        return this.docket;
    }

    public void setDocket(Docket docket) {
        this.docket = docket;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public List<FloorDetail> getFloorDetail() {
        return this.floorDetail;
    }

    public void setFloorDetail(List<FloorDetail> floorDetail) {
        this.floorDetail = floorDetail;
    }
}

