/*
 * Decompiled with CFR 0.152.
 */
package org.egov.bpa.application.entity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.bpa.application.entity.BpaStatus;
import org.egov.bpa.application.entity.DocketConstructionStage;
import org.egov.bpa.application.entity.DocketDetail;
import org.egov.bpa.application.entity.Inspection;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGBPA_DOCKET")
@SequenceGenerator(name="SEQ_EGBPA_DOCKET", sequenceName="SEQ_EGBPA_DOCKET", allocationSize=1)
public class Docket
extends AbstractAuditable {
    private static final long serialVersionUID = 3078684328383202788L;
    public static final String SEQ_DOCKET = "SEQ_EGBPA_DOCKET";
    @Id
    @GeneratedValue(generator="SEQ_EGBPA_DOCKET", strategy=GenerationType.SEQUENCE)
    private Long id;
    @OneToOne(mappedBy="docket", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private Inspection inspection;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private BpaStatus status;
    @Length(min=1, max=64)
    private String existingUsage;
    @Length(min=1, max=64)
    private String proposedActivityIsPermissible;
    @Length(min=1, max=32)
    private String oldProptaxPaidRecptEnclosed;
    @Length(min=1, max=32)
    private String existingSanctionPlanOrPtTaxPaidRecptEnclosed;
    private BigDecimal abuttingRoadWidth;
    @Length(min=1, max=32)
    private String abuttingRoadIsPrivateOrPublic;
    @Length(min=1, max=32)
    private String abuttingRoadTakenUpForImprovement;
    @Length(min=1, max=32)
    private String abuttingRoadgainsAceessThroughPassage;
    private BigDecimal abuttingRoadgainWidth;
    @Length(min=1, max=32)
    private String abuttingRoadgainPrivateOrPublic;
    @Length(min=1, max=32)
    private String planCompliesWithSideCondition;
    @Length(min=1, max=512)
    private String remarks;
    @Length(min=1, max=512)
    private String aeeInspectionReport;
    private Integer totalFloorCount;
    private BigDecimal lengthOfCompoundWall;
    private BigDecimal diameterOfWell;
    private BigDecimal seperateLatORTank;
    private BigDecimal terraced;
    private BigDecimal tiledRoof;
    private BigDecimal plotWidthRear = new BigDecimal(0);
    private BigDecimal constructionWidthRear = new BigDecimal(0);
    private BigDecimal constructionHeightRear = new BigDecimal(0);
    @OneToMany(mappedBy="docket", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<DocketConstructionStage> docketConstructionStage = new ArrayList<DocketConstructionStage>(0);
    @OneToMany(mappedBy="docket", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<DocketDetail> docketDetail = new ArrayList<DocketDetail>(0);

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Inspection getInspection() {
        return this.inspection;
    }

    public void setInspection(Inspection inspection) {
        this.inspection = inspection;
    }

    public String getExistingUsage() {
        return this.existingUsage;
    }

    public void setExistingUsage(String existingUsage) {
        this.existingUsage = existingUsage;
    }

    public String getProposedActivityIsPermissible() {
        return this.proposedActivityIsPermissible;
    }

    public void setProposedActivityIsPermissible(String proposedActivityIsPermissible) {
        this.proposedActivityIsPermissible = proposedActivityIsPermissible;
    }

    public String getOldProptaxPaidRecptEnclosed() {
        return this.oldProptaxPaidRecptEnclosed;
    }

    public void setOldProptaxPaidRecptEnclosed(String oldProptaxPaidRecptEnclosed) {
        this.oldProptaxPaidRecptEnclosed = oldProptaxPaidRecptEnclosed;
    }

    public String getExistingSanctionPlanOrPtTaxPaidRecptEnclosed() {
        return this.existingSanctionPlanOrPtTaxPaidRecptEnclosed;
    }

    public void setExistingSanctionPlanOrPtTaxPaidRecptEnclosed(String existingSanctionPlanOrPtTaxPaidRecptEnclosed) {
        this.existingSanctionPlanOrPtTaxPaidRecptEnclosed = existingSanctionPlanOrPtTaxPaidRecptEnclosed;
    }

    public BigDecimal getAbuttingRoadWidth() {
        return this.abuttingRoadWidth;
    }

    public void setAbuttingRoadWidth(BigDecimal abuttingRoadWidth) {
        this.abuttingRoadWidth = abuttingRoadWidth;
    }

    public String getAbuttingRoadIsPrivateOrPublic() {
        return this.abuttingRoadIsPrivateOrPublic;
    }

    public void setAbuttingRoadIsPrivateOrPublic(String abuttingRoadIsPrivateOrPublic) {
        this.abuttingRoadIsPrivateOrPublic = abuttingRoadIsPrivateOrPublic;
    }

    public String getAbuttingRoadTakenUpForImprovement() {
        return this.abuttingRoadTakenUpForImprovement;
    }

    public void setAbuttingRoadTakenUpForImprovement(String abuttingRoadTakenUpForImprovement) {
        this.abuttingRoadTakenUpForImprovement = abuttingRoadTakenUpForImprovement;
    }

    public String getAbuttingRoadgainsAceessThroughPassage() {
        return this.abuttingRoadgainsAceessThroughPassage;
    }

    public void setAbuttingRoadgainsAceessThroughPassage(String abuttingRoadgainsAceessThroughPassage) {
        this.abuttingRoadgainsAceessThroughPassage = abuttingRoadgainsAceessThroughPassage;
    }

    public BigDecimal getAbuttingRoadgainWidth() {
        return this.abuttingRoadgainWidth;
    }

    public void setAbuttingRoadgainWidth(BigDecimal abuttingRoadgainWidth) {
        this.abuttingRoadgainWidth = abuttingRoadgainWidth;
    }

    public String getAbuttingRoadgainPrivateOrPublic() {
        return this.abuttingRoadgainPrivateOrPublic;
    }

    public void setAbuttingRoadgainPrivateOrPublic(String abuttingRoadgainPrivateOrPublic) {
        this.abuttingRoadgainPrivateOrPublic = abuttingRoadgainPrivateOrPublic;
    }

    public String getPlanCompliesWithSideCondition() {
        return this.planCompliesWithSideCondition;
    }

    public void setPlanCompliesWithSideCondition(String planCompliesWithSideCondition) {
        this.planCompliesWithSideCondition = planCompliesWithSideCondition;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getAeeInspectionReport() {
        return this.aeeInspectionReport;
    }

    public void setAeeInspectionReport(String aeeInspectionReport) {
        this.aeeInspectionReport = aeeInspectionReport;
    }

    public Integer getTotalFloorCount() {
        return this.totalFloorCount;
    }

    public void setTotalFloorCount(Integer totalFloorCount) {
        this.totalFloorCount = totalFloorCount;
    }

    public BigDecimal getLengthOfCompoundWall() {
        return this.lengthOfCompoundWall;
    }

    public void setLengthOfCompoundWall(BigDecimal lengthOfCompoundWall) {
        this.lengthOfCompoundWall = lengthOfCompoundWall;
    }

    public BigDecimal getDiameterOfWell() {
        return this.diameterOfWell;
    }

    public void setDiameterOfWell(BigDecimal diameterOfWell) {
        this.diameterOfWell = diameterOfWell;
    }

    public BigDecimal getSeperateLatORTank() {
        return this.seperateLatORTank;
    }

    public void setSeperateLatORTank(BigDecimal seperateLatORTank) {
        this.seperateLatORTank = seperateLatORTank;
    }

    public BigDecimal getTerraced() {
        return this.terraced;
    }

    public void setTerraced(BigDecimal terraced) {
        this.terraced = terraced;
    }

    public BigDecimal getTiledRoof() {
        return this.tiledRoof;
    }

    public void setTiledRoof(BigDecimal tiledRoof) {
        this.tiledRoof = tiledRoof;
    }

    public BigDecimal getPlotWidthRear() {
        return this.plotWidthRear;
    }

    public void setPlotWidthRear(BigDecimal plotWidthRear) {
        this.plotWidthRear = plotWidthRear;
    }

    public BigDecimal getConstructionWidthRear() {
        return this.constructionWidthRear;
    }

    public void setConstructionWidthRear(BigDecimal constructionWidthRear) {
        this.constructionWidthRear = constructionWidthRear;
    }

    public BigDecimal getConstructionHeightRear() {
        return this.constructionHeightRear;
    }

    public void setConstructionHeightRear(BigDecimal constructionHeightRear) {
        this.constructionHeightRear = constructionHeightRear;
    }

    public BpaStatus getStatus() {
        return this.status;
    }

    public void setStatus(BpaStatus status) {
        this.status = status;
    }

    public List<DocketConstructionStage> getDocketConstructionStage() {
        return this.docketConstructionStage;
    }

    public void setDocketConstructionStage(List<DocketConstructionStage> docketConstructionStage) {
        this.docketConstructionStage = docketConstructionStage;
    }

    public List<DocketDetail> getDocketDetail() {
        return this.docketDetail;
    }

    public void setDocketDetail(List<DocketDetail> docketDetail) {
        this.docketDetail = docketDetail;
    }
}

