/*
 * Decompiled with CFR 0.152.
 */
package org.egov.bpa.application.entity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.egov.bpa.application.entity.BpaFeeDetail;
import org.egov.bpa.application.entity.ServiceType;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFunction;
import org.egov.commons.Fund;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGBPA_MSTR_BPAFEE")
@SequenceGenerator(name="SEQ_EGBPA_MSTR_BPAFEE", sequenceName="SEQ_EGBPA_MSTR_BPAFEE", allocationSize=1)
public class BpaFee
extends AbstractAuditable {
    private static final long serialVersionUID = 3078684328383202788L;
    public static final String SEQ_BPAFEE = "SEQ_EGBPA_MSTR_BPAFEE";
    @Id
    @GeneratedValue(generator="SEQ_EGBPA_MSTR_BPAFEE", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @NotNull
    private CChartOfAccounts glcode;
    @ManyToOne(fetch=FetchType.LAZY)
    private CFunction function;
    @ManyToOne(fetch=FetchType.LAZY)
    @NotNull
    private ServiceType serviceType;
    @ManyToOne(fetch=FetchType.LAZY)
    private Fund fund;
    @NotNull
    @Length(min=1, max=128)
    private String feeType;
    @NotNull
    @Length(min=1, max=128)
    @Column(name="code", unique=true)
    private String code;
    @NotNull
    @Length(min=1, max=256)
    private String description;
    @NotNull
    private Boolean isFixedAmount;
    @NotNull
    private Boolean isActive;
    @NotNull
    private Boolean isMandatory;
    @Transient
    private BigDecimal feeAmount;
    @Transient
    private Long demandDetailId;
    @NotNull
    @Length(min=1, max=256)
    private String feeDescriptionLocal;
    private Long orderNumber;
    @NotNull
    private Boolean isPlanningPermitFee;
    @Length(min=1, max=128)
    private String feeGroup;
    @OneToMany(mappedBy="bpafee", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private final List<BpaFeeDetail> feeDetail = new ArrayList<BpaFeeDetail>(0);

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public CChartOfAccounts getGlcode() {
        return this.glcode;
    }

    public void setGlcode(CChartOfAccounts glcode) {
        this.glcode = glcode;
    }

    public CFunction getFunction() {
        return this.function;
    }

    public void setFunction(CFunction function) {
        this.function = function;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(ServiceType serviceType) {
        this.serviceType = serviceType;
    }

    public Fund getFund() {
        return this.fund;
    }

    public void setFund(Fund fund) {
        this.fund = fund;
    }

    public String getFeeType() {
        return this.feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public Boolean getIsFixedAmount() {
        return this.isFixedAmount;
    }

    public void setIsFixedAmount(Boolean isFixedAmount) {
        this.isFixedAmount = isFixedAmount;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public Boolean getIsMandatory() {
        return this.isMandatory;
    }

    public void setIsMandatory(Boolean isMandatory) {
        this.isMandatory = isMandatory;
    }

    public BigDecimal getFeeAmount() {
        return this.feeAmount;
    }

    public void setFeeAmount(BigDecimal feeAmount) {
        this.feeAmount = feeAmount;
    }

    public Long getDemandDetailId() {
        return this.demandDetailId;
    }

    public void setDemandDetailId(Long demandDetailId) {
        this.demandDetailId = demandDetailId;
    }

    public String getFeeDescriptionLocal() {
        return this.feeDescriptionLocal;
    }

    public void setFeeDescriptionLocal(String feeDescriptionLocal) {
        this.feeDescriptionLocal = feeDescriptionLocal;
    }

    public Long getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(Long orderNumber) {
        this.orderNumber = orderNumber;
    }

    public Boolean getIsPlanningPermitFee() {
        return this.isPlanningPermitFee;
    }

    public void setIsPlanningPermitFee(Boolean isPlanningPermitFee) {
        this.isPlanningPermitFee = isPlanningPermitFee;
    }

    public String getFeeGroup() {
        return this.feeGroup;
    }

    public void setFeeGroup(String feeGroup) {
        this.feeGroup = feeGroup;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<BpaFeeDetail> getFeeDetail() {
        return this.feeDetail;
    }
}

